/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ImageBMP is the corresponding interface of ImageBMP
type ImageBMP interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
}

// ImageBMPExactly can be used when we want exactly this type and not a type which fulfills ImageBMP.
// This is useful for switch cases.
type ImageBMPExactly interface {
	ImageBMP
	isImageBMP() bool
}

// _ImageBMP is the data-structure of this message
type _ImageBMP struct {
}

// NewImageBMP factory function for _ImageBMP
func NewImageBMP() *_ImageBMP {
	return &_ImageBMP{}
}

// Deprecated: use the interface for direct cast
func CastImageBMP(structType any) ImageBMP {
	if casted, ok := structType.(ImageBMP); ok {
		return casted
	}
	if casted, ok := structType.(*ImageBMP); ok {
		return *casted
	}
	return nil
}

func (m *_ImageBMP) GetTypeName() string {
	return "ImageBMP"
}

func (m *_ImageBMP) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_ImageBMP) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ImageBMPParse(ctx context.Context, theBytes []byte) (ImageBMP, error) {
	return ImageBMPParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ImageBMPParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ImageBMP, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ImageBMP"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ImageBMP")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ImageBMP"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ImageBMP")
	}

	// Create the instance
	return &_ImageBMP{}, nil
}

func (m *_ImageBMP) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ImageBMP) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("ImageBMP"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ImageBMP")
	}

	if popErr := writeBuffer.PopContext("ImageBMP"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ImageBMP")
	}
	return nil
}

func (m *_ImageBMP) isImageBMP() bool {
	return true
}

func (m *_ImageBMP) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
