/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// HistoryReadValueId is the corresponding interface of HistoryReadValueId
type HistoryReadValueId interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetNodeId returns NodeId (property field)
	GetNodeId() NodeId
	// GetIndexRange returns IndexRange (property field)
	GetIndexRange() PascalString
	// GetDataEncoding returns DataEncoding (property field)
	GetDataEncoding() QualifiedName
	// GetContinuationPoint returns ContinuationPoint (property field)
	GetContinuationPoint() PascalByteString
}

// HistoryReadValueIdExactly can be used when we want exactly this type and not a type which fulfills HistoryReadValueId.
// This is useful for switch cases.
type HistoryReadValueIdExactly interface {
	HistoryReadValueId
	isHistoryReadValueId() bool
}

// _HistoryReadValueId is the data-structure of this message
type _HistoryReadValueId struct {
	*_ExtensionObjectDefinition
	NodeId            NodeId
	IndexRange        PascalString
	DataEncoding      QualifiedName
	ContinuationPoint PascalByteString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_HistoryReadValueId) GetIdentifier() string {
	return "637"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_HistoryReadValueId) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_HistoryReadValueId) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_HistoryReadValueId) GetNodeId() NodeId {
	return m.NodeId
}

func (m *_HistoryReadValueId) GetIndexRange() PascalString {
	return m.IndexRange
}

func (m *_HistoryReadValueId) GetDataEncoding() QualifiedName {
	return m.DataEncoding
}

func (m *_HistoryReadValueId) GetContinuationPoint() PascalByteString {
	return m.ContinuationPoint
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewHistoryReadValueId factory function for _HistoryReadValueId
func NewHistoryReadValueId(nodeId NodeId, indexRange PascalString, dataEncoding QualifiedName, continuationPoint PascalByteString) *_HistoryReadValueId {
	_result := &_HistoryReadValueId{
		NodeId:                     nodeId,
		IndexRange:                 indexRange,
		DataEncoding:               dataEncoding,
		ContinuationPoint:          continuationPoint,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastHistoryReadValueId(structType any) HistoryReadValueId {
	if casted, ok := structType.(HistoryReadValueId); ok {
		return casted
	}
	if casted, ok := structType.(*HistoryReadValueId); ok {
		return *casted
	}
	return nil
}

func (m *_HistoryReadValueId) GetTypeName() string {
	return "HistoryReadValueId"
}

func (m *_HistoryReadValueId) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (nodeId)
	lengthInBits += m.NodeId.GetLengthInBits(ctx)

	// Simple field (indexRange)
	lengthInBits += m.IndexRange.GetLengthInBits(ctx)

	// Simple field (dataEncoding)
	lengthInBits += m.DataEncoding.GetLengthInBits(ctx)

	// Simple field (continuationPoint)
	lengthInBits += m.ContinuationPoint.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_HistoryReadValueId) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func HistoryReadValueIdParse(ctx context.Context, theBytes []byte, identifier string) (HistoryReadValueId, error) {
	return HistoryReadValueIdParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func HistoryReadValueIdParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (HistoryReadValueId, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("HistoryReadValueId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for HistoryReadValueId")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (nodeId)
	if pullErr := readBuffer.PullContext("nodeId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for nodeId")
	}
	_nodeId, _nodeIdErr := NodeIdParseWithBuffer(ctx, readBuffer)
	if _nodeIdErr != nil {
		return nil, errors.Wrap(_nodeIdErr, "Error parsing 'nodeId' field of HistoryReadValueId")
	}
	nodeId := _nodeId.(NodeId)
	if closeErr := readBuffer.CloseContext("nodeId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for nodeId")
	}

	// Simple Field (indexRange)
	if pullErr := readBuffer.PullContext("indexRange"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for indexRange")
	}
	_indexRange, _indexRangeErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _indexRangeErr != nil {
		return nil, errors.Wrap(_indexRangeErr, "Error parsing 'indexRange' field of HistoryReadValueId")
	}
	indexRange := _indexRange.(PascalString)
	if closeErr := readBuffer.CloseContext("indexRange"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for indexRange")
	}

	// Simple Field (dataEncoding)
	if pullErr := readBuffer.PullContext("dataEncoding"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for dataEncoding")
	}
	_dataEncoding, _dataEncodingErr := QualifiedNameParseWithBuffer(ctx, readBuffer)
	if _dataEncodingErr != nil {
		return nil, errors.Wrap(_dataEncodingErr, "Error parsing 'dataEncoding' field of HistoryReadValueId")
	}
	dataEncoding := _dataEncoding.(QualifiedName)
	if closeErr := readBuffer.CloseContext("dataEncoding"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for dataEncoding")
	}

	// Simple Field (continuationPoint)
	if pullErr := readBuffer.PullContext("continuationPoint"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for continuationPoint")
	}
	_continuationPoint, _continuationPointErr := PascalByteStringParseWithBuffer(ctx, readBuffer)
	if _continuationPointErr != nil {
		return nil, errors.Wrap(_continuationPointErr, "Error parsing 'continuationPoint' field of HistoryReadValueId")
	}
	continuationPoint := _continuationPoint.(PascalByteString)
	if closeErr := readBuffer.CloseContext("continuationPoint"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for continuationPoint")
	}

	if closeErr := readBuffer.CloseContext("HistoryReadValueId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for HistoryReadValueId")
	}

	// Create a partially initialized instance
	_child := &_HistoryReadValueId{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		NodeId:                     nodeId,
		IndexRange:                 indexRange,
		DataEncoding:               dataEncoding,
		ContinuationPoint:          continuationPoint,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_HistoryReadValueId) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_HistoryReadValueId) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("HistoryReadValueId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for HistoryReadValueId")
		}

		// Simple Field (nodeId)
		if pushErr := writeBuffer.PushContext("nodeId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for nodeId")
		}
		_nodeIdErr := writeBuffer.WriteSerializable(ctx, m.GetNodeId())
		if popErr := writeBuffer.PopContext("nodeId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for nodeId")
		}
		if _nodeIdErr != nil {
			return errors.Wrap(_nodeIdErr, "Error serializing 'nodeId' field")
		}

		// Simple Field (indexRange)
		if pushErr := writeBuffer.PushContext("indexRange"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for indexRange")
		}
		_indexRangeErr := writeBuffer.WriteSerializable(ctx, m.GetIndexRange())
		if popErr := writeBuffer.PopContext("indexRange"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for indexRange")
		}
		if _indexRangeErr != nil {
			return errors.Wrap(_indexRangeErr, "Error serializing 'indexRange' field")
		}

		// Simple Field (dataEncoding)
		if pushErr := writeBuffer.PushContext("dataEncoding"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for dataEncoding")
		}
		_dataEncodingErr := writeBuffer.WriteSerializable(ctx, m.GetDataEncoding())
		if popErr := writeBuffer.PopContext("dataEncoding"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for dataEncoding")
		}
		if _dataEncodingErr != nil {
			return errors.Wrap(_dataEncodingErr, "Error serializing 'dataEncoding' field")
		}

		// Simple Field (continuationPoint)
		if pushErr := writeBuffer.PushContext("continuationPoint"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for continuationPoint")
		}
		_continuationPointErr := writeBuffer.WriteSerializable(ctx, m.GetContinuationPoint())
		if popErr := writeBuffer.PopContext("continuationPoint"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for continuationPoint")
		}
		if _continuationPointErr != nil {
			return errors.Wrap(_continuationPointErr, "Error serializing 'continuationPoint' field")
		}

		if popErr := writeBuffer.PopContext("HistoryReadValueId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for HistoryReadValueId")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_HistoryReadValueId) isHistoryReadValueId() bool {
	return true
}

func (m *_HistoryReadValueId) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
