/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// EUInformation is the corresponding interface of EUInformation
type EUInformation interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetNamespaceUri returns NamespaceUri (property field)
	GetNamespaceUri() PascalString
	// GetUnitId returns UnitId (property field)
	GetUnitId() int32
	// GetDisplayName returns DisplayName (property field)
	GetDisplayName() LocalizedText
	// GetDescription returns Description (property field)
	GetDescription() LocalizedText
}

// EUInformationExactly can be used when we want exactly this type and not a type which fulfills EUInformation.
// This is useful for switch cases.
type EUInformationExactly interface {
	EUInformation
	isEUInformation() bool
}

// _EUInformation is the data-structure of this message
type _EUInformation struct {
	*_ExtensionObjectDefinition
	NamespaceUri PascalString
	UnitId       int32
	DisplayName  LocalizedText
	Description  LocalizedText
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_EUInformation) GetIdentifier() string {
	return "889"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_EUInformation) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_EUInformation) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_EUInformation) GetNamespaceUri() PascalString {
	return m.NamespaceUri
}

func (m *_EUInformation) GetUnitId() int32 {
	return m.UnitId
}

func (m *_EUInformation) GetDisplayName() LocalizedText {
	return m.DisplayName
}

func (m *_EUInformation) GetDescription() LocalizedText {
	return m.Description
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewEUInformation factory function for _EUInformation
func NewEUInformation(namespaceUri PascalString, unitId int32, displayName LocalizedText, description LocalizedText) *_EUInformation {
	_result := &_EUInformation{
		NamespaceUri:               namespaceUri,
		UnitId:                     unitId,
		DisplayName:                displayName,
		Description:                description,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastEUInformation(structType any) EUInformation {
	if casted, ok := structType.(EUInformation); ok {
		return casted
	}
	if casted, ok := structType.(*EUInformation); ok {
		return *casted
	}
	return nil
}

func (m *_EUInformation) GetTypeName() string {
	return "EUInformation"
}

func (m *_EUInformation) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (namespaceUri)
	lengthInBits += m.NamespaceUri.GetLengthInBits(ctx)

	// Simple field (unitId)
	lengthInBits += 32

	// Simple field (displayName)
	lengthInBits += m.DisplayName.GetLengthInBits(ctx)

	// Simple field (description)
	lengthInBits += m.Description.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_EUInformation) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func EUInformationParse(ctx context.Context, theBytes []byte, identifier string) (EUInformation, error) {
	return EUInformationParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func EUInformationParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (EUInformation, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("EUInformation"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for EUInformation")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (namespaceUri)
	if pullErr := readBuffer.PullContext("namespaceUri"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for namespaceUri")
	}
	_namespaceUri, _namespaceUriErr := PascalStringParseWithBuffer(ctx, readBuffer)
	if _namespaceUriErr != nil {
		return nil, errors.Wrap(_namespaceUriErr, "Error parsing 'namespaceUri' field of EUInformation")
	}
	namespaceUri := _namespaceUri.(PascalString)
	if closeErr := readBuffer.CloseContext("namespaceUri"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for namespaceUri")
	}

	// Simple Field (unitId)
	_unitId, _unitIdErr := readBuffer.ReadInt32("unitId", 32)
	if _unitIdErr != nil {
		return nil, errors.Wrap(_unitIdErr, "Error parsing 'unitId' field of EUInformation")
	}
	unitId := _unitId

	// Simple Field (displayName)
	if pullErr := readBuffer.PullContext("displayName"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for displayName")
	}
	_displayName, _displayNameErr := LocalizedTextParseWithBuffer(ctx, readBuffer)
	if _displayNameErr != nil {
		return nil, errors.Wrap(_displayNameErr, "Error parsing 'displayName' field of EUInformation")
	}
	displayName := _displayName.(LocalizedText)
	if closeErr := readBuffer.CloseContext("displayName"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for displayName")
	}

	// Simple Field (description)
	if pullErr := readBuffer.PullContext("description"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for description")
	}
	_description, _descriptionErr := LocalizedTextParseWithBuffer(ctx, readBuffer)
	if _descriptionErr != nil {
		return nil, errors.Wrap(_descriptionErr, "Error parsing 'description' field of EUInformation")
	}
	description := _description.(LocalizedText)
	if closeErr := readBuffer.CloseContext("description"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for description")
	}

	if closeErr := readBuffer.CloseContext("EUInformation"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for EUInformation")
	}

	// Create a partially initialized instance
	_child := &_EUInformation{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		NamespaceUri:               namespaceUri,
		UnitId:                     unitId,
		DisplayName:                displayName,
		Description:                description,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_EUInformation) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_EUInformation) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("EUInformation"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for EUInformation")
		}

		// Simple Field (namespaceUri)
		if pushErr := writeBuffer.PushContext("namespaceUri"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for namespaceUri")
		}
		_namespaceUriErr := writeBuffer.WriteSerializable(ctx, m.GetNamespaceUri())
		if popErr := writeBuffer.PopContext("namespaceUri"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for namespaceUri")
		}
		if _namespaceUriErr != nil {
			return errors.Wrap(_namespaceUriErr, "Error serializing 'namespaceUri' field")
		}

		// Simple Field (unitId)
		unitId := int32(m.GetUnitId())
		_unitIdErr := writeBuffer.WriteInt32("unitId", 32, (unitId))
		if _unitIdErr != nil {
			return errors.Wrap(_unitIdErr, "Error serializing 'unitId' field")
		}

		// Simple Field (displayName)
		if pushErr := writeBuffer.PushContext("displayName"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for displayName")
		}
		_displayNameErr := writeBuffer.WriteSerializable(ctx, m.GetDisplayName())
		if popErr := writeBuffer.PopContext("displayName"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for displayName")
		}
		if _displayNameErr != nil {
			return errors.Wrap(_displayNameErr, "Error serializing 'displayName' field")
		}

		// Simple Field (description)
		if pushErr := writeBuffer.PushContext("description"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for description")
		}
		_descriptionErr := writeBuffer.WriteSerializable(ctx, m.GetDescription())
		if popErr := writeBuffer.PopContext("description"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for description")
		}
		if _descriptionErr != nil {
			return errors.Wrap(_descriptionErr, "Error serializing 'description' field")
		}

		if popErr := writeBuffer.PopContext("EUInformation"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for EUInformation")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_EUInformation) isEUInformation() bool {
	return true
}

func (m *_EUInformation) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
