/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// DataTypeDescription is the corresponding interface of DataTypeDescription
type DataTypeDescription interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetDataTypeId returns DataTypeId (property field)
	GetDataTypeId() NodeId
	// GetName returns Name (property field)
	GetName() QualifiedName
}

// DataTypeDescriptionExactly can be used when we want exactly this type and not a type which fulfills DataTypeDescription.
// This is useful for switch cases.
type DataTypeDescriptionExactly interface {
	DataTypeDescription
	isDataTypeDescription() bool
}

// _DataTypeDescription is the data-structure of this message
type _DataTypeDescription struct {
	*_ExtensionObjectDefinition
	DataTypeId NodeId
	Name       QualifiedName
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_DataTypeDescription) GetIdentifier() string {
	return "14527"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_DataTypeDescription) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_DataTypeDescription) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_DataTypeDescription) GetDataTypeId() NodeId {
	return m.DataTypeId
}

func (m *_DataTypeDescription) GetName() QualifiedName {
	return m.Name
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewDataTypeDescription factory function for _DataTypeDescription
func NewDataTypeDescription(dataTypeId NodeId, name QualifiedName) *_DataTypeDescription {
	_result := &_DataTypeDescription{
		DataTypeId:                 dataTypeId,
		Name:                       name,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastDataTypeDescription(structType any) DataTypeDescription {
	if casted, ok := structType.(DataTypeDescription); ok {
		return casted
	}
	if casted, ok := structType.(*DataTypeDescription); ok {
		return *casted
	}
	return nil
}

func (m *_DataTypeDescription) GetTypeName() string {
	return "DataTypeDescription"
}

func (m *_DataTypeDescription) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (dataTypeId)
	lengthInBits += m.DataTypeId.GetLengthInBits(ctx)

	// Simple field (name)
	lengthInBits += m.Name.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_DataTypeDescription) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func DataTypeDescriptionParse(ctx context.Context, theBytes []byte, identifier string) (DataTypeDescription, error) {
	return DataTypeDescriptionParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func DataTypeDescriptionParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (DataTypeDescription, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("DataTypeDescription"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DataTypeDescription")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (dataTypeId)
	if pullErr := readBuffer.PullContext("dataTypeId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for dataTypeId")
	}
	_dataTypeId, _dataTypeIdErr := NodeIdParseWithBuffer(ctx, readBuffer)
	if _dataTypeIdErr != nil {
		return nil, errors.Wrap(_dataTypeIdErr, "Error parsing 'dataTypeId' field of DataTypeDescription")
	}
	dataTypeId := _dataTypeId.(NodeId)
	if closeErr := readBuffer.CloseContext("dataTypeId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for dataTypeId")
	}

	// Simple Field (name)
	if pullErr := readBuffer.PullContext("name"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for name")
	}
	_name, _nameErr := QualifiedNameParseWithBuffer(ctx, readBuffer)
	if _nameErr != nil {
		return nil, errors.Wrap(_nameErr, "Error parsing 'name' field of DataTypeDescription")
	}
	name := _name.(QualifiedName)
	if closeErr := readBuffer.CloseContext("name"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for name")
	}

	if closeErr := readBuffer.CloseContext("DataTypeDescription"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DataTypeDescription")
	}

	// Create a partially initialized instance
	_child := &_DataTypeDescription{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		DataTypeId:                 dataTypeId,
		Name:                       name,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_DataTypeDescription) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DataTypeDescription) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("DataTypeDescription"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for DataTypeDescription")
		}

		// Simple Field (dataTypeId)
		if pushErr := writeBuffer.PushContext("dataTypeId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for dataTypeId")
		}
		_dataTypeIdErr := writeBuffer.WriteSerializable(ctx, m.GetDataTypeId())
		if popErr := writeBuffer.PopContext("dataTypeId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for dataTypeId")
		}
		if _dataTypeIdErr != nil {
			return errors.Wrap(_dataTypeIdErr, "Error serializing 'dataTypeId' field")
		}

		// Simple Field (name)
		if pushErr := writeBuffer.PushContext("name"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for name")
		}
		_nameErr := writeBuffer.WriteSerializable(ctx, m.GetName())
		if popErr := writeBuffer.PopContext("name"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for name")
		}
		if _nameErr != nil {
			return errors.Wrap(_nameErr, "Error serializing 'name' field")
		}

		if popErr := writeBuffer.PopContext("DataTypeDescription"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for DataTypeDescription")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_DataTypeDescription) isDataTypeDescription() bool {
	return true
}

func (m *_DataTypeDescription) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
