/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// DataChangeNotification is the corresponding interface of DataChangeNotification
type DataChangeNotification interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetNoOfMonitoredItems returns NoOfMonitoredItems (property field)
	GetNoOfMonitoredItems() int32
	// GetMonitoredItems returns MonitoredItems (property field)
	GetMonitoredItems() []ExtensionObjectDefinition
	// GetNoOfDiagnosticInfos returns NoOfDiagnosticInfos (property field)
	GetNoOfDiagnosticInfos() int32
	// GetDiagnosticInfos returns DiagnosticInfos (property field)
	GetDiagnosticInfos() []DiagnosticInfo
}

// DataChangeNotificationExactly can be used when we want exactly this type and not a type which fulfills DataChangeNotification.
// This is useful for switch cases.
type DataChangeNotificationExactly interface {
	DataChangeNotification
	isDataChangeNotification() bool
}

// _DataChangeNotification is the data-structure of this message
type _DataChangeNotification struct {
	*_ExtensionObjectDefinition
	NoOfMonitoredItems  int32
	MonitoredItems      []ExtensionObjectDefinition
	NoOfDiagnosticInfos int32
	DiagnosticInfos     []DiagnosticInfo
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_DataChangeNotification) GetIdentifier() string {
	return "811"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_DataChangeNotification) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_DataChangeNotification) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_DataChangeNotification) GetNoOfMonitoredItems() int32 {
	return m.NoOfMonitoredItems
}

func (m *_DataChangeNotification) GetMonitoredItems() []ExtensionObjectDefinition {
	return m.MonitoredItems
}

func (m *_DataChangeNotification) GetNoOfDiagnosticInfos() int32 {
	return m.NoOfDiagnosticInfos
}

func (m *_DataChangeNotification) GetDiagnosticInfos() []DiagnosticInfo {
	return m.DiagnosticInfos
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewDataChangeNotification factory function for _DataChangeNotification
func NewDataChangeNotification(noOfMonitoredItems int32, monitoredItems []ExtensionObjectDefinition, noOfDiagnosticInfos int32, diagnosticInfos []DiagnosticInfo) *_DataChangeNotification {
	_result := &_DataChangeNotification{
		NoOfMonitoredItems:         noOfMonitoredItems,
		MonitoredItems:             monitoredItems,
		NoOfDiagnosticInfos:        noOfDiagnosticInfos,
		DiagnosticInfos:            diagnosticInfos,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastDataChangeNotification(structType any) DataChangeNotification {
	if casted, ok := structType.(DataChangeNotification); ok {
		return casted
	}
	if casted, ok := structType.(*DataChangeNotification); ok {
		return *casted
	}
	return nil
}

func (m *_DataChangeNotification) GetTypeName() string {
	return "DataChangeNotification"
}

func (m *_DataChangeNotification) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Implicit Field (notificationLength)
	lengthInBits += 32

	// Simple field (noOfMonitoredItems)
	lengthInBits += 32

	// Array field
	if len(m.MonitoredItems) > 0 {
		for _curItem, element := range m.MonitoredItems {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.MonitoredItems), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	// Simple field (noOfDiagnosticInfos)
	lengthInBits += 32

	// Array field
	if len(m.DiagnosticInfos) > 0 {
		for _curItem, element := range m.DiagnosticInfos {
			arrayCtx := utils.CreateArrayContext(ctx, len(m.DiagnosticInfos), _curItem)
			_ = arrayCtx
			_ = _curItem
			lengthInBits += element.(interface{ GetLengthInBits(context.Context) uint16 }).GetLengthInBits(arrayCtx)
		}
	}

	return lengthInBits
}

func (m *_DataChangeNotification) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func DataChangeNotificationParse(ctx context.Context, theBytes []byte, identifier string) (DataChangeNotification, error) {
	return DataChangeNotificationParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func DataChangeNotificationParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (DataChangeNotification, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("DataChangeNotification"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DataChangeNotification")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Implicit Field (notificationLength) (Used for parsing, but its value is not stored as it's implicitly given by the objects content)
	notificationLength, _notificationLengthErr := readBuffer.ReadInt32("notificationLength", 32)
	_ = notificationLength
	if _notificationLengthErr != nil {
		return nil, errors.Wrap(_notificationLengthErr, "Error parsing 'notificationLength' field of DataChangeNotification")
	}

	// Simple Field (noOfMonitoredItems)
	_noOfMonitoredItems, _noOfMonitoredItemsErr := readBuffer.ReadInt32("noOfMonitoredItems", 32)
	if _noOfMonitoredItemsErr != nil {
		return nil, errors.Wrap(_noOfMonitoredItemsErr, "Error parsing 'noOfMonitoredItems' field of DataChangeNotification")
	}
	noOfMonitoredItems := _noOfMonitoredItems

	// Array field (monitoredItems)
	if pullErr := readBuffer.PullContext("monitoredItems", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for monitoredItems")
	}
	// Count array
	monitoredItems := make([]ExtensionObjectDefinition, utils.Max(noOfMonitoredItems, 0))
	// This happens when the size is set conditional to 0
	if len(monitoredItems) == 0 {
		monitoredItems = nil
	}
	{
		_numItems := uint16(utils.Max(noOfMonitoredItems, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := ExtensionObjectDefinitionParseWithBuffer(arrayCtx, readBuffer, "808")
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'monitoredItems' field of DataChangeNotification")
			}
			monitoredItems[_curItem] = _item.(ExtensionObjectDefinition)
		}
	}
	if closeErr := readBuffer.CloseContext("monitoredItems", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for monitoredItems")
	}

	// Simple Field (noOfDiagnosticInfos)
	_noOfDiagnosticInfos, _noOfDiagnosticInfosErr := readBuffer.ReadInt32("noOfDiagnosticInfos", 32)
	if _noOfDiagnosticInfosErr != nil {
		return nil, errors.Wrap(_noOfDiagnosticInfosErr, "Error parsing 'noOfDiagnosticInfos' field of DataChangeNotification")
	}
	noOfDiagnosticInfos := _noOfDiagnosticInfos

	// Array field (diagnosticInfos)
	if pullErr := readBuffer.PullContext("diagnosticInfos", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for diagnosticInfos")
	}
	// Count array
	diagnosticInfos := make([]DiagnosticInfo, utils.Max(noOfDiagnosticInfos, 0))
	// This happens when the size is set conditional to 0
	if len(diagnosticInfos) == 0 {
		diagnosticInfos = nil
	}
	{
		_numItems := uint16(utils.Max(noOfDiagnosticInfos, 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := DiagnosticInfoParseWithBuffer(arrayCtx, readBuffer)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'diagnosticInfos' field of DataChangeNotification")
			}
			diagnosticInfos[_curItem] = _item.(DiagnosticInfo)
		}
	}
	if closeErr := readBuffer.CloseContext("diagnosticInfos", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for diagnosticInfos")
	}

	if closeErr := readBuffer.CloseContext("DataChangeNotification"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DataChangeNotification")
	}

	// Create a partially initialized instance
	_child := &_DataChangeNotification{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		NoOfMonitoredItems:         noOfMonitoredItems,
		MonitoredItems:             monitoredItems,
		NoOfDiagnosticInfos:        noOfDiagnosticInfos,
		DiagnosticInfos:            diagnosticInfos,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_DataChangeNotification) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_DataChangeNotification) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("DataChangeNotification"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for DataChangeNotification")
		}

		// Implicit Field (notificationLength) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
		notificationLength := int32(int32(m.GetLengthInBytes(ctx)))
		_notificationLengthErr := writeBuffer.WriteInt32("notificationLength", 32, (notificationLength))
		if _notificationLengthErr != nil {
			return errors.Wrap(_notificationLengthErr, "Error serializing 'notificationLength' field")
		}

		// Simple Field (noOfMonitoredItems)
		noOfMonitoredItems := int32(m.GetNoOfMonitoredItems())
		_noOfMonitoredItemsErr := writeBuffer.WriteInt32("noOfMonitoredItems", 32, (noOfMonitoredItems))
		if _noOfMonitoredItemsErr != nil {
			return errors.Wrap(_noOfMonitoredItemsErr, "Error serializing 'noOfMonitoredItems' field")
		}

		// Array Field (monitoredItems)
		if pushErr := writeBuffer.PushContext("monitoredItems", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for monitoredItems")
		}
		for _curItem, _element := range m.GetMonitoredItems() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetMonitoredItems()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'monitoredItems' field")
			}
		}
		if popErr := writeBuffer.PopContext("monitoredItems", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for monitoredItems")
		}

		// Simple Field (noOfDiagnosticInfos)
		noOfDiagnosticInfos := int32(m.GetNoOfDiagnosticInfos())
		_noOfDiagnosticInfosErr := writeBuffer.WriteInt32("noOfDiagnosticInfos", 32, (noOfDiagnosticInfos))
		if _noOfDiagnosticInfosErr != nil {
			return errors.Wrap(_noOfDiagnosticInfosErr, "Error serializing 'noOfDiagnosticInfos' field")
		}

		// Array Field (diagnosticInfos)
		if pushErr := writeBuffer.PushContext("diagnosticInfos", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for diagnosticInfos")
		}
		for _curItem, _element := range m.GetDiagnosticInfos() {
			_ = _curItem
			arrayCtx := utils.CreateArrayContext(ctx, len(m.GetDiagnosticInfos()), _curItem)
			_ = arrayCtx
			_elementErr := writeBuffer.WriteSerializable(arrayCtx, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'diagnosticInfos' field")
			}
		}
		if popErr := writeBuffer.PopContext("diagnosticInfos", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for diagnosticInfos")
		}

		if popErr := writeBuffer.PopContext("DataChangeNotification"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for DataChangeNotification")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_DataChangeNotification) isDataChangeNotification() bool {
	return true
}

func (m *_DataChangeNotification) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
