/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// AddNodesItem is the corresponding interface of AddNodesItem
type AddNodesItem interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ExtensionObjectDefinition
	// GetParentNodeId returns ParentNodeId (property field)
	GetParentNodeId() ExpandedNodeId
	// GetReferenceTypeId returns ReferenceTypeId (property field)
	GetReferenceTypeId() NodeId
	// GetRequestedNewNodeId returns RequestedNewNodeId (property field)
	GetRequestedNewNodeId() ExpandedNodeId
	// GetBrowseName returns BrowseName (property field)
	GetBrowseName() QualifiedName
	// GetNodeClass returns NodeClass (property field)
	GetNodeClass() NodeClass
	// GetNodeAttributes returns NodeAttributes (property field)
	GetNodeAttributes() ExtensionObject
	// GetTypeDefinition returns TypeDefinition (property field)
	GetTypeDefinition() ExpandedNodeId
}

// AddNodesItemExactly can be used when we want exactly this type and not a type which fulfills AddNodesItem.
// This is useful for switch cases.
type AddNodesItemExactly interface {
	AddNodesItem
	isAddNodesItem() bool
}

// _AddNodesItem is the data-structure of this message
type _AddNodesItem struct {
	*_ExtensionObjectDefinition
	ParentNodeId       ExpandedNodeId
	ReferenceTypeId    NodeId
	RequestedNewNodeId ExpandedNodeId
	BrowseName         QualifiedName
	NodeClass          NodeClass
	NodeAttributes     ExtensionObject
	TypeDefinition     ExpandedNodeId
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_AddNodesItem) GetIdentifier() string {
	return "378"
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AddNodesItem) InitializeParent(parent ExtensionObjectDefinition) {}

func (m *_AddNodesItem) GetParent() ExtensionObjectDefinition {
	return m._ExtensionObjectDefinition
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AddNodesItem) GetParentNodeId() ExpandedNodeId {
	return m.ParentNodeId
}

func (m *_AddNodesItem) GetReferenceTypeId() NodeId {
	return m.ReferenceTypeId
}

func (m *_AddNodesItem) GetRequestedNewNodeId() ExpandedNodeId {
	return m.RequestedNewNodeId
}

func (m *_AddNodesItem) GetBrowseName() QualifiedName {
	return m.BrowseName
}

func (m *_AddNodesItem) GetNodeClass() NodeClass {
	return m.NodeClass
}

func (m *_AddNodesItem) GetNodeAttributes() ExtensionObject {
	return m.NodeAttributes
}

func (m *_AddNodesItem) GetTypeDefinition() ExpandedNodeId {
	return m.TypeDefinition
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewAddNodesItem factory function for _AddNodesItem
func NewAddNodesItem(parentNodeId ExpandedNodeId, referenceTypeId NodeId, requestedNewNodeId ExpandedNodeId, browseName QualifiedName, nodeClass NodeClass, nodeAttributes ExtensionObject, typeDefinition ExpandedNodeId) *_AddNodesItem {
	_result := &_AddNodesItem{
		ParentNodeId:               parentNodeId,
		ReferenceTypeId:            referenceTypeId,
		RequestedNewNodeId:         requestedNewNodeId,
		BrowseName:                 browseName,
		NodeClass:                  nodeClass,
		NodeAttributes:             nodeAttributes,
		TypeDefinition:             typeDefinition,
		_ExtensionObjectDefinition: NewExtensionObjectDefinition(),
	}
	_result._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastAddNodesItem(structType any) AddNodesItem {
	if casted, ok := structType.(AddNodesItem); ok {
		return casted
	}
	if casted, ok := structType.(*AddNodesItem); ok {
		return *casted
	}
	return nil
}

func (m *_AddNodesItem) GetTypeName() string {
	return "AddNodesItem"
}

func (m *_AddNodesItem) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (parentNodeId)
	lengthInBits += m.ParentNodeId.GetLengthInBits(ctx)

	// Simple field (referenceTypeId)
	lengthInBits += m.ReferenceTypeId.GetLengthInBits(ctx)

	// Simple field (requestedNewNodeId)
	lengthInBits += m.RequestedNewNodeId.GetLengthInBits(ctx)

	// Simple field (browseName)
	lengthInBits += m.BrowseName.GetLengthInBits(ctx)

	// Simple field (nodeClass)
	lengthInBits += 32

	// Simple field (nodeAttributes)
	lengthInBits += m.NodeAttributes.GetLengthInBits(ctx)

	// Simple field (typeDefinition)
	lengthInBits += m.TypeDefinition.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_AddNodesItem) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AddNodesItemParse(ctx context.Context, theBytes []byte, identifier string) (AddNodesItem, error) {
	return AddNodesItemParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), identifier)
}

func AddNodesItemParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, identifier string) (AddNodesItem, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("AddNodesItem"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AddNodesItem")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (parentNodeId)
	if pullErr := readBuffer.PullContext("parentNodeId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for parentNodeId")
	}
	_parentNodeId, _parentNodeIdErr := ExpandedNodeIdParseWithBuffer(ctx, readBuffer)
	if _parentNodeIdErr != nil {
		return nil, errors.Wrap(_parentNodeIdErr, "Error parsing 'parentNodeId' field of AddNodesItem")
	}
	parentNodeId := _parentNodeId.(ExpandedNodeId)
	if closeErr := readBuffer.CloseContext("parentNodeId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for parentNodeId")
	}

	// Simple Field (referenceTypeId)
	if pullErr := readBuffer.PullContext("referenceTypeId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for referenceTypeId")
	}
	_referenceTypeId, _referenceTypeIdErr := NodeIdParseWithBuffer(ctx, readBuffer)
	if _referenceTypeIdErr != nil {
		return nil, errors.Wrap(_referenceTypeIdErr, "Error parsing 'referenceTypeId' field of AddNodesItem")
	}
	referenceTypeId := _referenceTypeId.(NodeId)
	if closeErr := readBuffer.CloseContext("referenceTypeId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for referenceTypeId")
	}

	// Simple Field (requestedNewNodeId)
	if pullErr := readBuffer.PullContext("requestedNewNodeId"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for requestedNewNodeId")
	}
	_requestedNewNodeId, _requestedNewNodeIdErr := ExpandedNodeIdParseWithBuffer(ctx, readBuffer)
	if _requestedNewNodeIdErr != nil {
		return nil, errors.Wrap(_requestedNewNodeIdErr, "Error parsing 'requestedNewNodeId' field of AddNodesItem")
	}
	requestedNewNodeId := _requestedNewNodeId.(ExpandedNodeId)
	if closeErr := readBuffer.CloseContext("requestedNewNodeId"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for requestedNewNodeId")
	}

	// Simple Field (browseName)
	if pullErr := readBuffer.PullContext("browseName"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for browseName")
	}
	_browseName, _browseNameErr := QualifiedNameParseWithBuffer(ctx, readBuffer)
	if _browseNameErr != nil {
		return nil, errors.Wrap(_browseNameErr, "Error parsing 'browseName' field of AddNodesItem")
	}
	browseName := _browseName.(QualifiedName)
	if closeErr := readBuffer.CloseContext("browseName"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for browseName")
	}

	// Simple Field (nodeClass)
	if pullErr := readBuffer.PullContext("nodeClass"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for nodeClass")
	}
	_nodeClass, _nodeClassErr := NodeClassParseWithBuffer(ctx, readBuffer)
	if _nodeClassErr != nil {
		return nil, errors.Wrap(_nodeClassErr, "Error parsing 'nodeClass' field of AddNodesItem")
	}
	nodeClass := _nodeClass
	if closeErr := readBuffer.CloseContext("nodeClass"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for nodeClass")
	}

	// Simple Field (nodeAttributes)
	if pullErr := readBuffer.PullContext("nodeAttributes"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for nodeAttributes")
	}
	_nodeAttributes, _nodeAttributesErr := ExtensionObjectParseWithBuffer(ctx, readBuffer, bool(bool(true)))
	if _nodeAttributesErr != nil {
		return nil, errors.Wrap(_nodeAttributesErr, "Error parsing 'nodeAttributes' field of AddNodesItem")
	}
	nodeAttributes := _nodeAttributes.(ExtensionObject)
	if closeErr := readBuffer.CloseContext("nodeAttributes"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for nodeAttributes")
	}

	// Simple Field (typeDefinition)
	if pullErr := readBuffer.PullContext("typeDefinition"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for typeDefinition")
	}
	_typeDefinition, _typeDefinitionErr := ExpandedNodeIdParseWithBuffer(ctx, readBuffer)
	if _typeDefinitionErr != nil {
		return nil, errors.Wrap(_typeDefinitionErr, "Error parsing 'typeDefinition' field of AddNodesItem")
	}
	typeDefinition := _typeDefinition.(ExpandedNodeId)
	if closeErr := readBuffer.CloseContext("typeDefinition"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for typeDefinition")
	}

	if closeErr := readBuffer.CloseContext("AddNodesItem"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AddNodesItem")
	}

	// Create a partially initialized instance
	_child := &_AddNodesItem{
		_ExtensionObjectDefinition: &_ExtensionObjectDefinition{},
		ParentNodeId:               parentNodeId,
		ReferenceTypeId:            referenceTypeId,
		RequestedNewNodeId:         requestedNewNodeId,
		BrowseName:                 browseName,
		NodeClass:                  nodeClass,
		NodeAttributes:             nodeAttributes,
		TypeDefinition:             typeDefinition,
	}
	_child._ExtensionObjectDefinition._ExtensionObjectDefinitionChildRequirements = _child
	return _child, nil
}

func (m *_AddNodesItem) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AddNodesItem) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AddNodesItem"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AddNodesItem")
		}

		// Simple Field (parentNodeId)
		if pushErr := writeBuffer.PushContext("parentNodeId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for parentNodeId")
		}
		_parentNodeIdErr := writeBuffer.WriteSerializable(ctx, m.GetParentNodeId())
		if popErr := writeBuffer.PopContext("parentNodeId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for parentNodeId")
		}
		if _parentNodeIdErr != nil {
			return errors.Wrap(_parentNodeIdErr, "Error serializing 'parentNodeId' field")
		}

		// Simple Field (referenceTypeId)
		if pushErr := writeBuffer.PushContext("referenceTypeId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for referenceTypeId")
		}
		_referenceTypeIdErr := writeBuffer.WriteSerializable(ctx, m.GetReferenceTypeId())
		if popErr := writeBuffer.PopContext("referenceTypeId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for referenceTypeId")
		}
		if _referenceTypeIdErr != nil {
			return errors.Wrap(_referenceTypeIdErr, "Error serializing 'referenceTypeId' field")
		}

		// Simple Field (requestedNewNodeId)
		if pushErr := writeBuffer.PushContext("requestedNewNodeId"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for requestedNewNodeId")
		}
		_requestedNewNodeIdErr := writeBuffer.WriteSerializable(ctx, m.GetRequestedNewNodeId())
		if popErr := writeBuffer.PopContext("requestedNewNodeId"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for requestedNewNodeId")
		}
		if _requestedNewNodeIdErr != nil {
			return errors.Wrap(_requestedNewNodeIdErr, "Error serializing 'requestedNewNodeId' field")
		}

		// Simple Field (browseName)
		if pushErr := writeBuffer.PushContext("browseName"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for browseName")
		}
		_browseNameErr := writeBuffer.WriteSerializable(ctx, m.GetBrowseName())
		if popErr := writeBuffer.PopContext("browseName"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for browseName")
		}
		if _browseNameErr != nil {
			return errors.Wrap(_browseNameErr, "Error serializing 'browseName' field")
		}

		// Simple Field (nodeClass)
		if pushErr := writeBuffer.PushContext("nodeClass"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for nodeClass")
		}
		_nodeClassErr := writeBuffer.WriteSerializable(ctx, m.GetNodeClass())
		if popErr := writeBuffer.PopContext("nodeClass"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for nodeClass")
		}
		if _nodeClassErr != nil {
			return errors.Wrap(_nodeClassErr, "Error serializing 'nodeClass' field")
		}

		// Simple Field (nodeAttributes)
		if pushErr := writeBuffer.PushContext("nodeAttributes"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for nodeAttributes")
		}
		_nodeAttributesErr := writeBuffer.WriteSerializable(ctx, m.GetNodeAttributes())
		if popErr := writeBuffer.PopContext("nodeAttributes"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for nodeAttributes")
		}
		if _nodeAttributesErr != nil {
			return errors.Wrap(_nodeAttributesErr, "Error serializing 'nodeAttributes' field")
		}

		// Simple Field (typeDefinition)
		if pushErr := writeBuffer.PushContext("typeDefinition"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for typeDefinition")
		}
		_typeDefinitionErr := writeBuffer.WriteSerializable(ctx, m.GetTypeDefinition())
		if popErr := writeBuffer.PopContext("typeDefinition"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for typeDefinition")
		}
		if _typeDefinitionErr != nil {
			return errors.Wrap(_typeDefinitionErr, "Error serializing 'typeDefinition' field")
		}

		if popErr := writeBuffer.PopContext("AddNodesItem"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AddNodesItem")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AddNodesItem) isAddNodesItem() bool {
	return true
}

func (m *_AddNodesItem) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
