/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// ConnectionResponseDataBlockTunnelConnection is the corresponding interface of ConnectionResponseDataBlockTunnelConnection
type ConnectionResponseDataBlockTunnelConnection interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	ConnectionResponseDataBlock
	// GetKnxAddress returns KnxAddress (property field)
	GetKnxAddress() KnxAddress
}

// ConnectionResponseDataBlockTunnelConnectionExactly can be used when we want exactly this type and not a type which fulfills ConnectionResponseDataBlockTunnelConnection.
// This is useful for switch cases.
type ConnectionResponseDataBlockTunnelConnectionExactly interface {
	ConnectionResponseDataBlockTunnelConnection
	isConnectionResponseDataBlockTunnelConnection() bool
}

// _ConnectionResponseDataBlockTunnelConnection is the data-structure of this message
type _ConnectionResponseDataBlockTunnelConnection struct {
	*_ConnectionResponseDataBlock
	KnxAddress KnxAddress
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ConnectionResponseDataBlockTunnelConnection) GetConnectionType() uint8 {
	return 0x04
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ConnectionResponseDataBlockTunnelConnection) InitializeParent(parent ConnectionResponseDataBlock) {
}

func (m *_ConnectionResponseDataBlockTunnelConnection) GetParent() ConnectionResponseDataBlock {
	return m._ConnectionResponseDataBlock
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ConnectionResponseDataBlockTunnelConnection) GetKnxAddress() KnxAddress {
	return m.KnxAddress
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewConnectionResponseDataBlockTunnelConnection factory function for _ConnectionResponseDataBlockTunnelConnection
func NewConnectionResponseDataBlockTunnelConnection(knxAddress KnxAddress) *_ConnectionResponseDataBlockTunnelConnection {
	_result := &_ConnectionResponseDataBlockTunnelConnection{
		KnxAddress:                   knxAddress,
		_ConnectionResponseDataBlock: NewConnectionResponseDataBlock(),
	}
	_result._ConnectionResponseDataBlock._ConnectionResponseDataBlockChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastConnectionResponseDataBlockTunnelConnection(structType any) ConnectionResponseDataBlockTunnelConnection {
	if casted, ok := structType.(ConnectionResponseDataBlockTunnelConnection); ok {
		return casted
	}
	if casted, ok := structType.(*ConnectionResponseDataBlockTunnelConnection); ok {
		return *casted
	}
	return nil
}

func (m *_ConnectionResponseDataBlockTunnelConnection) GetTypeName() string {
	return "ConnectionResponseDataBlockTunnelConnection"
}

func (m *_ConnectionResponseDataBlockTunnelConnection) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (knxAddress)
	lengthInBits += m.KnxAddress.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_ConnectionResponseDataBlockTunnelConnection) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func ConnectionResponseDataBlockTunnelConnectionParse(ctx context.Context, theBytes []byte) (ConnectionResponseDataBlockTunnelConnection, error) {
	return ConnectionResponseDataBlockTunnelConnectionParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func ConnectionResponseDataBlockTunnelConnectionParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (ConnectionResponseDataBlockTunnelConnection, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("ConnectionResponseDataBlockTunnelConnection"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ConnectionResponseDataBlockTunnelConnection")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (knxAddress)
	if pullErr := readBuffer.PullContext("knxAddress"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for knxAddress")
	}
	_knxAddress, _knxAddressErr := KnxAddressParseWithBuffer(ctx, readBuffer)
	if _knxAddressErr != nil {
		return nil, errors.Wrap(_knxAddressErr, "Error parsing 'knxAddress' field of ConnectionResponseDataBlockTunnelConnection")
	}
	knxAddress := _knxAddress.(KnxAddress)
	if closeErr := readBuffer.CloseContext("knxAddress"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for knxAddress")
	}

	if closeErr := readBuffer.CloseContext("ConnectionResponseDataBlockTunnelConnection"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ConnectionResponseDataBlockTunnelConnection")
	}

	// Create a partially initialized instance
	_child := &_ConnectionResponseDataBlockTunnelConnection{
		_ConnectionResponseDataBlock: &_ConnectionResponseDataBlock{},
		KnxAddress:                   knxAddress,
	}
	_child._ConnectionResponseDataBlock._ConnectionResponseDataBlockChildRequirements = _child
	return _child, nil
}

func (m *_ConnectionResponseDataBlockTunnelConnection) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_ConnectionResponseDataBlockTunnelConnection) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ConnectionResponseDataBlockTunnelConnection"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ConnectionResponseDataBlockTunnelConnection")
		}

		// Simple Field (knxAddress)
		if pushErr := writeBuffer.PushContext("knxAddress"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for knxAddress")
		}
		_knxAddressErr := writeBuffer.WriteSerializable(ctx, m.GetKnxAddress())
		if popErr := writeBuffer.PopContext("knxAddress"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for knxAddress")
		}
		if _knxAddressErr != nil {
			return errors.Wrap(_knxAddressErr, "Error serializing 'knxAddress' field")
		}

		if popErr := writeBuffer.PopContext("ConnectionResponseDataBlockTunnelConnection"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ConnectionResponseDataBlockTunnelConnection")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_ConnectionResponseDataBlockTunnelConnection) isConnectionResponseDataBlockTunnelConnection() bool {
	return true
}

func (m *_ConnectionResponseDataBlockTunnelConnection) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
