/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// LogicalSegment is the corresponding interface of LogicalSegment
type LogicalSegment interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	PathSegment
	// GetSegmentType returns SegmentType (property field)
	GetSegmentType() LogicalSegmentType
}

// LogicalSegmentExactly can be used when we want exactly this type and not a type which fulfills LogicalSegment.
// This is useful for switch cases.
type LogicalSegmentExactly interface {
	LogicalSegment
	isLogicalSegment() bool
}

// _LogicalSegment is the data-structure of this message
type _LogicalSegment struct {
	*_PathSegment
	SegmentType LogicalSegmentType
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_LogicalSegment) GetPathSegment() uint8 {
	return 0x01
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_LogicalSegment) InitializeParent(parent PathSegment) {}

func (m *_LogicalSegment) GetParent() PathSegment {
	return m._PathSegment
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_LogicalSegment) GetSegmentType() LogicalSegmentType {
	return m.SegmentType
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewLogicalSegment factory function for _LogicalSegment
func NewLogicalSegment(segmentType LogicalSegmentType) *_LogicalSegment {
	_result := &_LogicalSegment{
		SegmentType:  segmentType,
		_PathSegment: NewPathSegment(),
	}
	_result._PathSegment._PathSegmentChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastLogicalSegment(structType any) LogicalSegment {
	if casted, ok := structType.(LogicalSegment); ok {
		return casted
	}
	if casted, ok := structType.(*LogicalSegment); ok {
		return *casted
	}
	return nil
}

func (m *_LogicalSegment) GetTypeName() string {
	return "LogicalSegment"
}

func (m *_LogicalSegment) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (segmentType)
	lengthInBits += m.SegmentType.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_LogicalSegment) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func LogicalSegmentParse(ctx context.Context, theBytes []byte) (LogicalSegment, error) {
	return LogicalSegmentParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func LogicalSegmentParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (LogicalSegment, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("LogicalSegment"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for LogicalSegment")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (segmentType)
	if pullErr := readBuffer.PullContext("segmentType"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for segmentType")
	}
	_segmentType, _segmentTypeErr := LogicalSegmentTypeParseWithBuffer(ctx, readBuffer)
	if _segmentTypeErr != nil {
		return nil, errors.Wrap(_segmentTypeErr, "Error parsing 'segmentType' field of LogicalSegment")
	}
	segmentType := _segmentType.(LogicalSegmentType)
	if closeErr := readBuffer.CloseContext("segmentType"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for segmentType")
	}

	if closeErr := readBuffer.CloseContext("LogicalSegment"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for LogicalSegment")
	}

	// Create a partially initialized instance
	_child := &_LogicalSegment{
		_PathSegment: &_PathSegment{},
		SegmentType:  segmentType,
	}
	_child._PathSegment._PathSegmentChildRequirements = _child
	return _child, nil
}

func (m *_LogicalSegment) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_LogicalSegment) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("LogicalSegment"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for LogicalSegment")
		}

		// Simple Field (segmentType)
		if pushErr := writeBuffer.PushContext("segmentType"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for segmentType")
		}
		_segmentTypeErr := writeBuffer.WriteSerializable(ctx, m.GetSegmentType())
		if popErr := writeBuffer.PopContext("segmentType"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for segmentType")
		}
		if _segmentTypeErr != nil {
			return errors.Wrap(_segmentTypeErr, "Error serializing 'segmentType' field")
		}

		if popErr := writeBuffer.PopContext("LogicalSegment"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for LogicalSegment")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_LogicalSegment) isLogicalSegment() bool {
	return true
}

func (m *_LogicalSegment) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
