/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const CipIdentity_ZEROES1 uint32 = 0x00000000
const CipIdentity_ZEROES2 uint32 = 0x00000000

// CipIdentity is the corresponding interface of CipIdentity
type CipIdentity interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	CommandSpecificDataItem
	// GetEncapsulationProtocolVersion returns EncapsulationProtocolVersion (property field)
	GetEncapsulationProtocolVersion() uint16
	// GetSocketAddressFamily returns SocketAddressFamily (property field)
	GetSocketAddressFamily() uint16
	// GetSocketAddressPort returns SocketAddressPort (property field)
	GetSocketAddressPort() uint16
	// GetSocketAddressAddress returns SocketAddressAddress (property field)
	GetSocketAddressAddress() []uint8
	// GetVendorId returns VendorId (property field)
	GetVendorId() uint16
	// GetDeviceType returns DeviceType (property field)
	GetDeviceType() uint16
	// GetProductCode returns ProductCode (property field)
	GetProductCode() uint16
	// GetRevisionMajor returns RevisionMajor (property field)
	GetRevisionMajor() uint8
	// GetRevisionMinor returns RevisionMinor (property field)
	GetRevisionMinor() uint8
	// GetStatus returns Status (property field)
	GetStatus() uint16
	// GetSerialNumber returns SerialNumber (property field)
	GetSerialNumber() uint32
	// GetProductName returns ProductName (property field)
	GetProductName() string
	// GetState returns State (property field)
	GetState() uint8
}

// CipIdentityExactly can be used when we want exactly this type and not a type which fulfills CipIdentity.
// This is useful for switch cases.
type CipIdentityExactly interface {
	CipIdentity
	isCipIdentity() bool
}

// _CipIdentity is the data-structure of this message
type _CipIdentity struct {
	*_CommandSpecificDataItem
	EncapsulationProtocolVersion uint16
	SocketAddressFamily          uint16
	SocketAddressPort            uint16
	SocketAddressAddress         []uint8
	VendorId                     uint16
	DeviceType                   uint16
	ProductCode                  uint16
	RevisionMajor                uint8
	RevisionMinor                uint8
	Status                       uint16
	SerialNumber                 uint32
	ProductName                  string
	State                        uint8
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_CipIdentity) GetItemType() uint16 {
	return 0x000C
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CipIdentity) InitializeParent(parent CommandSpecificDataItem) {}

func (m *_CipIdentity) GetParent() CommandSpecificDataItem {
	return m._CommandSpecificDataItem
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CipIdentity) GetEncapsulationProtocolVersion() uint16 {
	return m.EncapsulationProtocolVersion
}

func (m *_CipIdentity) GetSocketAddressFamily() uint16 {
	return m.SocketAddressFamily
}

func (m *_CipIdentity) GetSocketAddressPort() uint16 {
	return m.SocketAddressPort
}

func (m *_CipIdentity) GetSocketAddressAddress() []uint8 {
	return m.SocketAddressAddress
}

func (m *_CipIdentity) GetVendorId() uint16 {
	return m.VendorId
}

func (m *_CipIdentity) GetDeviceType() uint16 {
	return m.DeviceType
}

func (m *_CipIdentity) GetProductCode() uint16 {
	return m.ProductCode
}

func (m *_CipIdentity) GetRevisionMajor() uint8 {
	return m.RevisionMajor
}

func (m *_CipIdentity) GetRevisionMinor() uint8 {
	return m.RevisionMinor
}

func (m *_CipIdentity) GetStatus() uint16 {
	return m.Status
}

func (m *_CipIdentity) GetSerialNumber() uint32 {
	return m.SerialNumber
}

func (m *_CipIdentity) GetProductName() string {
	return m.ProductName
}

func (m *_CipIdentity) GetState() uint8 {
	return m.State
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for const fields.
///////////////////////

func (m *_CipIdentity) GetZeroes1() uint32 {
	return CipIdentity_ZEROES1
}

func (m *_CipIdentity) GetZeroes2() uint32 {
	return CipIdentity_ZEROES2
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewCipIdentity factory function for _CipIdentity
func NewCipIdentity(encapsulationProtocolVersion uint16, socketAddressFamily uint16, socketAddressPort uint16, socketAddressAddress []uint8, vendorId uint16, deviceType uint16, productCode uint16, revisionMajor uint8, revisionMinor uint8, status uint16, serialNumber uint32, productName string, state uint8) *_CipIdentity {
	_result := &_CipIdentity{
		EncapsulationProtocolVersion: encapsulationProtocolVersion,
		SocketAddressFamily:          socketAddressFamily,
		SocketAddressPort:            socketAddressPort,
		SocketAddressAddress:         socketAddressAddress,
		VendorId:                     vendorId,
		DeviceType:                   deviceType,
		ProductCode:                  productCode,
		RevisionMajor:                revisionMajor,
		RevisionMinor:                revisionMinor,
		Status:                       status,
		SerialNumber:                 serialNumber,
		ProductName:                  productName,
		State:                        state,
		_CommandSpecificDataItem:     NewCommandSpecificDataItem(),
	}
	_result._CommandSpecificDataItem._CommandSpecificDataItemChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastCipIdentity(structType any) CipIdentity {
	if casted, ok := structType.(CipIdentity); ok {
		return casted
	}
	if casted, ok := structType.(*CipIdentity); ok {
		return *casted
	}
	return nil
}

func (m *_CipIdentity) GetTypeName() string {
	return "CipIdentity"
}

func (m *_CipIdentity) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Implicit Field (itemLength)
	lengthInBits += 16

	// Simple field (encapsulationProtocolVersion)
	lengthInBits += 16

	// Simple field (socketAddressFamily)
	lengthInBits += 16

	// Simple field (socketAddressPort)
	lengthInBits += 16

	// Array field
	if len(m.SocketAddressAddress) > 0 {
		lengthInBits += 8 * uint16(len(m.SocketAddressAddress))
	}

	// Const Field (zeroes1)
	lengthInBits += 32

	// Const Field (zeroes2)
	lengthInBits += 32

	// Simple field (vendorId)
	lengthInBits += 16

	// Simple field (deviceType)
	lengthInBits += 16

	// Simple field (productCode)
	lengthInBits += 16

	// Simple field (revisionMajor)
	lengthInBits += 8

	// Simple field (revisionMinor)
	lengthInBits += 8

	// Simple field (status)
	lengthInBits += 16

	// Simple field (serialNumber)
	lengthInBits += 32

	// Implicit Field (productNameLength)
	lengthInBits += 8

	// Simple field (productName)
	lengthInBits += uint16(int32(uint8(len(m.GetProductName()))) * int32(int32(8)))

	// Simple field (state)
	lengthInBits += 8

	return lengthInBits
}

func (m *_CipIdentity) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func CipIdentityParse(ctx context.Context, theBytes []byte) (CipIdentity, error) {
	return CipIdentityParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func CipIdentityParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (CipIdentity, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("CipIdentity"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CipIdentity")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Implicit Field (itemLength) (Used for parsing, but its value is not stored as it's implicitly given by the objects content)
	itemLength, _itemLengthErr := readBuffer.ReadUint16("itemLength", 16)
	_ = itemLength
	if _itemLengthErr != nil {
		return nil, errors.Wrap(_itemLengthErr, "Error parsing 'itemLength' field of CipIdentity")
	}

	// Simple Field (encapsulationProtocolVersion)
	_encapsulationProtocolVersion, _encapsulationProtocolVersionErr := readBuffer.ReadUint16("encapsulationProtocolVersion", 16)
	if _encapsulationProtocolVersionErr != nil {
		return nil, errors.Wrap(_encapsulationProtocolVersionErr, "Error parsing 'encapsulationProtocolVersion' field of CipIdentity")
	}
	encapsulationProtocolVersion := _encapsulationProtocolVersion

	// Simple Field (socketAddressFamily)
	_socketAddressFamily, _socketAddressFamilyErr := readBuffer.ReadUint16("socketAddressFamily", 16)
	if _socketAddressFamilyErr != nil {
		return nil, errors.Wrap(_socketAddressFamilyErr, "Error parsing 'socketAddressFamily' field of CipIdentity")
	}
	socketAddressFamily := _socketAddressFamily

	// Simple Field (socketAddressPort)
	_socketAddressPort, _socketAddressPortErr := readBuffer.ReadUint16("socketAddressPort", 16)
	if _socketAddressPortErr != nil {
		return nil, errors.Wrap(_socketAddressPortErr, "Error parsing 'socketAddressPort' field of CipIdentity")
	}
	socketAddressPort := _socketAddressPort

	// Array field (socketAddressAddress)
	if pullErr := readBuffer.PullContext("socketAddressAddress", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for socketAddressAddress")
	}
	// Count array
	socketAddressAddress := make([]uint8, utils.Max(uint16(4), 0))
	// This happens when the size is set conditional to 0
	if len(socketAddressAddress) == 0 {
		socketAddressAddress = nil
	}
	{
		_numItems := uint16(utils.Max(uint16(4), 0))
		for _curItem := uint16(0); _curItem < _numItems; _curItem++ {
			arrayCtx := utils.CreateArrayContext(ctx, int(_numItems), int(_curItem))
			_ = arrayCtx
			_ = _curItem
			_item, _err := readBuffer.ReadUint8("", 8)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'socketAddressAddress' field of CipIdentity")
			}
			socketAddressAddress[_curItem] = _item
		}
	}
	if closeErr := readBuffer.CloseContext("socketAddressAddress", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for socketAddressAddress")
	}

	// Const Field (zeroes1)
	zeroes1, _zeroes1Err := readBuffer.ReadUint32("zeroes1", 32)
	if _zeroes1Err != nil {
		return nil, errors.Wrap(_zeroes1Err, "Error parsing 'zeroes1' field of CipIdentity")
	}
	if zeroes1 != CipIdentity_ZEROES1 {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", CipIdentity_ZEROES1) + " but got " + fmt.Sprintf("%d", zeroes1))
	}

	// Const Field (zeroes2)
	zeroes2, _zeroes2Err := readBuffer.ReadUint32("zeroes2", 32)
	if _zeroes2Err != nil {
		return nil, errors.Wrap(_zeroes2Err, "Error parsing 'zeroes2' field of CipIdentity")
	}
	if zeroes2 != CipIdentity_ZEROES2 {
		return nil, errors.New("Expected constant value " + fmt.Sprintf("%d", CipIdentity_ZEROES2) + " but got " + fmt.Sprintf("%d", zeroes2))
	}

	// Simple Field (vendorId)
	_vendorId, _vendorIdErr := readBuffer.ReadUint16("vendorId", 16)
	if _vendorIdErr != nil {
		return nil, errors.Wrap(_vendorIdErr, "Error parsing 'vendorId' field of CipIdentity")
	}
	vendorId := _vendorId

	// Simple Field (deviceType)
	_deviceType, _deviceTypeErr := readBuffer.ReadUint16("deviceType", 16)
	if _deviceTypeErr != nil {
		return nil, errors.Wrap(_deviceTypeErr, "Error parsing 'deviceType' field of CipIdentity")
	}
	deviceType := _deviceType

	// Simple Field (productCode)
	_productCode, _productCodeErr := readBuffer.ReadUint16("productCode", 16)
	if _productCodeErr != nil {
		return nil, errors.Wrap(_productCodeErr, "Error parsing 'productCode' field of CipIdentity")
	}
	productCode := _productCode

	// Simple Field (revisionMajor)
	_revisionMajor, _revisionMajorErr := readBuffer.ReadUint8("revisionMajor", 8)
	if _revisionMajorErr != nil {
		return nil, errors.Wrap(_revisionMajorErr, "Error parsing 'revisionMajor' field of CipIdentity")
	}
	revisionMajor := _revisionMajor

	// Simple Field (revisionMinor)
	_revisionMinor, _revisionMinorErr := readBuffer.ReadUint8("revisionMinor", 8)
	if _revisionMinorErr != nil {
		return nil, errors.Wrap(_revisionMinorErr, "Error parsing 'revisionMinor' field of CipIdentity")
	}
	revisionMinor := _revisionMinor

	// Simple Field (status)
	_status, _statusErr := readBuffer.ReadUint16("status", 16)
	if _statusErr != nil {
		return nil, errors.Wrap(_statusErr, "Error parsing 'status' field of CipIdentity")
	}
	status := _status

	// Simple Field (serialNumber)
	_serialNumber, _serialNumberErr := readBuffer.ReadUint32("serialNumber", 32)
	if _serialNumberErr != nil {
		return nil, errors.Wrap(_serialNumberErr, "Error parsing 'serialNumber' field of CipIdentity")
	}
	serialNumber := _serialNumber

	// Implicit Field (productNameLength) (Used for parsing, but its value is not stored as it's implicitly given by the objects content)
	productNameLength, _productNameLengthErr := readBuffer.ReadUint8("productNameLength", 8)
	_ = productNameLength
	if _productNameLengthErr != nil {
		return nil, errors.Wrap(_productNameLengthErr, "Error parsing 'productNameLength' field of CipIdentity")
	}

	// Simple Field (productName)
	_productName, _productNameErr := readBuffer.ReadString("productName", uint32((productNameLength)*(8)), "UTF-8")
	if _productNameErr != nil {
		return nil, errors.Wrap(_productNameErr, "Error parsing 'productName' field of CipIdentity")
	}
	productName := _productName

	// Simple Field (state)
	_state, _stateErr := readBuffer.ReadUint8("state", 8)
	if _stateErr != nil {
		return nil, errors.Wrap(_stateErr, "Error parsing 'state' field of CipIdentity")
	}
	state := _state

	if closeErr := readBuffer.CloseContext("CipIdentity"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CipIdentity")
	}

	// Create a partially initialized instance
	_child := &_CipIdentity{
		_CommandSpecificDataItem:     &_CommandSpecificDataItem{},
		EncapsulationProtocolVersion: encapsulationProtocolVersion,
		SocketAddressFamily:          socketAddressFamily,
		SocketAddressPort:            socketAddressPort,
		SocketAddressAddress:         socketAddressAddress,
		VendorId:                     vendorId,
		DeviceType:                   deviceType,
		ProductCode:                  productCode,
		RevisionMajor:                revisionMajor,
		RevisionMinor:                revisionMinor,
		Status:                       status,
		SerialNumber:                 serialNumber,
		ProductName:                  productName,
		State:                        state,
	}
	_child._CommandSpecificDataItem._CommandSpecificDataItemChildRequirements = _child
	return _child, nil
}

func (m *_CipIdentity) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_CipIdentity) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CipIdentity"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CipIdentity")
		}

		// Implicit Field (itemLength) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
		itemLength := uint16(uint16(uint16(34)) + uint16(uint8(len(m.GetProductName()))))
		_itemLengthErr := writeBuffer.WriteUint16("itemLength", 16, (itemLength))
		if _itemLengthErr != nil {
			return errors.Wrap(_itemLengthErr, "Error serializing 'itemLength' field")
		}

		// Simple Field (encapsulationProtocolVersion)
		encapsulationProtocolVersion := uint16(m.GetEncapsulationProtocolVersion())
		_encapsulationProtocolVersionErr := writeBuffer.WriteUint16("encapsulationProtocolVersion", 16, (encapsulationProtocolVersion))
		if _encapsulationProtocolVersionErr != nil {
			return errors.Wrap(_encapsulationProtocolVersionErr, "Error serializing 'encapsulationProtocolVersion' field")
		}

		// Simple Field (socketAddressFamily)
		socketAddressFamily := uint16(m.GetSocketAddressFamily())
		_socketAddressFamilyErr := writeBuffer.WriteUint16("socketAddressFamily", 16, (socketAddressFamily))
		if _socketAddressFamilyErr != nil {
			return errors.Wrap(_socketAddressFamilyErr, "Error serializing 'socketAddressFamily' field")
		}

		// Simple Field (socketAddressPort)
		socketAddressPort := uint16(m.GetSocketAddressPort())
		_socketAddressPortErr := writeBuffer.WriteUint16("socketAddressPort", 16, (socketAddressPort))
		if _socketAddressPortErr != nil {
			return errors.Wrap(_socketAddressPortErr, "Error serializing 'socketAddressPort' field")
		}

		// Array Field (socketAddressAddress)
		if pushErr := writeBuffer.PushContext("socketAddressAddress", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for socketAddressAddress")
		}
		for _curItem, _element := range m.GetSocketAddressAddress() {
			_ = _curItem
			_elementErr := writeBuffer.WriteUint8("", 8, _element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'socketAddressAddress' field")
			}
		}
		if popErr := writeBuffer.PopContext("socketAddressAddress", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for socketAddressAddress")
		}

		// Const Field (zeroes1)
		_zeroes1Err := writeBuffer.WriteUint32("zeroes1", 32, 0x00000000)
		if _zeroes1Err != nil {
			return errors.Wrap(_zeroes1Err, "Error serializing 'zeroes1' field")
		}

		// Const Field (zeroes2)
		_zeroes2Err := writeBuffer.WriteUint32("zeroes2", 32, 0x00000000)
		if _zeroes2Err != nil {
			return errors.Wrap(_zeroes2Err, "Error serializing 'zeroes2' field")
		}

		// Simple Field (vendorId)
		vendorId := uint16(m.GetVendorId())
		_vendorIdErr := writeBuffer.WriteUint16("vendorId", 16, (vendorId))
		if _vendorIdErr != nil {
			return errors.Wrap(_vendorIdErr, "Error serializing 'vendorId' field")
		}

		// Simple Field (deviceType)
		deviceType := uint16(m.GetDeviceType())
		_deviceTypeErr := writeBuffer.WriteUint16("deviceType", 16, (deviceType))
		if _deviceTypeErr != nil {
			return errors.Wrap(_deviceTypeErr, "Error serializing 'deviceType' field")
		}

		// Simple Field (productCode)
		productCode := uint16(m.GetProductCode())
		_productCodeErr := writeBuffer.WriteUint16("productCode", 16, (productCode))
		if _productCodeErr != nil {
			return errors.Wrap(_productCodeErr, "Error serializing 'productCode' field")
		}

		// Simple Field (revisionMajor)
		revisionMajor := uint8(m.GetRevisionMajor())
		_revisionMajorErr := writeBuffer.WriteUint8("revisionMajor", 8, (revisionMajor))
		if _revisionMajorErr != nil {
			return errors.Wrap(_revisionMajorErr, "Error serializing 'revisionMajor' field")
		}

		// Simple Field (revisionMinor)
		revisionMinor := uint8(m.GetRevisionMinor())
		_revisionMinorErr := writeBuffer.WriteUint8("revisionMinor", 8, (revisionMinor))
		if _revisionMinorErr != nil {
			return errors.Wrap(_revisionMinorErr, "Error serializing 'revisionMinor' field")
		}

		// Simple Field (status)
		status := uint16(m.GetStatus())
		_statusErr := writeBuffer.WriteUint16("status", 16, (status))
		if _statusErr != nil {
			return errors.Wrap(_statusErr, "Error serializing 'status' field")
		}

		// Simple Field (serialNumber)
		serialNumber := uint32(m.GetSerialNumber())
		_serialNumberErr := writeBuffer.WriteUint32("serialNumber", 32, (serialNumber))
		if _serialNumberErr != nil {
			return errors.Wrap(_serialNumberErr, "Error serializing 'serialNumber' field")
		}

		// Implicit Field (productNameLength) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
		productNameLength := uint8(uint8(len(m.GetProductName())))
		_productNameLengthErr := writeBuffer.WriteUint8("productNameLength", 8, (productNameLength))
		if _productNameLengthErr != nil {
			return errors.Wrap(_productNameLengthErr, "Error serializing 'productNameLength' field")
		}

		// Simple Field (productName)
		productName := string(m.GetProductName())
		_productNameErr := writeBuffer.WriteString("productName", uint32((uint8(len(m.GetProductName())))*(8)), "UTF-8", (productName))
		if _productNameErr != nil {
			return errors.Wrap(_productNameErr, "Error serializing 'productName' field")
		}

		// Simple Field (state)
		state := uint8(m.GetState())
		_stateErr := writeBuffer.WriteUint8("state", 8, (state))
		if _stateErr != nil {
			return errors.Wrap(_stateErr, "Error serializing 'state' field")
		}

		if popErr := writeBuffer.PopContext("CipIdentity"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CipIdentity")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_CipIdentity) isCipIdentity() bool {
	return true
}

func (m *_CipIdentity) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
