/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// TelephonyDataInternetConnectionRequestMade is the corresponding interface of TelephonyDataInternetConnectionRequestMade
type TelephonyDataInternetConnectionRequestMade interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	TelephonyData
}

// TelephonyDataInternetConnectionRequestMadeExactly can be used when we want exactly this type and not a type which fulfills TelephonyDataInternetConnectionRequestMade.
// This is useful for switch cases.
type TelephonyDataInternetConnectionRequestMadeExactly interface {
	TelephonyDataInternetConnectionRequestMade
	isTelephonyDataInternetConnectionRequestMade() bool
}

// _TelephonyDataInternetConnectionRequestMade is the data-structure of this message
type _TelephonyDataInternetConnectionRequestMade struct {
	*_TelephonyData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_TelephonyDataInternetConnectionRequestMade) InitializeParent(parent TelephonyData, commandTypeContainer TelephonyCommandTypeContainer, argument byte) {
	m.CommandTypeContainer = commandTypeContainer
	m.Argument = argument
}

func (m *_TelephonyDataInternetConnectionRequestMade) GetParent() TelephonyData {
	return m._TelephonyData
}

// NewTelephonyDataInternetConnectionRequestMade factory function for _TelephonyDataInternetConnectionRequestMade
func NewTelephonyDataInternetConnectionRequestMade(commandTypeContainer TelephonyCommandTypeContainer, argument byte) *_TelephonyDataInternetConnectionRequestMade {
	_result := &_TelephonyDataInternetConnectionRequestMade{
		_TelephonyData: NewTelephonyData(commandTypeContainer, argument),
	}
	_result._TelephonyData._TelephonyDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastTelephonyDataInternetConnectionRequestMade(structType any) TelephonyDataInternetConnectionRequestMade {
	if casted, ok := structType.(TelephonyDataInternetConnectionRequestMade); ok {
		return casted
	}
	if casted, ok := structType.(*TelephonyDataInternetConnectionRequestMade); ok {
		return *casted
	}
	return nil
}

func (m *_TelephonyDataInternetConnectionRequestMade) GetTypeName() string {
	return "TelephonyDataInternetConnectionRequestMade"
}

func (m *_TelephonyDataInternetConnectionRequestMade) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	return lengthInBits
}

func (m *_TelephonyDataInternetConnectionRequestMade) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func TelephonyDataInternetConnectionRequestMadeParse(ctx context.Context, theBytes []byte) (TelephonyDataInternetConnectionRequestMade, error) {
	return TelephonyDataInternetConnectionRequestMadeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func TelephonyDataInternetConnectionRequestMadeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (TelephonyDataInternetConnectionRequestMade, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("TelephonyDataInternetConnectionRequestMade"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for TelephonyDataInternetConnectionRequestMade")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("TelephonyDataInternetConnectionRequestMade"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for TelephonyDataInternetConnectionRequestMade")
	}

	// Create a partially initialized instance
	_child := &_TelephonyDataInternetConnectionRequestMade{
		_TelephonyData: &_TelephonyData{},
	}
	_child._TelephonyData._TelephonyDataChildRequirements = _child
	return _child, nil
}

func (m *_TelephonyDataInternetConnectionRequestMade) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_TelephonyDataInternetConnectionRequestMade) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("TelephonyDataInternetConnectionRequestMade"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for TelephonyDataInternetConnectionRequestMade")
		}

		if popErr := writeBuffer.PopContext("TelephonyDataInternetConnectionRequestMade"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for TelephonyDataInternetConnectionRequestMade")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_TelephonyDataInternetConnectionRequestMade) isTelephonyDataInternetConnectionRequestMade() bool {
	return true
}

func (m *_TelephonyDataInternetConnectionRequestMade) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
