/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// NLMUpdateKeyDistributionKey is the corresponding interface of NLMUpdateKeyDistributionKey
type NLMUpdateKeyDistributionKey interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	NLM
	// GetKeyRevision returns KeyRevision (property field)
	GetKeyRevision() byte
	// GetKey returns Key (property field)
	GetKey() NLMUpdateKeyUpdateKeyEntry
}

// NLMUpdateKeyDistributionKeyExactly can be used when we want exactly this type and not a type which fulfills NLMUpdateKeyDistributionKey.
// This is useful for switch cases.
type NLMUpdateKeyDistributionKeyExactly interface {
	NLMUpdateKeyDistributionKey
	isNLMUpdateKeyDistributionKey() bool
}

// _NLMUpdateKeyDistributionKey is the data-structure of this message
type _NLMUpdateKeyDistributionKey struct {
	*_NLM
	KeyRevision byte
	Key         NLMUpdateKeyUpdateKeyEntry
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_NLMUpdateKeyDistributionKey) GetMessageType() uint8 {
	return 0x0F
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_NLMUpdateKeyDistributionKey) InitializeParent(parent NLM) {}

func (m *_NLMUpdateKeyDistributionKey) GetParent() NLM {
	return m._NLM
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_NLMUpdateKeyDistributionKey) GetKeyRevision() byte {
	return m.KeyRevision
}

func (m *_NLMUpdateKeyDistributionKey) GetKey() NLMUpdateKeyUpdateKeyEntry {
	return m.Key
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewNLMUpdateKeyDistributionKey factory function for _NLMUpdateKeyDistributionKey
func NewNLMUpdateKeyDistributionKey(keyRevision byte, key NLMUpdateKeyUpdateKeyEntry, apduLength uint16) *_NLMUpdateKeyDistributionKey {
	_result := &_NLMUpdateKeyDistributionKey{
		KeyRevision: keyRevision,
		Key:         key,
		_NLM:        NewNLM(apduLength),
	}
	_result._NLM._NLMChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastNLMUpdateKeyDistributionKey(structType any) NLMUpdateKeyDistributionKey {
	if casted, ok := structType.(NLMUpdateKeyDistributionKey); ok {
		return casted
	}
	if casted, ok := structType.(*NLMUpdateKeyDistributionKey); ok {
		return *casted
	}
	return nil
}

func (m *_NLMUpdateKeyDistributionKey) GetTypeName() string {
	return "NLMUpdateKeyDistributionKey"
}

func (m *_NLMUpdateKeyDistributionKey) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (keyRevision)
	lengthInBits += 8

	// Simple field (key)
	lengthInBits += m.Key.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_NLMUpdateKeyDistributionKey) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func NLMUpdateKeyDistributionKeyParse(ctx context.Context, theBytes []byte, apduLength uint16) (NLMUpdateKeyDistributionKey, error) {
	return NLMUpdateKeyDistributionKeyParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), apduLength)
}

func NLMUpdateKeyDistributionKeyParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, apduLength uint16) (NLMUpdateKeyDistributionKey, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("NLMUpdateKeyDistributionKey"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for NLMUpdateKeyDistributionKey")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (keyRevision)
	_keyRevision, _keyRevisionErr := readBuffer.ReadByte("keyRevision")
	if _keyRevisionErr != nil {
		return nil, errors.Wrap(_keyRevisionErr, "Error parsing 'keyRevision' field of NLMUpdateKeyDistributionKey")
	}
	keyRevision := _keyRevision

	// Simple Field (key)
	if pullErr := readBuffer.PullContext("key"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for key")
	}
	_key, _keyErr := NLMUpdateKeyUpdateKeyEntryParseWithBuffer(ctx, readBuffer)
	if _keyErr != nil {
		return nil, errors.Wrap(_keyErr, "Error parsing 'key' field of NLMUpdateKeyDistributionKey")
	}
	key := _key.(NLMUpdateKeyUpdateKeyEntry)
	if closeErr := readBuffer.CloseContext("key"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for key")
	}

	if closeErr := readBuffer.CloseContext("NLMUpdateKeyDistributionKey"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for NLMUpdateKeyDistributionKey")
	}

	// Create a partially initialized instance
	_child := &_NLMUpdateKeyDistributionKey{
		_NLM: &_NLM{
			ApduLength: apduLength,
		},
		KeyRevision: keyRevision,
		Key:         key,
	}
	_child._NLM._NLMChildRequirements = _child
	return _child, nil
}

func (m *_NLMUpdateKeyDistributionKey) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_NLMUpdateKeyDistributionKey) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("NLMUpdateKeyDistributionKey"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for NLMUpdateKeyDistributionKey")
		}

		// Simple Field (keyRevision)
		keyRevision := byte(m.GetKeyRevision())
		_keyRevisionErr := writeBuffer.WriteByte("keyRevision", (keyRevision))
		if _keyRevisionErr != nil {
			return errors.Wrap(_keyRevisionErr, "Error serializing 'keyRevision' field")
		}

		// Simple Field (key)
		if pushErr := writeBuffer.PushContext("key"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for key")
		}
		_keyErr := writeBuffer.WriteSerializable(ctx, m.GetKey())
		if popErr := writeBuffer.PopContext("key"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for key")
		}
		if _keyErr != nil {
			return errors.Wrap(_keyErr, "Error serializing 'key' field")
		}

		if popErr := writeBuffer.PopContext("NLMUpdateKeyDistributionKey"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for NLMUpdateKeyDistributionKey")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_NLMUpdateKeyDistributionKey) isNLMUpdateKeyDistributionKey() bool {
	return true
}

func (m *_NLMUpdateKeyDistributionKey) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
