/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLastUseTime is the corresponding interface of BACnetConstructedDataLastUseTime
type BACnetConstructedDataLastUseTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetLastUseTime returns LastUseTime (property field)
	GetLastUseTime() BACnetDateTime
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDateTime
}

// BACnetConstructedDataLastUseTimeExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataLastUseTime.
// This is useful for switch cases.
type BACnetConstructedDataLastUseTimeExactly interface {
	BACnetConstructedDataLastUseTime
	isBACnetConstructedDataLastUseTime() bool
}

// _BACnetConstructedDataLastUseTime is the data-structure of this message
type _BACnetConstructedDataLastUseTime struct {
	*_BACnetConstructedData
	LastUseTime BACnetDateTime
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLastUseTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLastUseTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LAST_USE_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLastUseTime) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataLastUseTime) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLastUseTime) GetLastUseTime() BACnetDateTime {
	return m.LastUseTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLastUseTime) GetActualValue() BACnetDateTime {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDateTime(m.GetLastUseTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataLastUseTime factory function for _BACnetConstructedDataLastUseTime
func NewBACnetConstructedDataLastUseTime(lastUseTime BACnetDateTime, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLastUseTime {
	_result := &_BACnetConstructedDataLastUseTime{
		LastUseTime:            lastUseTime,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLastUseTime(structType any) BACnetConstructedDataLastUseTime {
	if casted, ok := structType.(BACnetConstructedDataLastUseTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLastUseTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLastUseTime) GetTypeName() string {
	return "BACnetConstructedDataLastUseTime"
}

func (m *_BACnetConstructedDataLastUseTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (lastUseTime)
	lengthInBits += m.LastUseTime.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLastUseTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetConstructedDataLastUseTimeParse(ctx context.Context, theBytes []byte, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataLastUseTime, error) {
	return BACnetConstructedDataLastUseTimeParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
}

func BACnetConstructedDataLastUseTimeParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataLastUseTime, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLastUseTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLastUseTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (lastUseTime)
	if pullErr := readBuffer.PullContext("lastUseTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for lastUseTime")
	}
	_lastUseTime, _lastUseTimeErr := BACnetDateTimeParseWithBuffer(ctx, readBuffer)
	if _lastUseTimeErr != nil {
		return nil, errors.Wrap(_lastUseTimeErr, "Error parsing 'lastUseTime' field of BACnetConstructedDataLastUseTime")
	}
	lastUseTime := _lastUseTime.(BACnetDateTime)
	if closeErr := readBuffer.CloseContext("lastUseTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for lastUseTime")
	}

	// Virtual field
	_actualValue := lastUseTime
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLastUseTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLastUseTime")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataLastUseTime{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		LastUseTime: lastUseTime,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataLastUseTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLastUseTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLastUseTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLastUseTime")
		}

		// Simple Field (lastUseTime)
		if pushErr := writeBuffer.PushContext("lastUseTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for lastUseTime")
		}
		_lastUseTimeErr := writeBuffer.WriteSerializable(ctx, m.GetLastUseTime())
		if popErr := writeBuffer.PopContext("lastUseTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for lastUseTime")
		}
		if _lastUseTimeErr != nil {
			return errors.Wrap(_lastUseTimeErr, "Error serializing 'lastUseTime' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLastUseTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLastUseTime")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLastUseTime) isBACnetConstructedDataLastUseTime() bool {
	return true
}

func (m *_BACnetConstructedDataLastUseTime) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
