/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataIsUTC is the corresponding interface of BACnetConstructedDataIsUTC
type BACnetConstructedDataIsUTC interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetIsUtc returns IsUtc (property field)
	GetIsUtc() BACnetApplicationTagBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBoolean
}

// BACnetConstructedDataIsUTCExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataIsUTC.
// This is useful for switch cases.
type BACnetConstructedDataIsUTCExactly interface {
	BACnetConstructedDataIsUTC
	isBACnetConstructedDataIsUTC() bool
}

// _BACnetConstructedDataIsUTC is the data-structure of this message
type _BACnetConstructedDataIsUTC struct {
	*_BACnetConstructedData
	IsUtc BACnetApplicationTagBoolean
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataIsUTC) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataIsUTC) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_IS_UTC
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataIsUTC) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataIsUTC) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataIsUTC) GetIsUtc() BACnetApplicationTagBoolean {
	return m.IsUtc
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataIsUTC) GetActualValue() BACnetApplicationTagBoolean {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagBoolean(m.GetIsUtc())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataIsUTC factory function for _BACnetConstructedDataIsUTC
func NewBACnetConstructedDataIsUTC(isUtc BACnetApplicationTagBoolean, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataIsUTC {
	_result := &_BACnetConstructedDataIsUTC{
		IsUtc:                  isUtc,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataIsUTC(structType any) BACnetConstructedDataIsUTC {
	if casted, ok := structType.(BACnetConstructedDataIsUTC); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataIsUTC); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataIsUTC) GetTypeName() string {
	return "BACnetConstructedDataIsUTC"
}

func (m *_BACnetConstructedDataIsUTC) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (isUtc)
	lengthInBits += m.IsUtc.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataIsUTC) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetConstructedDataIsUTCParse(ctx context.Context, theBytes []byte, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataIsUTC, error) {
	return BACnetConstructedDataIsUTCParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
}

func BACnetConstructedDataIsUTCParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataIsUTC, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetConstructedDataIsUTC"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataIsUTC")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (isUtc)
	if pullErr := readBuffer.PullContext("isUtc"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for isUtc")
	}
	_isUtc, _isUtcErr := BACnetApplicationTagParseWithBuffer(ctx, readBuffer)
	if _isUtcErr != nil {
		return nil, errors.Wrap(_isUtcErr, "Error parsing 'isUtc' field of BACnetConstructedDataIsUTC")
	}
	isUtc := _isUtc.(BACnetApplicationTagBoolean)
	if closeErr := readBuffer.CloseContext("isUtc"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for isUtc")
	}

	// Virtual field
	_actualValue := isUtc
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataIsUTC"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataIsUTC")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataIsUTC{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		IsUtc: isUtc,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataIsUTC) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataIsUTC) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataIsUTC"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataIsUTC")
		}

		// Simple Field (isUtc)
		if pushErr := writeBuffer.PushContext("isUtc"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for isUtc")
		}
		_isUtcErr := writeBuffer.WriteSerializable(ctx, m.GetIsUtc())
		if popErr := writeBuffer.PopContext("isUtc"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for isUtc")
		}
		if _isUtcErr != nil {
			return errors.Wrap(_isUtcErr, "Error serializing 'isUtc' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataIsUTC"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataIsUTC")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataIsUTC) isBACnetConstructedDataIsUTC() bool {
	return true
}

func (m *_BACnetConstructedDataIsUTC) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
