/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConfirmedServiceRequestAtomicReadFileRecord is the corresponding interface of BACnetConfirmedServiceRequestAtomicReadFileRecord
type BACnetConfirmedServiceRequestAtomicReadFileRecord interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord
	// GetFileStartRecord returns FileStartRecord (property field)
	GetFileStartRecord() BACnetApplicationTagSignedInteger
	// GetRequestRecordCount returns RequestRecordCount (property field)
	GetRequestRecordCount() BACnetApplicationTagUnsignedInteger
}

// BACnetConfirmedServiceRequestAtomicReadFileRecordExactly can be used when we want exactly this type and not a type which fulfills BACnetConfirmedServiceRequestAtomicReadFileRecord.
// This is useful for switch cases.
type BACnetConfirmedServiceRequestAtomicReadFileRecordExactly interface {
	BACnetConfirmedServiceRequestAtomicReadFileRecord
	isBACnetConfirmedServiceRequestAtomicReadFileRecord() bool
}

// _BACnetConfirmedServiceRequestAtomicReadFileRecord is the data-structure of this message
type _BACnetConfirmedServiceRequestAtomicReadFileRecord struct {
	*_BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord
	FileStartRecord    BACnetApplicationTagSignedInteger
	RequestRecordCount BACnetApplicationTagUnsignedInteger
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConfirmedServiceRequestAtomicReadFileRecord) InitializeParent(parent BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord, peekedTagHeader BACnetTagHeader, openingTag BACnetOpeningTag, closingTag BACnetClosingTag) {
	m.PeekedTagHeader = peekedTagHeader
	m.OpeningTag = openingTag
	m.ClosingTag = closingTag
}

func (m *_BACnetConfirmedServiceRequestAtomicReadFileRecord) GetParent() BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord {
	return m._BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConfirmedServiceRequestAtomicReadFileRecord) GetFileStartRecord() BACnetApplicationTagSignedInteger {
	return m.FileStartRecord
}

func (m *_BACnetConfirmedServiceRequestAtomicReadFileRecord) GetRequestRecordCount() BACnetApplicationTagUnsignedInteger {
	return m.RequestRecordCount
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConfirmedServiceRequestAtomicReadFileRecord factory function for _BACnetConfirmedServiceRequestAtomicReadFileRecord
func NewBACnetConfirmedServiceRequestAtomicReadFileRecord(fileStartRecord BACnetApplicationTagSignedInteger, requestRecordCount BACnetApplicationTagUnsignedInteger, peekedTagHeader BACnetTagHeader, openingTag BACnetOpeningTag, closingTag BACnetClosingTag) *_BACnetConfirmedServiceRequestAtomicReadFileRecord {
	_result := &_BACnetConfirmedServiceRequestAtomicReadFileRecord{
		FileStartRecord:    fileStartRecord,
		RequestRecordCount: requestRecordCount,
		_BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord: NewBACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord(peekedTagHeader, openingTag, closingTag),
	}
	_result._BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord._BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecordChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConfirmedServiceRequestAtomicReadFileRecord(structType any) BACnetConfirmedServiceRequestAtomicReadFileRecord {
	if casted, ok := structType.(BACnetConfirmedServiceRequestAtomicReadFileRecord); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConfirmedServiceRequestAtomicReadFileRecord); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConfirmedServiceRequestAtomicReadFileRecord) GetTypeName() string {
	return "BACnetConfirmedServiceRequestAtomicReadFileRecord"
}

func (m *_BACnetConfirmedServiceRequestAtomicReadFileRecord) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Simple field (fileStartRecord)
	lengthInBits += m.FileStartRecord.GetLengthInBits(ctx)

	// Simple field (requestRecordCount)
	lengthInBits += m.RequestRecordCount.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetConfirmedServiceRequestAtomicReadFileRecord) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetConfirmedServiceRequestAtomicReadFileRecordParse(ctx context.Context, theBytes []byte) (BACnetConfirmedServiceRequestAtomicReadFileRecord, error) {
	return BACnetConfirmedServiceRequestAtomicReadFileRecordParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetConfirmedServiceRequestAtomicReadFileRecordParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetConfirmedServiceRequestAtomicReadFileRecord, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetConfirmedServiceRequestAtomicReadFileRecord"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConfirmedServiceRequestAtomicReadFileRecord")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (fileStartRecord)
	if pullErr := readBuffer.PullContext("fileStartRecord"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for fileStartRecord")
	}
	_fileStartRecord, _fileStartRecordErr := BACnetApplicationTagParseWithBuffer(ctx, readBuffer)
	if _fileStartRecordErr != nil {
		return nil, errors.Wrap(_fileStartRecordErr, "Error parsing 'fileStartRecord' field of BACnetConfirmedServiceRequestAtomicReadFileRecord")
	}
	fileStartRecord := _fileStartRecord.(BACnetApplicationTagSignedInteger)
	if closeErr := readBuffer.CloseContext("fileStartRecord"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for fileStartRecord")
	}

	// Simple Field (requestRecordCount)
	if pullErr := readBuffer.PullContext("requestRecordCount"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for requestRecordCount")
	}
	_requestRecordCount, _requestRecordCountErr := BACnetApplicationTagParseWithBuffer(ctx, readBuffer)
	if _requestRecordCountErr != nil {
		return nil, errors.Wrap(_requestRecordCountErr, "Error parsing 'requestRecordCount' field of BACnetConfirmedServiceRequestAtomicReadFileRecord")
	}
	requestRecordCount := _requestRecordCount.(BACnetApplicationTagUnsignedInteger)
	if closeErr := readBuffer.CloseContext("requestRecordCount"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for requestRecordCount")
	}

	if closeErr := readBuffer.CloseContext("BACnetConfirmedServiceRequestAtomicReadFileRecord"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConfirmedServiceRequestAtomicReadFileRecord")
	}

	// Create a partially initialized instance
	_child := &_BACnetConfirmedServiceRequestAtomicReadFileRecord{
		_BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord: &_BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord{},
		FileStartRecord:    fileStartRecord,
		RequestRecordCount: requestRecordCount,
	}
	_child._BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord._BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecordChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConfirmedServiceRequestAtomicReadFileRecord) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConfirmedServiceRequestAtomicReadFileRecord) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConfirmedServiceRequestAtomicReadFileRecord"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConfirmedServiceRequestAtomicReadFileRecord")
		}

		// Simple Field (fileStartRecord)
		if pushErr := writeBuffer.PushContext("fileStartRecord"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for fileStartRecord")
		}
		_fileStartRecordErr := writeBuffer.WriteSerializable(ctx, m.GetFileStartRecord())
		if popErr := writeBuffer.PopContext("fileStartRecord"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for fileStartRecord")
		}
		if _fileStartRecordErr != nil {
			return errors.Wrap(_fileStartRecordErr, "Error serializing 'fileStartRecord' field")
		}

		// Simple Field (requestRecordCount)
		if pushErr := writeBuffer.PushContext("requestRecordCount"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for requestRecordCount")
		}
		_requestRecordCountErr := writeBuffer.WriteSerializable(ctx, m.GetRequestRecordCount())
		if popErr := writeBuffer.PopContext("requestRecordCount"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for requestRecordCount")
		}
		if _requestRecordCountErr != nil {
			return errors.Wrap(_requestRecordCountErr, "Error serializing 'requestRecordCount' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConfirmedServiceRequestAtomicReadFileRecord"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConfirmedServiceRequestAtomicReadFileRecord")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConfirmedServiceRequestAtomicReadFileRecord) isBACnetConfirmedServiceRequestAtomicReadFileRecord() bool {
	return true
}

func (m *_BACnetConfirmedServiceRequestAtomicReadFileRecord) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
