/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetAuthenticationPolicy is the corresponding interface of BACnetAuthenticationPolicy
type BACnetAuthenticationPolicy interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetPolicy returns Policy (property field)
	GetPolicy() BACnetAuthenticationPolicyList
	// GetOrderEnforced returns OrderEnforced (property field)
	GetOrderEnforced() BACnetContextTagBoolean
	// GetTimeout returns Timeout (property field)
	GetTimeout() BACnetContextTagUnsignedInteger
}

// BACnetAuthenticationPolicyExactly can be used when we want exactly this type and not a type which fulfills BACnetAuthenticationPolicy.
// This is useful for switch cases.
type BACnetAuthenticationPolicyExactly interface {
	BACnetAuthenticationPolicy
	isBACnetAuthenticationPolicy() bool
}

// _BACnetAuthenticationPolicy is the data-structure of this message
type _BACnetAuthenticationPolicy struct {
	Policy        BACnetAuthenticationPolicyList
	OrderEnforced BACnetContextTagBoolean
	Timeout       BACnetContextTagUnsignedInteger
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetAuthenticationPolicy) GetPolicy() BACnetAuthenticationPolicyList {
	return m.Policy
}

func (m *_BACnetAuthenticationPolicy) GetOrderEnforced() BACnetContextTagBoolean {
	return m.OrderEnforced
}

func (m *_BACnetAuthenticationPolicy) GetTimeout() BACnetContextTagUnsignedInteger {
	return m.Timeout
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetAuthenticationPolicy factory function for _BACnetAuthenticationPolicy
func NewBACnetAuthenticationPolicy(policy BACnetAuthenticationPolicyList, orderEnforced BACnetContextTagBoolean, timeout BACnetContextTagUnsignedInteger) *_BACnetAuthenticationPolicy {
	return &_BACnetAuthenticationPolicy{Policy: policy, OrderEnforced: orderEnforced, Timeout: timeout}
}

// Deprecated: use the interface for direct cast
func CastBACnetAuthenticationPolicy(structType any) BACnetAuthenticationPolicy {
	if casted, ok := structType.(BACnetAuthenticationPolicy); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetAuthenticationPolicy); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetAuthenticationPolicy) GetTypeName() string {
	return "BACnetAuthenticationPolicy"
}

func (m *_BACnetAuthenticationPolicy) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (policy)
	lengthInBits += m.Policy.GetLengthInBits(ctx)

	// Simple field (orderEnforced)
	lengthInBits += m.OrderEnforced.GetLengthInBits(ctx)

	// Simple field (timeout)
	lengthInBits += m.Timeout.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetAuthenticationPolicy) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetAuthenticationPolicyParse(ctx context.Context, theBytes []byte) (BACnetAuthenticationPolicy, error) {
	return BACnetAuthenticationPolicyParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetAuthenticationPolicyParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAuthenticationPolicy, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("BACnetAuthenticationPolicy"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetAuthenticationPolicy")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (policy)
	if pullErr := readBuffer.PullContext("policy"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for policy")
	}
	_policy, _policyErr := BACnetAuthenticationPolicyListParseWithBuffer(ctx, readBuffer, uint8(uint8(0)))
	if _policyErr != nil {
		return nil, errors.Wrap(_policyErr, "Error parsing 'policy' field of BACnetAuthenticationPolicy")
	}
	policy := _policy.(BACnetAuthenticationPolicyList)
	if closeErr := readBuffer.CloseContext("policy"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for policy")
	}

	// Simple Field (orderEnforced)
	if pullErr := readBuffer.PullContext("orderEnforced"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for orderEnforced")
	}
	_orderEnforced, _orderEnforcedErr := BACnetContextTagParseWithBuffer(ctx, readBuffer, uint8(uint8(1)), BACnetDataType(BACnetDataType_BOOLEAN))
	if _orderEnforcedErr != nil {
		return nil, errors.Wrap(_orderEnforcedErr, "Error parsing 'orderEnforced' field of BACnetAuthenticationPolicy")
	}
	orderEnforced := _orderEnforced.(BACnetContextTagBoolean)
	if closeErr := readBuffer.CloseContext("orderEnforced"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for orderEnforced")
	}

	// Simple Field (timeout)
	if pullErr := readBuffer.PullContext("timeout"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for timeout")
	}
	_timeout, _timeoutErr := BACnetContextTagParseWithBuffer(ctx, readBuffer, uint8(uint8(2)), BACnetDataType(BACnetDataType_UNSIGNED_INTEGER))
	if _timeoutErr != nil {
		return nil, errors.Wrap(_timeoutErr, "Error parsing 'timeout' field of BACnetAuthenticationPolicy")
	}
	timeout := _timeout.(BACnetContextTagUnsignedInteger)
	if closeErr := readBuffer.CloseContext("timeout"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for timeout")
	}

	if closeErr := readBuffer.CloseContext("BACnetAuthenticationPolicy"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetAuthenticationPolicy")
	}

	// Create the instance
	return &_BACnetAuthenticationPolicy{
		Policy:        policy,
		OrderEnforced: orderEnforced,
		Timeout:       timeout,
	}, nil
}

func (m *_BACnetAuthenticationPolicy) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetAuthenticationPolicy) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetAuthenticationPolicy"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetAuthenticationPolicy")
	}

	// Simple Field (policy)
	if pushErr := writeBuffer.PushContext("policy"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for policy")
	}
	_policyErr := writeBuffer.WriteSerializable(ctx, m.GetPolicy())
	if popErr := writeBuffer.PopContext("policy"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for policy")
	}
	if _policyErr != nil {
		return errors.Wrap(_policyErr, "Error serializing 'policy' field")
	}

	// Simple Field (orderEnforced)
	if pushErr := writeBuffer.PushContext("orderEnforced"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for orderEnforced")
	}
	_orderEnforcedErr := writeBuffer.WriteSerializable(ctx, m.GetOrderEnforced())
	if popErr := writeBuffer.PopContext("orderEnforced"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for orderEnforced")
	}
	if _orderEnforcedErr != nil {
		return errors.Wrap(_orderEnforcedErr, "Error serializing 'orderEnforced' field")
	}

	// Simple Field (timeout)
	if pushErr := writeBuffer.PushContext("timeout"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for timeout")
	}
	_timeoutErr := writeBuffer.WriteSerializable(ctx, m.GetTimeout())
	if popErr := writeBuffer.PopContext("timeout"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for timeout")
	}
	if _timeoutErr != nil {
		return errors.Wrap(_timeoutErr, "Error serializing 'timeout' field")
	}

	if popErr := writeBuffer.PopContext("BACnetAuthenticationPolicy"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetAuthenticationPolicy")
	}
	return nil
}

func (m *_BACnetAuthenticationPolicy) isBACnetAuthenticationPolicy() bool {
	return true
}

func (m *_BACnetAuthenticationPolicy) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
