/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// AdsDiscoveryBlockOsData is the corresponding interface of AdsDiscoveryBlockOsData
type AdsDiscoveryBlockOsData interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	AdsDiscoveryBlock
	// GetOsData returns OsData (property field)
	GetOsData() []byte
}

// AdsDiscoveryBlockOsDataExactly can be used when we want exactly this type and not a type which fulfills AdsDiscoveryBlockOsData.
// This is useful for switch cases.
type AdsDiscoveryBlockOsDataExactly interface {
	AdsDiscoveryBlockOsData
	isAdsDiscoveryBlockOsData() bool
}

// _AdsDiscoveryBlockOsData is the data-structure of this message
type _AdsDiscoveryBlockOsData struct {
	*_AdsDiscoveryBlock
	OsData []byte
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_AdsDiscoveryBlockOsData) GetBlockType() AdsDiscoveryBlockType {
	return AdsDiscoveryBlockType_OS_DATA
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AdsDiscoveryBlockOsData) InitializeParent(parent AdsDiscoveryBlock) {}

func (m *_AdsDiscoveryBlockOsData) GetParent() AdsDiscoveryBlock {
	return m._AdsDiscoveryBlock
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AdsDiscoveryBlockOsData) GetOsData() []byte {
	return m.OsData
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewAdsDiscoveryBlockOsData factory function for _AdsDiscoveryBlockOsData
func NewAdsDiscoveryBlockOsData(osData []byte) *_AdsDiscoveryBlockOsData {
	_result := &_AdsDiscoveryBlockOsData{
		OsData:             osData,
		_AdsDiscoveryBlock: NewAdsDiscoveryBlock(),
	}
	_result._AdsDiscoveryBlock._AdsDiscoveryBlockChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastAdsDiscoveryBlockOsData(structType any) AdsDiscoveryBlockOsData {
	if casted, ok := structType.(AdsDiscoveryBlockOsData); ok {
		return casted
	}
	if casted, ok := structType.(*AdsDiscoveryBlockOsData); ok {
		return *casted
	}
	return nil
}

func (m *_AdsDiscoveryBlockOsData) GetTypeName() string {
	return "AdsDiscoveryBlockOsData"
}

func (m *_AdsDiscoveryBlockOsData) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits(ctx))

	// Implicit Field (osDataLen)
	lengthInBits += 16

	// Array field
	if len(m.OsData) > 0 {
		lengthInBits += 8 * uint16(len(m.OsData))
	}

	return lengthInBits
}

func (m *_AdsDiscoveryBlockOsData) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AdsDiscoveryBlockOsDataParse(ctx context.Context, theBytes []byte) (AdsDiscoveryBlockOsData, error) {
	return AdsDiscoveryBlockOsDataParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func AdsDiscoveryBlockOsDataParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (AdsDiscoveryBlockOsData, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("AdsDiscoveryBlockOsData"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AdsDiscoveryBlockOsData")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Implicit Field (osDataLen) (Used for parsing, but its value is not stored as it's implicitly given by the objects content)
	osDataLen, _osDataLenErr := readBuffer.ReadUint16("osDataLen", 16)
	_ = osDataLen
	if _osDataLenErr != nil {
		return nil, errors.Wrap(_osDataLenErr, "Error parsing 'osDataLen' field of AdsDiscoveryBlockOsData")
	}
	// Byte Array field (osData)
	numberOfBytesosData := int(osDataLen)
	osData, _readArrayErr := readBuffer.ReadByteArray("osData", numberOfBytesosData)
	if _readArrayErr != nil {
		return nil, errors.Wrap(_readArrayErr, "Error parsing 'osData' field of AdsDiscoveryBlockOsData")
	}

	if closeErr := readBuffer.CloseContext("AdsDiscoveryBlockOsData"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AdsDiscoveryBlockOsData")
	}

	// Create a partially initialized instance
	_child := &_AdsDiscoveryBlockOsData{
		_AdsDiscoveryBlock: &_AdsDiscoveryBlock{},
		OsData:             osData,
	}
	_child._AdsDiscoveryBlock._AdsDiscoveryBlockChildRequirements = _child
	return _child, nil
}

func (m *_AdsDiscoveryBlockOsData) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AdsDiscoveryBlockOsData) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AdsDiscoveryBlockOsData"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AdsDiscoveryBlockOsData")
		}

		// Implicit Field (osDataLen) (Used for parsing, but it's value is not stored as it's implicitly given by the objects content)
		osDataLen := uint16(uint16(len(m.GetOsData())))
		_osDataLenErr := writeBuffer.WriteUint16("osDataLen", 16, (osDataLen))
		if _osDataLenErr != nil {
			return errors.Wrap(_osDataLenErr, "Error serializing 'osDataLen' field")
		}

		// Array Field (osData)
		// Byte Array field (osData)
		if err := writeBuffer.WriteByteArray("osData", m.GetOsData()); err != nil {
			return errors.Wrap(err, "Error serializing 'osData' field")
		}

		if popErr := writeBuffer.PopContext("AdsDiscoveryBlockOsData"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AdsDiscoveryBlockOsData")
		}
		return nil
	}
	return m.SerializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AdsDiscoveryBlockOsData) isAdsDiscoveryBlockOsData() bool {
	return true
}

func (m *_AdsDiscoveryBlockOsData) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
