/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
	"github.com/rs/zerolog"
)

// Code generated by code-generation. DO NOT EDIT.

// DF1RequestMessage is the corresponding interface of DF1RequestMessage
type DF1RequestMessage interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	// GetCommandCode returns CommandCode (discriminator field)
	GetCommandCode() uint8
	// GetDestinationAddress returns DestinationAddress (property field)
	GetDestinationAddress() uint8
	// GetSourceAddress returns SourceAddress (property field)
	GetSourceAddress() uint8
	// GetStatus returns Status (property field)
	GetStatus() uint8
	// GetTransactionCounter returns TransactionCounter (property field)
	GetTransactionCounter() uint16
}

// DF1RequestMessageExactly can be used when we want exactly this type and not a type which fulfills DF1RequestMessage.
// This is useful for switch cases.
type DF1RequestMessageExactly interface {
	DF1RequestMessage
	isDF1RequestMessage() bool
}

// _DF1RequestMessage is the data-structure of this message
type _DF1RequestMessage struct {
	_DF1RequestMessageChildRequirements
	DestinationAddress uint8
	SourceAddress      uint8
	Status             uint8
	TransactionCounter uint16
	// Reserved Fields
	reservedField0 *uint16
}

type _DF1RequestMessageChildRequirements interface {
	utils.Serializable
	GetLengthInBits(ctx context.Context) uint16
	GetCommandCode() uint8
}

type DF1RequestMessageParent interface {
	SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child DF1RequestMessage, serializeChildFunction func() error) error
	GetTypeName() string
}

type DF1RequestMessageChild interface {
	utils.Serializable
	InitializeParent(parent DF1RequestMessage, destinationAddress uint8, sourceAddress uint8, status uint8, transactionCounter uint16)
	GetParent() *DF1RequestMessage

	GetTypeName() string
	DF1RequestMessage
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_DF1RequestMessage) GetDestinationAddress() uint8 {
	return m.DestinationAddress
}

func (m *_DF1RequestMessage) GetSourceAddress() uint8 {
	return m.SourceAddress
}

func (m *_DF1RequestMessage) GetStatus() uint8 {
	return m.Status
}

func (m *_DF1RequestMessage) GetTransactionCounter() uint16 {
	return m.TransactionCounter
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewDF1RequestMessage factory function for _DF1RequestMessage
func NewDF1RequestMessage(destinationAddress uint8, sourceAddress uint8, status uint8, transactionCounter uint16) *_DF1RequestMessage {
	return &_DF1RequestMessage{DestinationAddress: destinationAddress, SourceAddress: sourceAddress, Status: status, TransactionCounter: transactionCounter}
}

// Deprecated: use the interface for direct cast
func CastDF1RequestMessage(structType any) DF1RequestMessage {
	if casted, ok := structType.(DF1RequestMessage); ok {
		return casted
	}
	if casted, ok := structType.(*DF1RequestMessage); ok {
		return *casted
	}
	return nil
}

func (m *_DF1RequestMessage) GetTypeName() string {
	return "DF1RequestMessage"
}

func (m *_DF1RequestMessage) GetParentLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (destinationAddress)
	lengthInBits += 8

	// Simple field (sourceAddress)
	lengthInBits += 8

	// Reserved Field (reserved)
	lengthInBits += 16
	// Discriminator Field (commandCode)
	lengthInBits += 8

	// Simple field (status)
	lengthInBits += 8

	// Simple field (transactionCounter)
	lengthInBits += 16

	return lengthInBits
}

func (m *_DF1RequestMessage) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func DF1RequestMessageParse(ctx context.Context, theBytes []byte) (DF1RequestMessage, error) {
	return DF1RequestMessageParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func DF1RequestMessageParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (DF1RequestMessage, error) {
	positionAware := readBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pullErr := readBuffer.PullContext("DF1RequestMessage"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for DF1RequestMessage")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (destinationAddress)
	_destinationAddress, _destinationAddressErr := readBuffer.ReadUint8("destinationAddress", 8)
	if _destinationAddressErr != nil {
		return nil, errors.Wrap(_destinationAddressErr, "Error parsing 'destinationAddress' field of DF1RequestMessage")
	}
	destinationAddress := _destinationAddress

	// Simple Field (sourceAddress)
	_sourceAddress, _sourceAddressErr := readBuffer.ReadUint8("sourceAddress", 8)
	if _sourceAddressErr != nil {
		return nil, errors.Wrap(_sourceAddressErr, "Error parsing 'sourceAddress' field of DF1RequestMessage")
	}
	sourceAddress := _sourceAddress

	var reservedField0 *uint16
	// Reserved Field (Compartmentalized so the "reserved" variable can't leak)
	{
		reserved, _err := readBuffer.ReadUint16("reserved", 16)
		if _err != nil {
			return nil, errors.Wrap(_err, "Error parsing 'reserved' field of DF1RequestMessage")
		}
		if reserved != uint16(0x0000) {
			log.Info().Fields(map[string]any{
				"expected value": uint16(0x0000),
				"got value":      reserved,
			}).Msg("Got unexpected response for reserved field.")
			// We save the value, so it can be re-serialized
			reservedField0 = &reserved
		}
	}

	// Discriminator Field (commandCode) (Used as input to a switch field)
	commandCode, _commandCodeErr := readBuffer.ReadUint8("commandCode", 8)
	if _commandCodeErr != nil {
		return nil, errors.Wrap(_commandCodeErr, "Error parsing 'commandCode' field of DF1RequestMessage")
	}

	// Simple Field (status)
	_status, _statusErr := readBuffer.ReadUint8("status", 8)
	if _statusErr != nil {
		return nil, errors.Wrap(_statusErr, "Error parsing 'status' field of DF1RequestMessage")
	}
	status := _status

	// Simple Field (transactionCounter)
	_transactionCounter, _transactionCounterErr := readBuffer.ReadUint16("transactionCounter", 16)
	if _transactionCounterErr != nil {
		return nil, errors.Wrap(_transactionCounterErr, "Error parsing 'transactionCounter' field of DF1RequestMessage")
	}
	transactionCounter := _transactionCounter

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	type DF1RequestMessageChildSerializeRequirement interface {
		DF1RequestMessage
		InitializeParent(DF1RequestMessage, uint8, uint8, uint8, uint16)
		GetParent() DF1RequestMessage
	}
	var _childTemp any
	var _child DF1RequestMessageChildSerializeRequirement
	var typeSwitchError error
	switch {
	case commandCode == 0x0F: // DF1CommandRequestMessage
		_childTemp, typeSwitchError = DF1CommandRequestMessageParseWithBuffer(ctx, readBuffer)
	default:
		typeSwitchError = errors.Errorf("Unmapped type for parameters [commandCode=%v]", commandCode)
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch of DF1RequestMessage")
	}
	_child = _childTemp.(DF1RequestMessageChildSerializeRequirement)

	if closeErr := readBuffer.CloseContext("DF1RequestMessage"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for DF1RequestMessage")
	}

	// Finish initializing
	_child.InitializeParent(_child, destinationAddress, sourceAddress, status, transactionCounter)
	_child.GetParent().(*_DF1RequestMessage).reservedField0 = reservedField0
	return _child, nil
}

func (pm *_DF1RequestMessage) SerializeParent(ctx context.Context, writeBuffer utils.WriteBuffer, child DF1RequestMessage, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("DF1RequestMessage"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for DF1RequestMessage")
	}

	// Simple Field (destinationAddress)
	destinationAddress := uint8(m.GetDestinationAddress())
	_destinationAddressErr := writeBuffer.WriteUint8("destinationAddress", 8, (destinationAddress))
	if _destinationAddressErr != nil {
		return errors.Wrap(_destinationAddressErr, "Error serializing 'destinationAddress' field")
	}

	// Simple Field (sourceAddress)
	sourceAddress := uint8(m.GetSourceAddress())
	_sourceAddressErr := writeBuffer.WriteUint8("sourceAddress", 8, (sourceAddress))
	if _sourceAddressErr != nil {
		return errors.Wrap(_sourceAddressErr, "Error serializing 'sourceAddress' field")
	}

	// Reserved Field (reserved)
	{
		var reserved uint16 = uint16(0x0000)
		if pm.reservedField0 != nil {
			log.Info().Fields(map[string]any{
				"expected value": uint16(0x0000),
				"got value":      reserved,
			}).Msg("Overriding reserved field with unexpected value.")
			reserved = *pm.reservedField0
		}
		_err := writeBuffer.WriteUint16("reserved", 16, reserved)
		if _err != nil {
			return errors.Wrap(_err, "Error serializing 'reserved' field")
		}
	}

	// Discriminator Field (commandCode) (Used as input to a switch field)
	commandCode := uint8(child.GetCommandCode())
	_commandCodeErr := writeBuffer.WriteUint8("commandCode", 8, (commandCode))

	if _commandCodeErr != nil {
		return errors.Wrap(_commandCodeErr, "Error serializing 'commandCode' field")
	}

	// Simple Field (status)
	status := uint8(m.GetStatus())
	_statusErr := writeBuffer.WriteUint8("status", 8, (status))
	if _statusErr != nil {
		return errors.Wrap(_statusErr, "Error serializing 'status' field")
	}

	// Simple Field (transactionCounter)
	transactionCounter := uint16(m.GetTransactionCounter())
	_transactionCounterErr := writeBuffer.WriteUint16("transactionCounter", 16, (transactionCounter))
	if _transactionCounterErr != nil {
		return errors.Wrap(_transactionCounterErr, "Error serializing 'transactionCounter' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("DF1RequestMessage"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for DF1RequestMessage")
	}
	return nil
}

func (m *_DF1RequestMessage) isDF1RequestMessage() bool {
	return true
}

func (m *_DF1RequestMessage) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
