/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

// Code generated by "plc4xgenerator -type=Configuration"; DO NOT EDIT.

package opcua

import (
	"context"
	"encoding/binary"
	"fmt"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

var _ = fmt.Printf

func (d *Configuration) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithByteOrderForByteBasedBuffer(binary.BigEndian))
	if err := d.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (d *Configuration) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	if err := writeBuffer.PushContext("Configuration"); err != nil {
		return err
	}

	if err := writeBuffer.WriteString("code", uint32(len(d.code)*8), "UTF-8", d.code); err != nil {
		return err
	}

	if err := writeBuffer.WriteString("host", uint32(len(d.host)*8), "UTF-8", d.host); err != nil {
		return err
	}

	if err := writeBuffer.WriteString("port", uint32(len(d.port)*8), "UTF-8", d.port); err != nil {
		return err
	}

	if err := writeBuffer.WriteString("endpoint", uint32(len(d.endpoint)*8), "UTF-8", d.endpoint); err != nil {
		return err
	}

	if err := writeBuffer.WriteString("transportEndpoint", uint32(len(d.transportEndpoint)*8), "UTF-8", d.transportEndpoint); err != nil {
		return err
	}

	if err := writeBuffer.WriteString("params", uint32(len(d.params)*8), "UTF-8", d.params); err != nil {
		return err
	}

	if err := writeBuffer.WriteBit("isEncrypted", d.isEncrypted); err != nil {
		return err
	}

	if d.thumbprint != nil {
		if serializableField, ok := d.thumbprint.(utils.Serializable); ok {
			if err := writeBuffer.PushContext("thumbprint"); err != nil {
				return err
			}
			if err := serializableField.SerializeWithWriteBuffer(ctx, writeBuffer); err != nil {
				return err
			}
			if err := writeBuffer.PopContext("thumbprint"); err != nil {
				return err
			}
		} else {
			stringValue := fmt.Sprintf("%v", d.thumbprint)
			if err := writeBuffer.WriteString("thumbprint", uint32(len(stringValue)*8), "UTF-8", stringValue); err != nil {
				return err
			}
		}
	}
	if err := writeBuffer.WriteByteArray("senderCertificate", d.senderCertificate); err != nil {
		return err
	}

	if err := writeBuffer.WriteBit("discovery", d.discovery); err != nil {
		return err
	}

	if err := writeBuffer.WriteString("username", uint32(len(d.username)*8), "UTF-8", d.username); err != nil {
		return err
	}

	if err := writeBuffer.WriteString("password", uint32(len(d.password)*8), "UTF-8", d.password); err != nil {
		return err
	}

	if err := writeBuffer.WriteString("securityPolicy", uint32(len(d.securityPolicy)*8), "UTF-8", d.securityPolicy); err != nil {
		return err
	}

	if err := writeBuffer.WriteString("keyStoreFile", uint32(len(d.keyStoreFile)*8), "UTF-8", d.keyStoreFile); err != nil {
		return err
	}

	if err := writeBuffer.WriteString("certDirectory", uint32(len(d.certDirectory)*8), "UTF-8", d.certDirectory); err != nil {
		return err
	}

	if err := writeBuffer.WriteString("keyStorePassword", uint32(len(d.keyStorePassword)*8), "UTF-8", d.keyStorePassword); err != nil {
		return err
	}
	{
		_value := fmt.Sprintf("%v", d.ckp)

		if err := writeBuffer.WriteString("ckp", uint32(len(_value)*8), "UTF-8", _value); err != nil {
			return err
		}
	}
	if err := writeBuffer.PopContext("Configuration"); err != nil {
		return err
	}
	return nil
}

func (d *Configuration) String() string {
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(context.Background(), d); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
