/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#ifndef PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_H_
#define PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_H_

#include <stdbool.h>
#include <stdint.h>
#include <plc4c/spi/context.h>
#include <plc4c/spi/read_buffer.h>
#include <plc4c/spi/write_buffer.h>
#include <plc4c/utils/list.h>
#include "data_transport_error_code.h"
#include "syntax_id_type.h"
#include "associated_query_value_type.h"
#include "alarm_type.h"
#include "date_and_time.h"
#include "szl_id.h"
#include "cyc_service_item_type.h"
#include "associated_value_type.h"
#include "data_transport_size.h"
#include "alarm_message_object_ack_type.h"
#include "alarm_message_ack_push_type.h"
#include "alarm_message_push_type.h"
#include "alarm_state_type.h"
#include "query_type.h"
#include "time_base.h"

// Code generated by code-generation. DO NOT EDIT.


// Structure used to contain the discriminator values for discriminated types using this as a parent
struct plc4c_s7_read_write_s7_payload_user_data_item_discriminator {
  uint8_t cpuFunctionGroup;
  uint8_t cpuFunctionType;
  uint8_t cpuSubfunction;
  uint16_t dataLength;
};
typedef struct plc4c_s7_read_write_s7_payload_user_data_item_discriminator plc4c_s7_read_write_s7_payload_user_data_item_discriminator;

// Enum assigning each subtype an individual id.
enum plc4c_s7_read_write_s7_payload_user_data_item_type {
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_push = 0,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_change_driven_push = 1,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_subscribe_request = 2,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_unsubscribe_request = 3,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_subscribe_response = 4,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_unsubscribe_response = 5,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_error_response = 6,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cyclic_services_change_driven_subscribe_response = 7,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_diagnostic_message = 8,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm8 = 9,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_notify = 10,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_ack_ind = 11,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_sq = 12,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_s = 13,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_alarm_sc = 14,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_notify8 = 15,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_no_data_request = 16,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_request = 17,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_read_szl_response = 18,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_request = 19,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_response = 20,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_sys_response = 21,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response = 22,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_request = 23,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_error_response = 24,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_ack_response = 25,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query_request = 26,
  plc4c_s7_read_write_s7_payload_user_data_item_type_plc4c_s7_read_write_s7_payload_user_data_item_cpu_function_alarm_query_response = 27};
typedef enum plc4c_s7_read_write_s7_payload_user_data_item_type plc4c_s7_read_write_s7_payload_user_data_item_type;

// Function to get the discriminator values for a given type.
plc4c_s7_read_write_s7_payload_user_data_item_discriminator plc4c_s7_read_write_s7_payload_user_data_item_get_discriminator(plc4c_s7_read_write_s7_payload_user_data_item_type type);

// Constant values.
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_ACK_REQUEST_FUNCTION_ID();
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_FUNCTION_ID();
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_NUMBER_MESSAGE_OBJ();
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_VARIABLE_SPEC();
uint8_t PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_CPU_FUNCTION_ALARM_QUERY_REQUEST_LENGTH();

struct plc4c_s7_read_write_s7_payload_user_data_item {
  /* This is an abstract type so this property saves the type of this typed union */
  plc4c_s7_read_write_s7_payload_user_data_item_type _type;
  /* Properties */
  plc4c_s7_read_write_data_transport_error_code return_code;
  plc4c_s7_read_write_data_transport_size transport_size;
  uint16_t data_length;
  union {
    struct { /* S7PayloadUserDataItemCyclicServicesPush */
      uint16_t s7_payload_user_data_item_cyclic_services_push_items_count;
      plc4c_list* s7_payload_user_data_item_cyclic_services_push_items;
    };
    struct { /* S7PayloadUserDataItemCyclicServicesChangeDrivenPush */
      uint16_t s7_payload_user_data_item_cyclic_services_change_driven_push_items_count;
      plc4c_list* s7_payload_user_data_item_cyclic_services_change_driven_push_items;
    };
    struct { /* S7PayloadUserDataItemCyclicServicesSubscribeRequest */
      uint16_t s7_payload_user_data_item_cyclic_services_subscribe_request_items_count;
      plc4c_s7_read_write_time_base s7_payload_user_data_item_cyclic_services_subscribe_request_time_base;
      uint8_t s7_payload_user_data_item_cyclic_services_subscribe_request_time_factor;
      plc4c_list* s7_payload_user_data_item_cyclic_services_subscribe_request_item;
    };
    struct { /* S7PayloadUserDataItemCyclicServicesUnsubscribeRequest */
      uint8_t s7_payload_user_data_item_cyclic_services_unsubscribe_request_function;
      uint8_t s7_payload_user_data_item_cyclic_services_unsubscribe_request_job_id;
    };
    struct { /* S7PayloadUserDataItemCyclicServicesSubscribeResponse */
      uint16_t s7_payload_user_data_item_cyclic_services_subscribe_response_items_count;
      plc4c_list* s7_payload_user_data_item_cyclic_services_subscribe_response_items;
    };
    struct { /* S7PayloadUserDataItemCyclicServicesChangeDrivenSubscribeResponse */
      uint16_t s7_payload_user_data_item_cyclic_services_change_driven_subscribe_response_items_count;
      plc4c_list* s7_payload_user_data_item_cyclic_services_change_driven_subscribe_response_items;
    };
    struct { /* S7PayloadDiagnosticMessage */
      uint16_t s7_payload_diagnostic_message_event_id;
      uint8_t s7_payload_diagnostic_message_priority_class;
      uint8_t s7_payload_diagnostic_message_ob_number;
      uint16_t s7_payload_diagnostic_message_dat_id;
      uint16_t s7_payload_diagnostic_message_info1;
      uint32_t s7_payload_diagnostic_message_info2;
      plc4c_s7_read_write_date_and_time* s7_payload_diagnostic_message_time_stamp;
    };
    struct { /* S7PayloadAlarm8 */
      plc4c_s7_read_write_alarm_message_push_type* s7_payload_alarm8_alarm_message;
    };
    struct { /* S7PayloadNotify */
      plc4c_s7_read_write_alarm_message_push_type* s7_payload_notify_alarm_message;
    };
    struct { /* S7PayloadAlarmAckInd */
      plc4c_s7_read_write_alarm_message_ack_push_type* s7_payload_alarm_ack_ind_alarm_message;
    };
    struct { /* S7PayloadAlarmSQ */
      plc4c_s7_read_write_alarm_message_push_type* s7_payload_alarm_sq_alarm_message;
    };
    struct { /* S7PayloadAlarmS */
      plc4c_s7_read_write_alarm_message_push_type* s7_payload_alarm_s_alarm_message;
    };
    struct { /* S7PayloadAlarmSC */
      plc4c_s7_read_write_alarm_message_push_type* s7_payload_alarm_sc_alarm_message;
    };
    struct { /* S7PayloadNotify8 */
      plc4c_s7_read_write_alarm_message_push_type* s7_payload_notify8_alarm_message;
    };
    struct { /* S7PayloadUserDataItemCpuFunctionReadSzlRequest */
      plc4c_s7_read_write_szl_id* s7_payload_user_data_item_cpu_function_read_szl_request_szl_id;
      uint16_t s7_payload_user_data_item_cpu_function_read_szl_request_szl_index;
    };
    struct { /* S7PayloadUserDataItemCpuFunctionReadSzlResponse */
      plc4c_list* s7_payload_user_data_item_cpu_function_read_szl_response_items;
    };
    struct { /* S7PayloadUserDataItemCpuFunctionMsgSubscriptionRequest */
      uint8_t s7_payload_user_data_item_cpu_function_msg_subscription_request_subscription;
      char* s7_payload_user_data_item_cpu_function_msg_subscription_request_magic_key;
      plc4c_s7_read_write_alarm_state_type* s7_payload_user_data_item_cpu_function_msg_subscription_request_alarmtype;
      uint8_t* s7_payload_user_data_item_cpu_function_msg_subscription_request_reserve;
    };
    struct { /* S7PayloadUserDataItemCpuFunctionMsgSubscriptionSysResponse */
      uint8_t s7_payload_user_data_item_cpu_function_msg_subscription_sys_response_result;
      uint8_t s7_payload_user_data_item_cpu_function_msg_subscription_sys_response_reserved01;
    };
    struct { /* S7PayloadUserDataItemCpuFunctionMsgSubscriptionAlarmResponse */
      uint8_t s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_result;
      uint8_t s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_reserved01;
      plc4c_s7_read_write_alarm_type s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_alarm_type;
      uint8_t s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_reserved02;
      uint8_t s7_payload_user_data_item_cpu_function_msg_subscription_alarm_response_reserved03;
    };
    struct { /* S7PayloadUserDataItemCpuFunctionAlarmAckRequest */
      plc4c_list* s7_payload_user_data_item_cpu_function_alarm_ack_request_message_objects;
    };
    struct { /* S7PayloadUserDataItemCpuFunctionAlarmAckResponse */
      uint8_t s7_payload_user_data_item_cpu_function_alarm_ack_response_function_id;
      plc4c_list* s7_payload_user_data_item_cpu_function_alarm_ack_response_message_objects;
    };
    struct { /* S7PayloadUserDataItemCpuFunctionAlarmQueryRequest */
      plc4c_s7_read_write_syntax_id_type s7_payload_user_data_item_cpu_function_alarm_query_request_syntax_id;
      plc4c_s7_read_write_query_type s7_payload_user_data_item_cpu_function_alarm_query_request_query_type;
      plc4c_s7_read_write_alarm_type s7_payload_user_data_item_cpu_function_alarm_query_request_alarm_type;
    };
    struct { /* S7PayloadUserDataItemCpuFunctionAlarmQueryResponse */
      plc4c_list* s7_payload_user_data_item_cpu_function_alarm_query_response_items;
    };
  };
};
typedef struct plc4c_s7_read_write_s7_payload_user_data_item plc4c_s7_read_write_s7_payload_user_data_item;

// Create an empty NULL-struct
plc4c_s7_read_write_s7_payload_user_data_item plc4c_s7_read_write_s7_payload_user_data_item_null();

plc4c_return_code plc4c_s7_read_write_s7_payload_user_data_item_parse(plc4x_spi_context ctx, plc4c_spi_read_buffer* readBuffer, uint8_t cpuFunctionGroup, uint8_t cpuFunctionType, uint8_t cpuSubfunction, plc4c_s7_read_write_s7_payload_user_data_item** message);

plc4c_return_code plc4c_s7_read_write_s7_payload_user_data_item_serialize(plc4x_spi_context ctx, plc4c_spi_write_buffer* writeBuffer, plc4c_s7_read_write_s7_payload_user_data_item* message);

uint16_t plc4c_s7_read_write_s7_payload_user_data_item_length_in_bytes(plc4x_spi_context ctx, plc4c_s7_read_write_s7_payload_user_data_item* message);

uint16_t plc4c_s7_read_write_s7_payload_user_data_item_length_in_bits(plc4x_spi_context ctx, plc4c_s7_read_write_s7_payload_user_data_item* message);

#endif  // PLC4C_S7_READ_WRITE_S7_PAYLOAD_USER_DATA_ITEM_H_
