/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class EnumDiscriminatedTypeMultiple implements Message {

  // Abstract accessors for discriminator values.
  public abstract EnumType getDiscr1();

  public abstract EnumTypeInt getDiscr2();

  public EnumDiscriminatedTypeMultiple() {
    super();
  }

  protected abstract void serializeEnumDiscriminatedTypeMultipleChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("EnumDiscriminatedTypeMultiple");

    // Discriminator Field (discr1) (Used as input to a switch field)
    writeDiscriminatorEnumField(
        "discr1",
        "EnumType",
        getDiscr1(),
        new DataWriterEnumDefault<>(
            EnumType::getValue, EnumType::name, writeUnsignedShort(writeBuffer, 8)));

    // Discriminator Field (discr2) (Used as input to a switch field)
    writeDiscriminatorEnumField(
        "discr2",
        "EnumTypeInt",
        getDiscr2(),
        new DataWriterEnumDefault<>(
            EnumTypeInt::getValue, EnumTypeInt::name, writeSignedByte(writeBuffer, 8)));

    // Switch field (Serialize the sub-type)
    serializeEnumDiscriminatedTypeMultipleChild(writeBuffer);

    writeBuffer.popContext("EnumDiscriminatedTypeMultiple");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    EnumDiscriminatedTypeMultiple _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Discriminator Field (discr1)
    lengthInBits += 8;

    // Discriminator Field (discr2)
    lengthInBits += 8;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static EnumDiscriminatedTypeMultiple staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static EnumDiscriminatedTypeMultiple staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("EnumDiscriminatedTypeMultiple");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    EnumType discr1 =
        readDiscriminatorField(
            "discr1",
            new DataReaderEnumDefault<>(EnumType::enumForValue, readUnsignedShort(readBuffer, 8)));

    EnumTypeInt discr2 =
        readDiscriminatorField(
            "discr2",
            new DataReaderEnumDefault<>(EnumTypeInt::enumForValue, readSignedByte(readBuffer, 8)));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    EnumDiscriminatedTypeMultipleBuilder builder = null;
    if (EvaluationHelper.equals(discr1, EnumType.BOOL)
        && EvaluationHelper.equals(discr2, EnumTypeInt.BOOLINT)) {
      builder =
          EnumDiscriminatedTypeMultipleA.staticParseEnumDiscriminatedTypeMultipleBuilder(
              readBuffer);
    } else if (EvaluationHelper.equals(discr1, EnumType.UINT)
        && EvaluationHelper.equals(discr2, EnumTypeInt.UINTINT)) {
      builder =
          EnumDiscriminatedTypeMultipleB.staticParseEnumDiscriminatedTypeMultipleBuilder(
              readBuffer);
    } else if (EvaluationHelper.equals(discr1, EnumType.INT)
        && EvaluationHelper.equals(discr2, EnumTypeInt.INTINT)) {
      builder =
          EnumDiscriminatedTypeMultipleC.staticParseEnumDiscriminatedTypeMultipleBuilder(
              readBuffer);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "discr1="
              + discr1
              + " "
              + "discr2="
              + discr2
              + "]");
    }

    readBuffer.closeContext("EnumDiscriminatedTypeMultiple");
    // Create the instance
    EnumDiscriminatedTypeMultiple _enumDiscriminatedTypeMultiple = builder.build();
    return _enumDiscriminatedTypeMultiple;
  }

  public interface EnumDiscriminatedTypeMultipleBuilder {
    EnumDiscriminatedTypeMultiple build();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof EnumDiscriminatedTypeMultiple)) {
      return false;
    }
    EnumDiscriminatedTypeMultiple that = (EnumDiscriminatedTypeMultiple) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
