/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.test.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AbstractTypeTestSubType extends AbstractTypeTest implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final boolean abstractBitField;
  protected final byte abstractIntField;
  protected final short abstractUintField;
  protected final float abstractFloatField;
  protected final double abstractDoubleField;
  protected final String abstractStringField;

  public AbstractTypeTestSubType(
      short simpleField,
      boolean abstractBitField,
      byte abstractIntField,
      short abstractUintField,
      float abstractFloatField,
      double abstractDoubleField,
      String abstractStringField) {
    super(simpleField);
    this.abstractBitField = abstractBitField;
    this.abstractIntField = abstractIntField;
    this.abstractUintField = abstractUintField;
    this.abstractFloatField = abstractFloatField;
    this.abstractDoubleField = abstractDoubleField;
    this.abstractStringField = abstractStringField;
  }

  public boolean getAbstractBitField() {
    return abstractBitField;
  }

  public byte getAbstractIntField() {
    return abstractIntField;
  }

  public short getAbstractUintField() {
    return abstractUintField;
  }

  public float getAbstractFloatField() {
    return abstractFloatField;
  }

  public double getAbstractDoubleField() {
    return abstractDoubleField;
  }

  public String getAbstractStringField() {
    return abstractStringField;
  }

  @Override
  protected void serializeAbstractTypeTestChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AbstractTypeTestSubType");

    // Simple Field (abstractBitField)
    writeSimpleField("abstractBitField", abstractBitField, writeBoolean(writeBuffer));

    // Simple Field (abstractIntField)
    writeSimpleField("abstractIntField", abstractIntField, writeSignedByte(writeBuffer, 8));

    // Simple Field (abstractUintField)
    writeSimpleField("abstractUintField", abstractUintField, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (abstractFloatField)
    writeSimpleField("abstractFloatField", abstractFloatField, writeFloat(writeBuffer, 32));

    // Simple Field (abstractDoubleField)
    writeSimpleField("abstractDoubleField", abstractDoubleField, writeDouble(writeBuffer, 64));

    // Simple Field (abstractStringField)
    writeSimpleField("abstractStringField", abstractStringField, writeString(writeBuffer, 8));

    writeBuffer.popContext("AbstractTypeTestSubType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AbstractTypeTestSubType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (abstractBitField)
    lengthInBits += 1;

    // Simple field (abstractIntField)
    lengthInBits += 8;

    // Simple field (abstractUintField)
    lengthInBits += 8;

    // Simple field (abstractFloatField)
    lengthInBits += 32;

    // Simple field (abstractDoubleField)
    lengthInBits += 64;

    // Simple field (abstractStringField)
    lengthInBits += 8;

    return lengthInBits;
  }

  public static AbstractTypeTestBuilder staticParseAbstractTypeTestBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("AbstractTypeTestSubType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    boolean abstractBitField = readSimpleField("abstractBitField", readBoolean(readBuffer));

    byte abstractIntField = readSimpleField("abstractIntField", readSignedByte(readBuffer, 8));

    short abstractUintField =
        readSimpleField("abstractUintField", readUnsignedShort(readBuffer, 8));

    float abstractFloatField = readSimpleField("abstractFloatField", readFloat(readBuffer, 32));

    double abstractDoubleField = readSimpleField("abstractDoubleField", readDouble(readBuffer, 64));

    String abstractStringField = readSimpleField("abstractStringField", readString(readBuffer, 8));

    readBuffer.closeContext("AbstractTypeTestSubType");
    // Create the instance
    return new AbstractTypeTestSubTypeBuilderImpl(
        abstractBitField,
        abstractIntField,
        abstractUintField,
        abstractFloatField,
        abstractDoubleField,
        abstractStringField);
  }

  public static class AbstractTypeTestSubTypeBuilderImpl
      implements AbstractTypeTest.AbstractTypeTestBuilder {
    private final boolean abstractBitField;
    private final byte abstractIntField;
    private final short abstractUintField;
    private final float abstractFloatField;
    private final double abstractDoubleField;
    private final String abstractStringField;

    public AbstractTypeTestSubTypeBuilderImpl(
        boolean abstractBitField,
        byte abstractIntField,
        short abstractUintField,
        float abstractFloatField,
        double abstractDoubleField,
        String abstractStringField) {
      this.abstractBitField = abstractBitField;
      this.abstractIntField = abstractIntField;
      this.abstractUintField = abstractUintField;
      this.abstractFloatField = abstractFloatField;
      this.abstractDoubleField = abstractDoubleField;
      this.abstractStringField = abstractStringField;
    }

    public AbstractTypeTestSubType build(short simpleField) {
      AbstractTypeTestSubType abstractTypeTestSubType =
          new AbstractTypeTestSubType(
              simpleField,
              abstractBitField,
              abstractIntField,
              abstractUintField,
              abstractFloatField,
              abstractDoubleField,
              abstractStringField);
      return abstractTypeTestSubType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AbstractTypeTestSubType)) {
      return false;
    }
    AbstractTypeTestSubType that = (AbstractTypeTestSubType) o;
    return (getAbstractBitField() == that.getAbstractBitField())
        && (getAbstractIntField() == that.getAbstractIntField())
        && (getAbstractUintField() == that.getAbstractUintField())
        && (getAbstractFloatField() == that.getAbstractFloatField())
        && (getAbstractDoubleField() == that.getAbstractDoubleField())
        && (getAbstractStringField() == that.getAbstractStringField())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getAbstractBitField(),
        getAbstractIntField(),
        getAbstractUintField(),
        getAbstractFloatField(),
        getAbstractDoubleField(),
        getAbstractStringField());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
