/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcuaserver.configuration;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonIgnore;

public class Configuration {

    @JsonIgnore
    private String configFile;

    @JsonProperty
    private String version;

    @JsonProperty(required=true)
    private String dir;

    @JsonProperty
    private String name;

    @JsonProperty
    private Boolean disableInsecureEndpoint = true;

    @JsonProperty
    private List<DeviceConfiguration> devices;

    @JsonProperty
    private Integer tcpPort = 12686;

    public Configuration() {
    }

    public void setConfigFile(String value) {
        configFile = value;
    }

    public String getName() {
        return name;
    }

    public boolean getDisableInsecureEndpoint() {
        return disableInsecureEndpoint;
    }

    public String getDir() {
        return dir;
    }

    public Integer getTcpPort() {
        return tcpPort;
    }

    public List<DeviceConfiguration> getDevices() {
        return devices;
    }

}
