/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/pkg/api/model"
	"github.com/apache/plc4x/plc4go/pkg/api/values"
)

//go:generate go run ../../tools/plc4xgenerator/gen.go -type=DefaultPlcBrowseQueryResult
type DefaultPlcBrowseQueryResult struct {
	Field             model.PlcField
	Name              string
	Readable          bool
	Writable          bool
	Subscribable      bool
	PossibleDataTypes []string
	Attributes        map[string]values.PlcValue
}

func (d *DefaultPlcBrowseQueryResult) GetField() model.PlcField {
	return d.Field
}

func (d *DefaultPlcBrowseQueryResult) GetName() string {
	return d.Name
}

func (d *DefaultPlcBrowseQueryResult) IsReadable() bool {
	return d.Readable
}

func (d *DefaultPlcBrowseQueryResult) IsWritable() bool {
	return d.Writable
}

func (d *DefaultPlcBrowseQueryResult) IsSubscribable() bool {
	return d.Subscribable
}

func (d *DefaultPlcBrowseQueryResult) GetPossibleDataTypes() []string {
	return d.PossibleDataTypes
}

func (d *DefaultPlcBrowseQueryResult) GetAttributes() map[string]values.PlcValue {
	return d.Attributes
}
