/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// LPollDataCon is the corresponding interface of LPollDataCon
type LPollDataCon interface {
	utils.LengthAware
	utils.Serializable
	CEMI
}

// LPollDataConExactly can be used when we want exactly this type and not a type which fulfills LPollDataCon.
// This is useful for switch cases.
type LPollDataConExactly interface {
	LPollDataCon
	isLPollDataCon() bool
}

// _LPollDataCon is the data-structure of this message
type _LPollDataCon struct {
	*_CEMI
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_LPollDataCon) GetMessageCode() uint8 {
	return 0x25
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_LPollDataCon) InitializeParent(parent CEMI) {}

func (m *_LPollDataCon) GetParent() CEMI {
	return m._CEMI
}

// NewLPollDataCon factory function for _LPollDataCon
func NewLPollDataCon(size uint16) *_LPollDataCon {
	_result := &_LPollDataCon{
		_CEMI: NewCEMI(size),
	}
	_result._CEMI._CEMIChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastLPollDataCon(structType interface{}) LPollDataCon {
	if casted, ok := structType.(LPollDataCon); ok {
		return casted
	}
	if casted, ok := structType.(*LPollDataCon); ok {
		return *casted
	}
	return nil
}

func (m *_LPollDataCon) GetTypeName() string {
	return "LPollDataCon"
}

func (m *_LPollDataCon) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_LPollDataCon) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	return lengthInBits
}

func (m *_LPollDataCon) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func LPollDataConParse(readBuffer utils.ReadBuffer, size uint16) (LPollDataCon, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("LPollDataCon"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for LPollDataCon")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("LPollDataCon"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for LPollDataCon")
	}

	// Create a partially initialized instance
	_child := &_LPollDataCon{
		_CEMI: &_CEMI{
			Size: size,
		},
	}
	_child._CEMI._CEMIChildRequirements = _child
	return _child, nil
}

func (m *_LPollDataCon) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("LPollDataCon"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for LPollDataCon")
		}

		if popErr := writeBuffer.PopContext("LPollDataCon"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for LPollDataCon")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_LPollDataCon) isLPollDataCon() bool {
	return true
}

func (m *_LPollDataCon) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
