/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	api "github.com/apache/plc4x/plc4go/pkg/api/values"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/apache/plc4x/plc4go/spi/values"
	"github.com/pkg/errors"
	"time"
)

// Code generated by code-generation. DO NOT EDIT.

func KnxDatapointParse(readBuffer utils.ReadBuffer, datapointType KnxDatapointType) (api.PlcValue, error) {
	readBuffer.PullContext("KnxDatapoint")
	switch {
	case datapointType == KnxDatapointType_BOOL: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_BYTE: // BYTE
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBYTE(value), nil
	case datapointType == KnxDatapointType_WORD: // WORD
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcWORD(value), nil
	case datapointType == KnxDatapointType_DWORD: // DWORD
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDWORD(value), nil
	case datapointType == KnxDatapointType_LWORD: // LWORD
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcLWORD(value), nil
	case datapointType == KnxDatapointType_USINT: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_SINT: // SINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSINT(value), nil
	case datapointType == KnxDatapointType_UINT: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_INT: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_UDINT: // UDINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUDINT(value), nil
	case datapointType == KnxDatapointType_DINT: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_ULINT: // ULINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcULINT(value), nil
	case datapointType == KnxDatapointType_LINT: // LINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcLINT(value), nil
	case datapointType == KnxDatapointType_REAL: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_LREAL: // LREAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcLREAL(value), nil
	case datapointType == KnxDatapointType_CHAR: // CHAR
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadString("value", uint32(8), "UTF-8")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcCHAR(value), nil
	case datapointType == KnxDatapointType_WCHAR: // WCHAR
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadString("value", uint32(16), "UTF-16")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcWCHAR(value), nil
	case datapointType == KnxDatapointType_TIME: // TIME
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcTIME(value), nil
	case datapointType == KnxDatapointType_LTIME: // LTIME
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcLTIME(value), nil
	case datapointType == KnxDatapointType_DATE: // DATE
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDATE(value), nil
	case datapointType == KnxDatapointType_TIME_OF_DAY: // TIME_OF_DAY
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcTIME_OF_DAY(value), nil
	case datapointType == KnxDatapointType_TOD: // TIME_OF_DAY
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcTIME_OF_DAY(value), nil
	case datapointType == KnxDatapointType_DATE_AND_TIME: // DATE_AND_TIME
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (year)
		year, _yearErr := readBuffer.ReadUint16("year", 16)
		if _yearErr != nil {
			return nil, errors.Wrap(_yearErr, "Error parsing 'year' field")
		}

		// Simple Field (month)
		month, _monthErr := readBuffer.ReadUint8("month", 8)
		if _monthErr != nil {
			return nil, errors.Wrap(_monthErr, "Error parsing 'month' field")
		}

		// Simple Field (day)
		day, _dayErr := readBuffer.ReadUint8("day", 8)
		if _dayErr != nil {
			return nil, errors.Wrap(_dayErr, "Error parsing 'day' field")
		}

		// Simple Field (dayOfWeek)
		_, _dayOfWeekErr := readBuffer.ReadUint8("dayOfWeek", 8)
		if _dayOfWeekErr != nil {
			return nil, errors.Wrap(_dayOfWeekErr, "Error parsing 'dayOfWeek' field")
		}

		// Simple Field (hour)
		hour, _hourErr := readBuffer.ReadUint8("hour", 8)
		if _hourErr != nil {
			return nil, errors.Wrap(_hourErr, "Error parsing 'hour' field")
		}

		// Simple Field (minutes)
		minutes, _minutesErr := readBuffer.ReadUint8("minutes", 8)
		if _minutesErr != nil {
			return nil, errors.Wrap(_minutesErr, "Error parsing 'minutes' field")
		}

		// Simple Field (seconds)
		seconds, _secondsErr := readBuffer.ReadUint8("seconds", 8)
		if _secondsErr != nil {
			return nil, errors.Wrap(_secondsErr, "Error parsing 'seconds' field")
		}

		// Simple Field (nanos)
		_, _nanosErr := readBuffer.ReadUint32("nanos", 32)
		if _nanosErr != nil {
			return nil, errors.Wrap(_nanosErr, "Error parsing 'nanos' field")
		}
		value := time.Date(int(year), time.Month(month), int(day), int(hour), int(minutes), int(seconds), 0, nil)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDATE_AND_TIME(value), nil
	case datapointType == KnxDatapointType_DT: // DATE_AND_TIME
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (year)
		year, _yearErr := readBuffer.ReadUint16("year", 16)
		if _yearErr != nil {
			return nil, errors.Wrap(_yearErr, "Error parsing 'year' field")
		}

		// Simple Field (month)
		month, _monthErr := readBuffer.ReadUint8("month", 8)
		if _monthErr != nil {
			return nil, errors.Wrap(_monthErr, "Error parsing 'month' field")
		}

		// Simple Field (day)
		day, _dayErr := readBuffer.ReadUint8("day", 8)
		if _dayErr != nil {
			return nil, errors.Wrap(_dayErr, "Error parsing 'day' field")
		}

		// Simple Field (dayOfWeek)
		_, _dayOfWeekErr := readBuffer.ReadUint8("dayOfWeek", 8)
		if _dayOfWeekErr != nil {
			return nil, errors.Wrap(_dayOfWeekErr, "Error parsing 'dayOfWeek' field")
		}

		// Simple Field (hour)
		hour, _hourErr := readBuffer.ReadUint8("hour", 8)
		if _hourErr != nil {
			return nil, errors.Wrap(_hourErr, "Error parsing 'hour' field")
		}

		// Simple Field (minutes)
		minutes, _minutesErr := readBuffer.ReadUint8("minutes", 8)
		if _minutesErr != nil {
			return nil, errors.Wrap(_minutesErr, "Error parsing 'minutes' field")
		}

		// Simple Field (seconds)
		seconds, _secondsErr := readBuffer.ReadUint8("seconds", 8)
		if _secondsErr != nil {
			return nil, errors.Wrap(_secondsErr, "Error parsing 'seconds' field")
		}

		// Simple Field (nanos)
		_, _nanosErr := readBuffer.ReadUint32("nanos", 32)
		if _nanosErr != nil {
			return nil, errors.Wrap(_nanosErr, "Error parsing 'nanos' field")
		}
		value := time.Date(int(year), time.Month(month), int(day), int(hour), int(minutes), int(seconds), 0, nil)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDATE_AND_TIME(value), nil
	case datapointType == KnxDatapointType_DPT_Switch: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Bool: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Enable: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Ramp: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Alarm: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_BinaryValue: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Step: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_UpDown: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_OpenClose: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Start: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_State: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Invert: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_DimSendStyle: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_InputSource: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Reset: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Ack: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Trigger: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Occupancy: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Window_Door: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_LogicalFunction: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Scene_AB: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_ShutterBlinds_Mode: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_DayNight: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Heat_Cool: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_Switch_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)

		// Simple Field (on)
		on, _onErr := readBuffer.ReadBit("on")
		if _onErr != nil {
			return nil, errors.Wrap(_onErr, "Error parsing 'on' field")
		}
		_map["Struct"] = values.NewPlcBOOL(on)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Bool_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)

		// Simple Field (valueTrue)
		valueTrue, _valueTrueErr := readBuffer.ReadBit("valueTrue")
		if _valueTrueErr != nil {
			return nil, errors.Wrap(_valueTrueErr, "Error parsing 'valueTrue' field")
		}
		_map["Struct"] = values.NewPlcBOOL(valueTrue)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Enable_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)

		// Simple Field (enable)
		enable, _enableErr := readBuffer.ReadBit("enable")
		if _enableErr != nil {
			return nil, errors.Wrap(_enableErr, "Error parsing 'enable' field")
		}
		_map["Struct"] = values.NewPlcBOOL(enable)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Ramp_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)

		// Simple Field (ramp)
		ramp, _rampErr := readBuffer.ReadBit("ramp")
		if _rampErr != nil {
			return nil, errors.Wrap(_rampErr, "Error parsing 'ramp' field")
		}
		_map["Struct"] = values.NewPlcBOOL(ramp)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Alarm_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)

		// Simple Field (alarm)
		alarm, _alarmErr := readBuffer.ReadBit("alarm")
		if _alarmErr != nil {
			return nil, errors.Wrap(_alarmErr, "Error parsing 'alarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(alarm)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_BinaryValue_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)

		// Simple Field (high)
		high, _highErr := readBuffer.ReadBit("high")
		if _highErr != nil {
			return nil, errors.Wrap(_highErr, "Error parsing 'high' field")
		}
		_map["Struct"] = values.NewPlcBOOL(high)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Step_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)

		// Simple Field (increase)
		increase, _increaseErr := readBuffer.ReadBit("increase")
		if _increaseErr != nil {
			return nil, errors.Wrap(_increaseErr, "Error parsing 'increase' field")
		}
		_map["Struct"] = values.NewPlcBOOL(increase)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Direction1_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)

		// Simple Field (down)
		down, _downErr := readBuffer.ReadBit("down")
		if _downErr != nil {
			return nil, errors.Wrap(_downErr, "Error parsing 'down' field")
		}
		_map["Struct"] = values.NewPlcBOOL(down)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Direction2_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)

		// Simple Field (close)
		close, _closeErr := readBuffer.ReadBit("close")
		if _closeErr != nil {
			return nil, errors.Wrap(_closeErr, "Error parsing 'close' field")
		}
		_map["Struct"] = values.NewPlcBOOL(close)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Start_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)

		// Simple Field (start)
		start, _startErr := readBuffer.ReadBit("start")
		if _startErr != nil {
			return nil, errors.Wrap(_startErr, "Error parsing 'start' field")
		}
		_map["Struct"] = values.NewPlcBOOL(start)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_State_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)

		// Simple Field (active)
		active, _activeErr := readBuffer.ReadBit("active")
		if _activeErr != nil {
			return nil, errors.Wrap(_activeErr, "Error parsing 'active' field")
		}
		_map["Struct"] = values.NewPlcBOOL(active)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Invert_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (control)
		control, _controlErr := readBuffer.ReadBit("control")
		if _controlErr != nil {
			return nil, errors.Wrap(_controlErr, "Error parsing 'control' field")
		}
		_map["Struct"] = values.NewPlcBOOL(control)

		// Simple Field (inverted)
		inverted, _invertedErr := readBuffer.ReadBit("inverted")
		if _invertedErr != nil {
			return nil, errors.Wrap(_invertedErr, "Error parsing 'inverted' field")
		}
		_map["Struct"] = values.NewPlcBOOL(inverted)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Control_Dimming: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (increase)
		increase, _increaseErr := readBuffer.ReadBit("increase")
		if _increaseErr != nil {
			return nil, errors.Wrap(_increaseErr, "Error parsing 'increase' field")
		}
		_map["Struct"] = values.NewPlcBOOL(increase)

		// Simple Field (stepcode)
		stepcode, _stepcodeErr := readBuffer.ReadUint8("stepcode", 3)
		if _stepcodeErr != nil {
			return nil, errors.Wrap(_stepcodeErr, "Error parsing 'stepcode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepcode)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Control_Blinds: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (down)
		down, _downErr := readBuffer.ReadBit("down")
		if _downErr != nil {
			return nil, errors.Wrap(_downErr, "Error parsing 'down' field")
		}
		_map["Struct"] = values.NewPlcBOOL(down)

		// Simple Field (stepcode)
		stepcode, _stepcodeErr := readBuffer.ReadUint8("stepcode", 3)
		if _stepcodeErr != nil {
			return nil, errors.Wrap(_stepcodeErr, "Error parsing 'stepcode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepcode)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Char_ASCII: // STRING
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadString("value", uint32(8), "ASCII")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSTRING(value), nil
	case datapointType == KnxDatapointType_DPT_Char_8859_1: // STRING
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadString("value", uint32(8), "ISO-8859-1")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSTRING(value), nil
	case datapointType == KnxDatapointType_DPT_Scaling: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Angle: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Percent_U8: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_DecimalFactor: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Tariff: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Value_1_Ucount: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_FanStage: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Percent_V8: // SINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Value_1_Count: // SINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Status_Mode3: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (statusA)
		statusA, _statusAErr := readBuffer.ReadBit("statusA")
		if _statusAErr != nil {
			return nil, errors.Wrap(_statusAErr, "Error parsing 'statusA' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusA)

		// Simple Field (statusB)
		statusB, _statusBErr := readBuffer.ReadBit("statusB")
		if _statusBErr != nil {
			return nil, errors.Wrap(_statusBErr, "Error parsing 'statusB' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusB)

		// Simple Field (statusC)
		statusC, _statusCErr := readBuffer.ReadBit("statusC")
		if _statusCErr != nil {
			return nil, errors.Wrap(_statusCErr, "Error parsing 'statusC' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusC)

		// Simple Field (statusD)
		statusD, _statusDErr := readBuffer.ReadBit("statusD")
		if _statusDErr != nil {
			return nil, errors.Wrap(_statusDErr, "Error parsing 'statusD' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusD)

		// Simple Field (statusE)
		statusE, _statusEErr := readBuffer.ReadBit("statusE")
		if _statusEErr != nil {
			return nil, errors.Wrap(_statusEErr, "Error parsing 'statusE' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusE)

		// Simple Field (mode)
		mode, _modeErr := readBuffer.ReadUint8("mode", 3)
		if _modeErr != nil {
			return nil, errors.Wrap(_modeErr, "Error parsing 'mode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(mode)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Value_2_Ucount: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_TimePeriodMsec: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_TimePeriod10Msec: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_TimePeriod100Msec: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_TimePeriodSec: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_TimePeriodMin: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_TimePeriodHrs: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_PropDataType: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_Length_mm: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_UElCurrentmA: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_Brightness: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_Absolute_Colour_Temperature: // UINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUINT(value), nil
	case datapointType == KnxDatapointType_DPT_Value_2_Count: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaTimeMsec: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaTime10Msec: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaTime100Msec: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaTimeSec: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaTimeMin: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaTimeHrs: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_Percent_V16: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_Rotation_Angle: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_Length_m: // INT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt16("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcINT(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Temp: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Tempd: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Tempa: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Lux: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Wsp: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Pres: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Humidity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_AirQuality: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_AirFlow: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Time1: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Time2: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Volt: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Curr: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_PowerDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_KelvinPerPercent: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Power: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Volume_Flow: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Rain_Amount: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Temp_F: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Wsp_kmh: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Absolute_Humidity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Concentration_ygm3: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_TimeOfDay: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (day)
		day, _dayErr := readBuffer.ReadUint8("day", 3)
		if _dayErr != nil {
			return nil, errors.Wrap(_dayErr, "Error parsing 'day' field")
		}
		_map["Struct"] = values.NewPlcUSINT(day)

		// Simple Field (hour)
		hour, _hourErr := readBuffer.ReadUint8("hour", 5)
		if _hourErr != nil {
			return nil, errors.Wrap(_hourErr, "Error parsing 'hour' field")
		}
		_map["Struct"] = values.NewPlcUSINT(hour)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (minutes)
		minutes, _minutesErr := readBuffer.ReadUint8("minutes", 6)
		if _minutesErr != nil {
			return nil, errors.Wrap(_minutesErr, "Error parsing 'minutes' field")
		}
		_map["Struct"] = values.NewPlcUSINT(minutes)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (seconds)
		seconds, _secondsErr := readBuffer.ReadUint8("seconds", 6)
		if _secondsErr != nil {
			return nil, errors.Wrap(_secondsErr, "Error parsing 'seconds' field")
		}
		_map["Struct"] = values.NewPlcUSINT(seconds)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Date: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 3); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (dayOfMonth)
		dayOfMonth, _dayOfMonthErr := readBuffer.ReadUint8("dayOfMonth", 5)
		if _dayOfMonthErr != nil {
			return nil, errors.Wrap(_dayOfMonthErr, "Error parsing 'dayOfMonth' field")
		}
		_map["Struct"] = values.NewPlcUSINT(dayOfMonth)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (month)
		month, _monthErr := readBuffer.ReadUint8("month", 4)
		if _monthErr != nil {
			return nil, errors.Wrap(_monthErr, "Error parsing 'month' field")
		}
		_map["Struct"] = values.NewPlcUSINT(month)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 1); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (year)
		year, _yearErr := readBuffer.ReadUint8("year", 7)
		if _yearErr != nil {
			return nil, errors.Wrap(_yearErr, "Error parsing 'year' field")
		}
		_map["Struct"] = values.NewPlcUSINT(year)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Value_4_Ucount: // UDINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUDINT(value), nil
	case datapointType == KnxDatapointType_DPT_LongTimePeriod_Sec: // UDINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUDINT(value), nil
	case datapointType == KnxDatapointType_DPT_LongTimePeriod_Min: // UDINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUDINT(value), nil
	case datapointType == KnxDatapointType_DPT_LongTimePeriod_Hrs: // UDINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUDINT(value), nil
	case datapointType == KnxDatapointType_DPT_VolumeLiquid_Litre: // UDINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUDINT(value), nil
	case datapointType == KnxDatapointType_DPT_Volume_m_3: // UDINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUDINT(value), nil
	case datapointType == KnxDatapointType_DPT_Value_4_Count: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_FlowRate_m3h: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_ActiveEnergy: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_ApparantEnergy: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_ReactiveEnergy: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_ActiveEnergy_kWh: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_ApparantEnergy_kVAh: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_ReactiveEnergy_kVARh: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_ActiveEnergy_MWh: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_LongDeltaTimeSec: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaVolumeLiquid_Litre: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_DeltaVolume_m_3: // DINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcDINT(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Acceleration: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Acceleration_Angular: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Activation_Energy: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Activity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Mol: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Amplitude: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_AngleRad: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_AngleDeg: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Angular_Momentum: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Angular_Velocity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Area: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Capacitance: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Charge_DensitySurface: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Charge_DensityVolume: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Compressibility: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Conductance: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electrical_Conductivity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Density: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_Charge: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_Current: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_CurrentDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_DipoleMoment: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_Displacement: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_FieldStrength: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_FluxDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_Polarization: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_Potential: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electric_PotentialDifference: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_ElectromagneticMoment: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Electromotive_Force: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Energy: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Force: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Frequency: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Angular_Frequency: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Heat_Capacity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Heat_FlowRate: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Heat_Quantity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Impedance: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Length: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Light_Quantity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Luminance: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Luminous_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Luminous_Intensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_FieldStrength: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_FluxDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_Moment: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_Polarization: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Magnetization: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_MagnetomotiveForce: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Mass: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_MassFlux: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Momentum: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Phase_AngleRad: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Phase_AngleDeg: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Power: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Power_Factor: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Pressure: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Reactance: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Resistance: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Resistivity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_SelfInductance: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_SolidAngle: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Sound_Intensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Speed: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Stress: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Surface_Tension: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Common_Temperature: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Absolute_Temperature: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_TemperatureDifference: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Thermal_Capacity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Thermal_Conductivity: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_ThermoelectricPower: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Time: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Torque: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Volume: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Volume_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Weight: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Value_Work: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 32)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Volume_Flux_Meter: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Volume_Flux_ls: // REAL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadFloat32("value", 16)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcREAL(value), nil
	case datapointType == KnxDatapointType_DPT_Access_Data: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (hurz)
		hurz, _hurzErr := readBuffer.ReadUint8("hurz", 4)
		if _hurzErr != nil {
			return nil, errors.Wrap(_hurzErr, "Error parsing 'hurz' field")
		}
		_map["Struct"] = values.NewPlcUSINT(hurz)

		// Simple Field (value1)
		value1, _value1Err := readBuffer.ReadUint8("value1", 4)
		if _value1Err != nil {
			return nil, errors.Wrap(_value1Err, "Error parsing 'value1' field")
		}
		_map["Struct"] = values.NewPlcUSINT(value1)

		// Simple Field (value2)
		value2, _value2Err := readBuffer.ReadUint8("value2", 4)
		if _value2Err != nil {
			return nil, errors.Wrap(_value2Err, "Error parsing 'value2' field")
		}
		_map["Struct"] = values.NewPlcUSINT(value2)

		// Simple Field (value3)
		value3, _value3Err := readBuffer.ReadUint8("value3", 4)
		if _value3Err != nil {
			return nil, errors.Wrap(_value3Err, "Error parsing 'value3' field")
		}
		_map["Struct"] = values.NewPlcUSINT(value3)

		// Simple Field (value4)
		value4, _value4Err := readBuffer.ReadUint8("value4", 4)
		if _value4Err != nil {
			return nil, errors.Wrap(_value4Err, "Error parsing 'value4' field")
		}
		_map["Struct"] = values.NewPlcUSINT(value4)

		// Simple Field (value5)
		value5, _value5Err := readBuffer.ReadUint8("value5", 4)
		if _value5Err != nil {
			return nil, errors.Wrap(_value5Err, "Error parsing 'value5' field")
		}
		_map["Struct"] = values.NewPlcUSINT(value5)

		// Simple Field (detectionError)
		detectionError, _detectionErrorErr := readBuffer.ReadBit("detectionError")
		if _detectionErrorErr != nil {
			return nil, errors.Wrap(_detectionErrorErr, "Error parsing 'detectionError' field")
		}
		_map["Struct"] = values.NewPlcBOOL(detectionError)

		// Simple Field (permission)
		permission, _permissionErr := readBuffer.ReadBit("permission")
		if _permissionErr != nil {
			return nil, errors.Wrap(_permissionErr, "Error parsing 'permission' field")
		}
		_map["Struct"] = values.NewPlcBOOL(permission)

		// Simple Field (readDirection)
		readDirection, _readDirectionErr := readBuffer.ReadBit("readDirection")
		if _readDirectionErr != nil {
			return nil, errors.Wrap(_readDirectionErr, "Error parsing 'readDirection' field")
		}
		_map["Struct"] = values.NewPlcBOOL(readDirection)

		// Simple Field (encryptionOfAccessInformation)
		encryptionOfAccessInformation, _encryptionOfAccessInformationErr := readBuffer.ReadBit("encryptionOfAccessInformation")
		if _encryptionOfAccessInformationErr != nil {
			return nil, errors.Wrap(_encryptionOfAccessInformationErr, "Error parsing 'encryptionOfAccessInformation' field")
		}
		_map["Struct"] = values.NewPlcBOOL(encryptionOfAccessInformation)

		// Simple Field (indexOfAccessIdentificationCode)
		indexOfAccessIdentificationCode, _indexOfAccessIdentificationCodeErr := readBuffer.ReadUint8("indexOfAccessIdentificationCode", 4)
		if _indexOfAccessIdentificationCodeErr != nil {
			return nil, errors.Wrap(_indexOfAccessIdentificationCodeErr, "Error parsing 'indexOfAccessIdentificationCode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(indexOfAccessIdentificationCode)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_String_ASCII: // STRING
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadString("value", uint32(112), "ASCII")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSTRING(value), nil
	case datapointType == KnxDatapointType_DPT_String_8859_1: // STRING
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadString("value", uint32(112), "ISO-8859-1")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSTRING(value), nil
	case datapointType == KnxDatapointType_DPT_SceneNumber: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 6)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_SceneControl: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (learnTheSceneCorrespondingToTheFieldSceneNumber)
		learnTheSceneCorrespondingToTheFieldSceneNumber, _learnTheSceneCorrespondingToTheFieldSceneNumberErr := readBuffer.ReadBit("learnTheSceneCorrespondingToTheFieldSceneNumber")
		if _learnTheSceneCorrespondingToTheFieldSceneNumberErr != nil {
			return nil, errors.Wrap(_learnTheSceneCorrespondingToTheFieldSceneNumberErr, "Error parsing 'learnTheSceneCorrespondingToTheFieldSceneNumber' field")
		}
		_map["Struct"] = values.NewPlcBOOL(learnTheSceneCorrespondingToTheFieldSceneNumber)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 1); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (sceneNumber)
		sceneNumber, _sceneNumberErr := readBuffer.ReadUint8("sceneNumber", 6)
		if _sceneNumberErr != nil {
			return nil, errors.Wrap(_sceneNumberErr, "Error parsing 'sceneNumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(sceneNumber)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_DateTime: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (year)
		year, _yearErr := readBuffer.ReadUint8("year", 8)
		if _yearErr != nil {
			return nil, errors.Wrap(_yearErr, "Error parsing 'year' field")
		}
		_map["Struct"] = values.NewPlcUSINT(year)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (month)
		month, _monthErr := readBuffer.ReadUint8("month", 4)
		if _monthErr != nil {
			return nil, errors.Wrap(_monthErr, "Error parsing 'month' field")
		}
		_map["Struct"] = values.NewPlcUSINT(month)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 3); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (dayofmonth)
		dayofmonth, _dayofmonthErr := readBuffer.ReadUint8("dayofmonth", 5)
		if _dayofmonthErr != nil {
			return nil, errors.Wrap(_dayofmonthErr, "Error parsing 'dayofmonth' field")
		}
		_map["Struct"] = values.NewPlcUSINT(dayofmonth)

		// Simple Field (dayofweek)
		dayofweek, _dayofweekErr := readBuffer.ReadUint8("dayofweek", 3)
		if _dayofweekErr != nil {
			return nil, errors.Wrap(_dayofweekErr, "Error parsing 'dayofweek' field")
		}
		_map["Struct"] = values.NewPlcUSINT(dayofweek)

		// Simple Field (hourofday)
		hourofday, _hourofdayErr := readBuffer.ReadUint8("hourofday", 5)
		if _hourofdayErr != nil {
			return nil, errors.Wrap(_hourofdayErr, "Error parsing 'hourofday' field")
		}
		_map["Struct"] = values.NewPlcUSINT(hourofday)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (minutes)
		minutes, _minutesErr := readBuffer.ReadUint8("minutes", 6)
		if _minutesErr != nil {
			return nil, errors.Wrap(_minutesErr, "Error parsing 'minutes' field")
		}
		_map["Struct"] = values.NewPlcUSINT(minutes)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (seconds)
		seconds, _secondsErr := readBuffer.ReadUint8("seconds", 6)
		if _secondsErr != nil {
			return nil, errors.Wrap(_secondsErr, "Error parsing 'seconds' field")
		}
		_map["Struct"] = values.NewPlcUSINT(seconds)

		// Simple Field (fault)
		fault, _faultErr := readBuffer.ReadBit("fault")
		if _faultErr != nil {
			return nil, errors.Wrap(_faultErr, "Error parsing 'fault' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fault)

		// Simple Field (workingDay)
		workingDay, _workingDayErr := readBuffer.ReadBit("workingDay")
		if _workingDayErr != nil {
			return nil, errors.Wrap(_workingDayErr, "Error parsing 'workingDay' field")
		}
		_map["Struct"] = values.NewPlcBOOL(workingDay)

		// Simple Field (noWd)
		noWd, _noWdErr := readBuffer.ReadBit("noWd")
		if _noWdErr != nil {
			return nil, errors.Wrap(_noWdErr, "Error parsing 'noWd' field")
		}
		_map["Struct"] = values.NewPlcBOOL(noWd)

		// Simple Field (noYear)
		noYear, _noYearErr := readBuffer.ReadBit("noYear")
		if _noYearErr != nil {
			return nil, errors.Wrap(_noYearErr, "Error parsing 'noYear' field")
		}
		_map["Struct"] = values.NewPlcBOOL(noYear)

		// Simple Field (noDate)
		noDate, _noDateErr := readBuffer.ReadBit("noDate")
		if _noDateErr != nil {
			return nil, errors.Wrap(_noDateErr, "Error parsing 'noDate' field")
		}
		_map["Struct"] = values.NewPlcBOOL(noDate)

		// Simple Field (noDayOfWeek)
		noDayOfWeek, _noDayOfWeekErr := readBuffer.ReadBit("noDayOfWeek")
		if _noDayOfWeekErr != nil {
			return nil, errors.Wrap(_noDayOfWeekErr, "Error parsing 'noDayOfWeek' field")
		}
		_map["Struct"] = values.NewPlcBOOL(noDayOfWeek)

		// Simple Field (noTime)
		noTime, _noTimeErr := readBuffer.ReadBit("noTime")
		if _noTimeErr != nil {
			return nil, errors.Wrap(_noTimeErr, "Error parsing 'noTime' field")
		}
		_map["Struct"] = values.NewPlcBOOL(noTime)

		// Simple Field (standardSummerTime)
		standardSummerTime, _standardSummerTimeErr := readBuffer.ReadBit("standardSummerTime")
		if _standardSummerTimeErr != nil {
			return nil, errors.Wrap(_standardSummerTimeErr, "Error parsing 'standardSummerTime' field")
		}
		_map["Struct"] = values.NewPlcBOOL(standardSummerTime)

		// Simple Field (qualityOfClock)
		qualityOfClock, _qualityOfClockErr := readBuffer.ReadBit("qualityOfClock")
		if _qualityOfClockErr != nil {
			return nil, errors.Wrap(_qualityOfClockErr, "Error parsing 'qualityOfClock' field")
		}
		_map["Struct"] = values.NewPlcBOOL(qualityOfClock)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_SCLOMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_BuildingMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_OccMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Priority: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_LightApplicationMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_ApplicationArea: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_AlarmClassType: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_PSUMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_ErrorClass_System: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_ErrorClass_HVAC: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Time_Delay: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Beaufort_Wind_Force_Scale: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_SensorSelect: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_ActuatorConnectType: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Cloud_Cover: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_PowerReturnMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_FuelType: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_BurnerType: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_HVACMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_DHWMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_LoadPriority: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_HVACContrMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_HVACEmergMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_ChangeoverMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_ValveMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_DamperMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_HeaterMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_FanMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_MasterSlaveMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_StatusRoomSetp: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Metering_DeviceType: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_HumDehumMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_EnableHCStage: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_ADAType: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_BackupMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_StartSynchronization: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Behaviour_Lock_Unlock: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Behaviour_Bus_Power_Up_Down: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_DALI_Fade_Time: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_BlinkingMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_LightControlMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_SwitchPBModel: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_PBAction: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_DimmPBModel: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_SwitchOnMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_LoadTypeSet: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_LoadTypeDetected: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Converter_Test_Control: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_SABExcept_Behaviour: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_SABBehaviour_Lock_Unlock: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_SSSBMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_BlindsControlMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_CommMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_AddInfoTypes: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_RF_ModeSelect: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_RF_FilterSelect: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 8)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_StatusGen: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 3); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (alarmStatusOfCorrespondingDatapointIsNotAcknowledged)
		alarmStatusOfCorrespondingDatapointIsNotAcknowledged, _alarmStatusOfCorrespondingDatapointIsNotAcknowledgedErr := readBuffer.ReadBit("alarmStatusOfCorrespondingDatapointIsNotAcknowledged")
		if _alarmStatusOfCorrespondingDatapointIsNotAcknowledgedErr != nil {
			return nil, errors.Wrap(_alarmStatusOfCorrespondingDatapointIsNotAcknowledgedErr, "Error parsing 'alarmStatusOfCorrespondingDatapointIsNotAcknowledged' field")
		}
		_map["Struct"] = values.NewPlcBOOL(alarmStatusOfCorrespondingDatapointIsNotAcknowledged)

		// Simple Field (correspondingDatapointIsInAlarm)
		correspondingDatapointIsInAlarm, _correspondingDatapointIsInAlarmErr := readBuffer.ReadBit("correspondingDatapointIsInAlarm")
		if _correspondingDatapointIsInAlarmErr != nil {
			return nil, errors.Wrap(_correspondingDatapointIsInAlarmErr, "Error parsing 'correspondingDatapointIsInAlarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(correspondingDatapointIsInAlarm)

		// Simple Field (correspondingDatapointMainValueIsOverridden)
		correspondingDatapointMainValueIsOverridden, _correspondingDatapointMainValueIsOverriddenErr := readBuffer.ReadBit("correspondingDatapointMainValueIsOverridden")
		if _correspondingDatapointMainValueIsOverriddenErr != nil {
			return nil, errors.Wrap(_correspondingDatapointMainValueIsOverriddenErr, "Error parsing 'correspondingDatapointMainValueIsOverridden' field")
		}
		_map["Struct"] = values.NewPlcBOOL(correspondingDatapointMainValueIsOverridden)

		// Simple Field (correspondingDatapointMainValueIsCorruptedDueToFailure)
		correspondingDatapointMainValueIsCorruptedDueToFailure, _correspondingDatapointMainValueIsCorruptedDueToFailureErr := readBuffer.ReadBit("correspondingDatapointMainValueIsCorruptedDueToFailure")
		if _correspondingDatapointMainValueIsCorruptedDueToFailureErr != nil {
			return nil, errors.Wrap(_correspondingDatapointMainValueIsCorruptedDueToFailureErr, "Error parsing 'correspondingDatapointMainValueIsCorruptedDueToFailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(correspondingDatapointMainValueIsCorruptedDueToFailure)

		// Simple Field (correspondingDatapointValueIsOutOfService)
		correspondingDatapointValueIsOutOfService, _correspondingDatapointValueIsOutOfServiceErr := readBuffer.ReadBit("correspondingDatapointValueIsOutOfService")
		if _correspondingDatapointValueIsOutOfServiceErr != nil {
			return nil, errors.Wrap(_correspondingDatapointValueIsOutOfServiceErr, "Error parsing 'correspondingDatapointValueIsOutOfService' field")
		}
		_map["Struct"] = values.NewPlcBOOL(correspondingDatapointValueIsOutOfService)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Device_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (verifyModeIsOn)
		verifyModeIsOn, _verifyModeIsOnErr := readBuffer.ReadBit("verifyModeIsOn")
		if _verifyModeIsOnErr != nil {
			return nil, errors.Wrap(_verifyModeIsOnErr, "Error parsing 'verifyModeIsOn' field")
		}
		_map["Struct"] = values.NewPlcBOOL(verifyModeIsOn)

		// Simple Field (aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived)
		aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived, _aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceivedErr := readBuffer.ReadBit("aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived")
		if _aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceivedErr != nil {
			return nil, errors.Wrap(_aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceivedErr, "Error parsing 'aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived' field")
		}
		_map["Struct"] = values.NewPlcBOOL(aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived)

		// Simple Field (theUserApplicationIsStopped)
		theUserApplicationIsStopped, _theUserApplicationIsStoppedErr := readBuffer.ReadBit("theUserApplicationIsStopped")
		if _theUserApplicationIsStoppedErr != nil {
			return nil, errors.Wrap(_theUserApplicationIsStoppedErr, "Error parsing 'theUserApplicationIsStopped' field")
		}
		_map["Struct"] = values.NewPlcBOOL(theUserApplicationIsStopped)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_ForceSign: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (roomhmax)
		roomhmax, _roomhmaxErr := readBuffer.ReadBit("roomhmax")
		if _roomhmaxErr != nil {
			return nil, errors.Wrap(_roomhmaxErr, "Error parsing 'roomhmax' field")
		}
		_map["Struct"] = values.NewPlcBOOL(roomhmax)

		// Simple Field (roomhconf)
		roomhconf, _roomhconfErr := readBuffer.ReadBit("roomhconf")
		if _roomhconfErr != nil {
			return nil, errors.Wrap(_roomhconfErr, "Error parsing 'roomhconf' field")
		}
		_map["Struct"] = values.NewPlcBOOL(roomhconf)

		// Simple Field (dhwlegio)
		dhwlegio, _dhwlegioErr := readBuffer.ReadBit("dhwlegio")
		if _dhwlegioErr != nil {
			return nil, errors.Wrap(_dhwlegioErr, "Error parsing 'dhwlegio' field")
		}
		_map["Struct"] = values.NewPlcBOOL(dhwlegio)

		// Simple Field (dhwnorm)
		dhwnorm, _dhwnormErr := readBuffer.ReadBit("dhwnorm")
		if _dhwnormErr != nil {
			return nil, errors.Wrap(_dhwnormErr, "Error parsing 'dhwnorm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(dhwnorm)

		// Simple Field (overrun)
		overrun, _overrunErr := readBuffer.ReadBit("overrun")
		if _overrunErr != nil {
			return nil, errors.Wrap(_overrunErr, "Error parsing 'overrun' field")
		}
		_map["Struct"] = values.NewPlcBOOL(overrun)

		// Simple Field (oversupply)
		oversupply, _oversupplyErr := readBuffer.ReadBit("oversupply")
		if _oversupplyErr != nil {
			return nil, errors.Wrap(_oversupplyErr, "Error parsing 'oversupply' field")
		}
		_map["Struct"] = values.NewPlcBOOL(oversupply)

		// Simple Field (protection)
		protection, _protectionErr := readBuffer.ReadBit("protection")
		if _protectionErr != nil {
			return nil, errors.Wrap(_protectionErr, "Error parsing 'protection' field")
		}
		_map["Struct"] = values.NewPlcBOOL(protection)

		// Simple Field (forcerequest)
		forcerequest, _forcerequestErr := readBuffer.ReadBit("forcerequest")
		if _forcerequestErr != nil {
			return nil, errors.Wrap(_forcerequestErr, "Error parsing 'forcerequest' field")
		}
		_map["Struct"] = values.NewPlcBOOL(forcerequest)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_ForceSignCool: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_StatusRHC: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (summermode)
		summermode, _summermodeErr := readBuffer.ReadBit("summermode")
		if _summermodeErr != nil {
			return nil, errors.Wrap(_summermodeErr, "Error parsing 'summermode' field")
		}
		_map["Struct"] = values.NewPlcBOOL(summermode)

		// Simple Field (statusstopoptim)
		statusstopoptim, _statusstopoptimErr := readBuffer.ReadBit("statusstopoptim")
		if _statusstopoptimErr != nil {
			return nil, errors.Wrap(_statusstopoptimErr, "Error parsing 'statusstopoptim' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusstopoptim)

		// Simple Field (statusstartoptim)
		statusstartoptim, _statusstartoptimErr := readBuffer.ReadBit("statusstartoptim")
		if _statusstartoptimErr != nil {
			return nil, errors.Wrap(_statusstartoptimErr, "Error parsing 'statusstartoptim' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusstartoptim)

		// Simple Field (statusmorningboost)
		statusmorningboost, _statusmorningboostErr := readBuffer.ReadBit("statusmorningboost")
		if _statusmorningboostErr != nil {
			return nil, errors.Wrap(_statusmorningboostErr, "Error parsing 'statusmorningboost' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusmorningboost)

		// Simple Field (tempreturnlimit)
		tempreturnlimit, _tempreturnlimitErr := readBuffer.ReadBit("tempreturnlimit")
		if _tempreturnlimitErr != nil {
			return nil, errors.Wrap(_tempreturnlimitErr, "Error parsing 'tempreturnlimit' field")
		}
		_map["Struct"] = values.NewPlcBOOL(tempreturnlimit)

		// Simple Field (tempflowlimit)
		tempflowlimit, _tempflowlimitErr := readBuffer.ReadBit("tempflowlimit")
		if _tempflowlimitErr != nil {
			return nil, errors.Wrap(_tempflowlimitErr, "Error parsing 'tempflowlimit' field")
		}
		_map["Struct"] = values.NewPlcBOOL(tempflowlimit)

		// Simple Field (satuseco)
		satuseco, _satusecoErr := readBuffer.ReadBit("satuseco")
		if _satusecoErr != nil {
			return nil, errors.Wrap(_satusecoErr, "Error parsing 'satuseco' field")
		}
		_map["Struct"] = values.NewPlcBOOL(satuseco)

		// Simple Field (fault)
		fault, _faultErr := readBuffer.ReadBit("fault")
		if _faultErr != nil {
			return nil, errors.Wrap(_faultErr, "Error parsing 'fault' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fault)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_StatusSDHWC: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (solarloadsufficient)
		solarloadsufficient, _solarloadsufficientErr := readBuffer.ReadBit("solarloadsufficient")
		if _solarloadsufficientErr != nil {
			return nil, errors.Wrap(_solarloadsufficientErr, "Error parsing 'solarloadsufficient' field")
		}
		_map["Struct"] = values.NewPlcBOOL(solarloadsufficient)

		// Simple Field (sdhwloadactive)
		sdhwloadactive, _sdhwloadactiveErr := readBuffer.ReadBit("sdhwloadactive")
		if _sdhwloadactiveErr != nil {
			return nil, errors.Wrap(_sdhwloadactiveErr, "Error parsing 'sdhwloadactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(sdhwloadactive)

		// Simple Field (fault)
		fault, _faultErr := readBuffer.ReadBit("fault")
		if _faultErr != nil {
			return nil, errors.Wrap(_faultErr, "Error parsing 'fault' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fault)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_FuelTypeSet: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (solidstate)
		solidstate, _solidstateErr := readBuffer.ReadBit("solidstate")
		if _solidstateErr != nil {
			return nil, errors.Wrap(_solidstateErr, "Error parsing 'solidstate' field")
		}
		_map["Struct"] = values.NewPlcBOOL(solidstate)

		// Simple Field (gas)
		gas, _gasErr := readBuffer.ReadBit("gas")
		if _gasErr != nil {
			return nil, errors.Wrap(_gasErr, "Error parsing 'gas' field")
		}
		_map["Struct"] = values.NewPlcBOOL(gas)

		// Simple Field (oil)
		oil, _oilErr := readBuffer.ReadBit("oil")
		if _oilErr != nil {
			return nil, errors.Wrap(_oilErr, "Error parsing 'oil' field")
		}
		_map["Struct"] = values.NewPlcBOOL(oil)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_StatusRCC: // BOOL
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadBit("value")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcBOOL(value), nil
	case datapointType == KnxDatapointType_DPT_StatusAHU: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cool)
		cool, _coolErr := readBuffer.ReadBit("cool")
		if _coolErr != nil {
			return nil, errors.Wrap(_coolErr, "Error parsing 'cool' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cool)

		// Simple Field (heat)
		heat, _heatErr := readBuffer.ReadBit("heat")
		if _heatErr != nil {
			return nil, errors.Wrap(_heatErr, "Error parsing 'heat' field")
		}
		_map["Struct"] = values.NewPlcBOOL(heat)

		// Simple Field (fanactive)
		fanactive, _fanactiveErr := readBuffer.ReadBit("fanactive")
		if _fanactiveErr != nil {
			return nil, errors.Wrap(_fanactiveErr, "Error parsing 'fanactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fanactive)

		// Simple Field (fault)
		fault, _faultErr := readBuffer.ReadBit("fault")
		if _faultErr != nil {
			return nil, errors.Wrap(_faultErr, "Error parsing 'fault' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fault)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_CombinedStatus_RTSM: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 3); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (statusOfHvacModeUser)
		statusOfHvacModeUser, _statusOfHvacModeUserErr := readBuffer.ReadBit("statusOfHvacModeUser")
		if _statusOfHvacModeUserErr != nil {
			return nil, errors.Wrap(_statusOfHvacModeUserErr, "Error parsing 'statusOfHvacModeUser' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusOfHvacModeUser)

		// Simple Field (statusOfComfortProlongationUser)
		statusOfComfortProlongationUser, _statusOfComfortProlongationUserErr := readBuffer.ReadBit("statusOfComfortProlongationUser")
		if _statusOfComfortProlongationUserErr != nil {
			return nil, errors.Wrap(_statusOfComfortProlongationUserErr, "Error parsing 'statusOfComfortProlongationUser' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusOfComfortProlongationUser)

		// Simple Field (effectiveValueOfTheComfortPushButton)
		effectiveValueOfTheComfortPushButton, _effectiveValueOfTheComfortPushButtonErr := readBuffer.ReadBit("effectiveValueOfTheComfortPushButton")
		if _effectiveValueOfTheComfortPushButtonErr != nil {
			return nil, errors.Wrap(_effectiveValueOfTheComfortPushButtonErr, "Error parsing 'effectiveValueOfTheComfortPushButton' field")
		}
		_map["Struct"] = values.NewPlcBOOL(effectiveValueOfTheComfortPushButton)

		// Simple Field (effectiveValueOfThePresenceStatus)
		effectiveValueOfThePresenceStatus, _effectiveValueOfThePresenceStatusErr := readBuffer.ReadBit("effectiveValueOfThePresenceStatus")
		if _effectiveValueOfThePresenceStatusErr != nil {
			return nil, errors.Wrap(_effectiveValueOfThePresenceStatusErr, "Error parsing 'effectiveValueOfThePresenceStatus' field")
		}
		_map["Struct"] = values.NewPlcBOOL(effectiveValueOfThePresenceStatus)

		// Simple Field (effectiveValueOfTheWindowStatus)
		effectiveValueOfTheWindowStatus, _effectiveValueOfTheWindowStatusErr := readBuffer.ReadBit("effectiveValueOfTheWindowStatus")
		if _effectiveValueOfTheWindowStatusErr != nil {
			return nil, errors.Wrap(_effectiveValueOfTheWindowStatusErr, "Error parsing 'effectiveValueOfTheWindowStatus' field")
		}
		_map["Struct"] = values.NewPlcBOOL(effectiveValueOfTheWindowStatus)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_LightActuatorErrorInfo: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 1); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (overheat)
		overheat, _overheatErr := readBuffer.ReadBit("overheat")
		if _overheatErr != nil {
			return nil, errors.Wrap(_overheatErr, "Error parsing 'overheat' field")
		}
		_map["Struct"] = values.NewPlcBOOL(overheat)

		// Simple Field (lampfailure)
		lampfailure, _lampfailureErr := readBuffer.ReadBit("lampfailure")
		if _lampfailureErr != nil {
			return nil, errors.Wrap(_lampfailureErr, "Error parsing 'lampfailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(lampfailure)

		// Simple Field (defectiveload)
		defectiveload, _defectiveloadErr := readBuffer.ReadBit("defectiveload")
		if _defectiveloadErr != nil {
			return nil, errors.Wrap(_defectiveloadErr, "Error parsing 'defectiveload' field")
		}
		_map["Struct"] = values.NewPlcBOOL(defectiveload)

		// Simple Field (underload)
		underload, _underloadErr := readBuffer.ReadBit("underload")
		if _underloadErr != nil {
			return nil, errors.Wrap(_underloadErr, "Error parsing 'underload' field")
		}
		_map["Struct"] = values.NewPlcBOOL(underload)

		// Simple Field (overcurrent)
		overcurrent, _overcurrentErr := readBuffer.ReadBit("overcurrent")
		if _overcurrentErr != nil {
			return nil, errors.Wrap(_overcurrentErr, "Error parsing 'overcurrent' field")
		}
		_map["Struct"] = values.NewPlcBOOL(overcurrent)

		// Simple Field (undervoltage)
		undervoltage, _undervoltageErr := readBuffer.ReadBit("undervoltage")
		if _undervoltageErr != nil {
			return nil, errors.Wrap(_undervoltageErr, "Error parsing 'undervoltage' field")
		}
		_map["Struct"] = values.NewPlcBOOL(undervoltage)

		// Simple Field (loaddetectionerror)
		loaddetectionerror, _loaddetectionerrorErr := readBuffer.ReadBit("loaddetectionerror")
		if _loaddetectionerrorErr != nil {
			return nil, errors.Wrap(_loaddetectionerrorErr, "Error parsing 'loaddetectionerror' field")
		}
		_map["Struct"] = values.NewPlcBOOL(loaddetectionerror)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_RF_ModeInfo: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (bibatSlave)
		bibatSlave, _bibatSlaveErr := readBuffer.ReadBit("bibatSlave")
		if _bibatSlaveErr != nil {
			return nil, errors.Wrap(_bibatSlaveErr, "Error parsing 'bibatSlave' field")
		}
		_map["Struct"] = values.NewPlcBOOL(bibatSlave)

		// Simple Field (bibatMaster)
		bibatMaster, _bibatMasterErr := readBuffer.ReadBit("bibatMaster")
		if _bibatMasterErr != nil {
			return nil, errors.Wrap(_bibatMasterErr, "Error parsing 'bibatMaster' field")
		}
		_map["Struct"] = values.NewPlcBOOL(bibatMaster)

		// Simple Field (asynchronous)
		asynchronous, _asynchronousErr := readBuffer.ReadBit("asynchronous")
		if _asynchronousErr != nil {
			return nil, errors.Wrap(_asynchronousErr, "Error parsing 'asynchronous' field")
		}
		_map["Struct"] = values.NewPlcBOOL(asynchronous)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_RF_FilterInfo: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (doa)
		doa, _doaErr := readBuffer.ReadBit("doa")
		if _doaErr != nil {
			return nil, errors.Wrap(_doaErr, "Error parsing 'doa' field")
		}
		_map["Struct"] = values.NewPlcBOOL(doa)

		// Simple Field (knxSn)
		knxSn, _knxSnErr := readBuffer.ReadBit("knxSn")
		if _knxSnErr != nil {
			return nil, errors.Wrap(_knxSnErr, "Error parsing 'knxSn' field")
		}
		_map["Struct"] = values.NewPlcBOOL(knxSn)

		// Simple Field (doaAndKnxSn)
		doaAndKnxSn, _doaAndKnxSnErr := readBuffer.ReadBit("doaAndKnxSn")
		if _doaAndKnxSnErr != nil {
			return nil, errors.Wrap(_doaAndKnxSnErr, "Error parsing 'doaAndKnxSn' field")
		}
		_map["Struct"] = values.NewPlcBOOL(doaAndKnxSn)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Channel_Activation_8: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (activationStateOfChannel1)
		activationStateOfChannel1, _activationStateOfChannel1Err := readBuffer.ReadBit("activationStateOfChannel1")
		if _activationStateOfChannel1Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel1Err, "Error parsing 'activationStateOfChannel1' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel1)

		// Simple Field (activationStateOfChannel2)
		activationStateOfChannel2, _activationStateOfChannel2Err := readBuffer.ReadBit("activationStateOfChannel2")
		if _activationStateOfChannel2Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel2Err, "Error parsing 'activationStateOfChannel2' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel2)

		// Simple Field (activationStateOfChannel3)
		activationStateOfChannel3, _activationStateOfChannel3Err := readBuffer.ReadBit("activationStateOfChannel3")
		if _activationStateOfChannel3Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel3Err, "Error parsing 'activationStateOfChannel3' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel3)

		// Simple Field (activationStateOfChannel4)
		activationStateOfChannel4, _activationStateOfChannel4Err := readBuffer.ReadBit("activationStateOfChannel4")
		if _activationStateOfChannel4Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel4Err, "Error parsing 'activationStateOfChannel4' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel4)

		// Simple Field (activationStateOfChannel5)
		activationStateOfChannel5, _activationStateOfChannel5Err := readBuffer.ReadBit("activationStateOfChannel5")
		if _activationStateOfChannel5Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel5Err, "Error parsing 'activationStateOfChannel5' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel5)

		// Simple Field (activationStateOfChannel6)
		activationStateOfChannel6, _activationStateOfChannel6Err := readBuffer.ReadBit("activationStateOfChannel6")
		if _activationStateOfChannel6Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel6Err, "Error parsing 'activationStateOfChannel6' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel6)

		// Simple Field (activationStateOfChannel7)
		activationStateOfChannel7, _activationStateOfChannel7Err := readBuffer.ReadBit("activationStateOfChannel7")
		if _activationStateOfChannel7Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel7Err, "Error parsing 'activationStateOfChannel7' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel7)

		// Simple Field (activationStateOfChannel8)
		activationStateOfChannel8, _activationStateOfChannel8Err := readBuffer.ReadBit("activationStateOfChannel8")
		if _activationStateOfChannel8Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel8Err, "Error parsing 'activationStateOfChannel8' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel8)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_StatusDHWC: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (tempoptimshiftactive)
		tempoptimshiftactive, _tempoptimshiftactiveErr := readBuffer.ReadBit("tempoptimshiftactive")
		if _tempoptimshiftactiveErr != nil {
			return nil, errors.Wrap(_tempoptimshiftactiveErr, "Error parsing 'tempoptimshiftactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(tempoptimshiftactive)

		// Simple Field (solarenergysupport)
		solarenergysupport, _solarenergysupportErr := readBuffer.ReadBit("solarenergysupport")
		if _solarenergysupportErr != nil {
			return nil, errors.Wrap(_solarenergysupportErr, "Error parsing 'solarenergysupport' field")
		}
		_map["Struct"] = values.NewPlcBOOL(solarenergysupport)

		// Simple Field (solarenergyonly)
		solarenergyonly, _solarenergyonlyErr := readBuffer.ReadBit("solarenergyonly")
		if _solarenergyonlyErr != nil {
			return nil, errors.Wrap(_solarenergyonlyErr, "Error parsing 'solarenergyonly' field")
		}
		_map["Struct"] = values.NewPlcBOOL(solarenergyonly)

		// Simple Field (otherenergysourceactive)
		otherenergysourceactive, _otherenergysourceactiveErr := readBuffer.ReadBit("otherenergysourceactive")
		if _otherenergysourceactiveErr != nil {
			return nil, errors.Wrap(_otherenergysourceactiveErr, "Error parsing 'otherenergysourceactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(otherenergysourceactive)

		// Simple Field (dhwpushactive)
		dhwpushactive, _dhwpushactiveErr := readBuffer.ReadBit("dhwpushactive")
		if _dhwpushactiveErr != nil {
			return nil, errors.Wrap(_dhwpushactiveErr, "Error parsing 'dhwpushactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(dhwpushactive)

		// Simple Field (legioprotactive)
		legioprotactive, _legioprotactiveErr := readBuffer.ReadBit("legioprotactive")
		if _legioprotactiveErr != nil {
			return nil, errors.Wrap(_legioprotactiveErr, "Error parsing 'legioprotactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(legioprotactive)

		// Simple Field (dhwloadactive)
		dhwloadactive, _dhwloadactiveErr := readBuffer.ReadBit("dhwloadactive")
		if _dhwloadactiveErr != nil {
			return nil, errors.Wrap(_dhwloadactiveErr, "Error parsing 'dhwloadactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(dhwloadactive)

		// Simple Field (fault)
		fault, _faultErr := readBuffer.ReadBit("fault")
		if _faultErr != nil {
			return nil, errors.Wrap(_faultErr, "Error parsing 'fault' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fault)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_StatusRHCC: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 1); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (overheatalarm)
		overheatalarm, _overheatalarmErr := readBuffer.ReadBit("overheatalarm")
		if _overheatalarmErr != nil {
			return nil, errors.Wrap(_overheatalarmErr, "Error parsing 'overheatalarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(overheatalarm)

		// Simple Field (frostalarm)
		frostalarm, _frostalarmErr := readBuffer.ReadBit("frostalarm")
		if _frostalarmErr != nil {
			return nil, errors.Wrap(_frostalarmErr, "Error parsing 'frostalarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(frostalarm)

		// Simple Field (dewpointstatus)
		dewpointstatus, _dewpointstatusErr := readBuffer.ReadBit("dewpointstatus")
		if _dewpointstatusErr != nil {
			return nil, errors.Wrap(_dewpointstatusErr, "Error parsing 'dewpointstatus' field")
		}
		_map["Struct"] = values.NewPlcBOOL(dewpointstatus)

		// Simple Field (coolingdisabled)
		coolingdisabled, _coolingdisabledErr := readBuffer.ReadBit("coolingdisabled")
		if _coolingdisabledErr != nil {
			return nil, errors.Wrap(_coolingdisabledErr, "Error parsing 'coolingdisabled' field")
		}
		_map["Struct"] = values.NewPlcBOOL(coolingdisabled)

		// Simple Field (statusprecool)
		statusprecool, _statusprecoolErr := readBuffer.ReadBit("statusprecool")
		if _statusprecoolErr != nil {
			return nil, errors.Wrap(_statusprecoolErr, "Error parsing 'statusprecool' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusprecool)

		// Simple Field (statusecoc)
		statusecoc, _statusecocErr := readBuffer.ReadBit("statusecoc")
		if _statusecocErr != nil {
			return nil, errors.Wrap(_statusecocErr, "Error parsing 'statusecoc' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusecoc)

		// Simple Field (heatcoolmode)
		heatcoolmode, _heatcoolmodeErr := readBuffer.ReadBit("heatcoolmode")
		if _heatcoolmodeErr != nil {
			return nil, errors.Wrap(_heatcoolmodeErr, "Error parsing 'heatcoolmode' field")
		}
		_map["Struct"] = values.NewPlcBOOL(heatcoolmode)

		// Simple Field (heatingdiabled)
		heatingdiabled, _heatingdiabledErr := readBuffer.ReadBit("heatingdiabled")
		if _heatingdiabledErr != nil {
			return nil, errors.Wrap(_heatingdiabledErr, "Error parsing 'heatingdiabled' field")
		}
		_map["Struct"] = values.NewPlcBOOL(heatingdiabled)

		// Simple Field (statusstopoptim)
		statusstopoptim, _statusstopoptimErr := readBuffer.ReadBit("statusstopoptim")
		if _statusstopoptimErr != nil {
			return nil, errors.Wrap(_statusstopoptimErr, "Error parsing 'statusstopoptim' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusstopoptim)

		// Simple Field (statusstartoptim)
		statusstartoptim, _statusstartoptimErr := readBuffer.ReadBit("statusstartoptim")
		if _statusstartoptimErr != nil {
			return nil, errors.Wrap(_statusstartoptimErr, "Error parsing 'statusstartoptim' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusstartoptim)

		// Simple Field (statusmorningboosth)
		statusmorningboosth, _statusmorningboosthErr := readBuffer.ReadBit("statusmorningboosth")
		if _statusmorningboosthErr != nil {
			return nil, errors.Wrap(_statusmorningboosthErr, "Error parsing 'statusmorningboosth' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusmorningboosth)

		// Simple Field (tempflowreturnlimit)
		tempflowreturnlimit, _tempflowreturnlimitErr := readBuffer.ReadBit("tempflowreturnlimit")
		if _tempflowreturnlimitErr != nil {
			return nil, errors.Wrap(_tempflowreturnlimitErr, "Error parsing 'tempflowreturnlimit' field")
		}
		_map["Struct"] = values.NewPlcBOOL(tempflowreturnlimit)

		// Simple Field (tempflowlimit)
		tempflowlimit, _tempflowlimitErr := readBuffer.ReadBit("tempflowlimit")
		if _tempflowlimitErr != nil {
			return nil, errors.Wrap(_tempflowlimitErr, "Error parsing 'tempflowlimit' field")
		}
		_map["Struct"] = values.NewPlcBOOL(tempflowlimit)

		// Simple Field (statusecoh)
		statusecoh, _statusecohErr := readBuffer.ReadBit("statusecoh")
		if _statusecohErr != nil {
			return nil, errors.Wrap(_statusecohErr, "Error parsing 'statusecoh' field")
		}
		_map["Struct"] = values.NewPlcBOOL(statusecoh)

		// Simple Field (fault)
		fault, _faultErr := readBuffer.ReadBit("fault")
		if _faultErr != nil {
			return nil, errors.Wrap(_faultErr, "Error parsing 'fault' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fault)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_CombinedStatus_HVA: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (calibrationMode)
		calibrationMode, _calibrationModeErr := readBuffer.ReadBit("calibrationMode")
		if _calibrationModeErr != nil {
			return nil, errors.Wrap(_calibrationModeErr, "Error parsing 'calibrationMode' field")
		}
		_map["Struct"] = values.NewPlcBOOL(calibrationMode)

		// Simple Field (lockedPosition)
		lockedPosition, _lockedPositionErr := readBuffer.ReadBit("lockedPosition")
		if _lockedPositionErr != nil {
			return nil, errors.Wrap(_lockedPositionErr, "Error parsing 'lockedPosition' field")
		}
		_map["Struct"] = values.NewPlcBOOL(lockedPosition)

		// Simple Field (forcedPosition)
		forcedPosition, _forcedPositionErr := readBuffer.ReadBit("forcedPosition")
		if _forcedPositionErr != nil {
			return nil, errors.Wrap(_forcedPositionErr, "Error parsing 'forcedPosition' field")
		}
		_map["Struct"] = values.NewPlcBOOL(forcedPosition)

		// Simple Field (manuaOperationOverridden)
		manuaOperationOverridden, _manuaOperationOverriddenErr := readBuffer.ReadBit("manuaOperationOverridden")
		if _manuaOperationOverriddenErr != nil {
			return nil, errors.Wrap(_manuaOperationOverriddenErr, "Error parsing 'manuaOperationOverridden' field")
		}
		_map["Struct"] = values.NewPlcBOOL(manuaOperationOverridden)

		// Simple Field (serviceMode)
		serviceMode, _serviceModeErr := readBuffer.ReadBit("serviceMode")
		if _serviceModeErr != nil {
			return nil, errors.Wrap(_serviceModeErr, "Error parsing 'serviceMode' field")
		}
		_map["Struct"] = values.NewPlcBOOL(serviceMode)

		// Simple Field (valveKick)
		valveKick, _valveKickErr := readBuffer.ReadBit("valveKick")
		if _valveKickErr != nil {
			return nil, errors.Wrap(_valveKickErr, "Error parsing 'valveKick' field")
		}
		_map["Struct"] = values.NewPlcBOOL(valveKick)

		// Simple Field (overload)
		overload, _overloadErr := readBuffer.ReadBit("overload")
		if _overloadErr != nil {
			return nil, errors.Wrap(_overloadErr, "Error parsing 'overload' field")
		}
		_map["Struct"] = values.NewPlcBOOL(overload)

		// Simple Field (shortCircuit)
		shortCircuit, _shortCircuitErr := readBuffer.ReadBit("shortCircuit")
		if _shortCircuitErr != nil {
			return nil, errors.Wrap(_shortCircuitErr, "Error parsing 'shortCircuit' field")
		}
		_map["Struct"] = values.NewPlcBOOL(shortCircuit)

		// Simple Field (currentValvePosition)
		currentValvePosition, _currentValvePositionErr := readBuffer.ReadBit("currentValvePosition")
		if _currentValvePositionErr != nil {
			return nil, errors.Wrap(_currentValvePositionErr, "Error parsing 'currentValvePosition' field")
		}
		_map["Struct"] = values.NewPlcBOOL(currentValvePosition)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_CombinedStatus_RTC: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 7); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (coolingModeEnabled)
		coolingModeEnabled, _coolingModeEnabledErr := readBuffer.ReadBit("coolingModeEnabled")
		if _coolingModeEnabledErr != nil {
			return nil, errors.Wrap(_coolingModeEnabledErr, "Error parsing 'coolingModeEnabled' field")
		}
		_map["Struct"] = values.NewPlcBOOL(coolingModeEnabled)

		// Simple Field (heatingModeEnabled)
		heatingModeEnabled, _heatingModeEnabledErr := readBuffer.ReadBit("heatingModeEnabled")
		if _heatingModeEnabledErr != nil {
			return nil, errors.Wrap(_heatingModeEnabledErr, "Error parsing 'heatingModeEnabled' field")
		}
		_map["Struct"] = values.NewPlcBOOL(heatingModeEnabled)

		// Simple Field (additionalHeatingCoolingStage2Stage)
		additionalHeatingCoolingStage2Stage, _additionalHeatingCoolingStage2StageErr := readBuffer.ReadBit("additionalHeatingCoolingStage2Stage")
		if _additionalHeatingCoolingStage2StageErr != nil {
			return nil, errors.Wrap(_additionalHeatingCoolingStage2StageErr, "Error parsing 'additionalHeatingCoolingStage2Stage' field")
		}
		_map["Struct"] = values.NewPlcBOOL(additionalHeatingCoolingStage2Stage)

		// Simple Field (controllerInactive)
		controllerInactive, _controllerInactiveErr := readBuffer.ReadBit("controllerInactive")
		if _controllerInactiveErr != nil {
			return nil, errors.Wrap(_controllerInactiveErr, "Error parsing 'controllerInactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(controllerInactive)

		// Simple Field (overheatAlarm)
		overheatAlarm, _overheatAlarmErr := readBuffer.ReadBit("overheatAlarm")
		if _overheatAlarmErr != nil {
			return nil, errors.Wrap(_overheatAlarmErr, "Error parsing 'overheatAlarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(overheatAlarm)

		// Simple Field (frostAlarm)
		frostAlarm, _frostAlarmErr := readBuffer.ReadBit("frostAlarm")
		if _frostAlarmErr != nil {
			return nil, errors.Wrap(_frostAlarmErr, "Error parsing 'frostAlarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(frostAlarm)

		// Simple Field (dewPointStatus)
		dewPointStatus, _dewPointStatusErr := readBuffer.ReadBit("dewPointStatus")
		if _dewPointStatusErr != nil {
			return nil, errors.Wrap(_dewPointStatusErr, "Error parsing 'dewPointStatus' field")
		}
		_map["Struct"] = values.NewPlcBOOL(dewPointStatus)

		// Simple Field (activeMode)
		activeMode, _activeModeErr := readBuffer.ReadBit("activeMode")
		if _activeModeErr != nil {
			return nil, errors.Wrap(_activeModeErr, "Error parsing 'activeMode' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activeMode)

		// Simple Field (generalFailureInformation)
		generalFailureInformation, _generalFailureInformationErr := readBuffer.ReadBit("generalFailureInformation")
		if _generalFailureInformationErr != nil {
			return nil, errors.Wrap(_generalFailureInformationErr, "Error parsing 'generalFailureInformation' field")
		}
		_map["Struct"] = values.NewPlcBOOL(generalFailureInformation)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Media: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint16("reserved", 10); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (knxIp)
		knxIp, _knxIpErr := readBuffer.ReadBit("knxIp")
		if _knxIpErr != nil {
			return nil, errors.Wrap(_knxIpErr, "Error parsing 'knxIp' field")
		}
		_map["Struct"] = values.NewPlcBOOL(knxIp)

		// Simple Field (rf)
		rf, _rfErr := readBuffer.ReadBit("rf")
		if _rfErr != nil {
			return nil, errors.Wrap(_rfErr, "Error parsing 'rf' field")
		}
		_map["Struct"] = values.NewPlcBOOL(rf)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 1); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (pl110)
		pl110, _pl110Err := readBuffer.ReadBit("pl110")
		if _pl110Err != nil {
			return nil, errors.Wrap(_pl110Err, "Error parsing 'pl110' field")
		}
		_map["Struct"] = values.NewPlcBOOL(pl110)

		// Simple Field (tp1)
		tp1, _tp1Err := readBuffer.ReadBit("tp1")
		if _tp1Err != nil {
			return nil, errors.Wrap(_tp1Err, "Error parsing 'tp1' field")
		}
		_map["Struct"] = values.NewPlcBOOL(tp1)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 1); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Channel_Activation_16: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (activationStateOfChannel1)
		activationStateOfChannel1, _activationStateOfChannel1Err := readBuffer.ReadBit("activationStateOfChannel1")
		if _activationStateOfChannel1Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel1Err, "Error parsing 'activationStateOfChannel1' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel1)

		// Simple Field (activationStateOfChannel2)
		activationStateOfChannel2, _activationStateOfChannel2Err := readBuffer.ReadBit("activationStateOfChannel2")
		if _activationStateOfChannel2Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel2Err, "Error parsing 'activationStateOfChannel2' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel2)

		// Simple Field (activationStateOfChannel3)
		activationStateOfChannel3, _activationStateOfChannel3Err := readBuffer.ReadBit("activationStateOfChannel3")
		if _activationStateOfChannel3Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel3Err, "Error parsing 'activationStateOfChannel3' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel3)

		// Simple Field (activationStateOfChannel4)
		activationStateOfChannel4, _activationStateOfChannel4Err := readBuffer.ReadBit("activationStateOfChannel4")
		if _activationStateOfChannel4Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel4Err, "Error parsing 'activationStateOfChannel4' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel4)

		// Simple Field (activationStateOfChannel5)
		activationStateOfChannel5, _activationStateOfChannel5Err := readBuffer.ReadBit("activationStateOfChannel5")
		if _activationStateOfChannel5Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel5Err, "Error parsing 'activationStateOfChannel5' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel5)

		// Simple Field (activationStateOfChannel6)
		activationStateOfChannel6, _activationStateOfChannel6Err := readBuffer.ReadBit("activationStateOfChannel6")
		if _activationStateOfChannel6Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel6Err, "Error parsing 'activationStateOfChannel6' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel6)

		// Simple Field (activationStateOfChannel7)
		activationStateOfChannel7, _activationStateOfChannel7Err := readBuffer.ReadBit("activationStateOfChannel7")
		if _activationStateOfChannel7Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel7Err, "Error parsing 'activationStateOfChannel7' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel7)

		// Simple Field (activationStateOfChannel8)
		activationStateOfChannel8, _activationStateOfChannel8Err := readBuffer.ReadBit("activationStateOfChannel8")
		if _activationStateOfChannel8Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel8Err, "Error parsing 'activationStateOfChannel8' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel8)

		// Simple Field (activationStateOfChannel9)
		activationStateOfChannel9, _activationStateOfChannel9Err := readBuffer.ReadBit("activationStateOfChannel9")
		if _activationStateOfChannel9Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel9Err, "Error parsing 'activationStateOfChannel9' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel9)

		// Simple Field (activationStateOfChannel10)
		activationStateOfChannel10, _activationStateOfChannel10Err := readBuffer.ReadBit("activationStateOfChannel10")
		if _activationStateOfChannel10Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel10Err, "Error parsing 'activationStateOfChannel10' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel10)

		// Simple Field (activationStateOfChannel11)
		activationStateOfChannel11, _activationStateOfChannel11Err := readBuffer.ReadBit("activationStateOfChannel11")
		if _activationStateOfChannel11Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel11Err, "Error parsing 'activationStateOfChannel11' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel11)

		// Simple Field (activationStateOfChannel12)
		activationStateOfChannel12, _activationStateOfChannel12Err := readBuffer.ReadBit("activationStateOfChannel12")
		if _activationStateOfChannel12Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel12Err, "Error parsing 'activationStateOfChannel12' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel12)

		// Simple Field (activationStateOfChannel13)
		activationStateOfChannel13, _activationStateOfChannel13Err := readBuffer.ReadBit("activationStateOfChannel13")
		if _activationStateOfChannel13Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel13Err, "Error parsing 'activationStateOfChannel13' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel13)

		// Simple Field (activationStateOfChannel14)
		activationStateOfChannel14, _activationStateOfChannel14Err := readBuffer.ReadBit("activationStateOfChannel14")
		if _activationStateOfChannel14Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel14Err, "Error parsing 'activationStateOfChannel14' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel14)

		// Simple Field (activationStateOfChannel15)
		activationStateOfChannel15, _activationStateOfChannel15Err := readBuffer.ReadBit("activationStateOfChannel15")
		if _activationStateOfChannel15Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel15Err, "Error parsing 'activationStateOfChannel15' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel15)

		// Simple Field (activationStateOfChannel16)
		activationStateOfChannel16, _activationStateOfChannel16Err := readBuffer.ReadBit("activationStateOfChannel16")
		if _activationStateOfChannel16Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel16Err, "Error parsing 'activationStateOfChannel16' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel16)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_OnOffAction: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 2)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_Alarm_Reaction: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 2)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_UpDown_Action: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 2)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_HVAC_PB_Action: // USINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadUint8("value", 2)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcUSINT(value), nil
	case datapointType == KnxDatapointType_DPT_DoubleNibble: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (busy)
		busy, _busyErr := readBuffer.ReadUint8("busy", 4)
		if _busyErr != nil {
			return nil, errors.Wrap(_busyErr, "Error parsing 'busy' field")
		}
		_map["Struct"] = values.NewPlcUSINT(busy)

		// Simple Field (nak)
		nak, _nakErr := readBuffer.ReadUint8("nak", 4)
		if _nakErr != nil {
			return nil, errors.Wrap(_nakErr, "Error parsing 'nak' field")
		}
		_map["Struct"] = values.NewPlcUSINT(nak)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_SceneInfo: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 1); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (sceneIsInactive)
		sceneIsInactive, _sceneIsInactiveErr := readBuffer.ReadBit("sceneIsInactive")
		if _sceneIsInactiveErr != nil {
			return nil, errors.Wrap(_sceneIsInactiveErr, "Error parsing 'sceneIsInactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(sceneIsInactive)

		// Simple Field (scenenumber)
		scenenumber, _scenenumberErr := readBuffer.ReadUint8("scenenumber", 6)
		if _scenenumberErr != nil {
			return nil, errors.Wrap(_scenenumberErr, "Error parsing 'scenenumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(scenenumber)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_CombinedInfoOnOff: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (maskBitInfoOnOffOutput16)
		maskBitInfoOnOffOutput16, _maskBitInfoOnOffOutput16Err := readBuffer.ReadBit("maskBitInfoOnOffOutput16")
		if _maskBitInfoOnOffOutput16Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput16Err, "Error parsing 'maskBitInfoOnOffOutput16' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput16)

		// Simple Field (maskBitInfoOnOffOutput15)
		maskBitInfoOnOffOutput15, _maskBitInfoOnOffOutput15Err := readBuffer.ReadBit("maskBitInfoOnOffOutput15")
		if _maskBitInfoOnOffOutput15Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput15Err, "Error parsing 'maskBitInfoOnOffOutput15' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput15)

		// Simple Field (maskBitInfoOnOffOutput14)
		maskBitInfoOnOffOutput14, _maskBitInfoOnOffOutput14Err := readBuffer.ReadBit("maskBitInfoOnOffOutput14")
		if _maskBitInfoOnOffOutput14Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput14Err, "Error parsing 'maskBitInfoOnOffOutput14' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput14)

		// Simple Field (maskBitInfoOnOffOutput13)
		maskBitInfoOnOffOutput13, _maskBitInfoOnOffOutput13Err := readBuffer.ReadBit("maskBitInfoOnOffOutput13")
		if _maskBitInfoOnOffOutput13Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput13Err, "Error parsing 'maskBitInfoOnOffOutput13' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput13)

		// Simple Field (maskBitInfoOnOffOutput12)
		maskBitInfoOnOffOutput12, _maskBitInfoOnOffOutput12Err := readBuffer.ReadBit("maskBitInfoOnOffOutput12")
		if _maskBitInfoOnOffOutput12Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput12Err, "Error parsing 'maskBitInfoOnOffOutput12' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput12)

		// Simple Field (maskBitInfoOnOffOutput11)
		maskBitInfoOnOffOutput11, _maskBitInfoOnOffOutput11Err := readBuffer.ReadBit("maskBitInfoOnOffOutput11")
		if _maskBitInfoOnOffOutput11Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput11Err, "Error parsing 'maskBitInfoOnOffOutput11' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput11)

		// Simple Field (maskBitInfoOnOffOutput10)
		maskBitInfoOnOffOutput10, _maskBitInfoOnOffOutput10Err := readBuffer.ReadBit("maskBitInfoOnOffOutput10")
		if _maskBitInfoOnOffOutput10Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput10Err, "Error parsing 'maskBitInfoOnOffOutput10' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput10)

		// Simple Field (maskBitInfoOnOffOutput9)
		maskBitInfoOnOffOutput9, _maskBitInfoOnOffOutput9Err := readBuffer.ReadBit("maskBitInfoOnOffOutput9")
		if _maskBitInfoOnOffOutput9Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput9Err, "Error parsing 'maskBitInfoOnOffOutput9' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput9)

		// Simple Field (maskBitInfoOnOffOutput8)
		maskBitInfoOnOffOutput8, _maskBitInfoOnOffOutput8Err := readBuffer.ReadBit("maskBitInfoOnOffOutput8")
		if _maskBitInfoOnOffOutput8Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput8Err, "Error parsing 'maskBitInfoOnOffOutput8' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput8)

		// Simple Field (maskBitInfoOnOffOutput7)
		maskBitInfoOnOffOutput7, _maskBitInfoOnOffOutput7Err := readBuffer.ReadBit("maskBitInfoOnOffOutput7")
		if _maskBitInfoOnOffOutput7Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput7Err, "Error parsing 'maskBitInfoOnOffOutput7' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput7)

		// Simple Field (maskBitInfoOnOffOutput6)
		maskBitInfoOnOffOutput6, _maskBitInfoOnOffOutput6Err := readBuffer.ReadBit("maskBitInfoOnOffOutput6")
		if _maskBitInfoOnOffOutput6Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput6Err, "Error parsing 'maskBitInfoOnOffOutput6' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput6)

		// Simple Field (maskBitInfoOnOffOutput5)
		maskBitInfoOnOffOutput5, _maskBitInfoOnOffOutput5Err := readBuffer.ReadBit("maskBitInfoOnOffOutput5")
		if _maskBitInfoOnOffOutput5Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput5Err, "Error parsing 'maskBitInfoOnOffOutput5' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput5)

		// Simple Field (maskBitInfoOnOffOutput4)
		maskBitInfoOnOffOutput4, _maskBitInfoOnOffOutput4Err := readBuffer.ReadBit("maskBitInfoOnOffOutput4")
		if _maskBitInfoOnOffOutput4Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput4Err, "Error parsing 'maskBitInfoOnOffOutput4' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput4)

		// Simple Field (maskBitInfoOnOffOutput3)
		maskBitInfoOnOffOutput3, _maskBitInfoOnOffOutput3Err := readBuffer.ReadBit("maskBitInfoOnOffOutput3")
		if _maskBitInfoOnOffOutput3Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput3Err, "Error parsing 'maskBitInfoOnOffOutput3' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput3)

		// Simple Field (maskBitInfoOnOffOutput2)
		maskBitInfoOnOffOutput2, _maskBitInfoOnOffOutput2Err := readBuffer.ReadBit("maskBitInfoOnOffOutput2")
		if _maskBitInfoOnOffOutput2Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput2Err, "Error parsing 'maskBitInfoOnOffOutput2' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput2)

		// Simple Field (maskBitInfoOnOffOutput1)
		maskBitInfoOnOffOutput1, _maskBitInfoOnOffOutput1Err := readBuffer.ReadBit("maskBitInfoOnOffOutput1")
		if _maskBitInfoOnOffOutput1Err != nil {
			return nil, errors.Wrap(_maskBitInfoOnOffOutput1Err, "Error parsing 'maskBitInfoOnOffOutput1' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskBitInfoOnOffOutput1)

		// Simple Field (infoOnOffOutput16)
		infoOnOffOutput16, _infoOnOffOutput16Err := readBuffer.ReadBit("infoOnOffOutput16")
		if _infoOnOffOutput16Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput16Err, "Error parsing 'infoOnOffOutput16' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput16)

		// Simple Field (infoOnOffOutput15)
		infoOnOffOutput15, _infoOnOffOutput15Err := readBuffer.ReadBit("infoOnOffOutput15")
		if _infoOnOffOutput15Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput15Err, "Error parsing 'infoOnOffOutput15' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput15)

		// Simple Field (infoOnOffOutput14)
		infoOnOffOutput14, _infoOnOffOutput14Err := readBuffer.ReadBit("infoOnOffOutput14")
		if _infoOnOffOutput14Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput14Err, "Error parsing 'infoOnOffOutput14' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput14)

		// Simple Field (infoOnOffOutput13)
		infoOnOffOutput13, _infoOnOffOutput13Err := readBuffer.ReadBit("infoOnOffOutput13")
		if _infoOnOffOutput13Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput13Err, "Error parsing 'infoOnOffOutput13' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput13)

		// Simple Field (infoOnOffOutput12)
		infoOnOffOutput12, _infoOnOffOutput12Err := readBuffer.ReadBit("infoOnOffOutput12")
		if _infoOnOffOutput12Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput12Err, "Error parsing 'infoOnOffOutput12' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput12)

		// Simple Field (infoOnOffOutput11)
		infoOnOffOutput11, _infoOnOffOutput11Err := readBuffer.ReadBit("infoOnOffOutput11")
		if _infoOnOffOutput11Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput11Err, "Error parsing 'infoOnOffOutput11' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput11)

		// Simple Field (infoOnOffOutput10)
		infoOnOffOutput10, _infoOnOffOutput10Err := readBuffer.ReadBit("infoOnOffOutput10")
		if _infoOnOffOutput10Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput10Err, "Error parsing 'infoOnOffOutput10' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput10)

		// Simple Field (infoOnOffOutput9)
		infoOnOffOutput9, _infoOnOffOutput9Err := readBuffer.ReadBit("infoOnOffOutput9")
		if _infoOnOffOutput9Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput9Err, "Error parsing 'infoOnOffOutput9' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput9)

		// Simple Field (infoOnOffOutput8)
		infoOnOffOutput8, _infoOnOffOutput8Err := readBuffer.ReadBit("infoOnOffOutput8")
		if _infoOnOffOutput8Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput8Err, "Error parsing 'infoOnOffOutput8' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput8)

		// Simple Field (infoOnOffOutput7)
		infoOnOffOutput7, _infoOnOffOutput7Err := readBuffer.ReadBit("infoOnOffOutput7")
		if _infoOnOffOutput7Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput7Err, "Error parsing 'infoOnOffOutput7' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput7)

		// Simple Field (infoOnOffOutput6)
		infoOnOffOutput6, _infoOnOffOutput6Err := readBuffer.ReadBit("infoOnOffOutput6")
		if _infoOnOffOutput6Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput6Err, "Error parsing 'infoOnOffOutput6' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput6)

		// Simple Field (infoOnOffOutput5)
		infoOnOffOutput5, _infoOnOffOutput5Err := readBuffer.ReadBit("infoOnOffOutput5")
		if _infoOnOffOutput5Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput5Err, "Error parsing 'infoOnOffOutput5' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput5)

		// Simple Field (infoOnOffOutput4)
		infoOnOffOutput4, _infoOnOffOutput4Err := readBuffer.ReadBit("infoOnOffOutput4")
		if _infoOnOffOutput4Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput4Err, "Error parsing 'infoOnOffOutput4' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput4)

		// Simple Field (infoOnOffOutput3)
		infoOnOffOutput3, _infoOnOffOutput3Err := readBuffer.ReadBit("infoOnOffOutput3")
		if _infoOnOffOutput3Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput3Err, "Error parsing 'infoOnOffOutput3' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput3)

		// Simple Field (infoOnOffOutput2)
		infoOnOffOutput2, _infoOnOffOutput2Err := readBuffer.ReadBit("infoOnOffOutput2")
		if _infoOnOffOutput2Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput2Err, "Error parsing 'infoOnOffOutput2' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput2)

		// Simple Field (infoOnOffOutput1)
		infoOnOffOutput1, _infoOnOffOutput1Err := readBuffer.ReadBit("infoOnOffOutput1")
		if _infoOnOffOutput1Err != nil {
			return nil, errors.Wrap(_infoOnOffOutput1Err, "Error parsing 'infoOnOffOutput1' field")
		}
		_map["Struct"] = values.NewPlcBOOL(infoOnOffOutput1)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_ActiveEnergy_V64: // LINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcLINT(value), nil
	case datapointType == KnxDatapointType_DPT_ApparantEnergy_V64: // LINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcLINT(value), nil
	case datapointType == KnxDatapointType_DPT_ReactiveEnergy_V64: // LINT
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadInt64("value", 64)
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcLINT(value), nil
	case datapointType == KnxDatapointType_DPT_Channel_Activation_24: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (activationStateOfChannel1)
		activationStateOfChannel1, _activationStateOfChannel1Err := readBuffer.ReadBit("activationStateOfChannel1")
		if _activationStateOfChannel1Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel1Err, "Error parsing 'activationStateOfChannel1' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel1)

		// Simple Field (activationStateOfChannel2)
		activationStateOfChannel2, _activationStateOfChannel2Err := readBuffer.ReadBit("activationStateOfChannel2")
		if _activationStateOfChannel2Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel2Err, "Error parsing 'activationStateOfChannel2' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel2)

		// Simple Field (activationStateOfChannel3)
		activationStateOfChannel3, _activationStateOfChannel3Err := readBuffer.ReadBit("activationStateOfChannel3")
		if _activationStateOfChannel3Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel3Err, "Error parsing 'activationStateOfChannel3' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel3)

		// Simple Field (activationStateOfChannel4)
		activationStateOfChannel4, _activationStateOfChannel4Err := readBuffer.ReadBit("activationStateOfChannel4")
		if _activationStateOfChannel4Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel4Err, "Error parsing 'activationStateOfChannel4' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel4)

		// Simple Field (activationStateOfChannel5)
		activationStateOfChannel5, _activationStateOfChannel5Err := readBuffer.ReadBit("activationStateOfChannel5")
		if _activationStateOfChannel5Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel5Err, "Error parsing 'activationStateOfChannel5' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel5)

		// Simple Field (activationStateOfChannel6)
		activationStateOfChannel6, _activationStateOfChannel6Err := readBuffer.ReadBit("activationStateOfChannel6")
		if _activationStateOfChannel6Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel6Err, "Error parsing 'activationStateOfChannel6' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel6)

		// Simple Field (activationStateOfChannel7)
		activationStateOfChannel7, _activationStateOfChannel7Err := readBuffer.ReadBit("activationStateOfChannel7")
		if _activationStateOfChannel7Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel7Err, "Error parsing 'activationStateOfChannel7' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel7)

		// Simple Field (activationStateOfChannel8)
		activationStateOfChannel8, _activationStateOfChannel8Err := readBuffer.ReadBit("activationStateOfChannel8")
		if _activationStateOfChannel8Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel8Err, "Error parsing 'activationStateOfChannel8' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel8)

		// Simple Field (activationStateOfChannel9)
		activationStateOfChannel9, _activationStateOfChannel9Err := readBuffer.ReadBit("activationStateOfChannel9")
		if _activationStateOfChannel9Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel9Err, "Error parsing 'activationStateOfChannel9' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel9)

		// Simple Field (activationStateOfChannel10)
		activationStateOfChannel10, _activationStateOfChannel10Err := readBuffer.ReadBit("activationStateOfChannel10")
		if _activationStateOfChannel10Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel10Err, "Error parsing 'activationStateOfChannel10' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel10)

		// Simple Field (activationStateOfChannel11)
		activationStateOfChannel11, _activationStateOfChannel11Err := readBuffer.ReadBit("activationStateOfChannel11")
		if _activationStateOfChannel11Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel11Err, "Error parsing 'activationStateOfChannel11' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel11)

		// Simple Field (activationStateOfChannel12)
		activationStateOfChannel12, _activationStateOfChannel12Err := readBuffer.ReadBit("activationStateOfChannel12")
		if _activationStateOfChannel12Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel12Err, "Error parsing 'activationStateOfChannel12' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel12)

		// Simple Field (activationStateOfChannel13)
		activationStateOfChannel13, _activationStateOfChannel13Err := readBuffer.ReadBit("activationStateOfChannel13")
		if _activationStateOfChannel13Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel13Err, "Error parsing 'activationStateOfChannel13' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel13)

		// Simple Field (activationStateOfChannel14)
		activationStateOfChannel14, _activationStateOfChannel14Err := readBuffer.ReadBit("activationStateOfChannel14")
		if _activationStateOfChannel14Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel14Err, "Error parsing 'activationStateOfChannel14' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel14)

		// Simple Field (activationStateOfChannel15)
		activationStateOfChannel15, _activationStateOfChannel15Err := readBuffer.ReadBit("activationStateOfChannel15")
		if _activationStateOfChannel15Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel15Err, "Error parsing 'activationStateOfChannel15' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel15)

		// Simple Field (activationStateOfChannel16)
		activationStateOfChannel16, _activationStateOfChannel16Err := readBuffer.ReadBit("activationStateOfChannel16")
		if _activationStateOfChannel16Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel16Err, "Error parsing 'activationStateOfChannel16' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel16)

		// Simple Field (activationStateOfChannel17)
		activationStateOfChannel17, _activationStateOfChannel17Err := readBuffer.ReadBit("activationStateOfChannel17")
		if _activationStateOfChannel17Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel17Err, "Error parsing 'activationStateOfChannel17' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel17)

		// Simple Field (activationStateOfChannel18)
		activationStateOfChannel18, _activationStateOfChannel18Err := readBuffer.ReadBit("activationStateOfChannel18")
		if _activationStateOfChannel18Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel18Err, "Error parsing 'activationStateOfChannel18' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel18)

		// Simple Field (activationStateOfChannel19)
		activationStateOfChannel19, _activationStateOfChannel19Err := readBuffer.ReadBit("activationStateOfChannel19")
		if _activationStateOfChannel19Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel19Err, "Error parsing 'activationStateOfChannel19' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel19)

		// Simple Field (activationStateOfChannel20)
		activationStateOfChannel20, _activationStateOfChannel20Err := readBuffer.ReadBit("activationStateOfChannel20")
		if _activationStateOfChannel20Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel20Err, "Error parsing 'activationStateOfChannel20' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel20)

		// Simple Field (activationStateOfChannel21)
		activationStateOfChannel21, _activationStateOfChannel21Err := readBuffer.ReadBit("activationStateOfChannel21")
		if _activationStateOfChannel21Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel21Err, "Error parsing 'activationStateOfChannel21' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel21)

		// Simple Field (activationStateOfChannel22)
		activationStateOfChannel22, _activationStateOfChannel22Err := readBuffer.ReadBit("activationStateOfChannel22")
		if _activationStateOfChannel22Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel22Err, "Error parsing 'activationStateOfChannel22' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel22)

		// Simple Field (activationStateOfChannel23)
		activationStateOfChannel23, _activationStateOfChannel23Err := readBuffer.ReadBit("activationStateOfChannel23")
		if _activationStateOfChannel23Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel23Err, "Error parsing 'activationStateOfChannel23' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel23)

		// Simple Field (activationStateOfChannel24)
		activationStateOfChannel24, _activationStateOfChannel24Err := readBuffer.ReadBit("activationStateOfChannel24")
		if _activationStateOfChannel24Err != nil {
			return nil, errors.Wrap(_activationStateOfChannel24Err, "Error parsing 'activationStateOfChannel24' field")
		}
		_map["Struct"] = values.NewPlcBOOL(activationStateOfChannel24)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_HVACModeNext: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (delayTimeMin)
		delayTimeMin, _delayTimeMinErr := readBuffer.ReadUint16("delayTimeMin", 16)
		if _delayTimeMinErr != nil {
			return nil, errors.Wrap(_delayTimeMinErr, "Error parsing 'delayTimeMin' field")
		}
		_map["Struct"] = values.NewPlcUINT(delayTimeMin)

		// Simple Field (hvacMode)
		hvacMode, _hvacModeErr := readBuffer.ReadUint8("hvacMode", 8)
		if _hvacModeErr != nil {
			return nil, errors.Wrap(_hvacModeErr, "Error parsing 'hvacMode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(hvacMode)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_DHWModeNext: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (delayTimeMin)
		delayTimeMin, _delayTimeMinErr := readBuffer.ReadUint16("delayTimeMin", 16)
		if _delayTimeMinErr != nil {
			return nil, errors.Wrap(_delayTimeMinErr, "Error parsing 'delayTimeMin' field")
		}
		_map["Struct"] = values.NewPlcUINT(delayTimeMin)

		// Simple Field (dhwMode)
		dhwMode, _dhwModeErr := readBuffer.ReadUint8("dhwMode", 8)
		if _dhwModeErr != nil {
			return nil, errors.Wrap(_dhwModeErr, "Error parsing 'dhwMode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(dhwMode)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_OccModeNext: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (delayTimeMin)
		delayTimeMin, _delayTimeMinErr := readBuffer.ReadUint16("delayTimeMin", 16)
		if _delayTimeMinErr != nil {
			return nil, errors.Wrap(_delayTimeMinErr, "Error parsing 'delayTimeMin' field")
		}
		_map["Struct"] = values.NewPlcUINT(delayTimeMin)

		// Simple Field (occupancyMode)
		occupancyMode, _occupancyModeErr := readBuffer.ReadUint8("occupancyMode", 8)
		if _occupancyModeErr != nil {
			return nil, errors.Wrap(_occupancyModeErr, "Error parsing 'occupancyMode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(occupancyMode)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_BuildingModeNext: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (delayTimeMin)
		delayTimeMin, _delayTimeMinErr := readBuffer.ReadUint16("delayTimeMin", 16)
		if _delayTimeMinErr != nil {
			return nil, errors.Wrap(_delayTimeMinErr, "Error parsing 'delayTimeMin' field")
		}
		_map["Struct"] = values.NewPlcUINT(delayTimeMin)

		// Simple Field (buildingMode)
		buildingMode, _buildingModeErr := readBuffer.ReadUint8("buildingMode", 8)
		if _buildingModeErr != nil {
			return nil, errors.Wrap(_buildingModeErr, "Error parsing 'buildingMode' field")
		}
		_map["Struct"] = values.NewPlcUSINT(buildingMode)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_StatusLightingActuator: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (validactualvalue)
		validactualvalue, _validactualvalueErr := readBuffer.ReadBit("validactualvalue")
		if _validactualvalueErr != nil {
			return nil, errors.Wrap(_validactualvalueErr, "Error parsing 'validactualvalue' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validactualvalue)

		// Simple Field (locked)
		locked, _lockedErr := readBuffer.ReadBit("locked")
		if _lockedErr != nil {
			return nil, errors.Wrap(_lockedErr, "Error parsing 'locked' field")
		}
		_map["Struct"] = values.NewPlcBOOL(locked)

		// Simple Field (forced)
		forced, _forcedErr := readBuffer.ReadBit("forced")
		if _forcedErr != nil {
			return nil, errors.Wrap(_forcedErr, "Error parsing 'forced' field")
		}
		_map["Struct"] = values.NewPlcBOOL(forced)

		// Simple Field (nightmodeactive)
		nightmodeactive, _nightmodeactiveErr := readBuffer.ReadBit("nightmodeactive")
		if _nightmodeactiveErr != nil {
			return nil, errors.Wrap(_nightmodeactiveErr, "Error parsing 'nightmodeactive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(nightmodeactive)

		// Simple Field (staircaselightingFunction)
		staircaselightingFunction, _staircaselightingFunctionErr := readBuffer.ReadBit("staircaselightingFunction")
		if _staircaselightingFunctionErr != nil {
			return nil, errors.Wrap(_staircaselightingFunctionErr, "Error parsing 'staircaselightingFunction' field")
		}
		_map["Struct"] = values.NewPlcBOOL(staircaselightingFunction)

		// Simple Field (dimming)
		dimming, _dimmingErr := readBuffer.ReadBit("dimming")
		if _dimmingErr != nil {
			return nil, errors.Wrap(_dimmingErr, "Error parsing 'dimming' field")
		}
		_map["Struct"] = values.NewPlcBOOL(dimming)

		// Simple Field (localoverride)
		localoverride, _localoverrideErr := readBuffer.ReadBit("localoverride")
		if _localoverrideErr != nil {
			return nil, errors.Wrap(_localoverrideErr, "Error parsing 'localoverride' field")
		}
		_map["Struct"] = values.NewPlcBOOL(localoverride)

		// Simple Field (failure)
		failure, _failureErr := readBuffer.ReadBit("failure")
		if _failureErr != nil {
			return nil, errors.Wrap(_failureErr, "Error parsing 'failure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(failure)

		// Simple Field (actualvalue)
		actualvalue, _actualvalueErr := readBuffer.ReadUint8("actualvalue", 8)
		if _actualvalueErr != nil {
			return nil, errors.Wrap(_actualvalueErr, "Error parsing 'actualvalue' field")
		}
		_map["Struct"] = values.NewPlcUSINT(actualvalue)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Version: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (magicNumber)
		magicNumber, _magicNumberErr := readBuffer.ReadUint8("magicNumber", 5)
		if _magicNumberErr != nil {
			return nil, errors.Wrap(_magicNumberErr, "Error parsing 'magicNumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(magicNumber)

		// Simple Field (versionNumber)
		versionNumber, _versionNumberErr := readBuffer.ReadUint8("versionNumber", 5)
		if _versionNumberErr != nil {
			return nil, errors.Wrap(_versionNumberErr, "Error parsing 'versionNumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(versionNumber)

		// Simple Field (revisionNumber)
		revisionNumber, _revisionNumberErr := readBuffer.ReadUint8("revisionNumber", 6)
		if _revisionNumberErr != nil {
			return nil, errors.Wrap(_revisionNumberErr, "Error parsing 'revisionNumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(revisionNumber)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_AlarmInfo: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (logNumber)
		logNumber, _logNumberErr := readBuffer.ReadUint8("logNumber", 8)
		if _logNumberErr != nil {
			return nil, errors.Wrap(_logNumberErr, "Error parsing 'logNumber' field")
		}
		_map["Struct"] = values.NewPlcUSINT(logNumber)

		// Simple Field (alarmPriority)
		alarmPriority, _alarmPriorityErr := readBuffer.ReadUint8("alarmPriority", 8)
		if _alarmPriorityErr != nil {
			return nil, errors.Wrap(_alarmPriorityErr, "Error parsing 'alarmPriority' field")
		}
		_map["Struct"] = values.NewPlcUSINT(alarmPriority)

		// Simple Field (applicationArea)
		applicationArea, _applicationAreaErr := readBuffer.ReadUint8("applicationArea", 8)
		if _applicationAreaErr != nil {
			return nil, errors.Wrap(_applicationAreaErr, "Error parsing 'applicationArea' field")
		}
		_map["Struct"] = values.NewPlcUSINT(applicationArea)

		// Simple Field (errorClass)
		errorClass, _errorClassErr := readBuffer.ReadUint8("errorClass", 8)
		if _errorClassErr != nil {
			return nil, errors.Wrap(_errorClassErr, "Error parsing 'errorClass' field")
		}
		_map["Struct"] = values.NewPlcUSINT(errorClass)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (errorcodeSup)
		errorcodeSup, _errorcodeSupErr := readBuffer.ReadBit("errorcodeSup")
		if _errorcodeSupErr != nil {
			return nil, errors.Wrap(_errorcodeSupErr, "Error parsing 'errorcodeSup' field")
		}
		_map["Struct"] = values.NewPlcBOOL(errorcodeSup)

		// Simple Field (alarmtextSup)
		alarmtextSup, _alarmtextSupErr := readBuffer.ReadBit("alarmtextSup")
		if _alarmtextSupErr != nil {
			return nil, errors.Wrap(_alarmtextSupErr, "Error parsing 'alarmtextSup' field")
		}
		_map["Struct"] = values.NewPlcBOOL(alarmtextSup)

		// Simple Field (timestampSup)
		timestampSup, _timestampSupErr := readBuffer.ReadBit("timestampSup")
		if _timestampSupErr != nil {
			return nil, errors.Wrap(_timestampSupErr, "Error parsing 'timestampSup' field")
		}
		_map["Struct"] = values.NewPlcBOOL(timestampSup)

		// Simple Field (ackSup)
		ackSup, _ackSupErr := readBuffer.ReadBit("ackSup")
		if _ackSupErr != nil {
			return nil, errors.Wrap(_ackSupErr, "Error parsing 'ackSup' field")
		}
		_map["Struct"] = values.NewPlcBOOL(ackSup)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (locked)
		locked, _lockedErr := readBuffer.ReadBit("locked")
		if _lockedErr != nil {
			return nil, errors.Wrap(_lockedErr, "Error parsing 'locked' field")
		}
		_map["Struct"] = values.NewPlcBOOL(locked)

		// Simple Field (alarmunack)
		alarmunack, _alarmunackErr := readBuffer.ReadBit("alarmunack")
		if _alarmunackErr != nil {
			return nil, errors.Wrap(_alarmunackErr, "Error parsing 'alarmunack' field")
		}
		_map["Struct"] = values.NewPlcBOOL(alarmunack)

		// Simple Field (inalarm)
		inalarm, _inalarmErr := readBuffer.ReadBit("inalarm")
		if _inalarmErr != nil {
			return nil, errors.Wrap(_inalarmErr, "Error parsing 'inalarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(inalarm)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetF16_3: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (tempsetpcomf)
		tempsetpcomf, _tempsetpcomfErr := readBuffer.ReadFloat32("tempsetpcomf", 16)
		if _tempsetpcomfErr != nil {
			return nil, errors.Wrap(_tempsetpcomfErr, "Error parsing 'tempsetpcomf' field")
		}
		_map["Struct"] = values.NewPlcREAL(tempsetpcomf)

		// Simple Field (tempsetpstdby)
		tempsetpstdby, _tempsetpstdbyErr := readBuffer.ReadFloat32("tempsetpstdby", 16)
		if _tempsetpstdbyErr != nil {
			return nil, errors.Wrap(_tempsetpstdbyErr, "Error parsing 'tempsetpstdby' field")
		}
		_map["Struct"] = values.NewPlcREAL(tempsetpstdby)

		// Simple Field (tempsetpeco)
		tempsetpeco, _tempsetpecoErr := readBuffer.ReadFloat32("tempsetpeco", 16)
		if _tempsetpecoErr != nil {
			return nil, errors.Wrap(_tempsetpecoErr, "Error parsing 'tempsetpeco' field")
		}
		_map["Struct"] = values.NewPlcREAL(tempsetpeco)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetShiftF16_3: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (tempsetpshiftcomf)
		tempsetpshiftcomf, _tempsetpshiftcomfErr := readBuffer.ReadFloat32("tempsetpshiftcomf", 16)
		if _tempsetpshiftcomfErr != nil {
			return nil, errors.Wrap(_tempsetpshiftcomfErr, "Error parsing 'tempsetpshiftcomf' field")
		}
		_map["Struct"] = values.NewPlcREAL(tempsetpshiftcomf)

		// Simple Field (tempsetpshiftstdby)
		tempsetpshiftstdby, _tempsetpshiftstdbyErr := readBuffer.ReadFloat32("tempsetpshiftstdby", 16)
		if _tempsetpshiftstdbyErr != nil {
			return nil, errors.Wrap(_tempsetpshiftstdbyErr, "Error parsing 'tempsetpshiftstdby' field")
		}
		_map["Struct"] = values.NewPlcREAL(tempsetpshiftstdby)

		// Simple Field (tempsetpshifteco)
		tempsetpshifteco, _tempsetpshiftecoErr := readBuffer.ReadFloat32("tempsetpshifteco", 16)
		if _tempsetpshiftecoErr != nil {
			return nil, errors.Wrap(_tempsetpshiftecoErr, "Error parsing 'tempsetpshifteco' field")
		}
		_map["Struct"] = values.NewPlcREAL(tempsetpshifteco)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Scaling_Speed: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (timePeriod)
		timePeriod, _timePeriodErr := readBuffer.ReadUint16("timePeriod", 16)
		if _timePeriodErr != nil {
			return nil, errors.Wrap(_timePeriodErr, "Error parsing 'timePeriod' field")
		}
		_map["Struct"] = values.NewPlcUINT(timePeriod)

		// Simple Field (percent)
		percent, _percentErr := readBuffer.ReadUint8("percent", 8)
		if _percentErr != nil {
			return nil, errors.Wrap(_percentErr, "Error parsing 'percent' field")
		}
		_map["Struct"] = values.NewPlcUSINT(percent)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Scaling_Step_Time: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (timePeriod)
		timePeriod, _timePeriodErr := readBuffer.ReadUint16("timePeriod", 16)
		if _timePeriodErr != nil {
			return nil, errors.Wrap(_timePeriodErr, "Error parsing 'timePeriod' field")
		}
		_map["Struct"] = values.NewPlcUINT(timePeriod)

		// Simple Field (percent)
		percent, _percentErr := readBuffer.ReadUint8("percent", 8)
		if _percentErr != nil {
			return nil, errors.Wrap(_percentErr, "Error parsing 'percent' field")
		}
		_map["Struct"] = values.NewPlcUSINT(percent)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_MeteringValue: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (countval)
		countval, _countvalErr := readBuffer.ReadInt32("countval", 32)
		if _countvalErr != nil {
			return nil, errors.Wrap(_countvalErr, "Error parsing 'countval' field")
		}
		_map["Struct"] = values.NewPlcDINT(countval)

		// Simple Field (valinffield)
		valinffield, _valinffieldErr := readBuffer.ReadUint8("valinffield", 8)
		if _valinffieldErr != nil {
			return nil, errors.Wrap(_valinffieldErr, "Error parsing 'valinffield' field")
		}
		_map["Struct"] = values.NewPlcUSINT(valinffield)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 3); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (alarmunack)
		alarmunack, _alarmunackErr := readBuffer.ReadBit("alarmunack")
		if _alarmunackErr != nil {
			return nil, errors.Wrap(_alarmunackErr, "Error parsing 'alarmunack' field")
		}
		_map["Struct"] = values.NewPlcBOOL(alarmunack)

		// Simple Field (inalarm)
		inalarm, _inalarmErr := readBuffer.ReadBit("inalarm")
		if _inalarmErr != nil {
			return nil, errors.Wrap(_inalarmErr, "Error parsing 'inalarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(inalarm)

		// Simple Field (overridden)
		overridden, _overriddenErr := readBuffer.ReadBit("overridden")
		if _overriddenErr != nil {
			return nil, errors.Wrap(_overriddenErr, "Error parsing 'overridden' field")
		}
		_map["Struct"] = values.NewPlcBOOL(overridden)

		// Simple Field (fault)
		fault, _faultErr := readBuffer.ReadBit("fault")
		if _faultErr != nil {
			return nil, errors.Wrap(_faultErr, "Error parsing 'fault' field")
		}
		_map["Struct"] = values.NewPlcBOOL(fault)

		// Simple Field (outofservice)
		outofservice, _outofserviceErr := readBuffer.ReadBit("outofservice")
		if _outofserviceErr != nil {
			return nil, errors.Wrap(_outofserviceErr, "Error parsing 'outofservice' field")
		}
		_map["Struct"] = values.NewPlcBOOL(outofservice)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_MBus_Address: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (manufactid)
		manufactid, _manufactidErr := readBuffer.ReadUint16("manufactid", 16)
		if _manufactidErr != nil {
			return nil, errors.Wrap(_manufactidErr, "Error parsing 'manufactid' field")
		}
		_map["Struct"] = values.NewPlcUINT(manufactid)

		// Simple Field (identnumber)
		identnumber, _identnumberErr := readBuffer.ReadUint32("identnumber", 32)
		if _identnumberErr != nil {
			return nil, errors.Wrap(_identnumberErr, "Error parsing 'identnumber' field")
		}
		_map["Struct"] = values.NewPlcUDINT(identnumber)

		// Simple Field (version)
		version, _versionErr := readBuffer.ReadUint8("version", 8)
		if _versionErr != nil {
			return nil, errors.Wrap(_versionErr, "Error parsing 'version' field")
		}
		_map["Struct"] = values.NewPlcUSINT(version)

		// Simple Field (medium)
		medium, _mediumErr := readBuffer.ReadUint8("medium", 8)
		if _mediumErr != nil {
			return nil, errors.Wrap(_mediumErr, "Error parsing 'medium' field")
		}
		_map["Struct"] = values.NewPlcUSINT(medium)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Colour_RGB: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (r)
		r, _rErr := readBuffer.ReadUint8("r", 8)
		if _rErr != nil {
			return nil, errors.Wrap(_rErr, "Error parsing 'r' field")
		}
		_map["Struct"] = values.NewPlcUSINT(r)

		// Simple Field (g)
		g, _gErr := readBuffer.ReadUint8("g", 8)
		if _gErr != nil {
			return nil, errors.Wrap(_gErr, "Error parsing 'g' field")
		}
		_map["Struct"] = values.NewPlcUSINT(g)

		// Simple Field (b)
		b, _bErr := readBuffer.ReadUint8("b", 8)
		if _bErr != nil {
			return nil, errors.Wrap(_bErr, "Error parsing 'b' field")
		}
		_map["Struct"] = values.NewPlcUSINT(b)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_LanguageCodeAlpha2_ASCII: // STRING
		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (value)
		value, _valueErr := readBuffer.ReadString("value", uint32(16), "ASCII")
		if _valueErr != nil {
			return nil, errors.Wrap(_valueErr, "Error parsing 'value' field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcSTRING(value), nil
	case datapointType == KnxDatapointType_DPT_Tariff_ActiveEnergy: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (activeelectricalenergy)
		activeelectricalenergy, _activeelectricalenergyErr := readBuffer.ReadInt32("activeelectricalenergy", 32)
		if _activeelectricalenergyErr != nil {
			return nil, errors.Wrap(_activeelectricalenergyErr, "Error parsing 'activeelectricalenergy' field")
		}
		_map["Struct"] = values.NewPlcDINT(activeelectricalenergy)

		// Simple Field (tariff)
		tariff, _tariffErr := readBuffer.ReadUint8("tariff", 8)
		if _tariffErr != nil {
			return nil, errors.Wrap(_tariffErr, "Error parsing 'tariff' field")
		}
		_map["Struct"] = values.NewPlcUSINT(tariff)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (electricalengergyvalidity)
		electricalengergyvalidity, _electricalengergyvalidityErr := readBuffer.ReadBit("electricalengergyvalidity")
		if _electricalengergyvalidityErr != nil {
			return nil, errors.Wrap(_electricalengergyvalidityErr, "Error parsing 'electricalengergyvalidity' field")
		}
		_map["Struct"] = values.NewPlcBOOL(electricalengergyvalidity)

		// Simple Field (tariffvalidity)
		tariffvalidity, _tariffvalidityErr := readBuffer.ReadBit("tariffvalidity")
		if _tariffvalidityErr != nil {
			return nil, errors.Wrap(_tariffvalidityErr, "Error parsing 'tariffvalidity' field")
		}
		_map["Struct"] = values.NewPlcBOOL(tariffvalidity)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Prioritised_Mode_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (deactivationOfPriority)
		deactivationOfPriority, _deactivationOfPriorityErr := readBuffer.ReadBit("deactivationOfPriority")
		if _deactivationOfPriorityErr != nil {
			return nil, errors.Wrap(_deactivationOfPriorityErr, "Error parsing 'deactivationOfPriority' field")
		}
		_map["Struct"] = values.NewPlcBOOL(deactivationOfPriority)

		// Simple Field (priorityLevel)
		priorityLevel, _priorityLevelErr := readBuffer.ReadUint8("priorityLevel", 3)
		if _priorityLevelErr != nil {
			return nil, errors.Wrap(_priorityLevelErr, "Error parsing 'priorityLevel' field")
		}
		_map["Struct"] = values.NewPlcUSINT(priorityLevel)

		// Simple Field (modeLevel)
		modeLevel, _modeLevelErr := readBuffer.ReadUint8("modeLevel", 4)
		if _modeLevelErr != nil {
			return nil, errors.Wrap(_modeLevelErr, "Error parsing 'modeLevel' field")
		}
		_map["Struct"] = values.NewPlcUSINT(modeLevel)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_DALI_Control_Gear_Diagnostic: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (convertorError)
		convertorError, _convertorErrorErr := readBuffer.ReadBit("convertorError")
		if _convertorErrorErr != nil {
			return nil, errors.Wrap(_convertorErrorErr, "Error parsing 'convertorError' field")
		}
		_map["Struct"] = values.NewPlcBOOL(convertorError)

		// Simple Field (ballastFailure)
		ballastFailure, _ballastFailureErr := readBuffer.ReadBit("ballastFailure")
		if _ballastFailureErr != nil {
			return nil, errors.Wrap(_ballastFailureErr, "Error parsing 'ballastFailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(ballastFailure)

		// Simple Field (lampFailure)
		lampFailure, _lampFailureErr := readBuffer.ReadBit("lampFailure")
		if _lampFailureErr != nil {
			return nil, errors.Wrap(_lampFailureErr, "Error parsing 'lampFailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(lampFailure)

		// Simple Field (readOrResponse)
		readOrResponse, _readOrResponseErr := readBuffer.ReadBit("readOrResponse")
		if _readOrResponseErr != nil {
			return nil, errors.Wrap(_readOrResponseErr, "Error parsing 'readOrResponse' field")
		}
		_map["Struct"] = values.NewPlcBOOL(readOrResponse)

		// Simple Field (addressIndicator)
		addressIndicator, _addressIndicatorErr := readBuffer.ReadBit("addressIndicator")
		if _addressIndicatorErr != nil {
			return nil, errors.Wrap(_addressIndicatorErr, "Error parsing 'addressIndicator' field")
		}
		_map["Struct"] = values.NewPlcBOOL(addressIndicator)

		// Simple Field (daliDeviceAddressOrDaliGroupAddress)
		daliDeviceAddressOrDaliGroupAddress, _daliDeviceAddressOrDaliGroupAddressErr := readBuffer.ReadUint8("daliDeviceAddressOrDaliGroupAddress", 6)
		if _daliDeviceAddressOrDaliGroupAddressErr != nil {
			return nil, errors.Wrap(_daliDeviceAddressOrDaliGroupAddressErr, "Error parsing 'daliDeviceAddressOrDaliGroupAddress' field")
		}
		_map["Struct"] = values.NewPlcUSINT(daliDeviceAddressOrDaliGroupAddress)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_DALI_Diagnostics: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (ballastFailure)
		ballastFailure, _ballastFailureErr := readBuffer.ReadBit("ballastFailure")
		if _ballastFailureErr != nil {
			return nil, errors.Wrap(_ballastFailureErr, "Error parsing 'ballastFailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(ballastFailure)

		// Simple Field (lampFailure)
		lampFailure, _lampFailureErr := readBuffer.ReadBit("lampFailure")
		if _lampFailureErr != nil {
			return nil, errors.Wrap(_lampFailureErr, "Error parsing 'lampFailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(lampFailure)

		// Simple Field (deviceAddress)
		deviceAddress, _deviceAddressErr := readBuffer.ReadUint8("deviceAddress", 6)
		if _deviceAddressErr != nil {
			return nil, errors.Wrap(_deviceAddressErr, "Error parsing 'deviceAddress' field")
		}
		_map["Struct"] = values.NewPlcUSINT(deviceAddress)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_CombinedPosition: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (heightPosition)
		heightPosition, _heightPositionErr := readBuffer.ReadUint8("heightPosition", 8)
		if _heightPositionErr != nil {
			return nil, errors.Wrap(_heightPositionErr, "Error parsing 'heightPosition' field")
		}
		_map["Struct"] = values.NewPlcUSINT(heightPosition)

		// Simple Field (slatsPosition)
		slatsPosition, _slatsPositionErr := readBuffer.ReadUint8("slatsPosition", 8)
		if _slatsPositionErr != nil {
			return nil, errors.Wrap(_slatsPositionErr, "Error parsing 'slatsPosition' field")
		}
		_map["Struct"] = values.NewPlcUSINT(slatsPosition)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (validityHeightPosition)
		validityHeightPosition, _validityHeightPositionErr := readBuffer.ReadBit("validityHeightPosition")
		if _validityHeightPositionErr != nil {
			return nil, errors.Wrap(_validityHeightPositionErr, "Error parsing 'validityHeightPosition' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validityHeightPosition)

		// Simple Field (validitySlatsPosition)
		validitySlatsPosition, _validitySlatsPositionErr := readBuffer.ReadBit("validitySlatsPosition")
		if _validitySlatsPositionErr != nil {
			return nil, errors.Wrap(_validitySlatsPositionErr, "Error parsing 'validitySlatsPosition' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validitySlatsPosition)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_StatusSAB: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (heightPosition)
		heightPosition, _heightPositionErr := readBuffer.ReadUint8("heightPosition", 8)
		if _heightPositionErr != nil {
			return nil, errors.Wrap(_heightPositionErr, "Error parsing 'heightPosition' field")
		}
		_map["Struct"] = values.NewPlcUSINT(heightPosition)

		// Simple Field (slatsPosition)
		slatsPosition, _slatsPositionErr := readBuffer.ReadUint8("slatsPosition", 8)
		if _slatsPositionErr != nil {
			return nil, errors.Wrap(_slatsPositionErr, "Error parsing 'slatsPosition' field")
		}
		_map["Struct"] = values.NewPlcUSINT(slatsPosition)

		// Simple Field (upperEndPosReached)
		upperEndPosReached, _upperEndPosReachedErr := readBuffer.ReadBit("upperEndPosReached")
		if _upperEndPosReachedErr != nil {
			return nil, errors.Wrap(_upperEndPosReachedErr, "Error parsing 'upperEndPosReached' field")
		}
		_map["Struct"] = values.NewPlcBOOL(upperEndPosReached)

		// Simple Field (lowerEndPosReached)
		lowerEndPosReached, _lowerEndPosReachedErr := readBuffer.ReadBit("lowerEndPosReached")
		if _lowerEndPosReachedErr != nil {
			return nil, errors.Wrap(_lowerEndPosReachedErr, "Error parsing 'lowerEndPosReached' field")
		}
		_map["Struct"] = values.NewPlcBOOL(lowerEndPosReached)

		// Simple Field (lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent)
		lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent, _lowerPredefPosReachedTypHeight100PercentSlatsAngle100PercentErr := readBuffer.ReadBit("lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent")
		if _lowerPredefPosReachedTypHeight100PercentSlatsAngle100PercentErr != nil {
			return nil, errors.Wrap(_lowerPredefPosReachedTypHeight100PercentSlatsAngle100PercentErr, "Error parsing 'lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent' field")
		}
		_map["Struct"] = values.NewPlcBOOL(lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent)

		// Simple Field (targetPosDrive)
		targetPosDrive, _targetPosDriveErr := readBuffer.ReadBit("targetPosDrive")
		if _targetPosDriveErr != nil {
			return nil, errors.Wrap(_targetPosDriveErr, "Error parsing 'targetPosDrive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(targetPosDrive)

		// Simple Field (restrictionOfTargetHeightPosPosCanNotBeReached)
		restrictionOfTargetHeightPosPosCanNotBeReached, _restrictionOfTargetHeightPosPosCanNotBeReachedErr := readBuffer.ReadBit("restrictionOfTargetHeightPosPosCanNotBeReached")
		if _restrictionOfTargetHeightPosPosCanNotBeReachedErr != nil {
			return nil, errors.Wrap(_restrictionOfTargetHeightPosPosCanNotBeReachedErr, "Error parsing 'restrictionOfTargetHeightPosPosCanNotBeReached' field")
		}
		_map["Struct"] = values.NewPlcBOOL(restrictionOfTargetHeightPosPosCanNotBeReached)

		// Simple Field (restrictionOfSlatsHeightPosPosCanNotBeReached)
		restrictionOfSlatsHeightPosPosCanNotBeReached, _restrictionOfSlatsHeightPosPosCanNotBeReachedErr := readBuffer.ReadBit("restrictionOfSlatsHeightPosPosCanNotBeReached")
		if _restrictionOfSlatsHeightPosPosCanNotBeReachedErr != nil {
			return nil, errors.Wrap(_restrictionOfSlatsHeightPosPosCanNotBeReachedErr, "Error parsing 'restrictionOfSlatsHeightPosPosCanNotBeReached' field")
		}
		_map["Struct"] = values.NewPlcBOOL(restrictionOfSlatsHeightPosPosCanNotBeReached)

		// Simple Field (atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm)
		atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm, _atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarmErr := readBuffer.ReadBit("atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm")
		if _atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarmErr != nil {
			return nil, errors.Wrap(_atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarmErr, "Error parsing 'atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm' field")
		}
		_map["Struct"] = values.NewPlcBOOL(atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm)

		// Simple Field (upDownPositionIsForcedByMoveupdownforcedInput)
		upDownPositionIsForcedByMoveupdownforcedInput, _upDownPositionIsForcedByMoveupdownforcedInputErr := readBuffer.ReadBit("upDownPositionIsForcedByMoveupdownforcedInput")
		if _upDownPositionIsForcedByMoveupdownforcedInputErr != nil {
			return nil, errors.Wrap(_upDownPositionIsForcedByMoveupdownforcedInputErr, "Error parsing 'upDownPositionIsForcedByMoveupdownforcedInput' field")
		}
		_map["Struct"] = values.NewPlcBOOL(upDownPositionIsForcedByMoveupdownforcedInput)

		// Simple Field (movementIsLockedEGByDevicelockedInput)
		movementIsLockedEGByDevicelockedInput, _movementIsLockedEGByDevicelockedInputErr := readBuffer.ReadBit("movementIsLockedEGByDevicelockedInput")
		if _movementIsLockedEGByDevicelockedInputErr != nil {
			return nil, errors.Wrap(_movementIsLockedEGByDevicelockedInputErr, "Error parsing 'movementIsLockedEGByDevicelockedInput' field")
		}
		_map["Struct"] = values.NewPlcBOOL(movementIsLockedEGByDevicelockedInput)

		// Simple Field (actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface)
		actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface, _actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterfaceErr := readBuffer.ReadBit("actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface")
		if _actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterfaceErr != nil {
			return nil, errors.Wrap(_actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterfaceErr, "Error parsing 'actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface' field")
		}
		_map["Struct"] = values.NewPlcBOOL(actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface)

		// Simple Field (generalFailureOfTheActuatorOrTheDrive)
		generalFailureOfTheActuatorOrTheDrive, _generalFailureOfTheActuatorOrTheDriveErr := readBuffer.ReadBit("generalFailureOfTheActuatorOrTheDrive")
		if _generalFailureOfTheActuatorOrTheDriveErr != nil {
			return nil, errors.Wrap(_generalFailureOfTheActuatorOrTheDriveErr, "Error parsing 'generalFailureOfTheActuatorOrTheDrive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(generalFailureOfTheActuatorOrTheDrive)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 3); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (validityHeightPos)
		validityHeightPos, _validityHeightPosErr := readBuffer.ReadBit("validityHeightPos")
		if _validityHeightPosErr != nil {
			return nil, errors.Wrap(_validityHeightPosErr, "Error parsing 'validityHeightPos' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validityHeightPos)

		// Simple Field (validitySlatsPos)
		validitySlatsPos, _validitySlatsPosErr := readBuffer.ReadBit("validitySlatsPos")
		if _validitySlatsPosErr != nil {
			return nil, errors.Wrap(_validitySlatsPosErr, "Error parsing 'validitySlatsPos' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validitySlatsPos)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Colour_xyY: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (xAxis)
		xAxis, _xAxisErr := readBuffer.ReadUint16("xAxis", 16)
		if _xAxisErr != nil {
			return nil, errors.Wrap(_xAxisErr, "Error parsing 'xAxis' field")
		}
		_map["Struct"] = values.NewPlcUINT(xAxis)

		// Simple Field (yAxis)
		yAxis, _yAxisErr := readBuffer.ReadUint16("yAxis", 16)
		if _yAxisErr != nil {
			return nil, errors.Wrap(_yAxisErr, "Error parsing 'yAxis' field")
		}
		_map["Struct"] = values.NewPlcUINT(yAxis)

		// Simple Field (brightness)
		brightness, _brightnessErr := readBuffer.ReadUint8("brightness", 8)
		if _brightnessErr != nil {
			return nil, errors.Wrap(_brightnessErr, "Error parsing 'brightness' field")
		}
		_map["Struct"] = values.NewPlcUSINT(brightness)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (validityXy)
		validityXy, _validityXyErr := readBuffer.ReadBit("validityXy")
		if _validityXyErr != nil {
			return nil, errors.Wrap(_validityXyErr, "Error parsing 'validityXy' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validityXy)

		// Simple Field (validityBrightness)
		validityBrightness, _validityBrightnessErr := readBuffer.ReadBit("validityBrightness")
		if _validityBrightnessErr != nil {
			return nil, errors.Wrap(_validityBrightnessErr, "Error parsing 'validityBrightness' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validityBrightness)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Converter_Status: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (converterModeAccordingToTheDaliConverterStateMachine)
		converterModeAccordingToTheDaliConverterStateMachine, _converterModeAccordingToTheDaliConverterStateMachineErr := readBuffer.ReadUint8("converterModeAccordingToTheDaliConverterStateMachine", 4)
		if _converterModeAccordingToTheDaliConverterStateMachineErr != nil {
			return nil, errors.Wrap(_converterModeAccordingToTheDaliConverterStateMachineErr, "Error parsing 'converterModeAccordingToTheDaliConverterStateMachine' field")
		}
		_map["Struct"] = values.NewPlcUSINT(converterModeAccordingToTheDaliConverterStateMachine)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (hardwiredSwitchIsActive)
		hardwiredSwitchIsActive, _hardwiredSwitchIsActiveErr := readBuffer.ReadBit("hardwiredSwitchIsActive")
		if _hardwiredSwitchIsActiveErr != nil {
			return nil, errors.Wrap(_hardwiredSwitchIsActiveErr, "Error parsing 'hardwiredSwitchIsActive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(hardwiredSwitchIsActive)

		// Simple Field (hardwiredInhibitIsActive)
		hardwiredInhibitIsActive, _hardwiredInhibitIsActiveErr := readBuffer.ReadBit("hardwiredInhibitIsActive")
		if _hardwiredInhibitIsActiveErr != nil {
			return nil, errors.Wrap(_hardwiredInhibitIsActiveErr, "Error parsing 'hardwiredInhibitIsActive' field")
		}
		_map["Struct"] = values.NewPlcBOOL(hardwiredInhibitIsActive)

		// Simple Field (functionTestPending)
		functionTestPending, _functionTestPendingErr := readBuffer.ReadUint8("functionTestPending", 2)
		if _functionTestPendingErr != nil {
			return nil, errors.Wrap(_functionTestPendingErr, "Error parsing 'functionTestPending' field")
		}
		_map["Struct"] = values.NewPlcUSINT(functionTestPending)

		// Simple Field (durationTestPending)
		durationTestPending, _durationTestPendingErr := readBuffer.ReadUint8("durationTestPending", 2)
		if _durationTestPendingErr != nil {
			return nil, errors.Wrap(_durationTestPendingErr, "Error parsing 'durationTestPending' field")
		}
		_map["Struct"] = values.NewPlcUSINT(durationTestPending)

		// Simple Field (partialDurationTestPending)
		partialDurationTestPending, _partialDurationTestPendingErr := readBuffer.ReadUint8("partialDurationTestPending", 2)
		if _partialDurationTestPendingErr != nil {
			return nil, errors.Wrap(_partialDurationTestPendingErr, "Error parsing 'partialDurationTestPending' field")
		}
		_map["Struct"] = values.NewPlcUSINT(partialDurationTestPending)

		// Simple Field (converterFailure)
		converterFailure, _converterFailureErr := readBuffer.ReadUint8("converterFailure", 2)
		if _converterFailureErr != nil {
			return nil, errors.Wrap(_converterFailureErr, "Error parsing 'converterFailure' field")
		}
		_map["Struct"] = values.NewPlcUSINT(converterFailure)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Converter_Test_Result: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (ltrf)
		ltrf, _ltrfErr := readBuffer.ReadUint8("ltrf", 4)
		if _ltrfErr != nil {
			return nil, errors.Wrap(_ltrfErr, "Error parsing 'ltrf' field")
		}
		_map["Struct"] = values.NewPlcUSINT(ltrf)

		// Simple Field (ltrd)
		ltrd, _ltrdErr := readBuffer.ReadUint8("ltrd", 4)
		if _ltrdErr != nil {
			return nil, errors.Wrap(_ltrdErr, "Error parsing 'ltrd' field")
		}
		_map["Struct"] = values.NewPlcUSINT(ltrd)

		// Simple Field (ltrp)
		ltrp, _ltrpErr := readBuffer.ReadUint8("ltrp", 4)
		if _ltrpErr != nil {
			return nil, errors.Wrap(_ltrpErr, "Error parsing 'ltrp' field")
		}
		_map["Struct"] = values.NewPlcUSINT(ltrp)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (sf)
		sf, _sfErr := readBuffer.ReadUint8("sf", 2)
		if _sfErr != nil {
			return nil, errors.Wrap(_sfErr, "Error parsing 'sf' field")
		}
		_map["Struct"] = values.NewPlcUSINT(sf)

		// Simple Field (sd)
		sd, _sdErr := readBuffer.ReadUint8("sd", 2)
		if _sdErr != nil {
			return nil, errors.Wrap(_sdErr, "Error parsing 'sd' field")
		}
		_map["Struct"] = values.NewPlcUSINT(sd)

		// Simple Field (sp)
		sp, _spErr := readBuffer.ReadUint8("sp", 2)
		if _spErr != nil {
			return nil, errors.Wrap(_spErr, "Error parsing 'sp' field")
		}
		_map["Struct"] = values.NewPlcUSINT(sp)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 2); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (ldtr)
		ldtr, _ldtrErr := readBuffer.ReadUint16("ldtr", 16)
		if _ldtrErr != nil {
			return nil, errors.Wrap(_ldtrErr, "Error parsing 'ldtr' field")
		}
		_map["Struct"] = values.NewPlcUINT(ldtr)

		// Simple Field (lpdtr)
		lpdtr, _lpdtrErr := readBuffer.ReadUint8("lpdtr", 8)
		if _lpdtrErr != nil {
			return nil, errors.Wrap(_lpdtrErr, "Error parsing 'lpdtr' field")
		}
		_map["Struct"] = values.NewPlcUSINT(lpdtr)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Battery_Info: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (batteryFailure)
		batteryFailure, _batteryFailureErr := readBuffer.ReadBit("batteryFailure")
		if _batteryFailureErr != nil {
			return nil, errors.Wrap(_batteryFailureErr, "Error parsing 'batteryFailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(batteryFailure)

		// Simple Field (batteryDurationFailure)
		batteryDurationFailure, _batteryDurationFailureErr := readBuffer.ReadBit("batteryDurationFailure")
		if _batteryDurationFailureErr != nil {
			return nil, errors.Wrap(_batteryDurationFailureErr, "Error parsing 'batteryDurationFailure' field")
		}
		_map["Struct"] = values.NewPlcBOOL(batteryDurationFailure)

		// Simple Field (batteryFullyCharged)
		batteryFullyCharged, _batteryFullyChargedErr := readBuffer.ReadBit("batteryFullyCharged")
		if _batteryFullyChargedErr != nil {
			return nil, errors.Wrap(_batteryFullyChargedErr, "Error parsing 'batteryFullyCharged' field")
		}
		_map["Struct"] = values.NewPlcBOOL(batteryFullyCharged)

		// Simple Field (batteryChargeLevel)
		batteryChargeLevel, _batteryChargeLevelErr := readBuffer.ReadUint8("batteryChargeLevel", 8)
		if _batteryChargeLevelErr != nil {
			return nil, errors.Wrap(_batteryChargeLevelErr, "Error parsing 'batteryChargeLevel' field")
		}
		_map["Struct"] = values.NewPlcUSINT(batteryChargeLevel)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Brightness_Colour_Temperature_Transition: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (ms)
		ms, _msErr := readBuffer.ReadUint16("ms", 16)
		if _msErr != nil {
			return nil, errors.Wrap(_msErr, "Error parsing 'ms' field")
		}
		_map["Struct"] = values.NewPlcUINT(ms)

		// Simple Field (temperatureK)
		temperatureK, _temperatureKErr := readBuffer.ReadUint16("temperatureK", 16)
		if _temperatureKErr != nil {
			return nil, errors.Wrap(_temperatureKErr, "Error parsing 'temperatureK' field")
		}
		_map["Struct"] = values.NewPlcUINT(temperatureK)

		// Simple Field (percent)
		percent, _percentErr := readBuffer.ReadUint8("percent", 8)
		if _percentErr != nil {
			return nil, errors.Wrap(_percentErr, "Error parsing 'percent' field")
		}
		_map["Struct"] = values.NewPlcUSINT(percent)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 5); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (validityOfTheTimePeriod)
		validityOfTheTimePeriod, _validityOfTheTimePeriodErr := readBuffer.ReadBit("validityOfTheTimePeriod")
		if _validityOfTheTimePeriodErr != nil {
			return nil, errors.Wrap(_validityOfTheTimePeriodErr, "Error parsing 'validityOfTheTimePeriod' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validityOfTheTimePeriod)

		// Simple Field (validityOfTheAbsoluteColourTemperature)
		validityOfTheAbsoluteColourTemperature, _validityOfTheAbsoluteColourTemperatureErr := readBuffer.ReadBit("validityOfTheAbsoluteColourTemperature")
		if _validityOfTheAbsoluteColourTemperatureErr != nil {
			return nil, errors.Wrap(_validityOfTheAbsoluteColourTemperatureErr, "Error parsing 'validityOfTheAbsoluteColourTemperature' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validityOfTheAbsoluteColourTemperature)

		// Simple Field (validityOfTheAbsoluteBrightness)
		validityOfTheAbsoluteBrightness, _validityOfTheAbsoluteBrightnessErr := readBuffer.ReadBit("validityOfTheAbsoluteBrightness")
		if _validityOfTheAbsoluteBrightnessErr != nil {
			return nil, errors.Wrap(_validityOfTheAbsoluteBrightnessErr, "Error parsing 'validityOfTheAbsoluteBrightness' field")
		}
		_map["Struct"] = values.NewPlcBOOL(validityOfTheAbsoluteBrightness)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Brightness_Colour_Temperature_Control: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cct)
		cct, _cctErr := readBuffer.ReadBit("cct")
		if _cctErr != nil {
			return nil, errors.Wrap(_cctErr, "Error parsing 'cct' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cct)

		// Simple Field (stepCodeColourTemperature)
		stepCodeColourTemperature, _stepCodeColourTemperatureErr := readBuffer.ReadUint8("stepCodeColourTemperature", 3)
		if _stepCodeColourTemperatureErr != nil {
			return nil, errors.Wrap(_stepCodeColourTemperatureErr, "Error parsing 'stepCodeColourTemperature' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourTemperature)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cb)
		cb, _cbErr := readBuffer.ReadBit("cb")
		if _cbErr != nil {
			return nil, errors.Wrap(_cbErr, "Error parsing 'cb' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cb)

		// Simple Field (stepCodeBrightness)
		stepCodeBrightness, _stepCodeBrightnessErr := readBuffer.ReadUint8("stepCodeBrightness", 3)
		if _stepCodeBrightnessErr != nil {
			return nil, errors.Wrap(_stepCodeBrightnessErr, "Error parsing 'stepCodeBrightness' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeBrightness)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 6); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cctAndStepCodeColourValidity)
		cctAndStepCodeColourValidity, _cctAndStepCodeColourValidityErr := readBuffer.ReadBit("cctAndStepCodeColourValidity")
		if _cctAndStepCodeColourValidityErr != nil {
			return nil, errors.Wrap(_cctAndStepCodeColourValidityErr, "Error parsing 'cctAndStepCodeColourValidity' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cctAndStepCodeColourValidity)

		// Simple Field (cbAndStepCodeBrightnessValidity)
		cbAndStepCodeBrightnessValidity, _cbAndStepCodeBrightnessValidityErr := readBuffer.ReadBit("cbAndStepCodeBrightnessValidity")
		if _cbAndStepCodeBrightnessValidityErr != nil {
			return nil, errors.Wrap(_cbAndStepCodeBrightnessValidityErr, "Error parsing 'cbAndStepCodeBrightnessValidity' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cbAndStepCodeBrightnessValidity)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Colour_RGBW: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (colourLevelRed)
		colourLevelRed, _colourLevelRedErr := readBuffer.ReadUint8("colourLevelRed", 8)
		if _colourLevelRedErr != nil {
			return nil, errors.Wrap(_colourLevelRedErr, "Error parsing 'colourLevelRed' field")
		}
		_map["Struct"] = values.NewPlcUSINT(colourLevelRed)

		// Simple Field (colourLevelGreen)
		colourLevelGreen, _colourLevelGreenErr := readBuffer.ReadUint8("colourLevelGreen", 8)
		if _colourLevelGreenErr != nil {
			return nil, errors.Wrap(_colourLevelGreenErr, "Error parsing 'colourLevelGreen' field")
		}
		_map["Struct"] = values.NewPlcUSINT(colourLevelGreen)

		// Simple Field (colourLevelBlue)
		colourLevelBlue, _colourLevelBlueErr := readBuffer.ReadUint8("colourLevelBlue", 8)
		if _colourLevelBlueErr != nil {
			return nil, errors.Wrap(_colourLevelBlueErr, "Error parsing 'colourLevelBlue' field")
		}
		_map["Struct"] = values.NewPlcUSINT(colourLevelBlue)

		// Simple Field (colourLevelWhite)
		colourLevelWhite, _colourLevelWhiteErr := readBuffer.ReadUint8("colourLevelWhite", 8)
		if _colourLevelWhiteErr != nil {
			return nil, errors.Wrap(_colourLevelWhiteErr, "Error parsing 'colourLevelWhite' field")
		}
		_map["Struct"] = values.NewPlcUSINT(colourLevelWhite)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (mr)
		mr, _mrErr := readBuffer.ReadBit("mr")
		if _mrErr != nil {
			return nil, errors.Wrap(_mrErr, "Error parsing 'mr' field")
		}
		_map["Struct"] = values.NewPlcBOOL(mr)

		// Simple Field (mg)
		mg, _mgErr := readBuffer.ReadBit("mg")
		if _mgErr != nil {
			return nil, errors.Wrap(_mgErr, "Error parsing 'mg' field")
		}
		_map["Struct"] = values.NewPlcBOOL(mg)

		// Simple Field (mb)
		mb, _mbErr := readBuffer.ReadBit("mb")
		if _mbErr != nil {
			return nil, errors.Wrap(_mbErr, "Error parsing 'mb' field")
		}
		_map["Struct"] = values.NewPlcBOOL(mb)

		// Simple Field (mw)
		mw, _mwErr := readBuffer.ReadBit("mw")
		if _mwErr != nil {
			return nil, errors.Wrap(_mwErr, "Error parsing 'mw' field")
		}
		_map["Struct"] = values.NewPlcBOOL(mw)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Relative_Control_RGBW: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (maskcw)
		maskcw, _maskcwErr := readBuffer.ReadBit("maskcw")
		if _maskcwErr != nil {
			return nil, errors.Wrap(_maskcwErr, "Error parsing 'maskcw' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskcw)

		// Simple Field (maskcb)
		maskcb, _maskcbErr := readBuffer.ReadBit("maskcb")
		if _maskcbErr != nil {
			return nil, errors.Wrap(_maskcbErr, "Error parsing 'maskcb' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskcb)

		// Simple Field (maskcg)
		maskcg, _maskcgErr := readBuffer.ReadBit("maskcg")
		if _maskcgErr != nil {
			return nil, errors.Wrap(_maskcgErr, "Error parsing 'maskcg' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskcg)

		// Simple Field (maskcr)
		maskcr, _maskcrErr := readBuffer.ReadBit("maskcr")
		if _maskcrErr != nil {
			return nil, errors.Wrap(_maskcrErr, "Error parsing 'maskcr' field")
		}
		_map["Struct"] = values.NewPlcBOOL(maskcr)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cw)
		cw, _cwErr := readBuffer.ReadBit("cw")
		if _cwErr != nil {
			return nil, errors.Wrap(_cwErr, "Error parsing 'cw' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cw)

		// Simple Field (stepCodeColourWhite)
		stepCodeColourWhite, _stepCodeColourWhiteErr := readBuffer.ReadUint8("stepCodeColourWhite", 3)
		if _stepCodeColourWhiteErr != nil {
			return nil, errors.Wrap(_stepCodeColourWhiteErr, "Error parsing 'stepCodeColourWhite' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourWhite)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cb)
		cb, _cbErr := readBuffer.ReadBit("cb")
		if _cbErr != nil {
			return nil, errors.Wrap(_cbErr, "Error parsing 'cb' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cb)

		// Simple Field (stepCodeColourBlue)
		stepCodeColourBlue, _stepCodeColourBlueErr := readBuffer.ReadUint8("stepCodeColourBlue", 3)
		if _stepCodeColourBlueErr != nil {
			return nil, errors.Wrap(_stepCodeColourBlueErr, "Error parsing 'stepCodeColourBlue' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourBlue)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cg)
		cg, _cgErr := readBuffer.ReadBit("cg")
		if _cgErr != nil {
			return nil, errors.Wrap(_cgErr, "Error parsing 'cg' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cg)

		// Simple Field (stepCodeColourGreen)
		stepCodeColourGreen, _stepCodeColourGreenErr := readBuffer.ReadUint8("stepCodeColourGreen", 3)
		if _stepCodeColourGreenErr != nil {
			return nil, errors.Wrap(_stepCodeColourGreenErr, "Error parsing 'stepCodeColourGreen' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourGreen)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cr)
		cr, _crErr := readBuffer.ReadBit("cr")
		if _crErr != nil {
			return nil, errors.Wrap(_crErr, "Error parsing 'cr' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cr)

		// Simple Field (stepCodeColourRed)
		stepCodeColourRed, _stepCodeColourRedErr := readBuffer.ReadUint8("stepCodeColourRed", 3)
		if _stepCodeColourRedErr != nil {
			return nil, errors.Wrap(_stepCodeColourRedErr, "Error parsing 'stepCodeColourRed' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourRed)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_Relative_Control_RGB: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cb)
		cb, _cbErr := readBuffer.ReadBit("cb")
		if _cbErr != nil {
			return nil, errors.Wrap(_cbErr, "Error parsing 'cb' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cb)

		// Simple Field (stepCodeColourBlue)
		stepCodeColourBlue, _stepCodeColourBlueErr := readBuffer.ReadUint8("stepCodeColourBlue", 3)
		if _stepCodeColourBlueErr != nil {
			return nil, errors.Wrap(_stepCodeColourBlueErr, "Error parsing 'stepCodeColourBlue' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourBlue)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cg)
		cg, _cgErr := readBuffer.ReadBit("cg")
		if _cgErr != nil {
			return nil, errors.Wrap(_cgErr, "Error parsing 'cg' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cg)

		// Simple Field (stepCodeColourGreen)
		stepCodeColourGreen, _stepCodeColourGreenErr := readBuffer.ReadUint8("stepCodeColourGreen", 3)
		if _stepCodeColourGreenErr != nil {
			return nil, errors.Wrap(_stepCodeColourGreenErr, "Error parsing 'stepCodeColourGreen' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourGreen)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (cr)
		cr, _crErr := readBuffer.ReadBit("cr")
		if _crErr != nil {
			return nil, errors.Wrap(_crErr, "Error parsing 'cr' field")
		}
		_map["Struct"] = values.NewPlcBOOL(cr)

		// Simple Field (stepCodeColourRed)
		stepCodeColourRed, _stepCodeColourRedErr := readBuffer.ReadUint8("stepCodeColourRed", 3)
		if _stepCodeColourRedErr != nil {
			return nil, errors.Wrap(_stepCodeColourRedErr, "Error parsing 'stepCodeColourRed' field")
		}
		_map["Struct"] = values.NewPlcUSINT(stepCodeColourRed)

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 4); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_GeographicalLocation: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (longitude)
		longitude, _longitudeErr := readBuffer.ReadFloat32("longitude", 32)
		if _longitudeErr != nil {
			return nil, errors.Wrap(_longitudeErr, "Error parsing 'longitude' field")
		}
		_map["Struct"] = values.NewPlcREAL(longitude)

		// Simple Field (latitude)
		latitude, _latitudeErr := readBuffer.ReadFloat32("latitude", 32)
		if _latitudeErr != nil {
			return nil, errors.Wrap(_latitudeErr, "Error parsing 'latitude' field")
		}
		_map["Struct"] = values.NewPlcREAL(latitude)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetF16_4: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (roomTemperatureSetpointComfort)
		roomTemperatureSetpointComfort, _roomTemperatureSetpointComfortErr := readBuffer.ReadFloat32("roomTemperatureSetpointComfort", 16)
		if _roomTemperatureSetpointComfortErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointComfortErr, "Error parsing 'roomTemperatureSetpointComfort' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointComfort)

		// Simple Field (roomTemperatureSetpointStandby)
		roomTemperatureSetpointStandby, _roomTemperatureSetpointStandbyErr := readBuffer.ReadFloat32("roomTemperatureSetpointStandby", 16)
		if _roomTemperatureSetpointStandbyErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointStandbyErr, "Error parsing 'roomTemperatureSetpointStandby' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointStandby)

		// Simple Field (roomTemperatureSetpointEconomy)
		roomTemperatureSetpointEconomy, _roomTemperatureSetpointEconomyErr := readBuffer.ReadFloat32("roomTemperatureSetpointEconomy", 16)
		if _roomTemperatureSetpointEconomyErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointEconomyErr, "Error parsing 'roomTemperatureSetpointEconomy' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointEconomy)

		// Simple Field (roomTemperatureSetpointBuildingProtection)
		roomTemperatureSetpointBuildingProtection, _roomTemperatureSetpointBuildingProtectionErr := readBuffer.ReadFloat32("roomTemperatureSetpointBuildingProtection", 16)
		if _roomTemperatureSetpointBuildingProtectionErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointBuildingProtectionErr, "Error parsing 'roomTemperatureSetpointBuildingProtection' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointBuildingProtection)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetShiftF16_4: // Struct
		// Struct
		_map := map[string]api.PlcValue{}

		// Reserved Field (Just skip the bytes)
		if _, _err := readBuffer.ReadUint8("reserved", 8); _err != nil {
			return nil, errors.Wrap(_err, "Error parsing reserved field")
		}

		// Simple Field (roomTemperatureSetpointShiftComfort)
		roomTemperatureSetpointShiftComfort, _roomTemperatureSetpointShiftComfortErr := readBuffer.ReadFloat32("roomTemperatureSetpointShiftComfort", 16)
		if _roomTemperatureSetpointShiftComfortErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointShiftComfortErr, "Error parsing 'roomTemperatureSetpointShiftComfort' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointShiftComfort)

		// Simple Field (roomTemperatureSetpointShiftStandby)
		roomTemperatureSetpointShiftStandby, _roomTemperatureSetpointShiftStandbyErr := readBuffer.ReadFloat32("roomTemperatureSetpointShiftStandby", 16)
		if _roomTemperatureSetpointShiftStandbyErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointShiftStandbyErr, "Error parsing 'roomTemperatureSetpointShiftStandby' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointShiftStandby)

		// Simple Field (roomTemperatureSetpointShiftEconomy)
		roomTemperatureSetpointShiftEconomy, _roomTemperatureSetpointShiftEconomyErr := readBuffer.ReadFloat32("roomTemperatureSetpointShiftEconomy", 16)
		if _roomTemperatureSetpointShiftEconomyErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointShiftEconomyErr, "Error parsing 'roomTemperatureSetpointShiftEconomy' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointShiftEconomy)

		// Simple Field (roomTemperatureSetpointShiftBuildingProtection)
		roomTemperatureSetpointShiftBuildingProtection, _roomTemperatureSetpointShiftBuildingProtectionErr := readBuffer.ReadFloat32("roomTemperatureSetpointShiftBuildingProtection", 16)
		if _roomTemperatureSetpointShiftBuildingProtectionErr != nil {
			return nil, errors.Wrap(_roomTemperatureSetpointShiftBuildingProtectionErr, "Error parsing 'roomTemperatureSetpointShiftBuildingProtection' field")
		}
		_map["Struct"] = values.NewPlcREAL(roomTemperatureSetpointShiftBuildingProtection)
		readBuffer.CloseContext("KnxDatapoint")
		return values.NewPlcStruct(_map), nil
	}
	// TODO: add more info which type it is actually
	return nil, errors.New("unsupported type")
}

func KnxDatapointSerialize(writeBuffer utils.WriteBuffer, value api.PlcValue, datapointType KnxDatapointType) error {
	m := struct {
		DatapointType KnxDatapointType
	}{
		DatapointType: datapointType,
	}
	_ = m
	writeBuffer.PushContext("KnxDatapoint")
	switch {
	case datapointType == KnxDatapointType_BOOL: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_BYTE: // BYTE
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_WORD: // WORD
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint16("value", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DWORD: // DWORD
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint32("value", 32, value.GetUint32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_LWORD: // LWORD
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint64("value", 64, value.GetUint64()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_USINT: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_SINT: // SINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt8("value", 8, value.GetInt8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_UINT: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint16("value", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_INT: // INT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt16("value", 16, value.GetInt16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_UDINT: // UDINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint32("value", 32, value.GetUint32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DINT: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt32("value", 32, value.GetInt32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_ULINT: // ULINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint64("value", 64, value.GetUint64()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_LINT: // LINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt64("value", 64, value.GetInt64()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_REAL: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_LREAL: // LREAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat64("value", 64, value.GetFloat64()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_CHAR: // CHAR
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteString("value", uint32(8), "UTF-8", value.GetString()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_WCHAR: // WCHAR
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteString("value", uint32(16), "UTF-16", value.GetString()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_TIME: // TIME
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint32("value", 32, value.GetUint32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_LTIME: // LTIME
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint64("value", 64, value.GetUint64()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DATE: // DATE
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint16("value", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_TIME_OF_DAY: // TIME_OF_DAY
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint32("value", 32, value.GetUint32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_TOD: // TIME_OF_DAY
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint32("value", 32, value.GetUint32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DATE_AND_TIME: // DATE_AND_TIME
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (year)
		if _err := writeBuffer.WriteUint16("year", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'year' field")
		}

		// Simple Field (month)
		if _err := writeBuffer.WriteUint8("month", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'month' field")
		}

		// Simple Field (day)
		if _err := writeBuffer.WriteUint8("day", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'day' field")
		}

		// Simple Field (dayOfWeek)
		if _err := writeBuffer.WriteUint8("dayOfWeek", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dayOfWeek' field")
		}

		// Simple Field (hour)
		if _err := writeBuffer.WriteUint8("hour", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hour' field")
		}

		// Simple Field (minutes)
		if _err := writeBuffer.WriteUint8("minutes", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'minutes' field")
		}

		// Simple Field (seconds)
		if _err := writeBuffer.WriteUint8("seconds", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'seconds' field")
		}

		// Simple Field (nanos)
		if _err := writeBuffer.WriteUint32("nanos", 32, value.GetUint32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'nanos' field")
		}
	case datapointType == KnxDatapointType_DT: // DATE_AND_TIME
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (year)
		if _err := writeBuffer.WriteUint16("year", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'year' field")
		}

		// Simple Field (month)
		if _err := writeBuffer.WriteUint8("month", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'month' field")
		}

		// Simple Field (day)
		if _err := writeBuffer.WriteUint8("day", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'day' field")
		}

		// Simple Field (dayOfWeek)
		if _err := writeBuffer.WriteUint8("dayOfWeek", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dayOfWeek' field")
		}

		// Simple Field (hour)
		if _err := writeBuffer.WriteUint8("hour", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hour' field")
		}

		// Simple Field (minutes)
		if _err := writeBuffer.WriteUint8("minutes", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'minutes' field")
		}

		// Simple Field (seconds)
		if _err := writeBuffer.WriteUint8("seconds", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'seconds' field")
		}

		// Simple Field (nanos)
		if _err := writeBuffer.WriteUint32("nanos", 32, value.GetUint32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'nanos' field")
		}
	case datapointType == KnxDatapointType_DPT_Switch: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Bool: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Enable: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Ramp: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Alarm: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_BinaryValue: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Step: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_UpDown: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_OpenClose: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Start: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_State: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Invert: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DimSendStyle: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_InputSource: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Reset: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Ack: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Trigger: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Occupancy: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Window_Door: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LogicalFunction: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Scene_AB: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ShutterBlinds_Mode: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DayNight: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Heat_Cool: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Switch_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (on)
		if _err := writeBuffer.WriteBit("on", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'on' field")
		}
	case datapointType == KnxDatapointType_DPT_Bool_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (valueTrue)
		if _err := writeBuffer.WriteBit("valueTrue", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'valueTrue' field")
		}
	case datapointType == KnxDatapointType_DPT_Enable_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (enable)
		if _err := writeBuffer.WriteBit("enable", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'enable' field")
		}
	case datapointType == KnxDatapointType_DPT_Ramp_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (ramp)
		if _err := writeBuffer.WriteBit("ramp", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ramp' field")
		}
	case datapointType == KnxDatapointType_DPT_Alarm_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (alarm)
		if _err := writeBuffer.WriteBit("alarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'alarm' field")
		}
	case datapointType == KnxDatapointType_DPT_BinaryValue_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (high)
		if _err := writeBuffer.WriteBit("high", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'high' field")
		}
	case datapointType == KnxDatapointType_DPT_Step_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (increase)
		if _err := writeBuffer.WriteBit("increase", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'increase' field")
		}
	case datapointType == KnxDatapointType_DPT_Direction1_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (down)
		if _err := writeBuffer.WriteBit("down", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'down' field")
		}
	case datapointType == KnxDatapointType_DPT_Direction2_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (close)
		if _err := writeBuffer.WriteBit("close", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'close' field")
		}
	case datapointType == KnxDatapointType_DPT_Start_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (start)
		if _err := writeBuffer.WriteBit("start", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'start' field")
		}
	case datapointType == KnxDatapointType_DPT_State_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (active)
		if _err := writeBuffer.WriteBit("active", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'active' field")
		}
	case datapointType == KnxDatapointType_DPT_Invert_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (control)
		if _err := writeBuffer.WriteBit("control", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'control' field")
		}

		// Simple Field (inverted)
		if _err := writeBuffer.WriteBit("inverted", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'inverted' field")
		}
	case datapointType == KnxDatapointType_DPT_Control_Dimming: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (increase)
		if _err := writeBuffer.WriteBit("increase", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'increase' field")
		}

		// Simple Field (stepcode)
		if _err := writeBuffer.WriteUint8("stepcode", 3, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepcode' field")
		}
	case datapointType == KnxDatapointType_DPT_Control_Blinds: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (down)
		if _err := writeBuffer.WriteBit("down", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'down' field")
		}

		// Simple Field (stepcode)
		if _err := writeBuffer.WriteUint8("stepcode", 3, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepcode' field")
		}
	case datapointType == KnxDatapointType_DPT_Char_ASCII: // STRING
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteString("value", uint32(8), "ASCII", value.GetString()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Char_8859_1: // STRING
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteString("value", uint32(8), "ISO-8859-1", value.GetString()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Scaling: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Angle: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Percent_U8: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DecimalFactor: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Tariff: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_1_Ucount: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_FanStage: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Percent_V8: // SINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt8("value", 8, value.GetInt8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_1_Count: // SINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt8("value", 8, value.GetInt8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Status_Mode3: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (statusA)
		if _err := writeBuffer.WriteBit("statusA", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusA' field")
		}

		// Simple Field (statusB)
		if _err := writeBuffer.WriteBit("statusB", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusB' field")
		}

		// Simple Field (statusC)
		if _err := writeBuffer.WriteBit("statusC", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusC' field")
		}

		// Simple Field (statusD)
		if _err := writeBuffer.WriteBit("statusD", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusD' field")
		}

		// Simple Field (statusE)
		if _err := writeBuffer.WriteBit("statusE", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusE' field")
		}

		// Simple Field (mode)
		if _err := writeBuffer.WriteUint8("mode", 3, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'mode' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_2_Ucount: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint16("value", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_TimePeriodMsec: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint16("value", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_TimePeriod10Msec: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint16("value", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_TimePeriod100Msec: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint16("value", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_TimePeriodSec: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint16("value", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_TimePeriodMin: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint16("value", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_TimePeriodHrs: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint16("value", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_PropDataType: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint16("value", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Length_mm: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint16("value", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_UElCurrentmA: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint16("value", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Brightness: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint16("value", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Absolute_Colour_Temperature: // UINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint16("value", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_2_Count: // INT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt16("value", 16, value.GetInt16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaTimeMsec: // INT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt16("value", 16, value.GetInt16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaTime10Msec: // INT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt16("value", 16, value.GetInt16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaTime100Msec: // INT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt16("value", 16, value.GetInt16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaTimeSec: // INT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt16("value", 16, value.GetInt16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaTimeMin: // INT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt16("value", 16, value.GetInt16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaTimeHrs: // INT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt16("value", 16, value.GetInt16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Percent_V16: // INT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt16("value", 16, value.GetInt16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Rotation_Angle: // INT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt16("value", 16, value.GetInt16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Length_m: // INT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt16("value", 16, value.GetInt16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Temp: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Tempd: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Tempa: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Lux: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Wsp: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Pres: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Humidity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_AirQuality: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_AirFlow: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Time1: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Time2: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Volt: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Curr: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_PowerDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_KelvinPerPercent: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Power: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Volume_Flow: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Rain_Amount: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Temp_F: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Wsp_kmh: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Absolute_Humidity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Concentration_ygm3: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_TimeOfDay: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (day)
		if _err := writeBuffer.WriteUint8("day", 3, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'day' field")
		}

		// Simple Field (hour)
		if _err := writeBuffer.WriteUint8("hour", 5, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hour' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 2, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (minutes)
		if _err := writeBuffer.WriteUint8("minutes", 6, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'minutes' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 2, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (seconds)
		if _err := writeBuffer.WriteUint8("seconds", 6, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'seconds' field")
		}
	case datapointType == KnxDatapointType_DPT_Date: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 3, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (dayOfMonth)
		if _err := writeBuffer.WriteUint8("dayOfMonth", 5, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dayOfMonth' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (month)
		if _err := writeBuffer.WriteUint8("month", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'month' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 1, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (year)
		if _err := writeBuffer.WriteUint8("year", 7, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'year' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_4_Ucount: // UDINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint32("value", 32, value.GetUint32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LongTimePeriod_Sec: // UDINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint32("value", 32, value.GetUint32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LongTimePeriod_Min: // UDINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint32("value", 32, value.GetUint32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LongTimePeriod_Hrs: // UDINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint32("value", 32, value.GetUint32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_VolumeLiquid_Litre: // UDINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint32("value", 32, value.GetUint32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Volume_m_3: // UDINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint32("value", 32, value.GetUint32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_4_Count: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt32("value", 32, value.GetInt32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_FlowRate_m3h: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt32("value", 32, value.GetInt32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ActiveEnergy: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt32("value", 32, value.GetInt32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ApparantEnergy: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt32("value", 32, value.GetInt32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ReactiveEnergy: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt32("value", 32, value.GetInt32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ActiveEnergy_kWh: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt32("value", 32, value.GetInt32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ApparantEnergy_kVAh: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt32("value", 32, value.GetInt32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ReactiveEnergy_kVARh: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt32("value", 32, value.GetInt32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ActiveEnergy_MWh: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt32("value", 32, value.GetInt32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LongDeltaTimeSec: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt32("value", 32, value.GetInt32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaVolumeLiquid_Litre: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt32("value", 32, value.GetInt32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DeltaVolume_m_3: // DINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt32("value", 32, value.GetInt32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Acceleration: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Acceleration_Angular: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Activation_Energy: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Activity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Mol: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Amplitude: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_AngleRad: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_AngleDeg: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Angular_Momentum: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Angular_Velocity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Area: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Capacitance: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Charge_DensitySurface: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Charge_DensityVolume: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Compressibility: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Conductance: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electrical_Conductivity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Density: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_Charge: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_Current: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_CurrentDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_DipoleMoment: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_Displacement: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_FieldStrength: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_FluxDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_Polarization: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_Potential: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electric_PotentialDifference: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_ElectromagneticMoment: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Electromotive_Force: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Energy: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Force: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Frequency: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Angular_Frequency: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Heat_Capacity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Heat_FlowRate: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Heat_Quantity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Impedance: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Length: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Light_Quantity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Luminance: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Luminous_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Luminous_Intensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_FieldStrength: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_FluxDensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_Moment: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Magnetic_Polarization: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Magnetization: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_MagnetomotiveForce: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Mass: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_MassFlux: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Momentum: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Phase_AngleRad: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Phase_AngleDeg: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Power: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Power_Factor: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Pressure: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Reactance: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Resistance: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Resistivity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_SelfInductance: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_SolidAngle: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Sound_Intensity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Speed: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Stress: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Surface_Tension: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Common_Temperature: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Absolute_Temperature: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_TemperatureDifference: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Thermal_Capacity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Thermal_Conductivity: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_ThermoelectricPower: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Time: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Torque: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Volume: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Volume_Flux: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Weight: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Value_Work: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Volume_Flux_Meter: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Volume_Flux_ls: // REAL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteFloat32("value", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Access_Data: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (hurz)
		if _err := writeBuffer.WriteUint8("hurz", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hurz' field")
		}

		// Simple Field (value1)
		if _err := writeBuffer.WriteUint8("value1", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value1' field")
		}

		// Simple Field (value2)
		if _err := writeBuffer.WriteUint8("value2", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value2' field")
		}

		// Simple Field (value3)
		if _err := writeBuffer.WriteUint8("value3", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value3' field")
		}

		// Simple Field (value4)
		if _err := writeBuffer.WriteUint8("value4", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value4' field")
		}

		// Simple Field (value5)
		if _err := writeBuffer.WriteUint8("value5", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value5' field")
		}

		// Simple Field (detectionError)
		if _err := writeBuffer.WriteBit("detectionError", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'detectionError' field")
		}

		// Simple Field (permission)
		if _err := writeBuffer.WriteBit("permission", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'permission' field")
		}

		// Simple Field (readDirection)
		if _err := writeBuffer.WriteBit("readDirection", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'readDirection' field")
		}

		// Simple Field (encryptionOfAccessInformation)
		if _err := writeBuffer.WriteBit("encryptionOfAccessInformation", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'encryptionOfAccessInformation' field")
		}

		// Simple Field (indexOfAccessIdentificationCode)
		if _err := writeBuffer.WriteUint8("indexOfAccessIdentificationCode", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'indexOfAccessIdentificationCode' field")
		}
	case datapointType == KnxDatapointType_DPT_String_ASCII: // STRING
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteString("value", uint32(112), "ASCII", value.GetString()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_String_8859_1: // STRING
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteString("value", uint32(112), "ISO-8859-1", value.GetString()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SceneNumber: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 2, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 6, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SceneControl: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (learnTheSceneCorrespondingToTheFieldSceneNumber)
		if _err := writeBuffer.WriteBit("learnTheSceneCorrespondingToTheFieldSceneNumber", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'learnTheSceneCorrespondingToTheFieldSceneNumber' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 1, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (sceneNumber)
		if _err := writeBuffer.WriteUint8("sceneNumber", 6, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'sceneNumber' field")
		}
	case datapointType == KnxDatapointType_DPT_DateTime: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (year)
		if _err := writeBuffer.WriteUint8("year", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'year' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (month)
		if _err := writeBuffer.WriteUint8("month", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'month' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 3, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (dayofmonth)
		if _err := writeBuffer.WriteUint8("dayofmonth", 5, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dayofmonth' field")
		}

		// Simple Field (dayofweek)
		if _err := writeBuffer.WriteUint8("dayofweek", 3, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dayofweek' field")
		}

		// Simple Field (hourofday)
		if _err := writeBuffer.WriteUint8("hourofday", 5, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hourofday' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 2, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (minutes)
		if _err := writeBuffer.WriteUint8("minutes", 6, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'minutes' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 2, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (seconds)
		if _err := writeBuffer.WriteUint8("seconds", 6, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'seconds' field")
		}

		// Simple Field (fault)
		if _err := writeBuffer.WriteBit("fault", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fault' field")
		}

		// Simple Field (workingDay)
		if _err := writeBuffer.WriteBit("workingDay", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'workingDay' field")
		}

		// Simple Field (noWd)
		if _err := writeBuffer.WriteBit("noWd", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'noWd' field")
		}

		// Simple Field (noYear)
		if _err := writeBuffer.WriteBit("noYear", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'noYear' field")
		}

		// Simple Field (noDate)
		if _err := writeBuffer.WriteBit("noDate", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'noDate' field")
		}

		// Simple Field (noDayOfWeek)
		if _err := writeBuffer.WriteBit("noDayOfWeek", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'noDayOfWeek' field")
		}

		// Simple Field (noTime)
		if _err := writeBuffer.WriteBit("noTime", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'noTime' field")
		}

		// Simple Field (standardSummerTime)
		if _err := writeBuffer.WriteBit("standardSummerTime", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'standardSummerTime' field")
		}

		// Simple Field (qualityOfClock)
		if _err := writeBuffer.WriteBit("qualityOfClock", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'qualityOfClock' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}
	case datapointType == KnxDatapointType_DPT_SCLOMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_BuildingMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_OccMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Priority: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LightApplicationMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ApplicationArea: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_AlarmClassType: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_PSUMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ErrorClass_System: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ErrorClass_HVAC: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Time_Delay: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Beaufort_Wind_Force_Scale: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SensorSelect: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ActuatorConnectType: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Cloud_Cover: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_PowerReturnMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_FuelType: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_BurnerType: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_HVACMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DHWMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LoadPriority: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_HVACContrMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_HVACEmergMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ChangeoverMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ValveMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DamperMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_HeaterMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_FanMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_MasterSlaveMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusRoomSetp: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Metering_DeviceType: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_HumDehumMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_EnableHCStage: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ADAType: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_BackupMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_StartSynchronization: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Behaviour_Lock_Unlock: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Behaviour_Bus_Power_Up_Down: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DALI_Fade_Time: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_BlinkingMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LightControlMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SwitchPBModel: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_PBAction: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DimmPBModel: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SwitchOnMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LoadTypeSet: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_LoadTypeDetected: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Converter_Test_Control: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SABExcept_Behaviour: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SABBehaviour_Lock_Unlock: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_SSSBMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_BlindsControlMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_CommMode: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_AddInfoTypes: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_RF_ModeSelect: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_RF_FilterSelect: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusGen: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 3, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (alarmStatusOfCorrespondingDatapointIsNotAcknowledged)
		if _err := writeBuffer.WriteBit("alarmStatusOfCorrespondingDatapointIsNotAcknowledged", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'alarmStatusOfCorrespondingDatapointIsNotAcknowledged' field")
		}

		// Simple Field (correspondingDatapointIsInAlarm)
		if _err := writeBuffer.WriteBit("correspondingDatapointIsInAlarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'correspondingDatapointIsInAlarm' field")
		}

		// Simple Field (correspondingDatapointMainValueIsOverridden)
		if _err := writeBuffer.WriteBit("correspondingDatapointMainValueIsOverridden", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'correspondingDatapointMainValueIsOverridden' field")
		}

		// Simple Field (correspondingDatapointMainValueIsCorruptedDueToFailure)
		if _err := writeBuffer.WriteBit("correspondingDatapointMainValueIsCorruptedDueToFailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'correspondingDatapointMainValueIsCorruptedDueToFailure' field")
		}

		// Simple Field (correspondingDatapointValueIsOutOfService)
		if _err := writeBuffer.WriteBit("correspondingDatapointValueIsOutOfService", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'correspondingDatapointValueIsOutOfService' field")
		}
	case datapointType == KnxDatapointType_DPT_Device_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 5, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (verifyModeIsOn)
		if _err := writeBuffer.WriteBit("verifyModeIsOn", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'verifyModeIsOn' field")
		}

		// Simple Field (aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived)
		if _err := writeBuffer.WriteBit("aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'aDatagramWithTheOwnIndividualAddressAsSourceAddressHasBeenReceived' field")
		}

		// Simple Field (theUserApplicationIsStopped)
		if _err := writeBuffer.WriteBit("theUserApplicationIsStopped", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'theUserApplicationIsStopped' field")
		}
	case datapointType == KnxDatapointType_DPT_ForceSign: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (roomhmax)
		if _err := writeBuffer.WriteBit("roomhmax", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomhmax' field")
		}

		// Simple Field (roomhconf)
		if _err := writeBuffer.WriteBit("roomhconf", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomhconf' field")
		}

		// Simple Field (dhwlegio)
		if _err := writeBuffer.WriteBit("dhwlegio", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dhwlegio' field")
		}

		// Simple Field (dhwnorm)
		if _err := writeBuffer.WriteBit("dhwnorm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dhwnorm' field")
		}

		// Simple Field (overrun)
		if _err := writeBuffer.WriteBit("overrun", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'overrun' field")
		}

		// Simple Field (oversupply)
		if _err := writeBuffer.WriteBit("oversupply", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'oversupply' field")
		}

		// Simple Field (protection)
		if _err := writeBuffer.WriteBit("protection", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'protection' field")
		}

		// Simple Field (forcerequest)
		if _err := writeBuffer.WriteBit("forcerequest", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'forcerequest' field")
		}
	case datapointType == KnxDatapointType_DPT_ForceSignCool: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusRHC: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (summermode)
		if _err := writeBuffer.WriteBit("summermode", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'summermode' field")
		}

		// Simple Field (statusstopoptim)
		if _err := writeBuffer.WriteBit("statusstopoptim", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusstopoptim' field")
		}

		// Simple Field (statusstartoptim)
		if _err := writeBuffer.WriteBit("statusstartoptim", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusstartoptim' field")
		}

		// Simple Field (statusmorningboost)
		if _err := writeBuffer.WriteBit("statusmorningboost", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusmorningboost' field")
		}

		// Simple Field (tempreturnlimit)
		if _err := writeBuffer.WriteBit("tempreturnlimit", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempreturnlimit' field")
		}

		// Simple Field (tempflowlimit)
		if _err := writeBuffer.WriteBit("tempflowlimit", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempflowlimit' field")
		}

		// Simple Field (satuseco)
		if _err := writeBuffer.WriteBit("satuseco", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'satuseco' field")
		}

		// Simple Field (fault)
		if _err := writeBuffer.WriteBit("fault", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fault' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusSDHWC: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 5, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (solarloadsufficient)
		if _err := writeBuffer.WriteBit("solarloadsufficient", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'solarloadsufficient' field")
		}

		// Simple Field (sdhwloadactive)
		if _err := writeBuffer.WriteBit("sdhwloadactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'sdhwloadactive' field")
		}

		// Simple Field (fault)
		if _err := writeBuffer.WriteBit("fault", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fault' field")
		}
	case datapointType == KnxDatapointType_DPT_FuelTypeSet: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 5, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (solidstate)
		if _err := writeBuffer.WriteBit("solidstate", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'solidstate' field")
		}

		// Simple Field (gas)
		if _err := writeBuffer.WriteBit("gas", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'gas' field")
		}

		// Simple Field (oil)
		if _err := writeBuffer.WriteBit("oil", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'oil' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusRCC: // BOOL
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteBit("value", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusAHU: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cool)
		if _err := writeBuffer.WriteBit("cool", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cool' field")
		}

		// Simple Field (heat)
		if _err := writeBuffer.WriteBit("heat", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'heat' field")
		}

		// Simple Field (fanactive)
		if _err := writeBuffer.WriteBit("fanactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fanactive' field")
		}

		// Simple Field (fault)
		if _err := writeBuffer.WriteBit("fault", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fault' field")
		}
	case datapointType == KnxDatapointType_DPT_CombinedStatus_RTSM: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 3, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (statusOfHvacModeUser)
		if _err := writeBuffer.WriteBit("statusOfHvacModeUser", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusOfHvacModeUser' field")
		}

		// Simple Field (statusOfComfortProlongationUser)
		if _err := writeBuffer.WriteBit("statusOfComfortProlongationUser", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusOfComfortProlongationUser' field")
		}

		// Simple Field (effectiveValueOfTheComfortPushButton)
		if _err := writeBuffer.WriteBit("effectiveValueOfTheComfortPushButton", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'effectiveValueOfTheComfortPushButton' field")
		}

		// Simple Field (effectiveValueOfThePresenceStatus)
		if _err := writeBuffer.WriteBit("effectiveValueOfThePresenceStatus", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'effectiveValueOfThePresenceStatus' field")
		}

		// Simple Field (effectiveValueOfTheWindowStatus)
		if _err := writeBuffer.WriteBit("effectiveValueOfTheWindowStatus", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'effectiveValueOfTheWindowStatus' field")
		}
	case datapointType == KnxDatapointType_DPT_LightActuatorErrorInfo: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 1, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (overheat)
		if _err := writeBuffer.WriteBit("overheat", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'overheat' field")
		}

		// Simple Field (lampfailure)
		if _err := writeBuffer.WriteBit("lampfailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'lampfailure' field")
		}

		// Simple Field (defectiveload)
		if _err := writeBuffer.WriteBit("defectiveload", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'defectiveload' field")
		}

		// Simple Field (underload)
		if _err := writeBuffer.WriteBit("underload", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'underload' field")
		}

		// Simple Field (overcurrent)
		if _err := writeBuffer.WriteBit("overcurrent", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'overcurrent' field")
		}

		// Simple Field (undervoltage)
		if _err := writeBuffer.WriteBit("undervoltage", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'undervoltage' field")
		}

		// Simple Field (loaddetectionerror)
		if _err := writeBuffer.WriteBit("loaddetectionerror", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'loaddetectionerror' field")
		}
	case datapointType == KnxDatapointType_DPT_RF_ModeInfo: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 5, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (bibatSlave)
		if _err := writeBuffer.WriteBit("bibatSlave", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'bibatSlave' field")
		}

		// Simple Field (bibatMaster)
		if _err := writeBuffer.WriteBit("bibatMaster", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'bibatMaster' field")
		}

		// Simple Field (asynchronous)
		if _err := writeBuffer.WriteBit("asynchronous", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'asynchronous' field")
		}
	case datapointType == KnxDatapointType_DPT_RF_FilterInfo: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 5, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (doa)
		if _err := writeBuffer.WriteBit("doa", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'doa' field")
		}

		// Simple Field (knxSn)
		if _err := writeBuffer.WriteBit("knxSn", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'knxSn' field")
		}

		// Simple Field (doaAndKnxSn)
		if _err := writeBuffer.WriteBit("doaAndKnxSn", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'doaAndKnxSn' field")
		}
	case datapointType == KnxDatapointType_DPT_Channel_Activation_8: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (activationStateOfChannel1)
		if _err := writeBuffer.WriteBit("activationStateOfChannel1", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel1' field")
		}

		// Simple Field (activationStateOfChannel2)
		if _err := writeBuffer.WriteBit("activationStateOfChannel2", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel2' field")
		}

		// Simple Field (activationStateOfChannel3)
		if _err := writeBuffer.WriteBit("activationStateOfChannel3", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel3' field")
		}

		// Simple Field (activationStateOfChannel4)
		if _err := writeBuffer.WriteBit("activationStateOfChannel4", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel4' field")
		}

		// Simple Field (activationStateOfChannel5)
		if _err := writeBuffer.WriteBit("activationStateOfChannel5", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel5' field")
		}

		// Simple Field (activationStateOfChannel6)
		if _err := writeBuffer.WriteBit("activationStateOfChannel6", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel6' field")
		}

		// Simple Field (activationStateOfChannel7)
		if _err := writeBuffer.WriteBit("activationStateOfChannel7", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel7' field")
		}

		// Simple Field (activationStateOfChannel8)
		if _err := writeBuffer.WriteBit("activationStateOfChannel8", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel8' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusDHWC: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (tempoptimshiftactive)
		if _err := writeBuffer.WriteBit("tempoptimshiftactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempoptimshiftactive' field")
		}

		// Simple Field (solarenergysupport)
		if _err := writeBuffer.WriteBit("solarenergysupport", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'solarenergysupport' field")
		}

		// Simple Field (solarenergyonly)
		if _err := writeBuffer.WriteBit("solarenergyonly", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'solarenergyonly' field")
		}

		// Simple Field (otherenergysourceactive)
		if _err := writeBuffer.WriteBit("otherenergysourceactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'otherenergysourceactive' field")
		}

		// Simple Field (dhwpushactive)
		if _err := writeBuffer.WriteBit("dhwpushactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dhwpushactive' field")
		}

		// Simple Field (legioprotactive)
		if _err := writeBuffer.WriteBit("legioprotactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'legioprotactive' field")
		}

		// Simple Field (dhwloadactive)
		if _err := writeBuffer.WriteBit("dhwloadactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dhwloadactive' field")
		}

		// Simple Field (fault)
		if _err := writeBuffer.WriteBit("fault", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fault' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusRHCC: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 1, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (overheatalarm)
		if _err := writeBuffer.WriteBit("overheatalarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'overheatalarm' field")
		}

		// Simple Field (frostalarm)
		if _err := writeBuffer.WriteBit("frostalarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'frostalarm' field")
		}

		// Simple Field (dewpointstatus)
		if _err := writeBuffer.WriteBit("dewpointstatus", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dewpointstatus' field")
		}

		// Simple Field (coolingdisabled)
		if _err := writeBuffer.WriteBit("coolingdisabled", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'coolingdisabled' field")
		}

		// Simple Field (statusprecool)
		if _err := writeBuffer.WriteBit("statusprecool", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusprecool' field")
		}

		// Simple Field (statusecoc)
		if _err := writeBuffer.WriteBit("statusecoc", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusecoc' field")
		}

		// Simple Field (heatcoolmode)
		if _err := writeBuffer.WriteBit("heatcoolmode", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'heatcoolmode' field")
		}

		// Simple Field (heatingdiabled)
		if _err := writeBuffer.WriteBit("heatingdiabled", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'heatingdiabled' field")
		}

		// Simple Field (statusstopoptim)
		if _err := writeBuffer.WriteBit("statusstopoptim", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusstopoptim' field")
		}

		// Simple Field (statusstartoptim)
		if _err := writeBuffer.WriteBit("statusstartoptim", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusstartoptim' field")
		}

		// Simple Field (statusmorningboosth)
		if _err := writeBuffer.WriteBit("statusmorningboosth", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusmorningboosth' field")
		}

		// Simple Field (tempflowreturnlimit)
		if _err := writeBuffer.WriteBit("tempflowreturnlimit", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempflowreturnlimit' field")
		}

		// Simple Field (tempflowlimit)
		if _err := writeBuffer.WriteBit("tempflowlimit", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempflowlimit' field")
		}

		// Simple Field (statusecoh)
		if _err := writeBuffer.WriteBit("statusecoh", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'statusecoh' field")
		}

		// Simple Field (fault)
		if _err := writeBuffer.WriteBit("fault", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fault' field")
		}
	case datapointType == KnxDatapointType_DPT_CombinedStatus_HVA: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (calibrationMode)
		if _err := writeBuffer.WriteBit("calibrationMode", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'calibrationMode' field")
		}

		// Simple Field (lockedPosition)
		if _err := writeBuffer.WriteBit("lockedPosition", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'lockedPosition' field")
		}

		// Simple Field (forcedPosition)
		if _err := writeBuffer.WriteBit("forcedPosition", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'forcedPosition' field")
		}

		// Simple Field (manuaOperationOverridden)
		if _err := writeBuffer.WriteBit("manuaOperationOverridden", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'manuaOperationOverridden' field")
		}

		// Simple Field (serviceMode)
		if _err := writeBuffer.WriteBit("serviceMode", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'serviceMode' field")
		}

		// Simple Field (valveKick)
		if _err := writeBuffer.WriteBit("valveKick", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'valveKick' field")
		}

		// Simple Field (overload)
		if _err := writeBuffer.WriteBit("overload", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'overload' field")
		}

		// Simple Field (shortCircuit)
		if _err := writeBuffer.WriteBit("shortCircuit", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'shortCircuit' field")
		}

		// Simple Field (currentValvePosition)
		if _err := writeBuffer.WriteBit("currentValvePosition", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'currentValvePosition' field")
		}
	case datapointType == KnxDatapointType_DPT_CombinedStatus_RTC: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 7, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (coolingModeEnabled)
		if _err := writeBuffer.WriteBit("coolingModeEnabled", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'coolingModeEnabled' field")
		}

		// Simple Field (heatingModeEnabled)
		if _err := writeBuffer.WriteBit("heatingModeEnabled", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'heatingModeEnabled' field")
		}

		// Simple Field (additionalHeatingCoolingStage2Stage)
		if _err := writeBuffer.WriteBit("additionalHeatingCoolingStage2Stage", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'additionalHeatingCoolingStage2Stage' field")
		}

		// Simple Field (controllerInactive)
		if _err := writeBuffer.WriteBit("controllerInactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'controllerInactive' field")
		}

		// Simple Field (overheatAlarm)
		if _err := writeBuffer.WriteBit("overheatAlarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'overheatAlarm' field")
		}

		// Simple Field (frostAlarm)
		if _err := writeBuffer.WriteBit("frostAlarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'frostAlarm' field")
		}

		// Simple Field (dewPointStatus)
		if _err := writeBuffer.WriteBit("dewPointStatus", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dewPointStatus' field")
		}

		// Simple Field (activeMode)
		if _err := writeBuffer.WriteBit("activeMode", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activeMode' field")
		}

		// Simple Field (generalFailureInformation)
		if _err := writeBuffer.WriteBit("generalFailureInformation", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'generalFailureInformation' field")
		}
	case datapointType == KnxDatapointType_DPT_Media: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint16("reserved", 10, uint16(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (knxIp)
		if _err := writeBuffer.WriteBit("knxIp", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'knxIp' field")
		}

		// Simple Field (rf)
		if _err := writeBuffer.WriteBit("rf", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'rf' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 1, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (pl110)
		if _err := writeBuffer.WriteBit("pl110", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'pl110' field")
		}

		// Simple Field (tp1)
		if _err := writeBuffer.WriteBit("tp1", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tp1' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 1, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}
	case datapointType == KnxDatapointType_DPT_Channel_Activation_16: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (activationStateOfChannel1)
		if _err := writeBuffer.WriteBit("activationStateOfChannel1", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel1' field")
		}

		// Simple Field (activationStateOfChannel2)
		if _err := writeBuffer.WriteBit("activationStateOfChannel2", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel2' field")
		}

		// Simple Field (activationStateOfChannel3)
		if _err := writeBuffer.WriteBit("activationStateOfChannel3", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel3' field")
		}

		// Simple Field (activationStateOfChannel4)
		if _err := writeBuffer.WriteBit("activationStateOfChannel4", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel4' field")
		}

		// Simple Field (activationStateOfChannel5)
		if _err := writeBuffer.WriteBit("activationStateOfChannel5", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel5' field")
		}

		// Simple Field (activationStateOfChannel6)
		if _err := writeBuffer.WriteBit("activationStateOfChannel6", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel6' field")
		}

		// Simple Field (activationStateOfChannel7)
		if _err := writeBuffer.WriteBit("activationStateOfChannel7", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel7' field")
		}

		// Simple Field (activationStateOfChannel8)
		if _err := writeBuffer.WriteBit("activationStateOfChannel8", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel8' field")
		}

		// Simple Field (activationStateOfChannel9)
		if _err := writeBuffer.WriteBit("activationStateOfChannel9", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel9' field")
		}

		// Simple Field (activationStateOfChannel10)
		if _err := writeBuffer.WriteBit("activationStateOfChannel10", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel10' field")
		}

		// Simple Field (activationStateOfChannel11)
		if _err := writeBuffer.WriteBit("activationStateOfChannel11", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel11' field")
		}

		// Simple Field (activationStateOfChannel12)
		if _err := writeBuffer.WriteBit("activationStateOfChannel12", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel12' field")
		}

		// Simple Field (activationStateOfChannel13)
		if _err := writeBuffer.WriteBit("activationStateOfChannel13", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel13' field")
		}

		// Simple Field (activationStateOfChannel14)
		if _err := writeBuffer.WriteBit("activationStateOfChannel14", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel14' field")
		}

		// Simple Field (activationStateOfChannel15)
		if _err := writeBuffer.WriteBit("activationStateOfChannel15", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel15' field")
		}

		// Simple Field (activationStateOfChannel16)
		if _err := writeBuffer.WriteBit("activationStateOfChannel16", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel16' field")
		}
	case datapointType == KnxDatapointType_DPT_OnOffAction: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 2, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Alarm_Reaction: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 2, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_UpDown_Action: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 2, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_HVAC_PB_Action: // USINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteUint8("value", 2, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_DoubleNibble: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (busy)
		if _err := writeBuffer.WriteUint8("busy", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'busy' field")
		}

		// Simple Field (nak)
		if _err := writeBuffer.WriteUint8("nak", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'nak' field")
		}
	case datapointType == KnxDatapointType_DPT_SceneInfo: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 1, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (sceneIsInactive)
		if _err := writeBuffer.WriteBit("sceneIsInactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'sceneIsInactive' field")
		}

		// Simple Field (scenenumber)
		if _err := writeBuffer.WriteUint8("scenenumber", 6, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'scenenumber' field")
		}
	case datapointType == KnxDatapointType_DPT_CombinedInfoOnOff: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (maskBitInfoOnOffOutput16)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput16", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput16' field")
		}

		// Simple Field (maskBitInfoOnOffOutput15)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput15", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput15' field")
		}

		// Simple Field (maskBitInfoOnOffOutput14)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput14", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput14' field")
		}

		// Simple Field (maskBitInfoOnOffOutput13)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput13", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput13' field")
		}

		// Simple Field (maskBitInfoOnOffOutput12)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput12", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput12' field")
		}

		// Simple Field (maskBitInfoOnOffOutput11)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput11", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput11' field")
		}

		// Simple Field (maskBitInfoOnOffOutput10)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput10", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput10' field")
		}

		// Simple Field (maskBitInfoOnOffOutput9)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput9", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput9' field")
		}

		// Simple Field (maskBitInfoOnOffOutput8)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput8", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput8' field")
		}

		// Simple Field (maskBitInfoOnOffOutput7)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput7", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput7' field")
		}

		// Simple Field (maskBitInfoOnOffOutput6)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput6", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput6' field")
		}

		// Simple Field (maskBitInfoOnOffOutput5)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput5", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput5' field")
		}

		// Simple Field (maskBitInfoOnOffOutput4)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput4", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput4' field")
		}

		// Simple Field (maskBitInfoOnOffOutput3)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput3", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput3' field")
		}

		// Simple Field (maskBitInfoOnOffOutput2)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput2", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput2' field")
		}

		// Simple Field (maskBitInfoOnOffOutput1)
		if _err := writeBuffer.WriteBit("maskBitInfoOnOffOutput1", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskBitInfoOnOffOutput1' field")
		}

		// Simple Field (infoOnOffOutput16)
		if _err := writeBuffer.WriteBit("infoOnOffOutput16", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput16' field")
		}

		// Simple Field (infoOnOffOutput15)
		if _err := writeBuffer.WriteBit("infoOnOffOutput15", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput15' field")
		}

		// Simple Field (infoOnOffOutput14)
		if _err := writeBuffer.WriteBit("infoOnOffOutput14", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput14' field")
		}

		// Simple Field (infoOnOffOutput13)
		if _err := writeBuffer.WriteBit("infoOnOffOutput13", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput13' field")
		}

		// Simple Field (infoOnOffOutput12)
		if _err := writeBuffer.WriteBit("infoOnOffOutput12", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput12' field")
		}

		// Simple Field (infoOnOffOutput11)
		if _err := writeBuffer.WriteBit("infoOnOffOutput11", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput11' field")
		}

		// Simple Field (infoOnOffOutput10)
		if _err := writeBuffer.WriteBit("infoOnOffOutput10", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput10' field")
		}

		// Simple Field (infoOnOffOutput9)
		if _err := writeBuffer.WriteBit("infoOnOffOutput9", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput9' field")
		}

		// Simple Field (infoOnOffOutput8)
		if _err := writeBuffer.WriteBit("infoOnOffOutput8", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput8' field")
		}

		// Simple Field (infoOnOffOutput7)
		if _err := writeBuffer.WriteBit("infoOnOffOutput7", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput7' field")
		}

		// Simple Field (infoOnOffOutput6)
		if _err := writeBuffer.WriteBit("infoOnOffOutput6", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput6' field")
		}

		// Simple Field (infoOnOffOutput5)
		if _err := writeBuffer.WriteBit("infoOnOffOutput5", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput5' field")
		}

		// Simple Field (infoOnOffOutput4)
		if _err := writeBuffer.WriteBit("infoOnOffOutput4", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput4' field")
		}

		// Simple Field (infoOnOffOutput3)
		if _err := writeBuffer.WriteBit("infoOnOffOutput3", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput3' field")
		}

		// Simple Field (infoOnOffOutput2)
		if _err := writeBuffer.WriteBit("infoOnOffOutput2", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput2' field")
		}

		// Simple Field (infoOnOffOutput1)
		if _err := writeBuffer.WriteBit("infoOnOffOutput1", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'infoOnOffOutput1' field")
		}
	case datapointType == KnxDatapointType_DPT_ActiveEnergy_V64: // LINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt64("value", 64, value.GetInt64()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ApparantEnergy_V64: // LINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt64("value", 64, value.GetInt64()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_ReactiveEnergy_V64: // LINT
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteInt64("value", 64, value.GetInt64()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Channel_Activation_24: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (activationStateOfChannel1)
		if _err := writeBuffer.WriteBit("activationStateOfChannel1", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel1' field")
		}

		// Simple Field (activationStateOfChannel2)
		if _err := writeBuffer.WriteBit("activationStateOfChannel2", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel2' field")
		}

		// Simple Field (activationStateOfChannel3)
		if _err := writeBuffer.WriteBit("activationStateOfChannel3", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel3' field")
		}

		// Simple Field (activationStateOfChannel4)
		if _err := writeBuffer.WriteBit("activationStateOfChannel4", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel4' field")
		}

		// Simple Field (activationStateOfChannel5)
		if _err := writeBuffer.WriteBit("activationStateOfChannel5", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel5' field")
		}

		// Simple Field (activationStateOfChannel6)
		if _err := writeBuffer.WriteBit("activationStateOfChannel6", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel6' field")
		}

		// Simple Field (activationStateOfChannel7)
		if _err := writeBuffer.WriteBit("activationStateOfChannel7", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel7' field")
		}

		// Simple Field (activationStateOfChannel8)
		if _err := writeBuffer.WriteBit("activationStateOfChannel8", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel8' field")
		}

		// Simple Field (activationStateOfChannel9)
		if _err := writeBuffer.WriteBit("activationStateOfChannel9", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel9' field")
		}

		// Simple Field (activationStateOfChannel10)
		if _err := writeBuffer.WriteBit("activationStateOfChannel10", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel10' field")
		}

		// Simple Field (activationStateOfChannel11)
		if _err := writeBuffer.WriteBit("activationStateOfChannel11", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel11' field")
		}

		// Simple Field (activationStateOfChannel12)
		if _err := writeBuffer.WriteBit("activationStateOfChannel12", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel12' field")
		}

		// Simple Field (activationStateOfChannel13)
		if _err := writeBuffer.WriteBit("activationStateOfChannel13", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel13' field")
		}

		// Simple Field (activationStateOfChannel14)
		if _err := writeBuffer.WriteBit("activationStateOfChannel14", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel14' field")
		}

		// Simple Field (activationStateOfChannel15)
		if _err := writeBuffer.WriteBit("activationStateOfChannel15", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel15' field")
		}

		// Simple Field (activationStateOfChannel16)
		if _err := writeBuffer.WriteBit("activationStateOfChannel16", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel16' field")
		}

		// Simple Field (activationStateOfChannel17)
		if _err := writeBuffer.WriteBit("activationStateOfChannel17", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel17' field")
		}

		// Simple Field (activationStateOfChannel18)
		if _err := writeBuffer.WriteBit("activationStateOfChannel18", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel18' field")
		}

		// Simple Field (activationStateOfChannel19)
		if _err := writeBuffer.WriteBit("activationStateOfChannel19", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel19' field")
		}

		// Simple Field (activationStateOfChannel20)
		if _err := writeBuffer.WriteBit("activationStateOfChannel20", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel20' field")
		}

		// Simple Field (activationStateOfChannel21)
		if _err := writeBuffer.WriteBit("activationStateOfChannel21", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel21' field")
		}

		// Simple Field (activationStateOfChannel22)
		if _err := writeBuffer.WriteBit("activationStateOfChannel22", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel22' field")
		}

		// Simple Field (activationStateOfChannel23)
		if _err := writeBuffer.WriteBit("activationStateOfChannel23", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel23' field")
		}

		// Simple Field (activationStateOfChannel24)
		if _err := writeBuffer.WriteBit("activationStateOfChannel24", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activationStateOfChannel24' field")
		}
	case datapointType == KnxDatapointType_DPT_HVACModeNext: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (delayTimeMin)
		if _err := writeBuffer.WriteUint16("delayTimeMin", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'delayTimeMin' field")
		}

		// Simple Field (hvacMode)
		if _err := writeBuffer.WriteUint8("hvacMode", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hvacMode' field")
		}
	case datapointType == KnxDatapointType_DPT_DHWModeNext: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (delayTimeMin)
		if _err := writeBuffer.WriteUint16("delayTimeMin", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'delayTimeMin' field")
		}

		// Simple Field (dhwMode)
		if _err := writeBuffer.WriteUint8("dhwMode", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dhwMode' field")
		}
	case datapointType == KnxDatapointType_DPT_OccModeNext: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (delayTimeMin)
		if _err := writeBuffer.WriteUint16("delayTimeMin", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'delayTimeMin' field")
		}

		// Simple Field (occupancyMode)
		if _err := writeBuffer.WriteUint8("occupancyMode", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'occupancyMode' field")
		}
	case datapointType == KnxDatapointType_DPT_BuildingModeNext: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (delayTimeMin)
		if _err := writeBuffer.WriteUint16("delayTimeMin", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'delayTimeMin' field")
		}

		// Simple Field (buildingMode)
		if _err := writeBuffer.WriteUint8("buildingMode", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'buildingMode' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusLightingActuator: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (validactualvalue)
		if _err := writeBuffer.WriteBit("validactualvalue", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validactualvalue' field")
		}

		// Simple Field (locked)
		if _err := writeBuffer.WriteBit("locked", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'locked' field")
		}

		// Simple Field (forced)
		if _err := writeBuffer.WriteBit("forced", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'forced' field")
		}

		// Simple Field (nightmodeactive)
		if _err := writeBuffer.WriteBit("nightmodeactive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'nightmodeactive' field")
		}

		// Simple Field (staircaselightingFunction)
		if _err := writeBuffer.WriteBit("staircaselightingFunction", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'staircaselightingFunction' field")
		}

		// Simple Field (dimming)
		if _err := writeBuffer.WriteBit("dimming", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'dimming' field")
		}

		// Simple Field (localoverride)
		if _err := writeBuffer.WriteBit("localoverride", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'localoverride' field")
		}

		// Simple Field (failure)
		if _err := writeBuffer.WriteBit("failure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'failure' field")
		}

		// Simple Field (actualvalue)
		if _err := writeBuffer.WriteUint8("actualvalue", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'actualvalue' field")
		}
	case datapointType == KnxDatapointType_DPT_Version: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (magicNumber)
		if _err := writeBuffer.WriteUint8("magicNumber", 5, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'magicNumber' field")
		}

		// Simple Field (versionNumber)
		if _err := writeBuffer.WriteUint8("versionNumber", 5, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'versionNumber' field")
		}

		// Simple Field (revisionNumber)
		if _err := writeBuffer.WriteUint8("revisionNumber", 6, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'revisionNumber' field")
		}
	case datapointType == KnxDatapointType_DPT_AlarmInfo: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (logNumber)
		if _err := writeBuffer.WriteUint8("logNumber", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'logNumber' field")
		}

		// Simple Field (alarmPriority)
		if _err := writeBuffer.WriteUint8("alarmPriority", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'alarmPriority' field")
		}

		// Simple Field (applicationArea)
		if _err := writeBuffer.WriteUint8("applicationArea", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'applicationArea' field")
		}

		// Simple Field (errorClass)
		if _err := writeBuffer.WriteUint8("errorClass", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'errorClass' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (errorcodeSup)
		if _err := writeBuffer.WriteBit("errorcodeSup", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'errorcodeSup' field")
		}

		// Simple Field (alarmtextSup)
		if _err := writeBuffer.WriteBit("alarmtextSup", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'alarmtextSup' field")
		}

		// Simple Field (timestampSup)
		if _err := writeBuffer.WriteBit("timestampSup", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'timestampSup' field")
		}

		// Simple Field (ackSup)
		if _err := writeBuffer.WriteBit("ackSup", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ackSup' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 5, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (locked)
		if _err := writeBuffer.WriteBit("locked", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'locked' field")
		}

		// Simple Field (alarmunack)
		if _err := writeBuffer.WriteBit("alarmunack", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'alarmunack' field")
		}

		// Simple Field (inalarm)
		if _err := writeBuffer.WriteBit("inalarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'inalarm' field")
		}
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetF16_3: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (tempsetpcomf)
		if _err := writeBuffer.WriteFloat32("tempsetpcomf", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempsetpcomf' field")
		}

		// Simple Field (tempsetpstdby)
		if _err := writeBuffer.WriteFloat32("tempsetpstdby", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempsetpstdby' field")
		}

		// Simple Field (tempsetpeco)
		if _err := writeBuffer.WriteFloat32("tempsetpeco", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempsetpeco' field")
		}
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetShiftF16_3: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (tempsetpshiftcomf)
		if _err := writeBuffer.WriteFloat32("tempsetpshiftcomf", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempsetpshiftcomf' field")
		}

		// Simple Field (tempsetpshiftstdby)
		if _err := writeBuffer.WriteFloat32("tempsetpshiftstdby", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempsetpshiftstdby' field")
		}

		// Simple Field (tempsetpshifteco)
		if _err := writeBuffer.WriteFloat32("tempsetpshifteco", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tempsetpshifteco' field")
		}
	case datapointType == KnxDatapointType_DPT_Scaling_Speed: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (timePeriod)
		if _err := writeBuffer.WriteUint16("timePeriod", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'timePeriod' field")
		}

		// Simple Field (percent)
		if _err := writeBuffer.WriteUint8("percent", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'percent' field")
		}
	case datapointType == KnxDatapointType_DPT_Scaling_Step_Time: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (timePeriod)
		if _err := writeBuffer.WriteUint16("timePeriod", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'timePeriod' field")
		}

		// Simple Field (percent)
		if _err := writeBuffer.WriteUint8("percent", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'percent' field")
		}
	case datapointType == KnxDatapointType_DPT_MeteringValue: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (countval)
		if _err := writeBuffer.WriteInt32("countval", 32, value.GetInt32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'countval' field")
		}

		// Simple Field (valinffield)
		if _err := writeBuffer.WriteUint8("valinffield", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'valinffield' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 3, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (alarmunack)
		if _err := writeBuffer.WriteBit("alarmunack", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'alarmunack' field")
		}

		// Simple Field (inalarm)
		if _err := writeBuffer.WriteBit("inalarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'inalarm' field")
		}

		// Simple Field (overridden)
		if _err := writeBuffer.WriteBit("overridden", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'overridden' field")
		}

		// Simple Field (fault)
		if _err := writeBuffer.WriteBit("fault", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'fault' field")
		}

		// Simple Field (outofservice)
		if _err := writeBuffer.WriteBit("outofservice", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'outofservice' field")
		}
	case datapointType == KnxDatapointType_DPT_MBus_Address: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (manufactid)
		if _err := writeBuffer.WriteUint16("manufactid", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'manufactid' field")
		}

		// Simple Field (identnumber)
		if _err := writeBuffer.WriteUint32("identnumber", 32, value.GetUint32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'identnumber' field")
		}

		// Simple Field (version)
		if _err := writeBuffer.WriteUint8("version", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'version' field")
		}

		// Simple Field (medium)
		if _err := writeBuffer.WriteUint8("medium", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'medium' field")
		}
	case datapointType == KnxDatapointType_DPT_Colour_RGB: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (r)
		if _err := writeBuffer.WriteUint8("r", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'r' field")
		}

		// Simple Field (g)
		if _err := writeBuffer.WriteUint8("g", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'g' field")
		}

		// Simple Field (b)
		if _err := writeBuffer.WriteUint8("b", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'b' field")
		}
	case datapointType == KnxDatapointType_DPT_LanguageCodeAlpha2_ASCII: // STRING
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (value)
		if _err := writeBuffer.WriteString("value", uint32(16), "ASCII", value.GetString()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'value' field")
		}
	case datapointType == KnxDatapointType_DPT_Tariff_ActiveEnergy: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (activeelectricalenergy)
		if _err := writeBuffer.WriteInt32("activeelectricalenergy", 32, value.GetInt32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'activeelectricalenergy' field")
		}

		// Simple Field (tariff)
		if _err := writeBuffer.WriteUint8("tariff", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tariff' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (electricalengergyvalidity)
		if _err := writeBuffer.WriteBit("electricalengergyvalidity", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'electricalengergyvalidity' field")
		}

		// Simple Field (tariffvalidity)
		if _err := writeBuffer.WriteBit("tariffvalidity", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'tariffvalidity' field")
		}
	case datapointType == KnxDatapointType_DPT_Prioritised_Mode_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (deactivationOfPriority)
		if _err := writeBuffer.WriteBit("deactivationOfPriority", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'deactivationOfPriority' field")
		}

		// Simple Field (priorityLevel)
		if _err := writeBuffer.WriteUint8("priorityLevel", 3, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'priorityLevel' field")
		}

		// Simple Field (modeLevel)
		if _err := writeBuffer.WriteUint8("modeLevel", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'modeLevel' field")
		}
	case datapointType == KnxDatapointType_DPT_DALI_Control_Gear_Diagnostic: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 5, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (convertorError)
		if _err := writeBuffer.WriteBit("convertorError", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'convertorError' field")
		}

		// Simple Field (ballastFailure)
		if _err := writeBuffer.WriteBit("ballastFailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ballastFailure' field")
		}

		// Simple Field (lampFailure)
		if _err := writeBuffer.WriteBit("lampFailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'lampFailure' field")
		}

		// Simple Field (readOrResponse)
		if _err := writeBuffer.WriteBit("readOrResponse", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'readOrResponse' field")
		}

		// Simple Field (addressIndicator)
		if _err := writeBuffer.WriteBit("addressIndicator", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'addressIndicator' field")
		}

		// Simple Field (daliDeviceAddressOrDaliGroupAddress)
		if _err := writeBuffer.WriteUint8("daliDeviceAddressOrDaliGroupAddress", 6, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'daliDeviceAddressOrDaliGroupAddress' field")
		}
	case datapointType == KnxDatapointType_DPT_DALI_Diagnostics: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (ballastFailure)
		if _err := writeBuffer.WriteBit("ballastFailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ballastFailure' field")
		}

		// Simple Field (lampFailure)
		if _err := writeBuffer.WriteBit("lampFailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'lampFailure' field")
		}

		// Simple Field (deviceAddress)
		if _err := writeBuffer.WriteUint8("deviceAddress", 6, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'deviceAddress' field")
		}
	case datapointType == KnxDatapointType_DPT_CombinedPosition: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (heightPosition)
		if _err := writeBuffer.WriteUint8("heightPosition", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'heightPosition' field")
		}

		// Simple Field (slatsPosition)
		if _err := writeBuffer.WriteUint8("slatsPosition", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'slatsPosition' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (validityHeightPosition)
		if _err := writeBuffer.WriteBit("validityHeightPosition", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validityHeightPosition' field")
		}

		// Simple Field (validitySlatsPosition)
		if _err := writeBuffer.WriteBit("validitySlatsPosition", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validitySlatsPosition' field")
		}
	case datapointType == KnxDatapointType_DPT_StatusSAB: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (heightPosition)
		if _err := writeBuffer.WriteUint8("heightPosition", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'heightPosition' field")
		}

		// Simple Field (slatsPosition)
		if _err := writeBuffer.WriteUint8("slatsPosition", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'slatsPosition' field")
		}

		// Simple Field (upperEndPosReached)
		if _err := writeBuffer.WriteBit("upperEndPosReached", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'upperEndPosReached' field")
		}

		// Simple Field (lowerEndPosReached)
		if _err := writeBuffer.WriteBit("lowerEndPosReached", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'lowerEndPosReached' field")
		}

		// Simple Field (lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent)
		if _err := writeBuffer.WriteBit("lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'lowerPredefPosReachedTypHeight100PercentSlatsAngle100Percent' field")
		}

		// Simple Field (targetPosDrive)
		if _err := writeBuffer.WriteBit("targetPosDrive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'targetPosDrive' field")
		}

		// Simple Field (restrictionOfTargetHeightPosPosCanNotBeReached)
		if _err := writeBuffer.WriteBit("restrictionOfTargetHeightPosPosCanNotBeReached", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'restrictionOfTargetHeightPosPosCanNotBeReached' field")
		}

		// Simple Field (restrictionOfSlatsHeightPosPosCanNotBeReached)
		if _err := writeBuffer.WriteBit("restrictionOfSlatsHeightPosPosCanNotBeReached", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'restrictionOfSlatsHeightPosPosCanNotBeReached' field")
		}

		// Simple Field (atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm)
		if _err := writeBuffer.WriteBit("atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'atLeastOneOfTheInputsWindRainFrostAlarmIsInAlarm' field")
		}

		// Simple Field (upDownPositionIsForcedByMoveupdownforcedInput)
		if _err := writeBuffer.WriteBit("upDownPositionIsForcedByMoveupdownforcedInput", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'upDownPositionIsForcedByMoveupdownforcedInput' field")
		}

		// Simple Field (movementIsLockedEGByDevicelockedInput)
		if _err := writeBuffer.WriteBit("movementIsLockedEGByDevicelockedInput", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'movementIsLockedEGByDevicelockedInput' field")
		}

		// Simple Field (actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface)
		if _err := writeBuffer.WriteBit("actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'actuatorSetvalueIsLocallyOverriddenEGViaALocalUserInterface' field")
		}

		// Simple Field (generalFailureOfTheActuatorOrTheDrive)
		if _err := writeBuffer.WriteBit("generalFailureOfTheActuatorOrTheDrive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'generalFailureOfTheActuatorOrTheDrive' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 3, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (validityHeightPos)
		if _err := writeBuffer.WriteBit("validityHeightPos", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validityHeightPos' field")
		}

		// Simple Field (validitySlatsPos)
		if _err := writeBuffer.WriteBit("validitySlatsPos", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validitySlatsPos' field")
		}
	case datapointType == KnxDatapointType_DPT_Colour_xyY: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (xAxis)
		if _err := writeBuffer.WriteUint16("xAxis", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'xAxis' field")
		}

		// Simple Field (yAxis)
		if _err := writeBuffer.WriteUint16("yAxis", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'yAxis' field")
		}

		// Simple Field (brightness)
		if _err := writeBuffer.WriteUint8("brightness", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'brightness' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (validityXy)
		if _err := writeBuffer.WriteBit("validityXy", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validityXy' field")
		}

		// Simple Field (validityBrightness)
		if _err := writeBuffer.WriteBit("validityBrightness", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validityBrightness' field")
		}
	case datapointType == KnxDatapointType_DPT_Converter_Status: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (converterModeAccordingToTheDaliConverterStateMachine)
		if _err := writeBuffer.WriteUint8("converterModeAccordingToTheDaliConverterStateMachine", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'converterModeAccordingToTheDaliConverterStateMachine' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 2, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (hardwiredSwitchIsActive)
		if _err := writeBuffer.WriteBit("hardwiredSwitchIsActive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hardwiredSwitchIsActive' field")
		}

		// Simple Field (hardwiredInhibitIsActive)
		if _err := writeBuffer.WriteBit("hardwiredInhibitIsActive", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'hardwiredInhibitIsActive' field")
		}

		// Simple Field (functionTestPending)
		if _err := writeBuffer.WriteUint8("functionTestPending", 2, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'functionTestPending' field")
		}

		// Simple Field (durationTestPending)
		if _err := writeBuffer.WriteUint8("durationTestPending", 2, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'durationTestPending' field")
		}

		// Simple Field (partialDurationTestPending)
		if _err := writeBuffer.WriteUint8("partialDurationTestPending", 2, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'partialDurationTestPending' field")
		}

		// Simple Field (converterFailure)
		if _err := writeBuffer.WriteUint8("converterFailure", 2, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'converterFailure' field")
		}
	case datapointType == KnxDatapointType_DPT_Converter_Test_Result: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (ltrf)
		if _err := writeBuffer.WriteUint8("ltrf", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ltrf' field")
		}

		// Simple Field (ltrd)
		if _err := writeBuffer.WriteUint8("ltrd", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ltrd' field")
		}

		// Simple Field (ltrp)
		if _err := writeBuffer.WriteUint8("ltrp", 4, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ltrp' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (sf)
		if _err := writeBuffer.WriteUint8("sf", 2, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'sf' field")
		}

		// Simple Field (sd)
		if _err := writeBuffer.WriteUint8("sd", 2, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'sd' field")
		}

		// Simple Field (sp)
		if _err := writeBuffer.WriteUint8("sp", 2, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'sp' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 2, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (ldtr)
		if _err := writeBuffer.WriteUint16("ldtr", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ldtr' field")
		}

		// Simple Field (lpdtr)
		if _err := writeBuffer.WriteUint8("lpdtr", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'lpdtr' field")
		}
	case datapointType == KnxDatapointType_DPT_Battery_Info: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 5, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (batteryFailure)
		if _err := writeBuffer.WriteBit("batteryFailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'batteryFailure' field")
		}

		// Simple Field (batteryDurationFailure)
		if _err := writeBuffer.WriteBit("batteryDurationFailure", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'batteryDurationFailure' field")
		}

		// Simple Field (batteryFullyCharged)
		if _err := writeBuffer.WriteBit("batteryFullyCharged", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'batteryFullyCharged' field")
		}

		// Simple Field (batteryChargeLevel)
		if _err := writeBuffer.WriteUint8("batteryChargeLevel", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'batteryChargeLevel' field")
		}
	case datapointType == KnxDatapointType_DPT_Brightness_Colour_Temperature_Transition: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (ms)
		if _err := writeBuffer.WriteUint16("ms", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'ms' field")
		}

		// Simple Field (temperatureK)
		if _err := writeBuffer.WriteUint16("temperatureK", 16, value.GetUint16()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'temperatureK' field")
		}

		// Simple Field (percent)
		if _err := writeBuffer.WriteUint8("percent", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'percent' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 5, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (validityOfTheTimePeriod)
		if _err := writeBuffer.WriteBit("validityOfTheTimePeriod", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validityOfTheTimePeriod' field")
		}

		// Simple Field (validityOfTheAbsoluteColourTemperature)
		if _err := writeBuffer.WriteBit("validityOfTheAbsoluteColourTemperature", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validityOfTheAbsoluteColourTemperature' field")
		}

		// Simple Field (validityOfTheAbsoluteBrightness)
		if _err := writeBuffer.WriteBit("validityOfTheAbsoluteBrightness", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'validityOfTheAbsoluteBrightness' field")
		}
	case datapointType == KnxDatapointType_DPT_Brightness_Colour_Temperature_Control: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cct)
		if _err := writeBuffer.WriteBit("cct", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cct' field")
		}

		// Simple Field (stepCodeColourTemperature)
		if _err := writeBuffer.WriteUint8("stepCodeColourTemperature", 3, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourTemperature' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cb)
		if _err := writeBuffer.WriteBit("cb", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cb' field")
		}

		// Simple Field (stepCodeBrightness)
		if _err := writeBuffer.WriteUint8("stepCodeBrightness", 3, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeBrightness' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 6, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cctAndStepCodeColourValidity)
		if _err := writeBuffer.WriteBit("cctAndStepCodeColourValidity", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cctAndStepCodeColourValidity' field")
		}

		// Simple Field (cbAndStepCodeBrightnessValidity)
		if _err := writeBuffer.WriteBit("cbAndStepCodeBrightnessValidity", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cbAndStepCodeBrightnessValidity' field")
		}
	case datapointType == KnxDatapointType_DPT_Colour_RGBW: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (colourLevelRed)
		if _err := writeBuffer.WriteUint8("colourLevelRed", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'colourLevelRed' field")
		}

		// Simple Field (colourLevelGreen)
		if _err := writeBuffer.WriteUint8("colourLevelGreen", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'colourLevelGreen' field")
		}

		// Simple Field (colourLevelBlue)
		if _err := writeBuffer.WriteUint8("colourLevelBlue", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'colourLevelBlue' field")
		}

		// Simple Field (colourLevelWhite)
		if _err := writeBuffer.WriteUint8("colourLevelWhite", 8, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'colourLevelWhite' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (mr)
		if _err := writeBuffer.WriteBit("mr", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'mr' field")
		}

		// Simple Field (mg)
		if _err := writeBuffer.WriteBit("mg", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'mg' field")
		}

		// Simple Field (mb)
		if _err := writeBuffer.WriteBit("mb", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'mb' field")
		}

		// Simple Field (mw)
		if _err := writeBuffer.WriteBit("mw", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'mw' field")
		}
	case datapointType == KnxDatapointType_DPT_Relative_Control_RGBW: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (maskcw)
		if _err := writeBuffer.WriteBit("maskcw", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskcw' field")
		}

		// Simple Field (maskcb)
		if _err := writeBuffer.WriteBit("maskcb", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskcb' field")
		}

		// Simple Field (maskcg)
		if _err := writeBuffer.WriteBit("maskcg", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskcg' field")
		}

		// Simple Field (maskcr)
		if _err := writeBuffer.WriteBit("maskcr", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'maskcr' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cw)
		if _err := writeBuffer.WriteBit("cw", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cw' field")
		}

		// Simple Field (stepCodeColourWhite)
		if _err := writeBuffer.WriteUint8("stepCodeColourWhite", 3, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourWhite' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cb)
		if _err := writeBuffer.WriteBit("cb", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cb' field")
		}

		// Simple Field (stepCodeColourBlue)
		if _err := writeBuffer.WriteUint8("stepCodeColourBlue", 3, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourBlue' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cg)
		if _err := writeBuffer.WriteBit("cg", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cg' field")
		}

		// Simple Field (stepCodeColourGreen)
		if _err := writeBuffer.WriteUint8("stepCodeColourGreen", 3, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourGreen' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cr)
		if _err := writeBuffer.WriteBit("cr", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cr' field")
		}

		// Simple Field (stepCodeColourRed)
		if _err := writeBuffer.WriteUint8("stepCodeColourRed", 3, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourRed' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}
	case datapointType == KnxDatapointType_DPT_Relative_Control_RGB: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cb)
		if _err := writeBuffer.WriteBit("cb", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cb' field")
		}

		// Simple Field (stepCodeColourBlue)
		if _err := writeBuffer.WriteUint8("stepCodeColourBlue", 3, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourBlue' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cg)
		if _err := writeBuffer.WriteBit("cg", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cg' field")
		}

		// Simple Field (stepCodeColourGreen)
		if _err := writeBuffer.WriteUint8("stepCodeColourGreen", 3, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourGreen' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (cr)
		if _err := writeBuffer.WriteBit("cr", value.GetBool()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'cr' field")
		}

		// Simple Field (stepCodeColourRed)
		if _err := writeBuffer.WriteUint8("stepCodeColourRed", 3, value.GetUint8()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'stepCodeColourRed' field")
		}

		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 4, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}
	case datapointType == KnxDatapointType_DPT_GeographicalLocation: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (longitude)
		if _err := writeBuffer.WriteFloat32("longitude", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'longitude' field")
		}

		// Simple Field (latitude)
		if _err := writeBuffer.WriteFloat32("latitude", 32, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'latitude' field")
		}
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetF16_4: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (roomTemperatureSetpointComfort)
		if _err := writeBuffer.WriteFloat32("roomTemperatureSetpointComfort", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointComfort' field")
		}

		// Simple Field (roomTemperatureSetpointStandby)
		if _err := writeBuffer.WriteFloat32("roomTemperatureSetpointStandby", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointStandby' field")
		}

		// Simple Field (roomTemperatureSetpointEconomy)
		if _err := writeBuffer.WriteFloat32("roomTemperatureSetpointEconomy", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointEconomy' field")
		}

		// Simple Field (roomTemperatureSetpointBuildingProtection)
		if _err := writeBuffer.WriteFloat32("roomTemperatureSetpointBuildingProtection", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointBuildingProtection' field")
		}
	case datapointType == KnxDatapointType_DPT_TempRoomSetpSetShiftF16_4: // Struct
		// Reserved Field (Just skip the bytes)
		if _err := writeBuffer.WriteUint8("reserved", 8, uint8(0x00)); _err != nil {
			return errors.Wrap(_err, "Error serializing reserved field")
		}

		// Simple Field (roomTemperatureSetpointShiftComfort)
		if _err := writeBuffer.WriteFloat32("roomTemperatureSetpointShiftComfort", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointShiftComfort' field")
		}

		// Simple Field (roomTemperatureSetpointShiftStandby)
		if _err := writeBuffer.WriteFloat32("roomTemperatureSetpointShiftStandby", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointShiftStandby' field")
		}

		// Simple Field (roomTemperatureSetpointShiftEconomy)
		if _err := writeBuffer.WriteFloat32("roomTemperatureSetpointShiftEconomy", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointShiftEconomy' field")
		}

		// Simple Field (roomTemperatureSetpointShiftBuildingProtection)
		if _err := writeBuffer.WriteFloat32("roomTemperatureSetpointShiftBuildingProtection", 16, value.GetFloat32()); _err != nil {
			return errors.Wrap(_err, "Error serializing 'roomTemperatureSetpointShiftBuildingProtection' field")
		}
	default:
		// TODO: add more info which type it is actually
		return errors.New("unsupported type")
	}
	writeBuffer.PopContext("KnxDatapoint")
	return nil
}
