/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// ApduDataExtWriteRoutingTableRequest is the corresponding interface of ApduDataExtWriteRoutingTableRequest
type ApduDataExtWriteRoutingTableRequest interface {
	utils.LengthAware
	utils.Serializable
	ApduDataExt
}

// ApduDataExtWriteRoutingTableRequestExactly can be used when we want exactly this type and not a type which fulfills ApduDataExtWriteRoutingTableRequest.
// This is useful for switch cases.
type ApduDataExtWriteRoutingTableRequestExactly interface {
	ApduDataExtWriteRoutingTableRequest
	isApduDataExtWriteRoutingTableRequest() bool
}

// _ApduDataExtWriteRoutingTableRequest is the data-structure of this message
type _ApduDataExtWriteRoutingTableRequest struct {
	*_ApduDataExt
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_ApduDataExtWriteRoutingTableRequest) GetExtApciType() uint8 {
	return 0x03
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_ApduDataExtWriteRoutingTableRequest) InitializeParent(parent ApduDataExt) {}

func (m *_ApduDataExtWriteRoutingTableRequest) GetParent() ApduDataExt {
	return m._ApduDataExt
}

// NewApduDataExtWriteRoutingTableRequest factory function for _ApduDataExtWriteRoutingTableRequest
func NewApduDataExtWriteRoutingTableRequest(length uint8) *_ApduDataExtWriteRoutingTableRequest {
	_result := &_ApduDataExtWriteRoutingTableRequest{
		_ApduDataExt: NewApduDataExt(length),
	}
	_result._ApduDataExt._ApduDataExtChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastApduDataExtWriteRoutingTableRequest(structType interface{}) ApduDataExtWriteRoutingTableRequest {
	if casted, ok := structType.(ApduDataExtWriteRoutingTableRequest); ok {
		return casted
	}
	if casted, ok := structType.(*ApduDataExtWriteRoutingTableRequest); ok {
		return *casted
	}
	return nil
}

func (m *_ApduDataExtWriteRoutingTableRequest) GetTypeName() string {
	return "ApduDataExtWriteRoutingTableRequest"
}

func (m *_ApduDataExtWriteRoutingTableRequest) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_ApduDataExtWriteRoutingTableRequest) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	return lengthInBits
}

func (m *_ApduDataExtWriteRoutingTableRequest) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func ApduDataExtWriteRoutingTableRequestParse(readBuffer utils.ReadBuffer, length uint8) (ApduDataExtWriteRoutingTableRequest, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ApduDataExtWriteRoutingTableRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ApduDataExtWriteRoutingTableRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("ApduDataExtWriteRoutingTableRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ApduDataExtWriteRoutingTableRequest")
	}

	// Create a partially initialized instance
	_child := &_ApduDataExtWriteRoutingTableRequest{
		_ApduDataExt: &_ApduDataExt{
			Length: length,
		},
	}
	_child._ApduDataExt._ApduDataExtChildRequirements = _child
	return _child, nil
}

func (m *_ApduDataExtWriteRoutingTableRequest) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("ApduDataExtWriteRoutingTableRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for ApduDataExtWriteRoutingTableRequest")
		}

		if popErr := writeBuffer.PopContext("ApduDataExtWriteRoutingTableRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for ApduDataExtWriteRoutingTableRequest")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_ApduDataExtWriteRoutingTableRequest) isApduDataExtWriteRoutingTableRequest() bool {
	return true
}

func (m *_ApduDataExtWriteRoutingTableRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
