/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package readwrite

import (
	"github.com/apache/plc4x/plc4go/protocols/knxnetip/readwrite/model"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

type KnxnetipParserHelper struct {
}

func (m KnxnetipParserHelper) Parse(typeName string, arguments []string, io utils.ReadBuffer) (interface{}, error) {
	switch typeName {
	case "KnxProperty":
		propertyType, _ := model.KnxPropertyDataTypeByName(arguments[0])
		dataLengthInBytes, err := utils.StrToUint8(arguments[1])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.KnxPropertyParse(io, propertyType, dataLengthInBytes)
	case "HPAIControlEndpoint":
		return model.HPAIControlEndpointParse(io)
	case "TunnelingResponseDataBlock":
		return model.TunnelingResponseDataBlockParse(io)
	case "DeviceDescriptorType2":
		return model.DeviceDescriptorType2Parse(io)
	case "ChannelInformation":
		return model.ChannelInformationParse(io)
	case "KnxDatapoint":
		datapointType, _ := model.KnxDatapointTypeByName(arguments[0])
		return model.KnxDatapointParse(io, datapointType)
	case "DeviceConfigurationAckDataBlock":
		return model.DeviceConfigurationAckDataBlockParse(io)
	case "ConnectionRequestInformation":
		return model.ConnectionRequestInformationParse(io)
	case "Apdu":
		dataLength, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.ApduParse(io, dataLength)
	case "HPAIDiscoveryEndpoint":
		return model.HPAIDiscoveryEndpointParse(io)
	case "ProjectInstallationIdentifier":
		return model.ProjectInstallationIdentifierParse(io)
	case "ServiceId":
		return model.ServiceIdParse(io)
	case "HPAIDataEndpoint":
		return model.HPAIDataEndpointParse(io)
	case "RelativeTimestamp":
		return model.RelativeTimestampParse(io)
	case "CEMI":
		size, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.CEMIParse(io, size)
	case "KnxNetIpMessage":
		return model.KnxNetIpMessageParse(io)
	case "DeviceStatus":
		return model.DeviceStatusParse(io)
	case "IPAddress":
		return model.IPAddressParse(io)
	case "GroupObjectDescriptorRealisationTypeB":
		return model.GroupObjectDescriptorRealisationTypeBParse(io)
	case "CEMIAdditionalInformation":
		return model.CEMIAdditionalInformationParse(io)
	case "ComObjectTable":
		firmwareType, _ := model.FirmwareTypeByName(arguments[0])
		return model.ComObjectTableParse(io, firmwareType)
	case "KnxAddress":
		return model.KnxAddressParse(io)
	case "ConnectionResponseDataBlock":
		return model.ConnectionResponseDataBlockParse(io)
	case "TunnelingRequestDataBlock":
		return model.TunnelingRequestDataBlockParse(io)
	case "DIBDeviceInfo":
		return model.DIBDeviceInfoParse(io)
	case "DeviceConfigurationRequestDataBlock":
		return model.DeviceConfigurationRequestDataBlockParse(io)
	case "DIBSuppSvcFamilies":
		return model.DIBSuppSvcFamiliesParse(io)
	case "LDataFrame":
		return model.LDataFrameParse(io)
	case "ApduDataExt":
		length, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.ApduDataExtParse(io, length)
	case "ApduControl":
		return model.ApduControlParse(io)
	case "KnxGroupAddress":
		numLevels, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.KnxGroupAddressParse(io, numLevels)
	case "GroupObjectDescriptorRealisationType6":
		return model.GroupObjectDescriptorRealisationType6Parse(io)
	case "GroupObjectDescriptorRealisationType7":
		return model.GroupObjectDescriptorRealisationType7Parse(io)
	case "MACAddress":
		return model.MACAddressParse(io)
	case "GroupObjectDescriptorRealisationType2":
		return model.GroupObjectDescriptorRealisationType2Parse(io)
	case "ApduData":
		dataLength, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.ApduDataParse(io, dataLength)
	case "GroupObjectDescriptorRealisationType1":
		return model.GroupObjectDescriptorRealisationType1Parse(io)
	}
	return nil, errors.Errorf("Unsupported type %s", typeName)
}
