/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// CipService is the corresponding interface of CipService
type CipService interface {
	utils.LengthAware
	utils.Serializable
	// GetService returns Service (discriminator field)
	GetService() uint8
}

// CipServiceExactly can be used when we want exactly this type and not a type which fulfills CipService.
// This is useful for switch cases.
type CipServiceExactly interface {
	CipService
	isCipService() bool
}

// _CipService is the data-structure of this message
type _CipService struct {
	_CipServiceChildRequirements

	// Arguments.
	ServiceLen uint16
}

type _CipServiceChildRequirements interface {
	utils.Serializable
	GetLengthInBits() uint16
	GetLengthInBitsConditional(lastItem bool) uint16
	GetService() uint8
}

type CipServiceParent interface {
	SerializeParent(writeBuffer utils.WriteBuffer, child CipService, serializeChildFunction func() error) error
	GetTypeName() string
}

type CipServiceChild interface {
	utils.Serializable
	InitializeParent(parent CipService)
	GetParent() *CipService

	GetTypeName() string
	CipService
}

// NewCipService factory function for _CipService
func NewCipService(serviceLen uint16) *_CipService {
	return &_CipService{ServiceLen: serviceLen}
}

// Deprecated: use the interface for direct cast
func CastCipService(structType interface{}) CipService {
	if casted, ok := structType.(CipService); ok {
		return casted
	}
	if casted, ok := structType.(*CipService); ok {
		return *casted
	}
	return nil
}

func (m *_CipService) GetTypeName() string {
	return "CipService"
}

func (m *_CipService) GetParentLengthInBits() uint16 {
	lengthInBits := uint16(0)
	// Discriminator Field (service)
	lengthInBits += 8

	return lengthInBits
}

func (m *_CipService) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func CipServiceParse(readBuffer utils.ReadBuffer, serviceLen uint16) (CipService, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CipService"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CipService")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Discriminator Field (service) (Used as input to a switch field)
	service, _serviceErr := readBuffer.ReadUint8("service", 8)
	if _serviceErr != nil {
		return nil, errors.Wrap(_serviceErr, "Error parsing 'service' field of CipService")
	}

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	type CipServiceChildSerializeRequirement interface {
		CipService
		InitializeParent(CipService)
		GetParent() CipService
	}
	var _childTemp interface{}
	var _child CipServiceChildSerializeRequirement
	var typeSwitchError error
	switch {
	case service == 0x4C: // CipReadRequest
		_childTemp, typeSwitchError = CipReadRequestParse(readBuffer, serviceLen)
	case service == 0xCC: // CipReadResponse
		_childTemp, typeSwitchError = CipReadResponseParse(readBuffer, serviceLen)
	case service == 0x4D: // CipWriteRequest
		_childTemp, typeSwitchError = CipWriteRequestParse(readBuffer, serviceLen)
	case service == 0xCD: // CipWriteResponse
		_childTemp, typeSwitchError = CipWriteResponseParse(readBuffer, serviceLen)
	case service == 0x0A: // MultipleServiceRequest
		_childTemp, typeSwitchError = MultipleServiceRequestParse(readBuffer, serviceLen)
	case service == 0x8A: // MultipleServiceResponse
		_childTemp, typeSwitchError = MultipleServiceResponseParse(readBuffer, serviceLen)
	case service == 0x52: // CipUnconnectedRequest
		_childTemp, typeSwitchError = CipUnconnectedRequestParse(readBuffer, serviceLen)
	default:
		typeSwitchError = errors.Errorf("Unmapped type for parameters [service=%v]", service)
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch of CipService")
	}
	_child = _childTemp.(CipServiceChildSerializeRequirement)

	if closeErr := readBuffer.CloseContext("CipService"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CipService")
	}

	// Finish initializing
	_child.InitializeParent(_child)
	return _child, nil
}

func (pm *_CipService) SerializeParent(writeBuffer utils.WriteBuffer, child CipService, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	if pushErr := writeBuffer.PushContext("CipService"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for CipService")
	}

	// Discriminator Field (service) (Used as input to a switch field)
	service := uint8(child.GetService())
	_serviceErr := writeBuffer.WriteUint8("service", 8, (service))

	if _serviceErr != nil {
		return errors.Wrap(_serviceErr, "Error serializing 'service' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("CipService"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for CipService")
	}
	return nil
}

////
// Arguments Getter

func (m *_CipService) GetServiceLen() uint16 {
	return m.ServiceLen
}

//
////

func (m *_CipService) isCipService() bool {
	return true
}

func (m *_CipService) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
