/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// ZoneStatus is the corresponding interface of ZoneStatus
type ZoneStatus interface {
	utils.LengthAware
	utils.Serializable
	// GetValue returns Value (property field)
	GetValue() ZoneStatusTemp
}

// ZoneStatusExactly can be used when we want exactly this type and not a type which fulfills ZoneStatus.
// This is useful for switch cases.
type ZoneStatusExactly interface {
	ZoneStatus
	isZoneStatus() bool
}

// _ZoneStatus is the data-structure of this message
type _ZoneStatus struct {
	Value ZoneStatusTemp
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_ZoneStatus) GetValue() ZoneStatusTemp {
	return m.Value
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewZoneStatus factory function for _ZoneStatus
func NewZoneStatus(value ZoneStatusTemp) *_ZoneStatus {
	return &_ZoneStatus{Value: value}
}

// Deprecated: use the interface for direct cast
func CastZoneStatus(structType interface{}) ZoneStatus {
	if casted, ok := structType.(ZoneStatus); ok {
		return casted
	}
	if casted, ok := structType.(*ZoneStatus); ok {
		return *casted
	}
	return nil
}

func (m *_ZoneStatus) GetTypeName() string {
	return "ZoneStatus"
}

func (m *_ZoneStatus) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_ZoneStatus) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(0)

	// Simple field (value)
	lengthInBits += 2

	return lengthInBits
}

func (m *_ZoneStatus) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func ZoneStatusParse(readBuffer utils.ReadBuffer) (ZoneStatus, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("ZoneStatus"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for ZoneStatus")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (value)
	if pullErr := readBuffer.PullContext("value"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for value")
	}
	_value, _valueErr := ZoneStatusTempParse(readBuffer)
	if _valueErr != nil {
		return nil, errors.Wrap(_valueErr, "Error parsing 'value' field of ZoneStatus")
	}
	value := _value
	if closeErr := readBuffer.CloseContext("value"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for value")
	}

	if closeErr := readBuffer.CloseContext("ZoneStatus"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for ZoneStatus")
	}

	// Create the instance
	return &_ZoneStatus{
		Value: value,
	}, nil
}

func (m *_ZoneStatus) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	if pushErr := writeBuffer.PushContext("ZoneStatus"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for ZoneStatus")
	}

	// Simple Field (value)
	if pushErr := writeBuffer.PushContext("value"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for value")
	}
	_valueErr := writeBuffer.WriteSerializable(m.GetValue())
	if popErr := writeBuffer.PopContext("value"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for value")
	}
	if _valueErr != nil {
		return errors.Wrap(_valueErr, "Error serializing 'value' field")
	}

	if popErr := writeBuffer.PopContext("ZoneStatus"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for ZoneStatus")
	}
	return nil
}

func (m *_ZoneStatus) isZoneStatus() bool {
	return true
}

func (m *_ZoneStatus) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
