/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataLineCutAlarmCleared is the corresponding interface of SecurityDataLineCutAlarmCleared
type SecurityDataLineCutAlarmCleared interface {
	utils.LengthAware
	utils.Serializable
	SecurityData
}

// SecurityDataLineCutAlarmClearedExactly can be used when we want exactly this type and not a type which fulfills SecurityDataLineCutAlarmCleared.
// This is useful for switch cases.
type SecurityDataLineCutAlarmClearedExactly interface {
	SecurityDataLineCutAlarmCleared
	isSecurityDataLineCutAlarmCleared() bool
}

// _SecurityDataLineCutAlarmCleared is the data-structure of this message
type _SecurityDataLineCutAlarmCleared struct {
	*_SecurityData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataLineCutAlarmCleared) InitializeParent(parent SecurityData, commandTypeContainer SecurityCommandTypeContainer, argument byte) {
	m.CommandTypeContainer = commandTypeContainer
	m.Argument = argument
}

func (m *_SecurityDataLineCutAlarmCleared) GetParent() SecurityData {
	return m._SecurityData
}

// NewSecurityDataLineCutAlarmCleared factory function for _SecurityDataLineCutAlarmCleared
func NewSecurityDataLineCutAlarmCleared(commandTypeContainer SecurityCommandTypeContainer, argument byte) *_SecurityDataLineCutAlarmCleared {
	_result := &_SecurityDataLineCutAlarmCleared{
		_SecurityData: NewSecurityData(commandTypeContainer, argument),
	}
	_result._SecurityData._SecurityDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastSecurityDataLineCutAlarmCleared(structType interface{}) SecurityDataLineCutAlarmCleared {
	if casted, ok := structType.(SecurityDataLineCutAlarmCleared); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataLineCutAlarmCleared); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataLineCutAlarmCleared) GetTypeName() string {
	return "SecurityDataLineCutAlarmCleared"
}

func (m *_SecurityDataLineCutAlarmCleared) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_SecurityDataLineCutAlarmCleared) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	return lengthInBits
}

func (m *_SecurityDataLineCutAlarmCleared) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func SecurityDataLineCutAlarmClearedParse(readBuffer utils.ReadBuffer) (SecurityDataLineCutAlarmCleared, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataLineCutAlarmCleared"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataLineCutAlarmCleared")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SecurityDataLineCutAlarmCleared"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataLineCutAlarmCleared")
	}

	// Create a partially initialized instance
	_child := &_SecurityDataLineCutAlarmCleared{
		_SecurityData: &_SecurityData{},
	}
	_child._SecurityData._SecurityDataChildRequirements = _child
	return _child, nil
}

func (m *_SecurityDataLineCutAlarmCleared) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataLineCutAlarmCleared"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataLineCutAlarmCleared")
		}

		if popErr := writeBuffer.PopContext("SecurityDataLineCutAlarmCleared"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataLineCutAlarmCleared")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_SecurityDataLineCutAlarmCleared) isSecurityDataLineCutAlarmCleared() bool {
	return true
}

func (m *_SecurityDataLineCutAlarmCleared) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
