/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// SecurityDataEntryDelayStarted is the corresponding interface of SecurityDataEntryDelayStarted
type SecurityDataEntryDelayStarted interface {
	utils.LengthAware
	utils.Serializable
	SecurityData
}

// SecurityDataEntryDelayStartedExactly can be used when we want exactly this type and not a type which fulfills SecurityDataEntryDelayStarted.
// This is useful for switch cases.
type SecurityDataEntryDelayStartedExactly interface {
	SecurityDataEntryDelayStarted
	isSecurityDataEntryDelayStarted() bool
}

// _SecurityDataEntryDelayStarted is the data-structure of this message
type _SecurityDataEntryDelayStarted struct {
	*_SecurityData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_SecurityDataEntryDelayStarted) InitializeParent(parent SecurityData, commandTypeContainer SecurityCommandTypeContainer, argument byte) {
	m.CommandTypeContainer = commandTypeContainer
	m.Argument = argument
}

func (m *_SecurityDataEntryDelayStarted) GetParent() SecurityData {
	return m._SecurityData
}

// NewSecurityDataEntryDelayStarted factory function for _SecurityDataEntryDelayStarted
func NewSecurityDataEntryDelayStarted(commandTypeContainer SecurityCommandTypeContainer, argument byte) *_SecurityDataEntryDelayStarted {
	_result := &_SecurityDataEntryDelayStarted{
		_SecurityData: NewSecurityData(commandTypeContainer, argument),
	}
	_result._SecurityData._SecurityDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastSecurityDataEntryDelayStarted(structType interface{}) SecurityDataEntryDelayStarted {
	if casted, ok := structType.(SecurityDataEntryDelayStarted); ok {
		return casted
	}
	if casted, ok := structType.(*SecurityDataEntryDelayStarted); ok {
		return *casted
	}
	return nil
}

func (m *_SecurityDataEntryDelayStarted) GetTypeName() string {
	return "SecurityDataEntryDelayStarted"
}

func (m *_SecurityDataEntryDelayStarted) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_SecurityDataEntryDelayStarted) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	return lengthInBits
}

func (m *_SecurityDataEntryDelayStarted) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func SecurityDataEntryDelayStartedParse(readBuffer utils.ReadBuffer) (SecurityDataEntryDelayStarted, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("SecurityDataEntryDelayStarted"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for SecurityDataEntryDelayStarted")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("SecurityDataEntryDelayStarted"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for SecurityDataEntryDelayStarted")
	}

	// Create a partially initialized instance
	_child := &_SecurityDataEntryDelayStarted{
		_SecurityData: &_SecurityData{},
	}
	_child._SecurityData._SecurityDataChildRequirements = _child
	return _child, nil
}

func (m *_SecurityDataEntryDelayStarted) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("SecurityDataEntryDelayStarted"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for SecurityDataEntryDelayStarted")
		}

		if popErr := writeBuffer.PopContext("SecurityDataEntryDelayStarted"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for SecurityDataEntryDelayStarted")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_SecurityDataEntryDelayStarted) isSecurityDataEntryDelayStarted() bool {
	return true
}

func (m *_SecurityDataEntryDelayStarted) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
