/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// CALDataStatusExtended is the corresponding interface of CALDataStatusExtended
type CALDataStatusExtended interface {
	utils.LengthAware
	utils.Serializable
	CALData
	// GetCoding returns Coding (property field)
	GetCoding() StatusCoding
	// GetApplication returns Application (property field)
	GetApplication() ApplicationIdContainer
	// GetBlockStart returns BlockStart (property field)
	GetBlockStart() uint8
	// GetStatusBytes returns StatusBytes (property field)
	GetStatusBytes() []StatusByte
	// GetLevelInformation returns LevelInformation (property field)
	GetLevelInformation() []LevelInformation
	// GetNumberOfStatusBytes returns NumberOfStatusBytes (virtual field)
	GetNumberOfStatusBytes() uint8
	// GetNumberOfLevelInformation returns NumberOfLevelInformation (virtual field)
	GetNumberOfLevelInformation() uint8
}

// CALDataStatusExtendedExactly can be used when we want exactly this type and not a type which fulfills CALDataStatusExtended.
// This is useful for switch cases.
type CALDataStatusExtendedExactly interface {
	CALDataStatusExtended
	isCALDataStatusExtended() bool
}

// _CALDataStatusExtended is the data-structure of this message
type _CALDataStatusExtended struct {
	*_CALData
	Coding           StatusCoding
	Application      ApplicationIdContainer
	BlockStart       uint8
	StatusBytes      []StatusByte
	LevelInformation []LevelInformation
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_CALDataStatusExtended) InitializeParent(parent CALData, commandTypeContainer CALCommandTypeContainer, additionalData CALData) {
	m.CommandTypeContainer = commandTypeContainer
	m.AdditionalData = additionalData
}

func (m *_CALDataStatusExtended) GetParent() CALData {
	return m._CALData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_CALDataStatusExtended) GetCoding() StatusCoding {
	return m.Coding
}

func (m *_CALDataStatusExtended) GetApplication() ApplicationIdContainer {
	return m.Application
}

func (m *_CALDataStatusExtended) GetBlockStart() uint8 {
	return m.BlockStart
}

func (m *_CALDataStatusExtended) GetStatusBytes() []StatusByte {
	return m.StatusBytes
}

func (m *_CALDataStatusExtended) GetLevelInformation() []LevelInformation {
	return m.LevelInformation
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_CALDataStatusExtended) GetNumberOfStatusBytes() uint8 {
	return uint8(utils.InlineIf((bool(bool((m.GetCoding()) == (StatusCoding_BINARY_BY_THIS_SERIAL_INTERFACE))) || bool(bool((m.GetCoding()) == (StatusCoding_BINARY_BY_ELSEWHERE)))), func() interface{} { return uint8((uint8(m.GetCommandTypeContainer().NumBytes()) - uint8(uint8(3)))) }, func() interface{} { return uint8((uint8(0))) }).(uint8))
}

func (m *_CALDataStatusExtended) GetNumberOfLevelInformation() uint8 {
	return uint8(utils.InlineIf((bool(bool((m.GetCoding()) == (StatusCoding_LEVEL_BY_THIS_SERIAL_INTERFACE))) || bool(bool((m.GetCoding()) == (StatusCoding_LEVEL_BY_ELSEWHERE)))), func() interface{} {
		return uint8((uint8((uint8(m.GetCommandTypeContainer().NumBytes()) - uint8(uint8(3)))) / uint8(uint8(2))))
	}, func() interface{} { return uint8((uint8(0))) }).(uint8))
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewCALDataStatusExtended factory function for _CALDataStatusExtended
func NewCALDataStatusExtended(coding StatusCoding, application ApplicationIdContainer, blockStart uint8, statusBytes []StatusByte, levelInformation []LevelInformation, commandTypeContainer CALCommandTypeContainer, additionalData CALData, requestContext RequestContext) *_CALDataStatusExtended {
	_result := &_CALDataStatusExtended{
		Coding:           coding,
		Application:      application,
		BlockStart:       blockStart,
		StatusBytes:      statusBytes,
		LevelInformation: levelInformation,
		_CALData:         NewCALData(commandTypeContainer, additionalData, requestContext),
	}
	_result._CALData._CALDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastCALDataStatusExtended(structType interface{}) CALDataStatusExtended {
	if casted, ok := structType.(CALDataStatusExtended); ok {
		return casted
	}
	if casted, ok := structType.(*CALDataStatusExtended); ok {
		return *casted
	}
	return nil
}

func (m *_CALDataStatusExtended) GetTypeName() string {
	return "CALDataStatusExtended"
}

func (m *_CALDataStatusExtended) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_CALDataStatusExtended) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (coding)
	lengthInBits += 8

	// Simple field (application)
	lengthInBits += 8

	// Simple field (blockStart)
	lengthInBits += 8

	// A virtual field doesn't have any in- or output.

	// A virtual field doesn't have any in- or output.

	// Array field
	if len(m.StatusBytes) > 0 {
		for i, element := range m.StatusBytes {
			last := i == len(m.StatusBytes)-1
			lengthInBits += element.(interface{ GetLengthInBitsConditional(bool) uint16 }).GetLengthInBitsConditional(last)
		}
	}

	// Array field
	if len(m.LevelInformation) > 0 {
		for i, element := range m.LevelInformation {
			last := i == len(m.LevelInformation)-1
			lengthInBits += element.(interface{ GetLengthInBitsConditional(bool) uint16 }).GetLengthInBitsConditional(last)
		}
	}

	return lengthInBits
}

func (m *_CALDataStatusExtended) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func CALDataStatusExtendedParse(readBuffer utils.ReadBuffer, requestContext RequestContext, commandTypeContainer CALCommandTypeContainer) (CALDataStatusExtended, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("CALDataStatusExtended"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for CALDataStatusExtended")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (coding)
	if pullErr := readBuffer.PullContext("coding"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for coding")
	}
	_coding, _codingErr := StatusCodingParse(readBuffer)
	if _codingErr != nil {
		return nil, errors.Wrap(_codingErr, "Error parsing 'coding' field of CALDataStatusExtended")
	}
	coding := _coding
	if closeErr := readBuffer.CloseContext("coding"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for coding")
	}

	// Simple Field (application)
	if pullErr := readBuffer.PullContext("application"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for application")
	}
	_application, _applicationErr := ApplicationIdContainerParse(readBuffer)
	if _applicationErr != nil {
		return nil, errors.Wrap(_applicationErr, "Error parsing 'application' field of CALDataStatusExtended")
	}
	application := _application
	if closeErr := readBuffer.CloseContext("application"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for application")
	}

	// Simple Field (blockStart)
	_blockStart, _blockStartErr := readBuffer.ReadUint8("blockStart", 8)
	if _blockStartErr != nil {
		return nil, errors.Wrap(_blockStartErr, "Error parsing 'blockStart' field of CALDataStatusExtended")
	}
	blockStart := _blockStart

	// Virtual field
	_numberOfStatusBytes := utils.InlineIf((bool(bool((coding) == (StatusCoding_BINARY_BY_THIS_SERIAL_INTERFACE))) || bool(bool((coding) == (StatusCoding_BINARY_BY_ELSEWHERE)))), func() interface{} { return uint8((uint8(commandTypeContainer.NumBytes()) - uint8(uint8(3)))) }, func() interface{} { return uint8((uint8(0))) }).(uint8)
	numberOfStatusBytes := uint8(_numberOfStatusBytes)
	_ = numberOfStatusBytes

	// Virtual field
	_numberOfLevelInformation := utils.InlineIf((bool(bool((coding) == (StatusCoding_LEVEL_BY_THIS_SERIAL_INTERFACE))) || bool(bool((coding) == (StatusCoding_LEVEL_BY_ELSEWHERE)))), func() interface{} {
		return uint8((uint8((uint8(commandTypeContainer.NumBytes()) - uint8(uint8(3)))) / uint8(uint8(2))))
	}, func() interface{} { return uint8((uint8(0))) }).(uint8)
	numberOfLevelInformation := uint8(_numberOfLevelInformation)
	_ = numberOfLevelInformation

	// Array field (statusBytes)
	if pullErr := readBuffer.PullContext("statusBytes", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for statusBytes")
	}
	// Count array
	statusBytes := make([]StatusByte, numberOfStatusBytes)
	// This happens when the size is set conditional to 0
	if len(statusBytes) == 0 {
		statusBytes = nil
	}
	{
		for curItem := uint16(0); curItem < uint16(numberOfStatusBytes); curItem++ {
			_item, _err := StatusByteParse(readBuffer)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'statusBytes' field of CALDataStatusExtended")
			}
			statusBytes[curItem] = _item.(StatusByte)
		}
	}
	if closeErr := readBuffer.CloseContext("statusBytes", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for statusBytes")
	}

	// Array field (levelInformation)
	if pullErr := readBuffer.PullContext("levelInformation", utils.WithRenderAsList(true)); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for levelInformation")
	}
	// Count array
	levelInformation := make([]LevelInformation, numberOfLevelInformation)
	// This happens when the size is set conditional to 0
	if len(levelInformation) == 0 {
		levelInformation = nil
	}
	{
		for curItem := uint16(0); curItem < uint16(numberOfLevelInformation); curItem++ {
			_item, _err := LevelInformationParse(readBuffer)
			if _err != nil {
				return nil, errors.Wrap(_err, "Error parsing 'levelInformation' field of CALDataStatusExtended")
			}
			levelInformation[curItem] = _item.(LevelInformation)
		}
	}
	if closeErr := readBuffer.CloseContext("levelInformation", utils.WithRenderAsList(true)); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for levelInformation")
	}

	if closeErr := readBuffer.CloseContext("CALDataStatusExtended"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for CALDataStatusExtended")
	}

	// Create a partially initialized instance
	_child := &_CALDataStatusExtended{
		_CALData: &_CALData{
			RequestContext: requestContext,
		},
		Coding:           coding,
		Application:      application,
		BlockStart:       blockStart,
		StatusBytes:      statusBytes,
		LevelInformation: levelInformation,
	}
	_child._CALData._CALDataChildRequirements = _child
	return _child, nil
}

func (m *_CALDataStatusExtended) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("CALDataStatusExtended"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for CALDataStatusExtended")
		}

		// Simple Field (coding)
		if pushErr := writeBuffer.PushContext("coding"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for coding")
		}
		_codingErr := writeBuffer.WriteSerializable(m.GetCoding())
		if popErr := writeBuffer.PopContext("coding"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for coding")
		}
		if _codingErr != nil {
			return errors.Wrap(_codingErr, "Error serializing 'coding' field")
		}

		// Simple Field (application)
		if pushErr := writeBuffer.PushContext("application"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for application")
		}
		_applicationErr := writeBuffer.WriteSerializable(m.GetApplication())
		if popErr := writeBuffer.PopContext("application"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for application")
		}
		if _applicationErr != nil {
			return errors.Wrap(_applicationErr, "Error serializing 'application' field")
		}

		// Simple Field (blockStart)
		blockStart := uint8(m.GetBlockStart())
		_blockStartErr := writeBuffer.WriteUint8("blockStart", 8, (blockStart))
		if _blockStartErr != nil {
			return errors.Wrap(_blockStartErr, "Error serializing 'blockStart' field")
		}
		// Virtual field
		if _numberOfStatusBytesErr := writeBuffer.WriteVirtual("numberOfStatusBytes", m.GetNumberOfStatusBytes()); _numberOfStatusBytesErr != nil {
			return errors.Wrap(_numberOfStatusBytesErr, "Error serializing 'numberOfStatusBytes' field")
		}
		// Virtual field
		if _numberOfLevelInformationErr := writeBuffer.WriteVirtual("numberOfLevelInformation", m.GetNumberOfLevelInformation()); _numberOfLevelInformationErr != nil {
			return errors.Wrap(_numberOfLevelInformationErr, "Error serializing 'numberOfLevelInformation' field")
		}

		// Array Field (statusBytes)
		if pushErr := writeBuffer.PushContext("statusBytes", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for statusBytes")
		}
		for _, _element := range m.GetStatusBytes() {
			_elementErr := writeBuffer.WriteSerializable(_element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'statusBytes' field")
			}
		}
		if popErr := writeBuffer.PopContext("statusBytes", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for statusBytes")
		}

		// Array Field (levelInformation)
		if pushErr := writeBuffer.PushContext("levelInformation", utils.WithRenderAsList(true)); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for levelInformation")
		}
		for _, _element := range m.GetLevelInformation() {
			_elementErr := writeBuffer.WriteSerializable(_element)
			if _elementErr != nil {
				return errors.Wrap(_elementErr, "Error serializing 'levelInformation' field")
			}
		}
		if popErr := writeBuffer.PopContext("levelInformation", utils.WithRenderAsList(true)); popErr != nil {
			return errors.Wrap(popErr, "Error popping for levelInformation")
		}

		if popErr := writeBuffer.PopContext("CALDataStatusExtended"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for CALDataStatusExtended")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_CALDataStatusExtended) isCALDataStatusExtended() bool {
	return true
}

func (m *_CALDataStatusExtended) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
