/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// AirConditioningDataSetZoneGroupOn is the corresponding interface of AirConditioningDataSetZoneGroupOn
type AirConditioningDataSetZoneGroupOn interface {
	utils.LengthAware
	utils.Serializable
	AirConditioningData
	// GetZoneGroup returns ZoneGroup (property field)
	GetZoneGroup() byte
}

// AirConditioningDataSetZoneGroupOnExactly can be used when we want exactly this type and not a type which fulfills AirConditioningDataSetZoneGroupOn.
// This is useful for switch cases.
type AirConditioningDataSetZoneGroupOnExactly interface {
	AirConditioningDataSetZoneGroupOn
	isAirConditioningDataSetZoneGroupOn() bool
}

// _AirConditioningDataSetZoneGroupOn is the data-structure of this message
type _AirConditioningDataSetZoneGroupOn struct {
	*_AirConditioningData
	ZoneGroup byte
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AirConditioningDataSetZoneGroupOn) InitializeParent(parent AirConditioningData, commandTypeContainer AirConditioningCommandTypeContainer) {
	m.CommandTypeContainer = commandTypeContainer
}

func (m *_AirConditioningDataSetZoneGroupOn) GetParent() AirConditioningData {
	return m._AirConditioningData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_AirConditioningDataSetZoneGroupOn) GetZoneGroup() byte {
	return m.ZoneGroup
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewAirConditioningDataSetZoneGroupOn factory function for _AirConditioningDataSetZoneGroupOn
func NewAirConditioningDataSetZoneGroupOn(zoneGroup byte, commandTypeContainer AirConditioningCommandTypeContainer) *_AirConditioningDataSetZoneGroupOn {
	_result := &_AirConditioningDataSetZoneGroupOn{
		ZoneGroup:            zoneGroup,
		_AirConditioningData: NewAirConditioningData(commandTypeContainer),
	}
	_result._AirConditioningData._AirConditioningDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastAirConditioningDataSetZoneGroupOn(structType interface{}) AirConditioningDataSetZoneGroupOn {
	if casted, ok := structType.(AirConditioningDataSetZoneGroupOn); ok {
		return casted
	}
	if casted, ok := structType.(*AirConditioningDataSetZoneGroupOn); ok {
		return *casted
	}
	return nil
}

func (m *_AirConditioningDataSetZoneGroupOn) GetTypeName() string {
	return "AirConditioningDataSetZoneGroupOn"
}

func (m *_AirConditioningDataSetZoneGroupOn) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_AirConditioningDataSetZoneGroupOn) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (zoneGroup)
	lengthInBits += 8

	return lengthInBits
}

func (m *_AirConditioningDataSetZoneGroupOn) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func AirConditioningDataSetZoneGroupOnParse(readBuffer utils.ReadBuffer) (AirConditioningDataSetZoneGroupOn, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AirConditioningDataSetZoneGroupOn"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AirConditioningDataSetZoneGroupOn")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (zoneGroup)
	_zoneGroup, _zoneGroupErr := readBuffer.ReadByte("zoneGroup")
	if _zoneGroupErr != nil {
		return nil, errors.Wrap(_zoneGroupErr, "Error parsing 'zoneGroup' field of AirConditioningDataSetZoneGroupOn")
	}
	zoneGroup := _zoneGroup

	if closeErr := readBuffer.CloseContext("AirConditioningDataSetZoneGroupOn"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AirConditioningDataSetZoneGroupOn")
	}

	// Create a partially initialized instance
	_child := &_AirConditioningDataSetZoneGroupOn{
		_AirConditioningData: &_AirConditioningData{},
		ZoneGroup:            zoneGroup,
	}
	_child._AirConditioningData._AirConditioningDataChildRequirements = _child
	return _child, nil
}

func (m *_AirConditioningDataSetZoneGroupOn) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AirConditioningDataSetZoneGroupOn"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AirConditioningDataSetZoneGroupOn")
		}

		// Simple Field (zoneGroup)
		zoneGroup := byte(m.GetZoneGroup())
		_zoneGroupErr := writeBuffer.WriteByte("zoneGroup", (zoneGroup))
		if _zoneGroupErr != nil {
			return errors.Wrap(_zoneGroupErr, "Error serializing 'zoneGroup' field")
		}

		if popErr := writeBuffer.PopContext("AirConditioningDataSetZoneGroupOn"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AirConditioningDataSetZoneGroupOn")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_AirConditioningDataSetZoneGroupOn) isAirConditioningDataSetZoneGroupOn() bool {
	return true
}

func (m *_AirConditioningDataSetZoneGroupOn) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
