/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetTimeStamp is the corresponding interface of BACnetTimeStamp
type BACnetTimeStamp interface {
	utils.LengthAware
	utils.Serializable
	// GetPeekedTagHeader returns PeekedTagHeader (property field)
	GetPeekedTagHeader() BACnetTagHeader
	// GetPeekedTagNumber returns PeekedTagNumber (virtual field)
	GetPeekedTagNumber() uint8
}

// BACnetTimeStampExactly can be used when we want exactly this type and not a type which fulfills BACnetTimeStamp.
// This is useful for switch cases.
type BACnetTimeStampExactly interface {
	BACnetTimeStamp
	isBACnetTimeStamp() bool
}

// _BACnetTimeStamp is the data-structure of this message
type _BACnetTimeStamp struct {
	_BACnetTimeStampChildRequirements
	PeekedTagHeader BACnetTagHeader
}

type _BACnetTimeStampChildRequirements interface {
	utils.Serializable
	GetLengthInBits() uint16
	GetLengthInBitsConditional(lastItem bool) uint16
}

type BACnetTimeStampParent interface {
	SerializeParent(writeBuffer utils.WriteBuffer, child BACnetTimeStamp, serializeChildFunction func() error) error
	GetTypeName() string
}

type BACnetTimeStampChild interface {
	utils.Serializable
	InitializeParent(parent BACnetTimeStamp, peekedTagHeader BACnetTagHeader)
	GetParent() *BACnetTimeStamp

	GetTypeName() string
	BACnetTimeStamp
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetTimeStamp) GetPeekedTagHeader() BACnetTagHeader {
	return m.PeekedTagHeader
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetTimeStamp) GetPeekedTagNumber() uint8 {
	return uint8(m.GetPeekedTagHeader().GetActualTagNumber())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetTimeStamp factory function for _BACnetTimeStamp
func NewBACnetTimeStamp(peekedTagHeader BACnetTagHeader) *_BACnetTimeStamp {
	return &_BACnetTimeStamp{PeekedTagHeader: peekedTagHeader}
}

// Deprecated: use the interface for direct cast
func CastBACnetTimeStamp(structType interface{}) BACnetTimeStamp {
	if casted, ok := structType.(BACnetTimeStamp); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetTimeStamp); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetTimeStamp) GetTypeName() string {
	return "BACnetTimeStamp"
}

func (m *_BACnetTimeStamp) GetParentLengthInBits() uint16 {
	lengthInBits := uint16(0)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetTimeStamp) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetTimeStampParse(readBuffer utils.ReadBuffer) (BACnetTimeStamp, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetTimeStamp"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetTimeStamp")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Peek Field (peekedTagHeader)
	currentPos = positionAware.GetPos()
	if pullErr := readBuffer.PullContext("peekedTagHeader"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for peekedTagHeader")
	}
	peekedTagHeader, _ := BACnetTagHeaderParse(readBuffer)
	readBuffer.Reset(currentPos)

	// Virtual field
	_peekedTagNumber := peekedTagHeader.GetActualTagNumber()
	peekedTagNumber := uint8(_peekedTagNumber)
	_ = peekedTagNumber

	// Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
	type BACnetTimeStampChildSerializeRequirement interface {
		BACnetTimeStamp
		InitializeParent(BACnetTimeStamp, BACnetTagHeader)
		GetParent() BACnetTimeStamp
	}
	var _childTemp interface{}
	var _child BACnetTimeStampChildSerializeRequirement
	var typeSwitchError error
	switch {
	case peekedTagNumber == uint8(0): // BACnetTimeStampTime
		_childTemp, typeSwitchError = BACnetTimeStampTimeParse(readBuffer)
	case peekedTagNumber == uint8(1): // BACnetTimeStampSequence
		_childTemp, typeSwitchError = BACnetTimeStampSequenceParse(readBuffer)
	case peekedTagNumber == uint8(2): // BACnetTimeStampDateTime
		_childTemp, typeSwitchError = BACnetTimeStampDateTimeParse(readBuffer)
	default:
		typeSwitchError = errors.Errorf("Unmapped type for parameters [peekedTagNumber=%v]", peekedTagNumber)
	}
	if typeSwitchError != nil {
		return nil, errors.Wrap(typeSwitchError, "Error parsing sub-type for type-switch of BACnetTimeStamp")
	}
	_child = _childTemp.(BACnetTimeStampChildSerializeRequirement)

	if closeErr := readBuffer.CloseContext("BACnetTimeStamp"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetTimeStamp")
	}

	// Finish initializing
	_child.InitializeParent(_child, peekedTagHeader)
	return _child, nil
}

func (pm *_BACnetTimeStamp) SerializeParent(writeBuffer utils.WriteBuffer, child BACnetTimeStamp, serializeChildFunction func() error) error {
	// We redirect all calls through client as some methods are only implemented there
	m := child
	_ = m
	positionAware := writeBuffer
	_ = positionAware
	if pushErr := writeBuffer.PushContext("BACnetTimeStamp"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetTimeStamp")
	}
	// Virtual field
	if _peekedTagNumberErr := writeBuffer.WriteVirtual("peekedTagNumber", m.GetPeekedTagNumber()); _peekedTagNumberErr != nil {
		return errors.Wrap(_peekedTagNumberErr, "Error serializing 'peekedTagNumber' field")
	}

	// Switch field (Depending on the discriminator values, passes the serialization to a sub-type)
	if _typeSwitchErr := serializeChildFunction(); _typeSwitchErr != nil {
		return errors.Wrap(_typeSwitchErr, "Error serializing sub-type field")
	}

	if popErr := writeBuffer.PopContext("BACnetTimeStamp"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetTimeStamp")
	}
	return nil
}

func (m *_BACnetTimeStamp) isBACnetTimeStamp() bool {
	return true
}

func (m *_BACnetTimeStamp) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
