/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetEngineeringUnits is an enum
type BACnetEngineeringUnits uint32

type IBACnetEngineeringUnits interface {
	Serialize(writeBuffer utils.WriteBuffer) error
}

const (
	BACnetEngineeringUnits_METERS_PER_SECOND_PER_SECOND           BACnetEngineeringUnits = 166
	BACnetEngineeringUnits_SQUARE_METERS                          BACnetEngineeringUnits = 0
	BACnetEngineeringUnits_SQUARE_CENTIMETERS                     BACnetEngineeringUnits = 116
	BACnetEngineeringUnits_SQUARE_FEET                            BACnetEngineeringUnits = 1
	BACnetEngineeringUnits_SQUARE_INCHES                          BACnetEngineeringUnits = 115
	BACnetEngineeringUnits_CURRENCY1                              BACnetEngineeringUnits = 105
	BACnetEngineeringUnits_CURRENCY2                              BACnetEngineeringUnits = 106
	BACnetEngineeringUnits_CURRENCY3                              BACnetEngineeringUnits = 107
	BACnetEngineeringUnits_CURRENCY4                              BACnetEngineeringUnits = 108
	BACnetEngineeringUnits_CURRENCY5                              BACnetEngineeringUnits = 109
	BACnetEngineeringUnits_CURRENCY6                              BACnetEngineeringUnits = 110
	BACnetEngineeringUnits_CURRENCY7                              BACnetEngineeringUnits = 111
	BACnetEngineeringUnits_CURRENCY8                              BACnetEngineeringUnits = 112
	BACnetEngineeringUnits_CURRENCY9                              BACnetEngineeringUnits = 113
	BACnetEngineeringUnits_CURRENCY10                             BACnetEngineeringUnits = 114
	BACnetEngineeringUnits_MILLIAMPERES                           BACnetEngineeringUnits = 2
	BACnetEngineeringUnits_AMPERES                                BACnetEngineeringUnits = 3
	BACnetEngineeringUnits_AMPERES_PER_METER                      BACnetEngineeringUnits = 167
	BACnetEngineeringUnits_AMPERES_PER_SQUARE_METER               BACnetEngineeringUnits = 168
	BACnetEngineeringUnits_AMPERE_SQUARE_METERS                   BACnetEngineeringUnits = 169
	BACnetEngineeringUnits_DECIBELS                               BACnetEngineeringUnits = 199
	BACnetEngineeringUnits_DECIBELS_MILLIVOLT                     BACnetEngineeringUnits = 200
	BACnetEngineeringUnits_DECIBELS_VOLT                          BACnetEngineeringUnits = 201
	BACnetEngineeringUnits_FARADS                                 BACnetEngineeringUnits = 170
	BACnetEngineeringUnits_HENRYS                                 BACnetEngineeringUnits = 171
	BACnetEngineeringUnits_OHMS                                   BACnetEngineeringUnits = 4
	BACnetEngineeringUnits_OHM_METER_SQUARED_PER_METER            BACnetEngineeringUnits = 237
	BACnetEngineeringUnits_OHM_METERS                             BACnetEngineeringUnits = 172
	BACnetEngineeringUnits_MILLIOHMS                              BACnetEngineeringUnits = 145
	BACnetEngineeringUnits_KILOHMS                                BACnetEngineeringUnits = 122
	BACnetEngineeringUnits_MEGOHMS                                BACnetEngineeringUnits = 123
	BACnetEngineeringUnits_MICROSIEMENS                           BACnetEngineeringUnits = 190
	BACnetEngineeringUnits_MILLISIEMENS                           BACnetEngineeringUnits = 202
	BACnetEngineeringUnits_SIEMENS                                BACnetEngineeringUnits = 173
	BACnetEngineeringUnits_SIEMENS_PER_METER                      BACnetEngineeringUnits = 174
	BACnetEngineeringUnits_TESLAS                                 BACnetEngineeringUnits = 175
	BACnetEngineeringUnits_VOLTS                                  BACnetEngineeringUnits = 5
	BACnetEngineeringUnits_MILLIVOLTS                             BACnetEngineeringUnits = 124
	BACnetEngineeringUnits_KILOVOLTS                              BACnetEngineeringUnits = 6
	BACnetEngineeringUnits_MEGAVOLTS                              BACnetEngineeringUnits = 7
	BACnetEngineeringUnits_VOLT_AMPERES                           BACnetEngineeringUnits = 8
	BACnetEngineeringUnits_KILOVOLT_AMPERES                       BACnetEngineeringUnits = 9
	BACnetEngineeringUnits_MEGAVOLT_AMPERES                       BACnetEngineeringUnits = 10
	BACnetEngineeringUnits_VOLT_AMPERES_REACTIVE                  BACnetEngineeringUnits = 11
	BACnetEngineeringUnits_KILOVOLT_AMPERES_REACTIVE              BACnetEngineeringUnits = 12
	BACnetEngineeringUnits_MEGAVOLT_AMPERES_REACTIVE              BACnetEngineeringUnits = 13
	BACnetEngineeringUnits_VOLTS_PER_DEGREE_KELVIN                BACnetEngineeringUnits = 176
	BACnetEngineeringUnits_VOLTS_PER_METER                        BACnetEngineeringUnits = 177
	BACnetEngineeringUnits_DEGREES_PHASE                          BACnetEngineeringUnits = 14
	BACnetEngineeringUnits_POWER_FACTOR                           BACnetEngineeringUnits = 15
	BACnetEngineeringUnits_WEBERS                                 BACnetEngineeringUnits = 178
	BACnetEngineeringUnits_AMPERE_SECONDS                         BACnetEngineeringUnits = 238
	BACnetEngineeringUnits_VOLT_AMPERE_HOURS                      BACnetEngineeringUnits = 239
	BACnetEngineeringUnits_KILOVOLT_AMPERE_HOURS                  BACnetEngineeringUnits = 240
	BACnetEngineeringUnits_MEGAVOLT_AMPERE_HOURS                  BACnetEngineeringUnits = 241
	BACnetEngineeringUnits_VOLT_AMPERE_HOURS_REACTIVE             BACnetEngineeringUnits = 242
	BACnetEngineeringUnits_KILOVOLT_AMPERE_HOURS_REACTIVE         BACnetEngineeringUnits = 243
	BACnetEngineeringUnits_MEGAVOLT_AMPERE_HOURS_REACTIVE         BACnetEngineeringUnits = 244
	BACnetEngineeringUnits_VOLT_SQUARE_HOURS                      BACnetEngineeringUnits = 245
	BACnetEngineeringUnits_AMPERE_SQUARE_HOURS                    BACnetEngineeringUnits = 246
	BACnetEngineeringUnits_JOULES                                 BACnetEngineeringUnits = 16
	BACnetEngineeringUnits_KILOJOULES                             BACnetEngineeringUnits = 17
	BACnetEngineeringUnits_KILOJOULES_PER_KILOGRAM                BACnetEngineeringUnits = 125
	BACnetEngineeringUnits_MEGAJOULES                             BACnetEngineeringUnits = 126
	BACnetEngineeringUnits_WATT_HOURS                             BACnetEngineeringUnits = 18
	BACnetEngineeringUnits_KILOWATT_HOURS                         BACnetEngineeringUnits = 19
	BACnetEngineeringUnits_MEGAWATT_HOURS                         BACnetEngineeringUnits = 146
	BACnetEngineeringUnits_WATT_HOURS_REACTIVE                    BACnetEngineeringUnits = 203
	BACnetEngineeringUnits_KILOWATT_HOURS_REACTIVE                BACnetEngineeringUnits = 204
	BACnetEngineeringUnits_MEGAWATT_HOURS_REACTIVE                BACnetEngineeringUnits = 205
	BACnetEngineeringUnits_BTUS                                   BACnetEngineeringUnits = 20
	BACnetEngineeringUnits_KILO_BTUS                              BACnetEngineeringUnits = 147
	BACnetEngineeringUnits_MEGA_BTUS                              BACnetEngineeringUnits = 148
	BACnetEngineeringUnits_THERMS                                 BACnetEngineeringUnits = 21
	BACnetEngineeringUnits_TON_HOURS                              BACnetEngineeringUnits = 22
	BACnetEngineeringUnits_JOULES_PER_KILOGRAM_DRY_AIR            BACnetEngineeringUnits = 23
	BACnetEngineeringUnits_KILOJOULES_PER_KILOGRAM_DRY_AIR        BACnetEngineeringUnits = 149
	BACnetEngineeringUnits_MEGAJOULES_PER_KILOGRAM_DRY_AIR        BACnetEngineeringUnits = 150
	BACnetEngineeringUnits_BTUS_PER_POUND_DRY_AIR                 BACnetEngineeringUnits = 24
	BACnetEngineeringUnits_BTUS_PER_POUND                         BACnetEngineeringUnits = 117
	BACnetEngineeringUnits_GRAMS_OF_WATER_PER_KILOGRAM_DRY_AIR    BACnetEngineeringUnits = 28
	BACnetEngineeringUnits_PERCENT_RELATIVE_HUMIDITY              BACnetEngineeringUnits = 29
	BACnetEngineeringUnits_MICROMETERS                            BACnetEngineeringUnits = 194
	BACnetEngineeringUnits_MILLIMETERS                            BACnetEngineeringUnits = 30
	BACnetEngineeringUnits_CENTIMETERS                            BACnetEngineeringUnits = 118
	BACnetEngineeringUnits_KILOMETERS                             BACnetEngineeringUnits = 193
	BACnetEngineeringUnits_METERS                                 BACnetEngineeringUnits = 31
	BACnetEngineeringUnits_INCHES                                 BACnetEngineeringUnits = 32
	BACnetEngineeringUnits_FEET                                   BACnetEngineeringUnits = 33
	BACnetEngineeringUnits_CANDELAS                               BACnetEngineeringUnits = 179
	BACnetEngineeringUnits_CANDELAS_PER_SQUARE_METER              BACnetEngineeringUnits = 180
	BACnetEngineeringUnits_WATTS_PER_SQUARE_FOOT                  BACnetEngineeringUnits = 34
	BACnetEngineeringUnits_WATTS_PER_SQUARE_METER                 BACnetEngineeringUnits = 35
	BACnetEngineeringUnits_LUMENS                                 BACnetEngineeringUnits = 36
	BACnetEngineeringUnits_LUXES                                  BACnetEngineeringUnits = 37
	BACnetEngineeringUnits_FOOT_CANDLES                           BACnetEngineeringUnits = 38
	BACnetEngineeringUnits_MILLIGRAMS                             BACnetEngineeringUnits = 196
	BACnetEngineeringUnits_GRAMS                                  BACnetEngineeringUnits = 195
	BACnetEngineeringUnits_KILOGRAMS                              BACnetEngineeringUnits = 39
	BACnetEngineeringUnits_POUNDS_MASS                            BACnetEngineeringUnits = 40
	BACnetEngineeringUnits_TONS                                   BACnetEngineeringUnits = 41
	BACnetEngineeringUnits_GRAMS_PER_SECOND                       BACnetEngineeringUnits = 154
	BACnetEngineeringUnits_GRAMS_PER_MINUTE                       BACnetEngineeringUnits = 155
	BACnetEngineeringUnits_KILOGRAMS_PER_SECOND                   BACnetEngineeringUnits = 42
	BACnetEngineeringUnits_KILOGRAMS_PER_MINUTE                   BACnetEngineeringUnits = 43
	BACnetEngineeringUnits_KILOGRAMS_PER_HOUR                     BACnetEngineeringUnits = 44
	BACnetEngineeringUnits_POUNDS_MASS_PER_SECOND                 BACnetEngineeringUnits = 119
	BACnetEngineeringUnits_POUNDS_MASS_PER_MINUTE                 BACnetEngineeringUnits = 45
	BACnetEngineeringUnits_POUNDS_MASS_PER_HOUR                   BACnetEngineeringUnits = 46
	BACnetEngineeringUnits_TONS_PER_HOUR                          BACnetEngineeringUnits = 156
	BACnetEngineeringUnits_IWATTS                                 BACnetEngineeringUnits = 132
	BACnetEngineeringUnits_WATTS                                  BACnetEngineeringUnits = 47
	BACnetEngineeringUnits_KILOWATTS                              BACnetEngineeringUnits = 48
	BACnetEngineeringUnits_MEGAWATTS                              BACnetEngineeringUnits = 49
	BACnetEngineeringUnits_BTUS_PER_HOUR                          BACnetEngineeringUnits = 50
	BACnetEngineeringUnits_KILO_BTUS_PER_HOUR                     BACnetEngineeringUnits = 157
	BACnetEngineeringUnits_JOULE_PER_HOURS                        BACnetEngineeringUnits = 247
	BACnetEngineeringUnits_HORSEPOWER                             BACnetEngineeringUnits = 51
	BACnetEngineeringUnits_TONS_REFRIGERATION                     BACnetEngineeringUnits = 52
	BACnetEngineeringUnits_PASCALS                                BACnetEngineeringUnits = 53
	BACnetEngineeringUnits_HECTOPASCALS                           BACnetEngineeringUnits = 133
	BACnetEngineeringUnits_KILOPASCALS                            BACnetEngineeringUnits = 54
	BACnetEngineeringUnits_MILLIBARS                              BACnetEngineeringUnits = 134
	BACnetEngineeringUnits_BARS                                   BACnetEngineeringUnits = 55
	BACnetEngineeringUnits_POUNDS_FORCE_PER_SQUARE_INCH           BACnetEngineeringUnits = 56
	BACnetEngineeringUnits_MILLIMETERS_OF_WATER                   BACnetEngineeringUnits = 206
	BACnetEngineeringUnits_CENTIMETERS_OF_WATER                   BACnetEngineeringUnits = 57
	BACnetEngineeringUnits_INCHES_OF_WATER                        BACnetEngineeringUnits = 58
	BACnetEngineeringUnits_MILLIMETERS_OF_MERCURY                 BACnetEngineeringUnits = 59
	BACnetEngineeringUnits_CENTIMETERS_OF_MERCURY                 BACnetEngineeringUnits = 60
	BACnetEngineeringUnits_INCHES_OF_MERCURY                      BACnetEngineeringUnits = 61
	BACnetEngineeringUnits_DEGREES_CELSIUS                        BACnetEngineeringUnits = 62
	BACnetEngineeringUnits_DEGREES_KELVIN                         BACnetEngineeringUnits = 63
	BACnetEngineeringUnits_DEGREES_KELVIN_PER_HOUR                BACnetEngineeringUnits = 181
	BACnetEngineeringUnits_DEGREES_KELVIN_PER_MINUTE              BACnetEngineeringUnits = 182
	BACnetEngineeringUnits_DEGREES_FAHRENHEIT                     BACnetEngineeringUnits = 64
	BACnetEngineeringUnits_DEGREE_DAYS_CELSIUS                    BACnetEngineeringUnits = 65
	BACnetEngineeringUnits_DEGREE_DAYS_FAHRENHEIT                 BACnetEngineeringUnits = 66
	BACnetEngineeringUnits_DELTA_DEGREES_FAHRENHEIT               BACnetEngineeringUnits = 120
	BACnetEngineeringUnits_DELTA_DEGREES_KELVIN                   BACnetEngineeringUnits = 121
	BACnetEngineeringUnits_YEARS                                  BACnetEngineeringUnits = 67
	BACnetEngineeringUnits_MONTHS                                 BACnetEngineeringUnits = 68
	BACnetEngineeringUnits_WEEKS                                  BACnetEngineeringUnits = 69
	BACnetEngineeringUnits_DAYS                                   BACnetEngineeringUnits = 70
	BACnetEngineeringUnits_HOURS                                  BACnetEngineeringUnits = 71
	BACnetEngineeringUnits_MINUTES                                BACnetEngineeringUnits = 72
	BACnetEngineeringUnits_SECONDS                                BACnetEngineeringUnits = 73
	BACnetEngineeringUnits_HUNDREDTHS_SECONDS                     BACnetEngineeringUnits = 158
	BACnetEngineeringUnits_MILLISECONDS                           BACnetEngineeringUnits = 159
	BACnetEngineeringUnits_NEWTON_METERS                          BACnetEngineeringUnits = 160
	BACnetEngineeringUnits_MILLIMETERS_PER_SECOND                 BACnetEngineeringUnits = 161
	BACnetEngineeringUnits_MILLIMETERS_PER_MINUTE                 BACnetEngineeringUnits = 162
	BACnetEngineeringUnits_METERS_PER_SECOND                      BACnetEngineeringUnits = 74
	BACnetEngineeringUnits_METERS_PER_MINUTE                      BACnetEngineeringUnits = 163
	BACnetEngineeringUnits_METERS_PER_HOUR                        BACnetEngineeringUnits = 164
	BACnetEngineeringUnits_KILOMETERS_PER_HOUR                    BACnetEngineeringUnits = 75
	BACnetEngineeringUnits_FEET_PER_SECOND                        BACnetEngineeringUnits = 76
	BACnetEngineeringUnits_FEET_PER_MINUTE                        BACnetEngineeringUnits = 77
	BACnetEngineeringUnits_MILES_PER_HOUR                         BACnetEngineeringUnits = 78
	BACnetEngineeringUnits_CUBIC_FEET                             BACnetEngineeringUnits = 79
	BACnetEngineeringUnits_CUBIC_METERS                           BACnetEngineeringUnits = 80
	BACnetEngineeringUnits_IMPERIAL_GALLONS                       BACnetEngineeringUnits = 81
	BACnetEngineeringUnits_MILLILITERS                            BACnetEngineeringUnits = 197
	BACnetEngineeringUnits_LITERS                                 BACnetEngineeringUnits = 82
	BACnetEngineeringUnits_US_GALLONS                             BACnetEngineeringUnits = 83
	BACnetEngineeringUnits_CUBIC_FEET_PER_SECOND                  BACnetEngineeringUnits = 142
	BACnetEngineeringUnits_CUBIC_FEET_PER_MINUTE                  BACnetEngineeringUnits = 84
	BACnetEngineeringUnits_MILLION_STANDARD_CUBIC_FEET_PER_MINUTE BACnetEngineeringUnits = 254
	BACnetEngineeringUnits_CUBIC_FEET_PER_HOUR                    BACnetEngineeringUnits = 191
	BACnetEngineeringUnits_CUBIC_FEET_PER_DAY                     BACnetEngineeringUnits = 248
	BACnetEngineeringUnits_STANDARD_CUBIC_FEET_PER_DAY            BACnetEngineeringUnits = 47808
	BACnetEngineeringUnits_MILLION_STANDARD_CUBIC_FEET_PER_DAY    BACnetEngineeringUnits = 47809
	BACnetEngineeringUnits_THOUSAND_CUBIC_FEET_PER_DAY            BACnetEngineeringUnits = 47810
	BACnetEngineeringUnits_THOUSAND_STANDARD_CUBIC_FEET_PER_DAY   BACnetEngineeringUnits = 47811
	BACnetEngineeringUnits_POUNDS_MASS_PER_DAY                    BACnetEngineeringUnits = 47812
	BACnetEngineeringUnits_CUBIC_METERS_PER_SECOND                BACnetEngineeringUnits = 85
	BACnetEngineeringUnits_CUBIC_METERS_PER_MINUTE                BACnetEngineeringUnits = 165
	BACnetEngineeringUnits_CUBIC_METERS_PER_HOUR                  BACnetEngineeringUnits = 135
	BACnetEngineeringUnits_CUBIC_METERS_PER_DAY                   BACnetEngineeringUnits = 249
	BACnetEngineeringUnits_IMPERIAL_GALLONS_PER_MINUTE            BACnetEngineeringUnits = 86
	BACnetEngineeringUnits_MILLILITERS_PER_SECOND                 BACnetEngineeringUnits = 198
	BACnetEngineeringUnits_LITERS_PER_SECOND                      BACnetEngineeringUnits = 87
	BACnetEngineeringUnits_LITERS_PER_MINUTE                      BACnetEngineeringUnits = 88
	BACnetEngineeringUnits_LITERS_PER_HOUR                        BACnetEngineeringUnits = 136
	BACnetEngineeringUnits_US_GALLONS_PER_MINUTE                  BACnetEngineeringUnits = 89
	BACnetEngineeringUnits_US_GALLONS_PER_HOUR                    BACnetEngineeringUnits = 192
	BACnetEngineeringUnits_DEGREES_ANGULAR                        BACnetEngineeringUnits = 90
	BACnetEngineeringUnits_DEGREES_CELSIUS_PER_HOUR               BACnetEngineeringUnits = 91
	BACnetEngineeringUnits_DEGREES_CELSIUS_PER_MINUTE             BACnetEngineeringUnits = 92
	BACnetEngineeringUnits_DEGREES_FAHRENHEIT_PER_HOUR            BACnetEngineeringUnits = 93
	BACnetEngineeringUnits_DEGREES_FAHRENHEIT_PER_MINUTE          BACnetEngineeringUnits = 94
	BACnetEngineeringUnits_JOULE_SECONDS                          BACnetEngineeringUnits = 183
	BACnetEngineeringUnits_KILOGRAMS_PER_CUBIC_METER              BACnetEngineeringUnits = 186
	BACnetEngineeringUnits_KILOWATT_HOURS_PER_SQUARE_METER        BACnetEngineeringUnits = 137
	BACnetEngineeringUnits_KILOWATT_HOURS_PER_SQUARE_FOOT         BACnetEngineeringUnits = 138
	BACnetEngineeringUnits_WATT_HOURS_PER_CUBIC_METER             BACnetEngineeringUnits = 250
	BACnetEngineeringUnits_JOULES_PER_CUBIC_METER                 BACnetEngineeringUnits = 251
	BACnetEngineeringUnits_MEGAJOULES_PER_SQUARE_METER            BACnetEngineeringUnits = 139
	BACnetEngineeringUnits_MEGAJOULES_PER_SQUARE_FOOT             BACnetEngineeringUnits = 140
	BACnetEngineeringUnits_MOLE_PERCENT                           BACnetEngineeringUnits = 252
	BACnetEngineeringUnits_NO_UNITS                               BACnetEngineeringUnits = 95
	BACnetEngineeringUnits_NEWTON_SECONDS                         BACnetEngineeringUnits = 187
	BACnetEngineeringUnits_NEWTONS_PER_METER                      BACnetEngineeringUnits = 188
	BACnetEngineeringUnits_PARTS_PER_MILLION                      BACnetEngineeringUnits = 96
	BACnetEngineeringUnits_PARTS_PER_BILLION                      BACnetEngineeringUnits = 97
	BACnetEngineeringUnits_PASCAL_SECONDS                         BACnetEngineeringUnits = 253
	BACnetEngineeringUnits_PERCENT                                BACnetEngineeringUnits = 98
	BACnetEngineeringUnits_PERCENT_OBSCURATION_PER_FOOT           BACnetEngineeringUnits = 143
	BACnetEngineeringUnits_PERCENT_OBSCURATION_PER_METER          BACnetEngineeringUnits = 144
	BACnetEngineeringUnits_PERCENT_PER_SECOND                     BACnetEngineeringUnits = 99
	BACnetEngineeringUnits_PER_MINUTE                             BACnetEngineeringUnits = 100
	BACnetEngineeringUnits_PER_SECOND                             BACnetEngineeringUnits = 101
	BACnetEngineeringUnits_PSI_PER_DEGREE_FAHRENHEIT              BACnetEngineeringUnits = 102
	BACnetEngineeringUnits_RADIANS                                BACnetEngineeringUnits = 103
	BACnetEngineeringUnits_RADIANS_PER_SECOND                     BACnetEngineeringUnits = 184
	BACnetEngineeringUnits_REVOLUTIONS_PER_MINUTE                 BACnetEngineeringUnits = 104
	BACnetEngineeringUnits_SQUARE_METERS_PER_NEWTON               BACnetEngineeringUnits = 185
	BACnetEngineeringUnits_WATTS_PER_METER_PER_DEGREE_KELVIN      BACnetEngineeringUnits = 189
	BACnetEngineeringUnits_WATTS_PER_SQUARE_METER_DEGREE_KELVIN   BACnetEngineeringUnits = 141
	BACnetEngineeringUnits_PER_MILLE                              BACnetEngineeringUnits = 207
	BACnetEngineeringUnits_GRAMS_PER_GRAM                         BACnetEngineeringUnits = 208
	BACnetEngineeringUnits_KILOGRAMS_PER_KILOGRAM                 BACnetEngineeringUnits = 209
	BACnetEngineeringUnits_GRAMS_PER_KILOGRAM                     BACnetEngineeringUnits = 210
	BACnetEngineeringUnits_MILLIGRAMS_PER_GRAM                    BACnetEngineeringUnits = 211
	BACnetEngineeringUnits_MILLIGRAMS_PER_KILOGRAM                BACnetEngineeringUnits = 212
	BACnetEngineeringUnits_GRAMS_PER_MILLILITER                   BACnetEngineeringUnits = 213
	BACnetEngineeringUnits_GRAMS_PER_LITER                        BACnetEngineeringUnits = 214
	BACnetEngineeringUnits_MILLIGRAMS_PER_LITER                   BACnetEngineeringUnits = 215
	BACnetEngineeringUnits_MICROGRAMS_PER_LITER                   BACnetEngineeringUnits = 216
	BACnetEngineeringUnits_GRAMS_PER_CUBIC_METER                  BACnetEngineeringUnits = 217
	BACnetEngineeringUnits_MILLIGRAMS_PER_CUBIC_METER             BACnetEngineeringUnits = 218
	BACnetEngineeringUnits_MICROGRAMS_PER_CUBIC_METER             BACnetEngineeringUnits = 219
	BACnetEngineeringUnits_NANOGRAMS_PER_CUBIC_METER              BACnetEngineeringUnits = 220
	BACnetEngineeringUnits_GRAMS_PER_CUBIC_CENTIMETER             BACnetEngineeringUnits = 221
	BACnetEngineeringUnits_BECQUERELS                             BACnetEngineeringUnits = 222
	BACnetEngineeringUnits_KILOBECQUERELS                         BACnetEngineeringUnits = 223
	BACnetEngineeringUnits_MEGABECQUERELS                         BACnetEngineeringUnits = 224
	BACnetEngineeringUnits_GRAY                                   BACnetEngineeringUnits = 225
	BACnetEngineeringUnits_MILLIGRAY                              BACnetEngineeringUnits = 226
	BACnetEngineeringUnits_MICROGRAY                              BACnetEngineeringUnits = 227
	BACnetEngineeringUnits_SIEVERTS                               BACnetEngineeringUnits = 228
	BACnetEngineeringUnits_MILLISIEVERTS                          BACnetEngineeringUnits = 229
	BACnetEngineeringUnits_MICROSIEVERTS                          BACnetEngineeringUnits = 230
	BACnetEngineeringUnits_MICROSIEVERTS_PER_HOUR                 BACnetEngineeringUnits = 231
	BACnetEngineeringUnits_MILLIREMS                              BACnetEngineeringUnits = 47814
	BACnetEngineeringUnits_MILLIREMS_PER_HOUR                     BACnetEngineeringUnits = 47815
	BACnetEngineeringUnits_DECIBELS_A                             BACnetEngineeringUnits = 232
	BACnetEngineeringUnits_NEPHELOMETRIC_TURBIDITY_UNIT           BACnetEngineeringUnits = 233
	BACnetEngineeringUnits_P_H                                    BACnetEngineeringUnits = 234
	BACnetEngineeringUnits_GRAMS_PER_SQUARE_METER                 BACnetEngineeringUnits = 235
	BACnetEngineeringUnits_MINUTES_PER_DEGREE_KELVIN              BACnetEngineeringUnits = 236
	BACnetEngineeringUnits_VENDOR_PROPRIETARY_VALUE               BACnetEngineeringUnits = 0xFF
)

var BACnetEngineeringUnitsValues []BACnetEngineeringUnits

func init() {
	_ = errors.New
	BACnetEngineeringUnitsValues = []BACnetEngineeringUnits{
		BACnetEngineeringUnits_METERS_PER_SECOND_PER_SECOND,
		BACnetEngineeringUnits_SQUARE_METERS,
		BACnetEngineeringUnits_SQUARE_CENTIMETERS,
		BACnetEngineeringUnits_SQUARE_FEET,
		BACnetEngineeringUnits_SQUARE_INCHES,
		BACnetEngineeringUnits_CURRENCY1,
		BACnetEngineeringUnits_CURRENCY2,
		BACnetEngineeringUnits_CURRENCY3,
		BACnetEngineeringUnits_CURRENCY4,
		BACnetEngineeringUnits_CURRENCY5,
		BACnetEngineeringUnits_CURRENCY6,
		BACnetEngineeringUnits_CURRENCY7,
		BACnetEngineeringUnits_CURRENCY8,
		BACnetEngineeringUnits_CURRENCY9,
		BACnetEngineeringUnits_CURRENCY10,
		BACnetEngineeringUnits_MILLIAMPERES,
		BACnetEngineeringUnits_AMPERES,
		BACnetEngineeringUnits_AMPERES_PER_METER,
		BACnetEngineeringUnits_AMPERES_PER_SQUARE_METER,
		BACnetEngineeringUnits_AMPERE_SQUARE_METERS,
		BACnetEngineeringUnits_DECIBELS,
		BACnetEngineeringUnits_DECIBELS_MILLIVOLT,
		BACnetEngineeringUnits_DECIBELS_VOLT,
		BACnetEngineeringUnits_FARADS,
		BACnetEngineeringUnits_HENRYS,
		BACnetEngineeringUnits_OHMS,
		BACnetEngineeringUnits_OHM_METER_SQUARED_PER_METER,
		BACnetEngineeringUnits_OHM_METERS,
		BACnetEngineeringUnits_MILLIOHMS,
		BACnetEngineeringUnits_KILOHMS,
		BACnetEngineeringUnits_MEGOHMS,
		BACnetEngineeringUnits_MICROSIEMENS,
		BACnetEngineeringUnits_MILLISIEMENS,
		BACnetEngineeringUnits_SIEMENS,
		BACnetEngineeringUnits_SIEMENS_PER_METER,
		BACnetEngineeringUnits_TESLAS,
		BACnetEngineeringUnits_VOLTS,
		BACnetEngineeringUnits_MILLIVOLTS,
		BACnetEngineeringUnits_KILOVOLTS,
		BACnetEngineeringUnits_MEGAVOLTS,
		BACnetEngineeringUnits_VOLT_AMPERES,
		BACnetEngineeringUnits_KILOVOLT_AMPERES,
		BACnetEngineeringUnits_MEGAVOLT_AMPERES,
		BACnetEngineeringUnits_VOLT_AMPERES_REACTIVE,
		BACnetEngineeringUnits_KILOVOLT_AMPERES_REACTIVE,
		BACnetEngineeringUnits_MEGAVOLT_AMPERES_REACTIVE,
		BACnetEngineeringUnits_VOLTS_PER_DEGREE_KELVIN,
		BACnetEngineeringUnits_VOLTS_PER_METER,
		BACnetEngineeringUnits_DEGREES_PHASE,
		BACnetEngineeringUnits_POWER_FACTOR,
		BACnetEngineeringUnits_WEBERS,
		BACnetEngineeringUnits_AMPERE_SECONDS,
		BACnetEngineeringUnits_VOLT_AMPERE_HOURS,
		BACnetEngineeringUnits_KILOVOLT_AMPERE_HOURS,
		BACnetEngineeringUnits_MEGAVOLT_AMPERE_HOURS,
		BACnetEngineeringUnits_VOLT_AMPERE_HOURS_REACTIVE,
		BACnetEngineeringUnits_KILOVOLT_AMPERE_HOURS_REACTIVE,
		BACnetEngineeringUnits_MEGAVOLT_AMPERE_HOURS_REACTIVE,
		BACnetEngineeringUnits_VOLT_SQUARE_HOURS,
		BACnetEngineeringUnits_AMPERE_SQUARE_HOURS,
		BACnetEngineeringUnits_JOULES,
		BACnetEngineeringUnits_KILOJOULES,
		BACnetEngineeringUnits_KILOJOULES_PER_KILOGRAM,
		BACnetEngineeringUnits_MEGAJOULES,
		BACnetEngineeringUnits_WATT_HOURS,
		BACnetEngineeringUnits_KILOWATT_HOURS,
		BACnetEngineeringUnits_MEGAWATT_HOURS,
		BACnetEngineeringUnits_WATT_HOURS_REACTIVE,
		BACnetEngineeringUnits_KILOWATT_HOURS_REACTIVE,
		BACnetEngineeringUnits_MEGAWATT_HOURS_REACTIVE,
		BACnetEngineeringUnits_BTUS,
		BACnetEngineeringUnits_KILO_BTUS,
		BACnetEngineeringUnits_MEGA_BTUS,
		BACnetEngineeringUnits_THERMS,
		BACnetEngineeringUnits_TON_HOURS,
		BACnetEngineeringUnits_JOULES_PER_KILOGRAM_DRY_AIR,
		BACnetEngineeringUnits_KILOJOULES_PER_KILOGRAM_DRY_AIR,
		BACnetEngineeringUnits_MEGAJOULES_PER_KILOGRAM_DRY_AIR,
		BACnetEngineeringUnits_BTUS_PER_POUND_DRY_AIR,
		BACnetEngineeringUnits_BTUS_PER_POUND,
		BACnetEngineeringUnits_GRAMS_OF_WATER_PER_KILOGRAM_DRY_AIR,
		BACnetEngineeringUnits_PERCENT_RELATIVE_HUMIDITY,
		BACnetEngineeringUnits_MICROMETERS,
		BACnetEngineeringUnits_MILLIMETERS,
		BACnetEngineeringUnits_CENTIMETERS,
		BACnetEngineeringUnits_KILOMETERS,
		BACnetEngineeringUnits_METERS,
		BACnetEngineeringUnits_INCHES,
		BACnetEngineeringUnits_FEET,
		BACnetEngineeringUnits_CANDELAS,
		BACnetEngineeringUnits_CANDELAS_PER_SQUARE_METER,
		BACnetEngineeringUnits_WATTS_PER_SQUARE_FOOT,
		BACnetEngineeringUnits_WATTS_PER_SQUARE_METER,
		BACnetEngineeringUnits_LUMENS,
		BACnetEngineeringUnits_LUXES,
		BACnetEngineeringUnits_FOOT_CANDLES,
		BACnetEngineeringUnits_MILLIGRAMS,
		BACnetEngineeringUnits_GRAMS,
		BACnetEngineeringUnits_KILOGRAMS,
		BACnetEngineeringUnits_POUNDS_MASS,
		BACnetEngineeringUnits_TONS,
		BACnetEngineeringUnits_GRAMS_PER_SECOND,
		BACnetEngineeringUnits_GRAMS_PER_MINUTE,
		BACnetEngineeringUnits_KILOGRAMS_PER_SECOND,
		BACnetEngineeringUnits_KILOGRAMS_PER_MINUTE,
		BACnetEngineeringUnits_KILOGRAMS_PER_HOUR,
		BACnetEngineeringUnits_POUNDS_MASS_PER_SECOND,
		BACnetEngineeringUnits_POUNDS_MASS_PER_MINUTE,
		BACnetEngineeringUnits_POUNDS_MASS_PER_HOUR,
		BACnetEngineeringUnits_TONS_PER_HOUR,
		BACnetEngineeringUnits_IWATTS,
		BACnetEngineeringUnits_WATTS,
		BACnetEngineeringUnits_KILOWATTS,
		BACnetEngineeringUnits_MEGAWATTS,
		BACnetEngineeringUnits_BTUS_PER_HOUR,
		BACnetEngineeringUnits_KILO_BTUS_PER_HOUR,
		BACnetEngineeringUnits_JOULE_PER_HOURS,
		BACnetEngineeringUnits_HORSEPOWER,
		BACnetEngineeringUnits_TONS_REFRIGERATION,
		BACnetEngineeringUnits_PASCALS,
		BACnetEngineeringUnits_HECTOPASCALS,
		BACnetEngineeringUnits_KILOPASCALS,
		BACnetEngineeringUnits_MILLIBARS,
		BACnetEngineeringUnits_BARS,
		BACnetEngineeringUnits_POUNDS_FORCE_PER_SQUARE_INCH,
		BACnetEngineeringUnits_MILLIMETERS_OF_WATER,
		BACnetEngineeringUnits_CENTIMETERS_OF_WATER,
		BACnetEngineeringUnits_INCHES_OF_WATER,
		BACnetEngineeringUnits_MILLIMETERS_OF_MERCURY,
		BACnetEngineeringUnits_CENTIMETERS_OF_MERCURY,
		BACnetEngineeringUnits_INCHES_OF_MERCURY,
		BACnetEngineeringUnits_DEGREES_CELSIUS,
		BACnetEngineeringUnits_DEGREES_KELVIN,
		BACnetEngineeringUnits_DEGREES_KELVIN_PER_HOUR,
		BACnetEngineeringUnits_DEGREES_KELVIN_PER_MINUTE,
		BACnetEngineeringUnits_DEGREES_FAHRENHEIT,
		BACnetEngineeringUnits_DEGREE_DAYS_CELSIUS,
		BACnetEngineeringUnits_DEGREE_DAYS_FAHRENHEIT,
		BACnetEngineeringUnits_DELTA_DEGREES_FAHRENHEIT,
		BACnetEngineeringUnits_DELTA_DEGREES_KELVIN,
		BACnetEngineeringUnits_YEARS,
		BACnetEngineeringUnits_MONTHS,
		BACnetEngineeringUnits_WEEKS,
		BACnetEngineeringUnits_DAYS,
		BACnetEngineeringUnits_HOURS,
		BACnetEngineeringUnits_MINUTES,
		BACnetEngineeringUnits_SECONDS,
		BACnetEngineeringUnits_HUNDREDTHS_SECONDS,
		BACnetEngineeringUnits_MILLISECONDS,
		BACnetEngineeringUnits_NEWTON_METERS,
		BACnetEngineeringUnits_MILLIMETERS_PER_SECOND,
		BACnetEngineeringUnits_MILLIMETERS_PER_MINUTE,
		BACnetEngineeringUnits_METERS_PER_SECOND,
		BACnetEngineeringUnits_METERS_PER_MINUTE,
		BACnetEngineeringUnits_METERS_PER_HOUR,
		BACnetEngineeringUnits_KILOMETERS_PER_HOUR,
		BACnetEngineeringUnits_FEET_PER_SECOND,
		BACnetEngineeringUnits_FEET_PER_MINUTE,
		BACnetEngineeringUnits_MILES_PER_HOUR,
		BACnetEngineeringUnits_CUBIC_FEET,
		BACnetEngineeringUnits_CUBIC_METERS,
		BACnetEngineeringUnits_IMPERIAL_GALLONS,
		BACnetEngineeringUnits_MILLILITERS,
		BACnetEngineeringUnits_LITERS,
		BACnetEngineeringUnits_US_GALLONS,
		BACnetEngineeringUnits_CUBIC_FEET_PER_SECOND,
		BACnetEngineeringUnits_CUBIC_FEET_PER_MINUTE,
		BACnetEngineeringUnits_MILLION_STANDARD_CUBIC_FEET_PER_MINUTE,
		BACnetEngineeringUnits_CUBIC_FEET_PER_HOUR,
		BACnetEngineeringUnits_CUBIC_FEET_PER_DAY,
		BACnetEngineeringUnits_STANDARD_CUBIC_FEET_PER_DAY,
		BACnetEngineeringUnits_MILLION_STANDARD_CUBIC_FEET_PER_DAY,
		BACnetEngineeringUnits_THOUSAND_CUBIC_FEET_PER_DAY,
		BACnetEngineeringUnits_THOUSAND_STANDARD_CUBIC_FEET_PER_DAY,
		BACnetEngineeringUnits_POUNDS_MASS_PER_DAY,
		BACnetEngineeringUnits_CUBIC_METERS_PER_SECOND,
		BACnetEngineeringUnits_CUBIC_METERS_PER_MINUTE,
		BACnetEngineeringUnits_CUBIC_METERS_PER_HOUR,
		BACnetEngineeringUnits_CUBIC_METERS_PER_DAY,
		BACnetEngineeringUnits_IMPERIAL_GALLONS_PER_MINUTE,
		BACnetEngineeringUnits_MILLILITERS_PER_SECOND,
		BACnetEngineeringUnits_LITERS_PER_SECOND,
		BACnetEngineeringUnits_LITERS_PER_MINUTE,
		BACnetEngineeringUnits_LITERS_PER_HOUR,
		BACnetEngineeringUnits_US_GALLONS_PER_MINUTE,
		BACnetEngineeringUnits_US_GALLONS_PER_HOUR,
		BACnetEngineeringUnits_DEGREES_ANGULAR,
		BACnetEngineeringUnits_DEGREES_CELSIUS_PER_HOUR,
		BACnetEngineeringUnits_DEGREES_CELSIUS_PER_MINUTE,
		BACnetEngineeringUnits_DEGREES_FAHRENHEIT_PER_HOUR,
		BACnetEngineeringUnits_DEGREES_FAHRENHEIT_PER_MINUTE,
		BACnetEngineeringUnits_JOULE_SECONDS,
		BACnetEngineeringUnits_KILOGRAMS_PER_CUBIC_METER,
		BACnetEngineeringUnits_KILOWATT_HOURS_PER_SQUARE_METER,
		BACnetEngineeringUnits_KILOWATT_HOURS_PER_SQUARE_FOOT,
		BACnetEngineeringUnits_WATT_HOURS_PER_CUBIC_METER,
		BACnetEngineeringUnits_JOULES_PER_CUBIC_METER,
		BACnetEngineeringUnits_MEGAJOULES_PER_SQUARE_METER,
		BACnetEngineeringUnits_MEGAJOULES_PER_SQUARE_FOOT,
		BACnetEngineeringUnits_MOLE_PERCENT,
		BACnetEngineeringUnits_NO_UNITS,
		BACnetEngineeringUnits_NEWTON_SECONDS,
		BACnetEngineeringUnits_NEWTONS_PER_METER,
		BACnetEngineeringUnits_PARTS_PER_MILLION,
		BACnetEngineeringUnits_PARTS_PER_BILLION,
		BACnetEngineeringUnits_PASCAL_SECONDS,
		BACnetEngineeringUnits_PERCENT,
		BACnetEngineeringUnits_PERCENT_OBSCURATION_PER_FOOT,
		BACnetEngineeringUnits_PERCENT_OBSCURATION_PER_METER,
		BACnetEngineeringUnits_PERCENT_PER_SECOND,
		BACnetEngineeringUnits_PER_MINUTE,
		BACnetEngineeringUnits_PER_SECOND,
		BACnetEngineeringUnits_PSI_PER_DEGREE_FAHRENHEIT,
		BACnetEngineeringUnits_RADIANS,
		BACnetEngineeringUnits_RADIANS_PER_SECOND,
		BACnetEngineeringUnits_REVOLUTIONS_PER_MINUTE,
		BACnetEngineeringUnits_SQUARE_METERS_PER_NEWTON,
		BACnetEngineeringUnits_WATTS_PER_METER_PER_DEGREE_KELVIN,
		BACnetEngineeringUnits_WATTS_PER_SQUARE_METER_DEGREE_KELVIN,
		BACnetEngineeringUnits_PER_MILLE,
		BACnetEngineeringUnits_GRAMS_PER_GRAM,
		BACnetEngineeringUnits_KILOGRAMS_PER_KILOGRAM,
		BACnetEngineeringUnits_GRAMS_PER_KILOGRAM,
		BACnetEngineeringUnits_MILLIGRAMS_PER_GRAM,
		BACnetEngineeringUnits_MILLIGRAMS_PER_KILOGRAM,
		BACnetEngineeringUnits_GRAMS_PER_MILLILITER,
		BACnetEngineeringUnits_GRAMS_PER_LITER,
		BACnetEngineeringUnits_MILLIGRAMS_PER_LITER,
		BACnetEngineeringUnits_MICROGRAMS_PER_LITER,
		BACnetEngineeringUnits_GRAMS_PER_CUBIC_METER,
		BACnetEngineeringUnits_MILLIGRAMS_PER_CUBIC_METER,
		BACnetEngineeringUnits_MICROGRAMS_PER_CUBIC_METER,
		BACnetEngineeringUnits_NANOGRAMS_PER_CUBIC_METER,
		BACnetEngineeringUnits_GRAMS_PER_CUBIC_CENTIMETER,
		BACnetEngineeringUnits_BECQUERELS,
		BACnetEngineeringUnits_KILOBECQUERELS,
		BACnetEngineeringUnits_MEGABECQUERELS,
		BACnetEngineeringUnits_GRAY,
		BACnetEngineeringUnits_MILLIGRAY,
		BACnetEngineeringUnits_MICROGRAY,
		BACnetEngineeringUnits_SIEVERTS,
		BACnetEngineeringUnits_MILLISIEVERTS,
		BACnetEngineeringUnits_MICROSIEVERTS,
		BACnetEngineeringUnits_MICROSIEVERTS_PER_HOUR,
		BACnetEngineeringUnits_MILLIREMS,
		BACnetEngineeringUnits_MILLIREMS_PER_HOUR,
		BACnetEngineeringUnits_DECIBELS_A,
		BACnetEngineeringUnits_NEPHELOMETRIC_TURBIDITY_UNIT,
		BACnetEngineeringUnits_P_H,
		BACnetEngineeringUnits_GRAMS_PER_SQUARE_METER,
		BACnetEngineeringUnits_MINUTES_PER_DEGREE_KELVIN,
		BACnetEngineeringUnits_VENDOR_PROPRIETARY_VALUE,
	}
}

func BACnetEngineeringUnitsByValue(value uint32) (enum BACnetEngineeringUnits, ok bool) {
	switch value {
	case 0:
		return BACnetEngineeringUnits_SQUARE_METERS, true
	case 0xFF:
		return BACnetEngineeringUnits_VENDOR_PROPRIETARY_VALUE, true
	case 1:
		return BACnetEngineeringUnits_SQUARE_FEET, true
	case 10:
		return BACnetEngineeringUnits_MEGAVOLT_AMPERES, true
	case 100:
		return BACnetEngineeringUnits_PER_MINUTE, true
	case 101:
		return BACnetEngineeringUnits_PER_SECOND, true
	case 102:
		return BACnetEngineeringUnits_PSI_PER_DEGREE_FAHRENHEIT, true
	case 103:
		return BACnetEngineeringUnits_RADIANS, true
	case 104:
		return BACnetEngineeringUnits_REVOLUTIONS_PER_MINUTE, true
	case 105:
		return BACnetEngineeringUnits_CURRENCY1, true
	case 106:
		return BACnetEngineeringUnits_CURRENCY2, true
	case 107:
		return BACnetEngineeringUnits_CURRENCY3, true
	case 108:
		return BACnetEngineeringUnits_CURRENCY4, true
	case 109:
		return BACnetEngineeringUnits_CURRENCY5, true
	case 11:
		return BACnetEngineeringUnits_VOLT_AMPERES_REACTIVE, true
	case 110:
		return BACnetEngineeringUnits_CURRENCY6, true
	case 111:
		return BACnetEngineeringUnits_CURRENCY7, true
	case 112:
		return BACnetEngineeringUnits_CURRENCY8, true
	case 113:
		return BACnetEngineeringUnits_CURRENCY9, true
	case 114:
		return BACnetEngineeringUnits_CURRENCY10, true
	case 115:
		return BACnetEngineeringUnits_SQUARE_INCHES, true
	case 116:
		return BACnetEngineeringUnits_SQUARE_CENTIMETERS, true
	case 117:
		return BACnetEngineeringUnits_BTUS_PER_POUND, true
	case 118:
		return BACnetEngineeringUnits_CENTIMETERS, true
	case 119:
		return BACnetEngineeringUnits_POUNDS_MASS_PER_SECOND, true
	case 12:
		return BACnetEngineeringUnits_KILOVOLT_AMPERES_REACTIVE, true
	case 120:
		return BACnetEngineeringUnits_DELTA_DEGREES_FAHRENHEIT, true
	case 121:
		return BACnetEngineeringUnits_DELTA_DEGREES_KELVIN, true
	case 122:
		return BACnetEngineeringUnits_KILOHMS, true
	case 123:
		return BACnetEngineeringUnits_MEGOHMS, true
	case 124:
		return BACnetEngineeringUnits_MILLIVOLTS, true
	case 125:
		return BACnetEngineeringUnits_KILOJOULES_PER_KILOGRAM, true
	case 126:
		return BACnetEngineeringUnits_MEGAJOULES, true
	case 13:
		return BACnetEngineeringUnits_MEGAVOLT_AMPERES_REACTIVE, true
	case 132:
		return BACnetEngineeringUnits_IWATTS, true
	case 133:
		return BACnetEngineeringUnits_HECTOPASCALS, true
	case 134:
		return BACnetEngineeringUnits_MILLIBARS, true
	case 135:
		return BACnetEngineeringUnits_CUBIC_METERS_PER_HOUR, true
	case 136:
		return BACnetEngineeringUnits_LITERS_PER_HOUR, true
	case 137:
		return BACnetEngineeringUnits_KILOWATT_HOURS_PER_SQUARE_METER, true
	case 138:
		return BACnetEngineeringUnits_KILOWATT_HOURS_PER_SQUARE_FOOT, true
	case 139:
		return BACnetEngineeringUnits_MEGAJOULES_PER_SQUARE_METER, true
	case 14:
		return BACnetEngineeringUnits_DEGREES_PHASE, true
	case 140:
		return BACnetEngineeringUnits_MEGAJOULES_PER_SQUARE_FOOT, true
	case 141:
		return BACnetEngineeringUnits_WATTS_PER_SQUARE_METER_DEGREE_KELVIN, true
	case 142:
		return BACnetEngineeringUnits_CUBIC_FEET_PER_SECOND, true
	case 143:
		return BACnetEngineeringUnits_PERCENT_OBSCURATION_PER_FOOT, true
	case 144:
		return BACnetEngineeringUnits_PERCENT_OBSCURATION_PER_METER, true
	case 145:
		return BACnetEngineeringUnits_MILLIOHMS, true
	case 146:
		return BACnetEngineeringUnits_MEGAWATT_HOURS, true
	case 147:
		return BACnetEngineeringUnits_KILO_BTUS, true
	case 148:
		return BACnetEngineeringUnits_MEGA_BTUS, true
	case 149:
		return BACnetEngineeringUnits_KILOJOULES_PER_KILOGRAM_DRY_AIR, true
	case 15:
		return BACnetEngineeringUnits_POWER_FACTOR, true
	case 150:
		return BACnetEngineeringUnits_MEGAJOULES_PER_KILOGRAM_DRY_AIR, true
	case 154:
		return BACnetEngineeringUnits_GRAMS_PER_SECOND, true
	case 155:
		return BACnetEngineeringUnits_GRAMS_PER_MINUTE, true
	case 156:
		return BACnetEngineeringUnits_TONS_PER_HOUR, true
	case 157:
		return BACnetEngineeringUnits_KILO_BTUS_PER_HOUR, true
	case 158:
		return BACnetEngineeringUnits_HUNDREDTHS_SECONDS, true
	case 159:
		return BACnetEngineeringUnits_MILLISECONDS, true
	case 16:
		return BACnetEngineeringUnits_JOULES, true
	case 160:
		return BACnetEngineeringUnits_NEWTON_METERS, true
	case 161:
		return BACnetEngineeringUnits_MILLIMETERS_PER_SECOND, true
	case 162:
		return BACnetEngineeringUnits_MILLIMETERS_PER_MINUTE, true
	case 163:
		return BACnetEngineeringUnits_METERS_PER_MINUTE, true
	case 164:
		return BACnetEngineeringUnits_METERS_PER_HOUR, true
	case 165:
		return BACnetEngineeringUnits_CUBIC_METERS_PER_MINUTE, true
	case 166:
		return BACnetEngineeringUnits_METERS_PER_SECOND_PER_SECOND, true
	case 167:
		return BACnetEngineeringUnits_AMPERES_PER_METER, true
	case 168:
		return BACnetEngineeringUnits_AMPERES_PER_SQUARE_METER, true
	case 169:
		return BACnetEngineeringUnits_AMPERE_SQUARE_METERS, true
	case 17:
		return BACnetEngineeringUnits_KILOJOULES, true
	case 170:
		return BACnetEngineeringUnits_FARADS, true
	case 171:
		return BACnetEngineeringUnits_HENRYS, true
	case 172:
		return BACnetEngineeringUnits_OHM_METERS, true
	case 173:
		return BACnetEngineeringUnits_SIEMENS, true
	case 174:
		return BACnetEngineeringUnits_SIEMENS_PER_METER, true
	case 175:
		return BACnetEngineeringUnits_TESLAS, true
	case 176:
		return BACnetEngineeringUnits_VOLTS_PER_DEGREE_KELVIN, true
	case 177:
		return BACnetEngineeringUnits_VOLTS_PER_METER, true
	case 178:
		return BACnetEngineeringUnits_WEBERS, true
	case 179:
		return BACnetEngineeringUnits_CANDELAS, true
	case 18:
		return BACnetEngineeringUnits_WATT_HOURS, true
	case 180:
		return BACnetEngineeringUnits_CANDELAS_PER_SQUARE_METER, true
	case 181:
		return BACnetEngineeringUnits_DEGREES_KELVIN_PER_HOUR, true
	case 182:
		return BACnetEngineeringUnits_DEGREES_KELVIN_PER_MINUTE, true
	case 183:
		return BACnetEngineeringUnits_JOULE_SECONDS, true
	case 184:
		return BACnetEngineeringUnits_RADIANS_PER_SECOND, true
	case 185:
		return BACnetEngineeringUnits_SQUARE_METERS_PER_NEWTON, true
	case 186:
		return BACnetEngineeringUnits_KILOGRAMS_PER_CUBIC_METER, true
	case 187:
		return BACnetEngineeringUnits_NEWTON_SECONDS, true
	case 188:
		return BACnetEngineeringUnits_NEWTONS_PER_METER, true
	case 189:
		return BACnetEngineeringUnits_WATTS_PER_METER_PER_DEGREE_KELVIN, true
	case 19:
		return BACnetEngineeringUnits_KILOWATT_HOURS, true
	case 190:
		return BACnetEngineeringUnits_MICROSIEMENS, true
	case 191:
		return BACnetEngineeringUnits_CUBIC_FEET_PER_HOUR, true
	case 192:
		return BACnetEngineeringUnits_US_GALLONS_PER_HOUR, true
	case 193:
		return BACnetEngineeringUnits_KILOMETERS, true
	case 194:
		return BACnetEngineeringUnits_MICROMETERS, true
	case 195:
		return BACnetEngineeringUnits_GRAMS, true
	case 196:
		return BACnetEngineeringUnits_MILLIGRAMS, true
	case 197:
		return BACnetEngineeringUnits_MILLILITERS, true
	case 198:
		return BACnetEngineeringUnits_MILLILITERS_PER_SECOND, true
	case 199:
		return BACnetEngineeringUnits_DECIBELS, true
	case 2:
		return BACnetEngineeringUnits_MILLIAMPERES, true
	case 20:
		return BACnetEngineeringUnits_BTUS, true
	case 200:
		return BACnetEngineeringUnits_DECIBELS_MILLIVOLT, true
	case 201:
		return BACnetEngineeringUnits_DECIBELS_VOLT, true
	case 202:
		return BACnetEngineeringUnits_MILLISIEMENS, true
	case 203:
		return BACnetEngineeringUnits_WATT_HOURS_REACTIVE, true
	case 204:
		return BACnetEngineeringUnits_KILOWATT_HOURS_REACTIVE, true
	case 205:
		return BACnetEngineeringUnits_MEGAWATT_HOURS_REACTIVE, true
	case 206:
		return BACnetEngineeringUnits_MILLIMETERS_OF_WATER, true
	case 207:
		return BACnetEngineeringUnits_PER_MILLE, true
	case 208:
		return BACnetEngineeringUnits_GRAMS_PER_GRAM, true
	case 209:
		return BACnetEngineeringUnits_KILOGRAMS_PER_KILOGRAM, true
	case 21:
		return BACnetEngineeringUnits_THERMS, true
	case 210:
		return BACnetEngineeringUnits_GRAMS_PER_KILOGRAM, true
	case 211:
		return BACnetEngineeringUnits_MILLIGRAMS_PER_GRAM, true
	case 212:
		return BACnetEngineeringUnits_MILLIGRAMS_PER_KILOGRAM, true
	case 213:
		return BACnetEngineeringUnits_GRAMS_PER_MILLILITER, true
	case 214:
		return BACnetEngineeringUnits_GRAMS_PER_LITER, true
	case 215:
		return BACnetEngineeringUnits_MILLIGRAMS_PER_LITER, true
	case 216:
		return BACnetEngineeringUnits_MICROGRAMS_PER_LITER, true
	case 217:
		return BACnetEngineeringUnits_GRAMS_PER_CUBIC_METER, true
	case 218:
		return BACnetEngineeringUnits_MILLIGRAMS_PER_CUBIC_METER, true
	case 219:
		return BACnetEngineeringUnits_MICROGRAMS_PER_CUBIC_METER, true
	case 22:
		return BACnetEngineeringUnits_TON_HOURS, true
	case 220:
		return BACnetEngineeringUnits_NANOGRAMS_PER_CUBIC_METER, true
	case 221:
		return BACnetEngineeringUnits_GRAMS_PER_CUBIC_CENTIMETER, true
	case 222:
		return BACnetEngineeringUnits_BECQUERELS, true
	case 223:
		return BACnetEngineeringUnits_KILOBECQUERELS, true
	case 224:
		return BACnetEngineeringUnits_MEGABECQUERELS, true
	case 225:
		return BACnetEngineeringUnits_GRAY, true
	case 226:
		return BACnetEngineeringUnits_MILLIGRAY, true
	case 227:
		return BACnetEngineeringUnits_MICROGRAY, true
	case 228:
		return BACnetEngineeringUnits_SIEVERTS, true
	case 229:
		return BACnetEngineeringUnits_MILLISIEVERTS, true
	case 23:
		return BACnetEngineeringUnits_JOULES_PER_KILOGRAM_DRY_AIR, true
	case 230:
		return BACnetEngineeringUnits_MICROSIEVERTS, true
	case 231:
		return BACnetEngineeringUnits_MICROSIEVERTS_PER_HOUR, true
	case 232:
		return BACnetEngineeringUnits_DECIBELS_A, true
	case 233:
		return BACnetEngineeringUnits_NEPHELOMETRIC_TURBIDITY_UNIT, true
	case 234:
		return BACnetEngineeringUnits_P_H, true
	case 235:
		return BACnetEngineeringUnits_GRAMS_PER_SQUARE_METER, true
	case 236:
		return BACnetEngineeringUnits_MINUTES_PER_DEGREE_KELVIN, true
	case 237:
		return BACnetEngineeringUnits_OHM_METER_SQUARED_PER_METER, true
	case 238:
		return BACnetEngineeringUnits_AMPERE_SECONDS, true
	case 239:
		return BACnetEngineeringUnits_VOLT_AMPERE_HOURS, true
	case 24:
		return BACnetEngineeringUnits_BTUS_PER_POUND_DRY_AIR, true
	case 240:
		return BACnetEngineeringUnits_KILOVOLT_AMPERE_HOURS, true
	case 241:
		return BACnetEngineeringUnits_MEGAVOLT_AMPERE_HOURS, true
	case 242:
		return BACnetEngineeringUnits_VOLT_AMPERE_HOURS_REACTIVE, true
	case 243:
		return BACnetEngineeringUnits_KILOVOLT_AMPERE_HOURS_REACTIVE, true
	case 244:
		return BACnetEngineeringUnits_MEGAVOLT_AMPERE_HOURS_REACTIVE, true
	case 245:
		return BACnetEngineeringUnits_VOLT_SQUARE_HOURS, true
	case 246:
		return BACnetEngineeringUnits_AMPERE_SQUARE_HOURS, true
	case 247:
		return BACnetEngineeringUnits_JOULE_PER_HOURS, true
	case 248:
		return BACnetEngineeringUnits_CUBIC_FEET_PER_DAY, true
	case 249:
		return BACnetEngineeringUnits_CUBIC_METERS_PER_DAY, true
	case 250:
		return BACnetEngineeringUnits_WATT_HOURS_PER_CUBIC_METER, true
	case 251:
		return BACnetEngineeringUnits_JOULES_PER_CUBIC_METER, true
	case 252:
		return BACnetEngineeringUnits_MOLE_PERCENT, true
	case 253:
		return BACnetEngineeringUnits_PASCAL_SECONDS, true
	case 254:
		return BACnetEngineeringUnits_MILLION_STANDARD_CUBIC_FEET_PER_MINUTE, true
	case 28:
		return BACnetEngineeringUnits_GRAMS_OF_WATER_PER_KILOGRAM_DRY_AIR, true
	case 29:
		return BACnetEngineeringUnits_PERCENT_RELATIVE_HUMIDITY, true
	case 3:
		return BACnetEngineeringUnits_AMPERES, true
	case 30:
		return BACnetEngineeringUnits_MILLIMETERS, true
	case 31:
		return BACnetEngineeringUnits_METERS, true
	case 32:
		return BACnetEngineeringUnits_INCHES, true
	case 33:
		return BACnetEngineeringUnits_FEET, true
	case 34:
		return BACnetEngineeringUnits_WATTS_PER_SQUARE_FOOT, true
	case 35:
		return BACnetEngineeringUnits_WATTS_PER_SQUARE_METER, true
	case 36:
		return BACnetEngineeringUnits_LUMENS, true
	case 37:
		return BACnetEngineeringUnits_LUXES, true
	case 38:
		return BACnetEngineeringUnits_FOOT_CANDLES, true
	case 39:
		return BACnetEngineeringUnits_KILOGRAMS, true
	case 4:
		return BACnetEngineeringUnits_OHMS, true
	case 40:
		return BACnetEngineeringUnits_POUNDS_MASS, true
	case 41:
		return BACnetEngineeringUnits_TONS, true
	case 42:
		return BACnetEngineeringUnits_KILOGRAMS_PER_SECOND, true
	case 43:
		return BACnetEngineeringUnits_KILOGRAMS_PER_MINUTE, true
	case 44:
		return BACnetEngineeringUnits_KILOGRAMS_PER_HOUR, true
	case 45:
		return BACnetEngineeringUnits_POUNDS_MASS_PER_MINUTE, true
	case 46:
		return BACnetEngineeringUnits_POUNDS_MASS_PER_HOUR, true
	case 47:
		return BACnetEngineeringUnits_WATTS, true
	case 47808:
		return BACnetEngineeringUnits_STANDARD_CUBIC_FEET_PER_DAY, true
	case 47809:
		return BACnetEngineeringUnits_MILLION_STANDARD_CUBIC_FEET_PER_DAY, true
	case 47810:
		return BACnetEngineeringUnits_THOUSAND_CUBIC_FEET_PER_DAY, true
	case 47811:
		return BACnetEngineeringUnits_THOUSAND_STANDARD_CUBIC_FEET_PER_DAY, true
	case 47812:
		return BACnetEngineeringUnits_POUNDS_MASS_PER_DAY, true
	case 47814:
		return BACnetEngineeringUnits_MILLIREMS, true
	case 47815:
		return BACnetEngineeringUnits_MILLIREMS_PER_HOUR, true
	case 48:
		return BACnetEngineeringUnits_KILOWATTS, true
	case 49:
		return BACnetEngineeringUnits_MEGAWATTS, true
	case 5:
		return BACnetEngineeringUnits_VOLTS, true
	case 50:
		return BACnetEngineeringUnits_BTUS_PER_HOUR, true
	case 51:
		return BACnetEngineeringUnits_HORSEPOWER, true
	case 52:
		return BACnetEngineeringUnits_TONS_REFRIGERATION, true
	case 53:
		return BACnetEngineeringUnits_PASCALS, true
	case 54:
		return BACnetEngineeringUnits_KILOPASCALS, true
	case 55:
		return BACnetEngineeringUnits_BARS, true
	case 56:
		return BACnetEngineeringUnits_POUNDS_FORCE_PER_SQUARE_INCH, true
	case 57:
		return BACnetEngineeringUnits_CENTIMETERS_OF_WATER, true
	case 58:
		return BACnetEngineeringUnits_INCHES_OF_WATER, true
	case 59:
		return BACnetEngineeringUnits_MILLIMETERS_OF_MERCURY, true
	case 6:
		return BACnetEngineeringUnits_KILOVOLTS, true
	case 60:
		return BACnetEngineeringUnits_CENTIMETERS_OF_MERCURY, true
	case 61:
		return BACnetEngineeringUnits_INCHES_OF_MERCURY, true
	case 62:
		return BACnetEngineeringUnits_DEGREES_CELSIUS, true
	case 63:
		return BACnetEngineeringUnits_DEGREES_KELVIN, true
	case 64:
		return BACnetEngineeringUnits_DEGREES_FAHRENHEIT, true
	case 65:
		return BACnetEngineeringUnits_DEGREE_DAYS_CELSIUS, true
	case 66:
		return BACnetEngineeringUnits_DEGREE_DAYS_FAHRENHEIT, true
	case 67:
		return BACnetEngineeringUnits_YEARS, true
	case 68:
		return BACnetEngineeringUnits_MONTHS, true
	case 69:
		return BACnetEngineeringUnits_WEEKS, true
	case 7:
		return BACnetEngineeringUnits_MEGAVOLTS, true
	case 70:
		return BACnetEngineeringUnits_DAYS, true
	case 71:
		return BACnetEngineeringUnits_HOURS, true
	case 72:
		return BACnetEngineeringUnits_MINUTES, true
	case 73:
		return BACnetEngineeringUnits_SECONDS, true
	case 74:
		return BACnetEngineeringUnits_METERS_PER_SECOND, true
	case 75:
		return BACnetEngineeringUnits_KILOMETERS_PER_HOUR, true
	case 76:
		return BACnetEngineeringUnits_FEET_PER_SECOND, true
	case 77:
		return BACnetEngineeringUnits_FEET_PER_MINUTE, true
	case 78:
		return BACnetEngineeringUnits_MILES_PER_HOUR, true
	case 79:
		return BACnetEngineeringUnits_CUBIC_FEET, true
	case 8:
		return BACnetEngineeringUnits_VOLT_AMPERES, true
	case 80:
		return BACnetEngineeringUnits_CUBIC_METERS, true
	case 81:
		return BACnetEngineeringUnits_IMPERIAL_GALLONS, true
	case 82:
		return BACnetEngineeringUnits_LITERS, true
	case 83:
		return BACnetEngineeringUnits_US_GALLONS, true
	case 84:
		return BACnetEngineeringUnits_CUBIC_FEET_PER_MINUTE, true
	case 85:
		return BACnetEngineeringUnits_CUBIC_METERS_PER_SECOND, true
	case 86:
		return BACnetEngineeringUnits_IMPERIAL_GALLONS_PER_MINUTE, true
	case 87:
		return BACnetEngineeringUnits_LITERS_PER_SECOND, true
	case 88:
		return BACnetEngineeringUnits_LITERS_PER_MINUTE, true
	case 89:
		return BACnetEngineeringUnits_US_GALLONS_PER_MINUTE, true
	case 9:
		return BACnetEngineeringUnits_KILOVOLT_AMPERES, true
	case 90:
		return BACnetEngineeringUnits_DEGREES_ANGULAR, true
	case 91:
		return BACnetEngineeringUnits_DEGREES_CELSIUS_PER_HOUR, true
	case 92:
		return BACnetEngineeringUnits_DEGREES_CELSIUS_PER_MINUTE, true
	case 93:
		return BACnetEngineeringUnits_DEGREES_FAHRENHEIT_PER_HOUR, true
	case 94:
		return BACnetEngineeringUnits_DEGREES_FAHRENHEIT_PER_MINUTE, true
	case 95:
		return BACnetEngineeringUnits_NO_UNITS, true
	case 96:
		return BACnetEngineeringUnits_PARTS_PER_MILLION, true
	case 97:
		return BACnetEngineeringUnits_PARTS_PER_BILLION, true
	case 98:
		return BACnetEngineeringUnits_PERCENT, true
	case 99:
		return BACnetEngineeringUnits_PERCENT_PER_SECOND, true
	}
	return 0, false
}

func BACnetEngineeringUnitsByName(value string) (enum BACnetEngineeringUnits, ok bool) {
	switch value {
	case "SQUARE_METERS":
		return BACnetEngineeringUnits_SQUARE_METERS, true
	case "VENDOR_PROPRIETARY_VALUE":
		return BACnetEngineeringUnits_VENDOR_PROPRIETARY_VALUE, true
	case "SQUARE_FEET":
		return BACnetEngineeringUnits_SQUARE_FEET, true
	case "MEGAVOLT_AMPERES":
		return BACnetEngineeringUnits_MEGAVOLT_AMPERES, true
	case "PER_MINUTE":
		return BACnetEngineeringUnits_PER_MINUTE, true
	case "PER_SECOND":
		return BACnetEngineeringUnits_PER_SECOND, true
	case "PSI_PER_DEGREE_FAHRENHEIT":
		return BACnetEngineeringUnits_PSI_PER_DEGREE_FAHRENHEIT, true
	case "RADIANS":
		return BACnetEngineeringUnits_RADIANS, true
	case "REVOLUTIONS_PER_MINUTE":
		return BACnetEngineeringUnits_REVOLUTIONS_PER_MINUTE, true
	case "CURRENCY1":
		return BACnetEngineeringUnits_CURRENCY1, true
	case "CURRENCY2":
		return BACnetEngineeringUnits_CURRENCY2, true
	case "CURRENCY3":
		return BACnetEngineeringUnits_CURRENCY3, true
	case "CURRENCY4":
		return BACnetEngineeringUnits_CURRENCY4, true
	case "CURRENCY5":
		return BACnetEngineeringUnits_CURRENCY5, true
	case "VOLT_AMPERES_REACTIVE":
		return BACnetEngineeringUnits_VOLT_AMPERES_REACTIVE, true
	case "CURRENCY6":
		return BACnetEngineeringUnits_CURRENCY6, true
	case "CURRENCY7":
		return BACnetEngineeringUnits_CURRENCY7, true
	case "CURRENCY8":
		return BACnetEngineeringUnits_CURRENCY8, true
	case "CURRENCY9":
		return BACnetEngineeringUnits_CURRENCY9, true
	case "CURRENCY10":
		return BACnetEngineeringUnits_CURRENCY10, true
	case "SQUARE_INCHES":
		return BACnetEngineeringUnits_SQUARE_INCHES, true
	case "SQUARE_CENTIMETERS":
		return BACnetEngineeringUnits_SQUARE_CENTIMETERS, true
	case "BTUS_PER_POUND":
		return BACnetEngineeringUnits_BTUS_PER_POUND, true
	case "CENTIMETERS":
		return BACnetEngineeringUnits_CENTIMETERS, true
	case "POUNDS_MASS_PER_SECOND":
		return BACnetEngineeringUnits_POUNDS_MASS_PER_SECOND, true
	case "KILOVOLT_AMPERES_REACTIVE":
		return BACnetEngineeringUnits_KILOVOLT_AMPERES_REACTIVE, true
	case "DELTA_DEGREES_FAHRENHEIT":
		return BACnetEngineeringUnits_DELTA_DEGREES_FAHRENHEIT, true
	case "DELTA_DEGREES_KELVIN":
		return BACnetEngineeringUnits_DELTA_DEGREES_KELVIN, true
	case "KILOHMS":
		return BACnetEngineeringUnits_KILOHMS, true
	case "MEGOHMS":
		return BACnetEngineeringUnits_MEGOHMS, true
	case "MILLIVOLTS":
		return BACnetEngineeringUnits_MILLIVOLTS, true
	case "KILOJOULES_PER_KILOGRAM":
		return BACnetEngineeringUnits_KILOJOULES_PER_KILOGRAM, true
	case "MEGAJOULES":
		return BACnetEngineeringUnits_MEGAJOULES, true
	case "MEGAVOLT_AMPERES_REACTIVE":
		return BACnetEngineeringUnits_MEGAVOLT_AMPERES_REACTIVE, true
	case "IWATTS":
		return BACnetEngineeringUnits_IWATTS, true
	case "HECTOPASCALS":
		return BACnetEngineeringUnits_HECTOPASCALS, true
	case "MILLIBARS":
		return BACnetEngineeringUnits_MILLIBARS, true
	case "CUBIC_METERS_PER_HOUR":
		return BACnetEngineeringUnits_CUBIC_METERS_PER_HOUR, true
	case "LITERS_PER_HOUR":
		return BACnetEngineeringUnits_LITERS_PER_HOUR, true
	case "KILOWATT_HOURS_PER_SQUARE_METER":
		return BACnetEngineeringUnits_KILOWATT_HOURS_PER_SQUARE_METER, true
	case "KILOWATT_HOURS_PER_SQUARE_FOOT":
		return BACnetEngineeringUnits_KILOWATT_HOURS_PER_SQUARE_FOOT, true
	case "MEGAJOULES_PER_SQUARE_METER":
		return BACnetEngineeringUnits_MEGAJOULES_PER_SQUARE_METER, true
	case "DEGREES_PHASE":
		return BACnetEngineeringUnits_DEGREES_PHASE, true
	case "MEGAJOULES_PER_SQUARE_FOOT":
		return BACnetEngineeringUnits_MEGAJOULES_PER_SQUARE_FOOT, true
	case "WATTS_PER_SQUARE_METER_DEGREE_KELVIN":
		return BACnetEngineeringUnits_WATTS_PER_SQUARE_METER_DEGREE_KELVIN, true
	case "CUBIC_FEET_PER_SECOND":
		return BACnetEngineeringUnits_CUBIC_FEET_PER_SECOND, true
	case "PERCENT_OBSCURATION_PER_FOOT":
		return BACnetEngineeringUnits_PERCENT_OBSCURATION_PER_FOOT, true
	case "PERCENT_OBSCURATION_PER_METER":
		return BACnetEngineeringUnits_PERCENT_OBSCURATION_PER_METER, true
	case "MILLIOHMS":
		return BACnetEngineeringUnits_MILLIOHMS, true
	case "MEGAWATT_HOURS":
		return BACnetEngineeringUnits_MEGAWATT_HOURS, true
	case "KILO_BTUS":
		return BACnetEngineeringUnits_KILO_BTUS, true
	case "MEGA_BTUS":
		return BACnetEngineeringUnits_MEGA_BTUS, true
	case "KILOJOULES_PER_KILOGRAM_DRY_AIR":
		return BACnetEngineeringUnits_KILOJOULES_PER_KILOGRAM_DRY_AIR, true
	case "POWER_FACTOR":
		return BACnetEngineeringUnits_POWER_FACTOR, true
	case "MEGAJOULES_PER_KILOGRAM_DRY_AIR":
		return BACnetEngineeringUnits_MEGAJOULES_PER_KILOGRAM_DRY_AIR, true
	case "GRAMS_PER_SECOND":
		return BACnetEngineeringUnits_GRAMS_PER_SECOND, true
	case "GRAMS_PER_MINUTE":
		return BACnetEngineeringUnits_GRAMS_PER_MINUTE, true
	case "TONS_PER_HOUR":
		return BACnetEngineeringUnits_TONS_PER_HOUR, true
	case "KILO_BTUS_PER_HOUR":
		return BACnetEngineeringUnits_KILO_BTUS_PER_HOUR, true
	case "HUNDREDTHS_SECONDS":
		return BACnetEngineeringUnits_HUNDREDTHS_SECONDS, true
	case "MILLISECONDS":
		return BACnetEngineeringUnits_MILLISECONDS, true
	case "JOULES":
		return BACnetEngineeringUnits_JOULES, true
	case "NEWTON_METERS":
		return BACnetEngineeringUnits_NEWTON_METERS, true
	case "MILLIMETERS_PER_SECOND":
		return BACnetEngineeringUnits_MILLIMETERS_PER_SECOND, true
	case "MILLIMETERS_PER_MINUTE":
		return BACnetEngineeringUnits_MILLIMETERS_PER_MINUTE, true
	case "METERS_PER_MINUTE":
		return BACnetEngineeringUnits_METERS_PER_MINUTE, true
	case "METERS_PER_HOUR":
		return BACnetEngineeringUnits_METERS_PER_HOUR, true
	case "CUBIC_METERS_PER_MINUTE":
		return BACnetEngineeringUnits_CUBIC_METERS_PER_MINUTE, true
	case "METERS_PER_SECOND_PER_SECOND":
		return BACnetEngineeringUnits_METERS_PER_SECOND_PER_SECOND, true
	case "AMPERES_PER_METER":
		return BACnetEngineeringUnits_AMPERES_PER_METER, true
	case "AMPERES_PER_SQUARE_METER":
		return BACnetEngineeringUnits_AMPERES_PER_SQUARE_METER, true
	case "AMPERE_SQUARE_METERS":
		return BACnetEngineeringUnits_AMPERE_SQUARE_METERS, true
	case "KILOJOULES":
		return BACnetEngineeringUnits_KILOJOULES, true
	case "FARADS":
		return BACnetEngineeringUnits_FARADS, true
	case "HENRYS":
		return BACnetEngineeringUnits_HENRYS, true
	case "OHM_METERS":
		return BACnetEngineeringUnits_OHM_METERS, true
	case "SIEMENS":
		return BACnetEngineeringUnits_SIEMENS, true
	case "SIEMENS_PER_METER":
		return BACnetEngineeringUnits_SIEMENS_PER_METER, true
	case "TESLAS":
		return BACnetEngineeringUnits_TESLAS, true
	case "VOLTS_PER_DEGREE_KELVIN":
		return BACnetEngineeringUnits_VOLTS_PER_DEGREE_KELVIN, true
	case "VOLTS_PER_METER":
		return BACnetEngineeringUnits_VOLTS_PER_METER, true
	case "WEBERS":
		return BACnetEngineeringUnits_WEBERS, true
	case "CANDELAS":
		return BACnetEngineeringUnits_CANDELAS, true
	case "WATT_HOURS":
		return BACnetEngineeringUnits_WATT_HOURS, true
	case "CANDELAS_PER_SQUARE_METER":
		return BACnetEngineeringUnits_CANDELAS_PER_SQUARE_METER, true
	case "DEGREES_KELVIN_PER_HOUR":
		return BACnetEngineeringUnits_DEGREES_KELVIN_PER_HOUR, true
	case "DEGREES_KELVIN_PER_MINUTE":
		return BACnetEngineeringUnits_DEGREES_KELVIN_PER_MINUTE, true
	case "JOULE_SECONDS":
		return BACnetEngineeringUnits_JOULE_SECONDS, true
	case "RADIANS_PER_SECOND":
		return BACnetEngineeringUnits_RADIANS_PER_SECOND, true
	case "SQUARE_METERS_PER_NEWTON":
		return BACnetEngineeringUnits_SQUARE_METERS_PER_NEWTON, true
	case "KILOGRAMS_PER_CUBIC_METER":
		return BACnetEngineeringUnits_KILOGRAMS_PER_CUBIC_METER, true
	case "NEWTON_SECONDS":
		return BACnetEngineeringUnits_NEWTON_SECONDS, true
	case "NEWTONS_PER_METER":
		return BACnetEngineeringUnits_NEWTONS_PER_METER, true
	case "WATTS_PER_METER_PER_DEGREE_KELVIN":
		return BACnetEngineeringUnits_WATTS_PER_METER_PER_DEGREE_KELVIN, true
	case "KILOWATT_HOURS":
		return BACnetEngineeringUnits_KILOWATT_HOURS, true
	case "MICROSIEMENS":
		return BACnetEngineeringUnits_MICROSIEMENS, true
	case "CUBIC_FEET_PER_HOUR":
		return BACnetEngineeringUnits_CUBIC_FEET_PER_HOUR, true
	case "US_GALLONS_PER_HOUR":
		return BACnetEngineeringUnits_US_GALLONS_PER_HOUR, true
	case "KILOMETERS":
		return BACnetEngineeringUnits_KILOMETERS, true
	case "MICROMETERS":
		return BACnetEngineeringUnits_MICROMETERS, true
	case "GRAMS":
		return BACnetEngineeringUnits_GRAMS, true
	case "MILLIGRAMS":
		return BACnetEngineeringUnits_MILLIGRAMS, true
	case "MILLILITERS":
		return BACnetEngineeringUnits_MILLILITERS, true
	case "MILLILITERS_PER_SECOND":
		return BACnetEngineeringUnits_MILLILITERS_PER_SECOND, true
	case "DECIBELS":
		return BACnetEngineeringUnits_DECIBELS, true
	case "MILLIAMPERES":
		return BACnetEngineeringUnits_MILLIAMPERES, true
	case "BTUS":
		return BACnetEngineeringUnits_BTUS, true
	case "DECIBELS_MILLIVOLT":
		return BACnetEngineeringUnits_DECIBELS_MILLIVOLT, true
	case "DECIBELS_VOLT":
		return BACnetEngineeringUnits_DECIBELS_VOLT, true
	case "MILLISIEMENS":
		return BACnetEngineeringUnits_MILLISIEMENS, true
	case "WATT_HOURS_REACTIVE":
		return BACnetEngineeringUnits_WATT_HOURS_REACTIVE, true
	case "KILOWATT_HOURS_REACTIVE":
		return BACnetEngineeringUnits_KILOWATT_HOURS_REACTIVE, true
	case "MEGAWATT_HOURS_REACTIVE":
		return BACnetEngineeringUnits_MEGAWATT_HOURS_REACTIVE, true
	case "MILLIMETERS_OF_WATER":
		return BACnetEngineeringUnits_MILLIMETERS_OF_WATER, true
	case "PER_MILLE":
		return BACnetEngineeringUnits_PER_MILLE, true
	case "GRAMS_PER_GRAM":
		return BACnetEngineeringUnits_GRAMS_PER_GRAM, true
	case "KILOGRAMS_PER_KILOGRAM":
		return BACnetEngineeringUnits_KILOGRAMS_PER_KILOGRAM, true
	case "THERMS":
		return BACnetEngineeringUnits_THERMS, true
	case "GRAMS_PER_KILOGRAM":
		return BACnetEngineeringUnits_GRAMS_PER_KILOGRAM, true
	case "MILLIGRAMS_PER_GRAM":
		return BACnetEngineeringUnits_MILLIGRAMS_PER_GRAM, true
	case "MILLIGRAMS_PER_KILOGRAM":
		return BACnetEngineeringUnits_MILLIGRAMS_PER_KILOGRAM, true
	case "GRAMS_PER_MILLILITER":
		return BACnetEngineeringUnits_GRAMS_PER_MILLILITER, true
	case "GRAMS_PER_LITER":
		return BACnetEngineeringUnits_GRAMS_PER_LITER, true
	case "MILLIGRAMS_PER_LITER":
		return BACnetEngineeringUnits_MILLIGRAMS_PER_LITER, true
	case "MICROGRAMS_PER_LITER":
		return BACnetEngineeringUnits_MICROGRAMS_PER_LITER, true
	case "GRAMS_PER_CUBIC_METER":
		return BACnetEngineeringUnits_GRAMS_PER_CUBIC_METER, true
	case "MILLIGRAMS_PER_CUBIC_METER":
		return BACnetEngineeringUnits_MILLIGRAMS_PER_CUBIC_METER, true
	case "MICROGRAMS_PER_CUBIC_METER":
		return BACnetEngineeringUnits_MICROGRAMS_PER_CUBIC_METER, true
	case "TON_HOURS":
		return BACnetEngineeringUnits_TON_HOURS, true
	case "NANOGRAMS_PER_CUBIC_METER":
		return BACnetEngineeringUnits_NANOGRAMS_PER_CUBIC_METER, true
	case "GRAMS_PER_CUBIC_CENTIMETER":
		return BACnetEngineeringUnits_GRAMS_PER_CUBIC_CENTIMETER, true
	case "BECQUERELS":
		return BACnetEngineeringUnits_BECQUERELS, true
	case "KILOBECQUERELS":
		return BACnetEngineeringUnits_KILOBECQUERELS, true
	case "MEGABECQUERELS":
		return BACnetEngineeringUnits_MEGABECQUERELS, true
	case "GRAY":
		return BACnetEngineeringUnits_GRAY, true
	case "MILLIGRAY":
		return BACnetEngineeringUnits_MILLIGRAY, true
	case "MICROGRAY":
		return BACnetEngineeringUnits_MICROGRAY, true
	case "SIEVERTS":
		return BACnetEngineeringUnits_SIEVERTS, true
	case "MILLISIEVERTS":
		return BACnetEngineeringUnits_MILLISIEVERTS, true
	case "JOULES_PER_KILOGRAM_DRY_AIR":
		return BACnetEngineeringUnits_JOULES_PER_KILOGRAM_DRY_AIR, true
	case "MICROSIEVERTS":
		return BACnetEngineeringUnits_MICROSIEVERTS, true
	case "MICROSIEVERTS_PER_HOUR":
		return BACnetEngineeringUnits_MICROSIEVERTS_PER_HOUR, true
	case "DECIBELS_A":
		return BACnetEngineeringUnits_DECIBELS_A, true
	case "NEPHELOMETRIC_TURBIDITY_UNIT":
		return BACnetEngineeringUnits_NEPHELOMETRIC_TURBIDITY_UNIT, true
	case "P_H":
		return BACnetEngineeringUnits_P_H, true
	case "GRAMS_PER_SQUARE_METER":
		return BACnetEngineeringUnits_GRAMS_PER_SQUARE_METER, true
	case "MINUTES_PER_DEGREE_KELVIN":
		return BACnetEngineeringUnits_MINUTES_PER_DEGREE_KELVIN, true
	case "OHM_METER_SQUARED_PER_METER":
		return BACnetEngineeringUnits_OHM_METER_SQUARED_PER_METER, true
	case "AMPERE_SECONDS":
		return BACnetEngineeringUnits_AMPERE_SECONDS, true
	case "VOLT_AMPERE_HOURS":
		return BACnetEngineeringUnits_VOLT_AMPERE_HOURS, true
	case "BTUS_PER_POUND_DRY_AIR":
		return BACnetEngineeringUnits_BTUS_PER_POUND_DRY_AIR, true
	case "KILOVOLT_AMPERE_HOURS":
		return BACnetEngineeringUnits_KILOVOLT_AMPERE_HOURS, true
	case "MEGAVOLT_AMPERE_HOURS":
		return BACnetEngineeringUnits_MEGAVOLT_AMPERE_HOURS, true
	case "VOLT_AMPERE_HOURS_REACTIVE":
		return BACnetEngineeringUnits_VOLT_AMPERE_HOURS_REACTIVE, true
	case "KILOVOLT_AMPERE_HOURS_REACTIVE":
		return BACnetEngineeringUnits_KILOVOLT_AMPERE_HOURS_REACTIVE, true
	case "MEGAVOLT_AMPERE_HOURS_REACTIVE":
		return BACnetEngineeringUnits_MEGAVOLT_AMPERE_HOURS_REACTIVE, true
	case "VOLT_SQUARE_HOURS":
		return BACnetEngineeringUnits_VOLT_SQUARE_HOURS, true
	case "AMPERE_SQUARE_HOURS":
		return BACnetEngineeringUnits_AMPERE_SQUARE_HOURS, true
	case "JOULE_PER_HOURS":
		return BACnetEngineeringUnits_JOULE_PER_HOURS, true
	case "CUBIC_FEET_PER_DAY":
		return BACnetEngineeringUnits_CUBIC_FEET_PER_DAY, true
	case "CUBIC_METERS_PER_DAY":
		return BACnetEngineeringUnits_CUBIC_METERS_PER_DAY, true
	case "WATT_HOURS_PER_CUBIC_METER":
		return BACnetEngineeringUnits_WATT_HOURS_PER_CUBIC_METER, true
	case "JOULES_PER_CUBIC_METER":
		return BACnetEngineeringUnits_JOULES_PER_CUBIC_METER, true
	case "MOLE_PERCENT":
		return BACnetEngineeringUnits_MOLE_PERCENT, true
	case "PASCAL_SECONDS":
		return BACnetEngineeringUnits_PASCAL_SECONDS, true
	case "MILLION_STANDARD_CUBIC_FEET_PER_MINUTE":
		return BACnetEngineeringUnits_MILLION_STANDARD_CUBIC_FEET_PER_MINUTE, true
	case "GRAMS_OF_WATER_PER_KILOGRAM_DRY_AIR":
		return BACnetEngineeringUnits_GRAMS_OF_WATER_PER_KILOGRAM_DRY_AIR, true
	case "PERCENT_RELATIVE_HUMIDITY":
		return BACnetEngineeringUnits_PERCENT_RELATIVE_HUMIDITY, true
	case "AMPERES":
		return BACnetEngineeringUnits_AMPERES, true
	case "MILLIMETERS":
		return BACnetEngineeringUnits_MILLIMETERS, true
	case "METERS":
		return BACnetEngineeringUnits_METERS, true
	case "INCHES":
		return BACnetEngineeringUnits_INCHES, true
	case "FEET":
		return BACnetEngineeringUnits_FEET, true
	case "WATTS_PER_SQUARE_FOOT":
		return BACnetEngineeringUnits_WATTS_PER_SQUARE_FOOT, true
	case "WATTS_PER_SQUARE_METER":
		return BACnetEngineeringUnits_WATTS_PER_SQUARE_METER, true
	case "LUMENS":
		return BACnetEngineeringUnits_LUMENS, true
	case "LUXES":
		return BACnetEngineeringUnits_LUXES, true
	case "FOOT_CANDLES":
		return BACnetEngineeringUnits_FOOT_CANDLES, true
	case "KILOGRAMS":
		return BACnetEngineeringUnits_KILOGRAMS, true
	case "OHMS":
		return BACnetEngineeringUnits_OHMS, true
	case "POUNDS_MASS":
		return BACnetEngineeringUnits_POUNDS_MASS, true
	case "TONS":
		return BACnetEngineeringUnits_TONS, true
	case "KILOGRAMS_PER_SECOND":
		return BACnetEngineeringUnits_KILOGRAMS_PER_SECOND, true
	case "KILOGRAMS_PER_MINUTE":
		return BACnetEngineeringUnits_KILOGRAMS_PER_MINUTE, true
	case "KILOGRAMS_PER_HOUR":
		return BACnetEngineeringUnits_KILOGRAMS_PER_HOUR, true
	case "POUNDS_MASS_PER_MINUTE":
		return BACnetEngineeringUnits_POUNDS_MASS_PER_MINUTE, true
	case "POUNDS_MASS_PER_HOUR":
		return BACnetEngineeringUnits_POUNDS_MASS_PER_HOUR, true
	case "WATTS":
		return BACnetEngineeringUnits_WATTS, true
	case "STANDARD_CUBIC_FEET_PER_DAY":
		return BACnetEngineeringUnits_STANDARD_CUBIC_FEET_PER_DAY, true
	case "MILLION_STANDARD_CUBIC_FEET_PER_DAY":
		return BACnetEngineeringUnits_MILLION_STANDARD_CUBIC_FEET_PER_DAY, true
	case "THOUSAND_CUBIC_FEET_PER_DAY":
		return BACnetEngineeringUnits_THOUSAND_CUBIC_FEET_PER_DAY, true
	case "THOUSAND_STANDARD_CUBIC_FEET_PER_DAY":
		return BACnetEngineeringUnits_THOUSAND_STANDARD_CUBIC_FEET_PER_DAY, true
	case "POUNDS_MASS_PER_DAY":
		return BACnetEngineeringUnits_POUNDS_MASS_PER_DAY, true
	case "MILLIREMS":
		return BACnetEngineeringUnits_MILLIREMS, true
	case "MILLIREMS_PER_HOUR":
		return BACnetEngineeringUnits_MILLIREMS_PER_HOUR, true
	case "KILOWATTS":
		return BACnetEngineeringUnits_KILOWATTS, true
	case "MEGAWATTS":
		return BACnetEngineeringUnits_MEGAWATTS, true
	case "VOLTS":
		return BACnetEngineeringUnits_VOLTS, true
	case "BTUS_PER_HOUR":
		return BACnetEngineeringUnits_BTUS_PER_HOUR, true
	case "HORSEPOWER":
		return BACnetEngineeringUnits_HORSEPOWER, true
	case "TONS_REFRIGERATION":
		return BACnetEngineeringUnits_TONS_REFRIGERATION, true
	case "PASCALS":
		return BACnetEngineeringUnits_PASCALS, true
	case "KILOPASCALS":
		return BACnetEngineeringUnits_KILOPASCALS, true
	case "BARS":
		return BACnetEngineeringUnits_BARS, true
	case "POUNDS_FORCE_PER_SQUARE_INCH":
		return BACnetEngineeringUnits_POUNDS_FORCE_PER_SQUARE_INCH, true
	case "CENTIMETERS_OF_WATER":
		return BACnetEngineeringUnits_CENTIMETERS_OF_WATER, true
	case "INCHES_OF_WATER":
		return BACnetEngineeringUnits_INCHES_OF_WATER, true
	case "MILLIMETERS_OF_MERCURY":
		return BACnetEngineeringUnits_MILLIMETERS_OF_MERCURY, true
	case "KILOVOLTS":
		return BACnetEngineeringUnits_KILOVOLTS, true
	case "CENTIMETERS_OF_MERCURY":
		return BACnetEngineeringUnits_CENTIMETERS_OF_MERCURY, true
	case "INCHES_OF_MERCURY":
		return BACnetEngineeringUnits_INCHES_OF_MERCURY, true
	case "DEGREES_CELSIUS":
		return BACnetEngineeringUnits_DEGREES_CELSIUS, true
	case "DEGREES_KELVIN":
		return BACnetEngineeringUnits_DEGREES_KELVIN, true
	case "DEGREES_FAHRENHEIT":
		return BACnetEngineeringUnits_DEGREES_FAHRENHEIT, true
	case "DEGREE_DAYS_CELSIUS":
		return BACnetEngineeringUnits_DEGREE_DAYS_CELSIUS, true
	case "DEGREE_DAYS_FAHRENHEIT":
		return BACnetEngineeringUnits_DEGREE_DAYS_FAHRENHEIT, true
	case "YEARS":
		return BACnetEngineeringUnits_YEARS, true
	case "MONTHS":
		return BACnetEngineeringUnits_MONTHS, true
	case "WEEKS":
		return BACnetEngineeringUnits_WEEKS, true
	case "MEGAVOLTS":
		return BACnetEngineeringUnits_MEGAVOLTS, true
	case "DAYS":
		return BACnetEngineeringUnits_DAYS, true
	case "HOURS":
		return BACnetEngineeringUnits_HOURS, true
	case "MINUTES":
		return BACnetEngineeringUnits_MINUTES, true
	case "SECONDS":
		return BACnetEngineeringUnits_SECONDS, true
	case "METERS_PER_SECOND":
		return BACnetEngineeringUnits_METERS_PER_SECOND, true
	case "KILOMETERS_PER_HOUR":
		return BACnetEngineeringUnits_KILOMETERS_PER_HOUR, true
	case "FEET_PER_SECOND":
		return BACnetEngineeringUnits_FEET_PER_SECOND, true
	case "FEET_PER_MINUTE":
		return BACnetEngineeringUnits_FEET_PER_MINUTE, true
	case "MILES_PER_HOUR":
		return BACnetEngineeringUnits_MILES_PER_HOUR, true
	case "CUBIC_FEET":
		return BACnetEngineeringUnits_CUBIC_FEET, true
	case "VOLT_AMPERES":
		return BACnetEngineeringUnits_VOLT_AMPERES, true
	case "CUBIC_METERS":
		return BACnetEngineeringUnits_CUBIC_METERS, true
	case "IMPERIAL_GALLONS":
		return BACnetEngineeringUnits_IMPERIAL_GALLONS, true
	case "LITERS":
		return BACnetEngineeringUnits_LITERS, true
	case "US_GALLONS":
		return BACnetEngineeringUnits_US_GALLONS, true
	case "CUBIC_FEET_PER_MINUTE":
		return BACnetEngineeringUnits_CUBIC_FEET_PER_MINUTE, true
	case "CUBIC_METERS_PER_SECOND":
		return BACnetEngineeringUnits_CUBIC_METERS_PER_SECOND, true
	case "IMPERIAL_GALLONS_PER_MINUTE":
		return BACnetEngineeringUnits_IMPERIAL_GALLONS_PER_MINUTE, true
	case "LITERS_PER_SECOND":
		return BACnetEngineeringUnits_LITERS_PER_SECOND, true
	case "LITERS_PER_MINUTE":
		return BACnetEngineeringUnits_LITERS_PER_MINUTE, true
	case "US_GALLONS_PER_MINUTE":
		return BACnetEngineeringUnits_US_GALLONS_PER_MINUTE, true
	case "KILOVOLT_AMPERES":
		return BACnetEngineeringUnits_KILOVOLT_AMPERES, true
	case "DEGREES_ANGULAR":
		return BACnetEngineeringUnits_DEGREES_ANGULAR, true
	case "DEGREES_CELSIUS_PER_HOUR":
		return BACnetEngineeringUnits_DEGREES_CELSIUS_PER_HOUR, true
	case "DEGREES_CELSIUS_PER_MINUTE":
		return BACnetEngineeringUnits_DEGREES_CELSIUS_PER_MINUTE, true
	case "DEGREES_FAHRENHEIT_PER_HOUR":
		return BACnetEngineeringUnits_DEGREES_FAHRENHEIT_PER_HOUR, true
	case "DEGREES_FAHRENHEIT_PER_MINUTE":
		return BACnetEngineeringUnits_DEGREES_FAHRENHEIT_PER_MINUTE, true
	case "NO_UNITS":
		return BACnetEngineeringUnits_NO_UNITS, true
	case "PARTS_PER_MILLION":
		return BACnetEngineeringUnits_PARTS_PER_MILLION, true
	case "PARTS_PER_BILLION":
		return BACnetEngineeringUnits_PARTS_PER_BILLION, true
	case "PERCENT":
		return BACnetEngineeringUnits_PERCENT, true
	case "PERCENT_PER_SECOND":
		return BACnetEngineeringUnits_PERCENT_PER_SECOND, true
	}
	return 0, false
}

func BACnetEngineeringUnitsKnows(value uint32) bool {
	for _, typeValue := range BACnetEngineeringUnitsValues {
		if uint32(typeValue) == value {
			return true
		}
	}
	return false
}

func CastBACnetEngineeringUnits(structType interface{}) BACnetEngineeringUnits {
	castFunc := func(typ interface{}) BACnetEngineeringUnits {
		if sBACnetEngineeringUnits, ok := typ.(BACnetEngineeringUnits); ok {
			return sBACnetEngineeringUnits
		}
		return 0
	}
	return castFunc(structType)
}

func (m BACnetEngineeringUnits) GetLengthInBits() uint16 {
	return 32
}

func (m BACnetEngineeringUnits) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetEngineeringUnitsParse(readBuffer utils.ReadBuffer) (BACnetEngineeringUnits, error) {
	val, err := readBuffer.ReadUint32("BACnetEngineeringUnits", 32)
	if err != nil {
		return 0, errors.Wrap(err, "error reading BACnetEngineeringUnits")
	}
	if enum, ok := BACnetEngineeringUnitsByValue(val); !ok {
		Plc4xModelLog.Debug().Msgf("no value %x found for RequestType", val)
		return BACnetEngineeringUnits(val), nil
	} else {
		return enum, nil
	}
}

func (e BACnetEngineeringUnits) Serialize(writeBuffer utils.WriteBuffer) error {
	return writeBuffer.WriteUint32("BACnetEngineeringUnits", 32, uint32(e), utils.WithAdditionalStringRepresentation(e.PLC4XEnumName()))
}

// PLC4XEnumName returns the name that is used in code to identify this enum
func (e BACnetEngineeringUnits) PLC4XEnumName() string {
	switch e {
	case BACnetEngineeringUnits_SQUARE_METERS:
		return "SQUARE_METERS"
	case BACnetEngineeringUnits_VENDOR_PROPRIETARY_VALUE:
		return "VENDOR_PROPRIETARY_VALUE"
	case BACnetEngineeringUnits_SQUARE_FEET:
		return "SQUARE_FEET"
	case BACnetEngineeringUnits_MEGAVOLT_AMPERES:
		return "MEGAVOLT_AMPERES"
	case BACnetEngineeringUnits_PER_MINUTE:
		return "PER_MINUTE"
	case BACnetEngineeringUnits_PER_SECOND:
		return "PER_SECOND"
	case BACnetEngineeringUnits_PSI_PER_DEGREE_FAHRENHEIT:
		return "PSI_PER_DEGREE_FAHRENHEIT"
	case BACnetEngineeringUnits_RADIANS:
		return "RADIANS"
	case BACnetEngineeringUnits_REVOLUTIONS_PER_MINUTE:
		return "REVOLUTIONS_PER_MINUTE"
	case BACnetEngineeringUnits_CURRENCY1:
		return "CURRENCY1"
	case BACnetEngineeringUnits_CURRENCY2:
		return "CURRENCY2"
	case BACnetEngineeringUnits_CURRENCY3:
		return "CURRENCY3"
	case BACnetEngineeringUnits_CURRENCY4:
		return "CURRENCY4"
	case BACnetEngineeringUnits_CURRENCY5:
		return "CURRENCY5"
	case BACnetEngineeringUnits_VOLT_AMPERES_REACTIVE:
		return "VOLT_AMPERES_REACTIVE"
	case BACnetEngineeringUnits_CURRENCY6:
		return "CURRENCY6"
	case BACnetEngineeringUnits_CURRENCY7:
		return "CURRENCY7"
	case BACnetEngineeringUnits_CURRENCY8:
		return "CURRENCY8"
	case BACnetEngineeringUnits_CURRENCY9:
		return "CURRENCY9"
	case BACnetEngineeringUnits_CURRENCY10:
		return "CURRENCY10"
	case BACnetEngineeringUnits_SQUARE_INCHES:
		return "SQUARE_INCHES"
	case BACnetEngineeringUnits_SQUARE_CENTIMETERS:
		return "SQUARE_CENTIMETERS"
	case BACnetEngineeringUnits_BTUS_PER_POUND:
		return "BTUS_PER_POUND"
	case BACnetEngineeringUnits_CENTIMETERS:
		return "CENTIMETERS"
	case BACnetEngineeringUnits_POUNDS_MASS_PER_SECOND:
		return "POUNDS_MASS_PER_SECOND"
	case BACnetEngineeringUnits_KILOVOLT_AMPERES_REACTIVE:
		return "KILOVOLT_AMPERES_REACTIVE"
	case BACnetEngineeringUnits_DELTA_DEGREES_FAHRENHEIT:
		return "DELTA_DEGREES_FAHRENHEIT"
	case BACnetEngineeringUnits_DELTA_DEGREES_KELVIN:
		return "DELTA_DEGREES_KELVIN"
	case BACnetEngineeringUnits_KILOHMS:
		return "KILOHMS"
	case BACnetEngineeringUnits_MEGOHMS:
		return "MEGOHMS"
	case BACnetEngineeringUnits_MILLIVOLTS:
		return "MILLIVOLTS"
	case BACnetEngineeringUnits_KILOJOULES_PER_KILOGRAM:
		return "KILOJOULES_PER_KILOGRAM"
	case BACnetEngineeringUnits_MEGAJOULES:
		return "MEGAJOULES"
	case BACnetEngineeringUnits_MEGAVOLT_AMPERES_REACTIVE:
		return "MEGAVOLT_AMPERES_REACTIVE"
	case BACnetEngineeringUnits_IWATTS:
		return "IWATTS"
	case BACnetEngineeringUnits_HECTOPASCALS:
		return "HECTOPASCALS"
	case BACnetEngineeringUnits_MILLIBARS:
		return "MILLIBARS"
	case BACnetEngineeringUnits_CUBIC_METERS_PER_HOUR:
		return "CUBIC_METERS_PER_HOUR"
	case BACnetEngineeringUnits_LITERS_PER_HOUR:
		return "LITERS_PER_HOUR"
	case BACnetEngineeringUnits_KILOWATT_HOURS_PER_SQUARE_METER:
		return "KILOWATT_HOURS_PER_SQUARE_METER"
	case BACnetEngineeringUnits_KILOWATT_HOURS_PER_SQUARE_FOOT:
		return "KILOWATT_HOURS_PER_SQUARE_FOOT"
	case BACnetEngineeringUnits_MEGAJOULES_PER_SQUARE_METER:
		return "MEGAJOULES_PER_SQUARE_METER"
	case BACnetEngineeringUnits_DEGREES_PHASE:
		return "DEGREES_PHASE"
	case BACnetEngineeringUnits_MEGAJOULES_PER_SQUARE_FOOT:
		return "MEGAJOULES_PER_SQUARE_FOOT"
	case BACnetEngineeringUnits_WATTS_PER_SQUARE_METER_DEGREE_KELVIN:
		return "WATTS_PER_SQUARE_METER_DEGREE_KELVIN"
	case BACnetEngineeringUnits_CUBIC_FEET_PER_SECOND:
		return "CUBIC_FEET_PER_SECOND"
	case BACnetEngineeringUnits_PERCENT_OBSCURATION_PER_FOOT:
		return "PERCENT_OBSCURATION_PER_FOOT"
	case BACnetEngineeringUnits_PERCENT_OBSCURATION_PER_METER:
		return "PERCENT_OBSCURATION_PER_METER"
	case BACnetEngineeringUnits_MILLIOHMS:
		return "MILLIOHMS"
	case BACnetEngineeringUnits_MEGAWATT_HOURS:
		return "MEGAWATT_HOURS"
	case BACnetEngineeringUnits_KILO_BTUS:
		return "KILO_BTUS"
	case BACnetEngineeringUnits_MEGA_BTUS:
		return "MEGA_BTUS"
	case BACnetEngineeringUnits_KILOJOULES_PER_KILOGRAM_DRY_AIR:
		return "KILOJOULES_PER_KILOGRAM_DRY_AIR"
	case BACnetEngineeringUnits_POWER_FACTOR:
		return "POWER_FACTOR"
	case BACnetEngineeringUnits_MEGAJOULES_PER_KILOGRAM_DRY_AIR:
		return "MEGAJOULES_PER_KILOGRAM_DRY_AIR"
	case BACnetEngineeringUnits_GRAMS_PER_SECOND:
		return "GRAMS_PER_SECOND"
	case BACnetEngineeringUnits_GRAMS_PER_MINUTE:
		return "GRAMS_PER_MINUTE"
	case BACnetEngineeringUnits_TONS_PER_HOUR:
		return "TONS_PER_HOUR"
	case BACnetEngineeringUnits_KILO_BTUS_PER_HOUR:
		return "KILO_BTUS_PER_HOUR"
	case BACnetEngineeringUnits_HUNDREDTHS_SECONDS:
		return "HUNDREDTHS_SECONDS"
	case BACnetEngineeringUnits_MILLISECONDS:
		return "MILLISECONDS"
	case BACnetEngineeringUnits_JOULES:
		return "JOULES"
	case BACnetEngineeringUnits_NEWTON_METERS:
		return "NEWTON_METERS"
	case BACnetEngineeringUnits_MILLIMETERS_PER_SECOND:
		return "MILLIMETERS_PER_SECOND"
	case BACnetEngineeringUnits_MILLIMETERS_PER_MINUTE:
		return "MILLIMETERS_PER_MINUTE"
	case BACnetEngineeringUnits_METERS_PER_MINUTE:
		return "METERS_PER_MINUTE"
	case BACnetEngineeringUnits_METERS_PER_HOUR:
		return "METERS_PER_HOUR"
	case BACnetEngineeringUnits_CUBIC_METERS_PER_MINUTE:
		return "CUBIC_METERS_PER_MINUTE"
	case BACnetEngineeringUnits_METERS_PER_SECOND_PER_SECOND:
		return "METERS_PER_SECOND_PER_SECOND"
	case BACnetEngineeringUnits_AMPERES_PER_METER:
		return "AMPERES_PER_METER"
	case BACnetEngineeringUnits_AMPERES_PER_SQUARE_METER:
		return "AMPERES_PER_SQUARE_METER"
	case BACnetEngineeringUnits_AMPERE_SQUARE_METERS:
		return "AMPERE_SQUARE_METERS"
	case BACnetEngineeringUnits_KILOJOULES:
		return "KILOJOULES"
	case BACnetEngineeringUnits_FARADS:
		return "FARADS"
	case BACnetEngineeringUnits_HENRYS:
		return "HENRYS"
	case BACnetEngineeringUnits_OHM_METERS:
		return "OHM_METERS"
	case BACnetEngineeringUnits_SIEMENS:
		return "SIEMENS"
	case BACnetEngineeringUnits_SIEMENS_PER_METER:
		return "SIEMENS_PER_METER"
	case BACnetEngineeringUnits_TESLAS:
		return "TESLAS"
	case BACnetEngineeringUnits_VOLTS_PER_DEGREE_KELVIN:
		return "VOLTS_PER_DEGREE_KELVIN"
	case BACnetEngineeringUnits_VOLTS_PER_METER:
		return "VOLTS_PER_METER"
	case BACnetEngineeringUnits_WEBERS:
		return "WEBERS"
	case BACnetEngineeringUnits_CANDELAS:
		return "CANDELAS"
	case BACnetEngineeringUnits_WATT_HOURS:
		return "WATT_HOURS"
	case BACnetEngineeringUnits_CANDELAS_PER_SQUARE_METER:
		return "CANDELAS_PER_SQUARE_METER"
	case BACnetEngineeringUnits_DEGREES_KELVIN_PER_HOUR:
		return "DEGREES_KELVIN_PER_HOUR"
	case BACnetEngineeringUnits_DEGREES_KELVIN_PER_MINUTE:
		return "DEGREES_KELVIN_PER_MINUTE"
	case BACnetEngineeringUnits_JOULE_SECONDS:
		return "JOULE_SECONDS"
	case BACnetEngineeringUnits_RADIANS_PER_SECOND:
		return "RADIANS_PER_SECOND"
	case BACnetEngineeringUnits_SQUARE_METERS_PER_NEWTON:
		return "SQUARE_METERS_PER_NEWTON"
	case BACnetEngineeringUnits_KILOGRAMS_PER_CUBIC_METER:
		return "KILOGRAMS_PER_CUBIC_METER"
	case BACnetEngineeringUnits_NEWTON_SECONDS:
		return "NEWTON_SECONDS"
	case BACnetEngineeringUnits_NEWTONS_PER_METER:
		return "NEWTONS_PER_METER"
	case BACnetEngineeringUnits_WATTS_PER_METER_PER_DEGREE_KELVIN:
		return "WATTS_PER_METER_PER_DEGREE_KELVIN"
	case BACnetEngineeringUnits_KILOWATT_HOURS:
		return "KILOWATT_HOURS"
	case BACnetEngineeringUnits_MICROSIEMENS:
		return "MICROSIEMENS"
	case BACnetEngineeringUnits_CUBIC_FEET_PER_HOUR:
		return "CUBIC_FEET_PER_HOUR"
	case BACnetEngineeringUnits_US_GALLONS_PER_HOUR:
		return "US_GALLONS_PER_HOUR"
	case BACnetEngineeringUnits_KILOMETERS:
		return "KILOMETERS"
	case BACnetEngineeringUnits_MICROMETERS:
		return "MICROMETERS"
	case BACnetEngineeringUnits_GRAMS:
		return "GRAMS"
	case BACnetEngineeringUnits_MILLIGRAMS:
		return "MILLIGRAMS"
	case BACnetEngineeringUnits_MILLILITERS:
		return "MILLILITERS"
	case BACnetEngineeringUnits_MILLILITERS_PER_SECOND:
		return "MILLILITERS_PER_SECOND"
	case BACnetEngineeringUnits_DECIBELS:
		return "DECIBELS"
	case BACnetEngineeringUnits_MILLIAMPERES:
		return "MILLIAMPERES"
	case BACnetEngineeringUnits_BTUS:
		return "BTUS"
	case BACnetEngineeringUnits_DECIBELS_MILLIVOLT:
		return "DECIBELS_MILLIVOLT"
	case BACnetEngineeringUnits_DECIBELS_VOLT:
		return "DECIBELS_VOLT"
	case BACnetEngineeringUnits_MILLISIEMENS:
		return "MILLISIEMENS"
	case BACnetEngineeringUnits_WATT_HOURS_REACTIVE:
		return "WATT_HOURS_REACTIVE"
	case BACnetEngineeringUnits_KILOWATT_HOURS_REACTIVE:
		return "KILOWATT_HOURS_REACTIVE"
	case BACnetEngineeringUnits_MEGAWATT_HOURS_REACTIVE:
		return "MEGAWATT_HOURS_REACTIVE"
	case BACnetEngineeringUnits_MILLIMETERS_OF_WATER:
		return "MILLIMETERS_OF_WATER"
	case BACnetEngineeringUnits_PER_MILLE:
		return "PER_MILLE"
	case BACnetEngineeringUnits_GRAMS_PER_GRAM:
		return "GRAMS_PER_GRAM"
	case BACnetEngineeringUnits_KILOGRAMS_PER_KILOGRAM:
		return "KILOGRAMS_PER_KILOGRAM"
	case BACnetEngineeringUnits_THERMS:
		return "THERMS"
	case BACnetEngineeringUnits_GRAMS_PER_KILOGRAM:
		return "GRAMS_PER_KILOGRAM"
	case BACnetEngineeringUnits_MILLIGRAMS_PER_GRAM:
		return "MILLIGRAMS_PER_GRAM"
	case BACnetEngineeringUnits_MILLIGRAMS_PER_KILOGRAM:
		return "MILLIGRAMS_PER_KILOGRAM"
	case BACnetEngineeringUnits_GRAMS_PER_MILLILITER:
		return "GRAMS_PER_MILLILITER"
	case BACnetEngineeringUnits_GRAMS_PER_LITER:
		return "GRAMS_PER_LITER"
	case BACnetEngineeringUnits_MILLIGRAMS_PER_LITER:
		return "MILLIGRAMS_PER_LITER"
	case BACnetEngineeringUnits_MICROGRAMS_PER_LITER:
		return "MICROGRAMS_PER_LITER"
	case BACnetEngineeringUnits_GRAMS_PER_CUBIC_METER:
		return "GRAMS_PER_CUBIC_METER"
	case BACnetEngineeringUnits_MILLIGRAMS_PER_CUBIC_METER:
		return "MILLIGRAMS_PER_CUBIC_METER"
	case BACnetEngineeringUnits_MICROGRAMS_PER_CUBIC_METER:
		return "MICROGRAMS_PER_CUBIC_METER"
	case BACnetEngineeringUnits_TON_HOURS:
		return "TON_HOURS"
	case BACnetEngineeringUnits_NANOGRAMS_PER_CUBIC_METER:
		return "NANOGRAMS_PER_CUBIC_METER"
	case BACnetEngineeringUnits_GRAMS_PER_CUBIC_CENTIMETER:
		return "GRAMS_PER_CUBIC_CENTIMETER"
	case BACnetEngineeringUnits_BECQUERELS:
		return "BECQUERELS"
	case BACnetEngineeringUnits_KILOBECQUERELS:
		return "KILOBECQUERELS"
	case BACnetEngineeringUnits_MEGABECQUERELS:
		return "MEGABECQUERELS"
	case BACnetEngineeringUnits_GRAY:
		return "GRAY"
	case BACnetEngineeringUnits_MILLIGRAY:
		return "MILLIGRAY"
	case BACnetEngineeringUnits_MICROGRAY:
		return "MICROGRAY"
	case BACnetEngineeringUnits_SIEVERTS:
		return "SIEVERTS"
	case BACnetEngineeringUnits_MILLISIEVERTS:
		return "MILLISIEVERTS"
	case BACnetEngineeringUnits_JOULES_PER_KILOGRAM_DRY_AIR:
		return "JOULES_PER_KILOGRAM_DRY_AIR"
	case BACnetEngineeringUnits_MICROSIEVERTS:
		return "MICROSIEVERTS"
	case BACnetEngineeringUnits_MICROSIEVERTS_PER_HOUR:
		return "MICROSIEVERTS_PER_HOUR"
	case BACnetEngineeringUnits_DECIBELS_A:
		return "DECIBELS_A"
	case BACnetEngineeringUnits_NEPHELOMETRIC_TURBIDITY_UNIT:
		return "NEPHELOMETRIC_TURBIDITY_UNIT"
	case BACnetEngineeringUnits_P_H:
		return "P_H"
	case BACnetEngineeringUnits_GRAMS_PER_SQUARE_METER:
		return "GRAMS_PER_SQUARE_METER"
	case BACnetEngineeringUnits_MINUTES_PER_DEGREE_KELVIN:
		return "MINUTES_PER_DEGREE_KELVIN"
	case BACnetEngineeringUnits_OHM_METER_SQUARED_PER_METER:
		return "OHM_METER_SQUARED_PER_METER"
	case BACnetEngineeringUnits_AMPERE_SECONDS:
		return "AMPERE_SECONDS"
	case BACnetEngineeringUnits_VOLT_AMPERE_HOURS:
		return "VOLT_AMPERE_HOURS"
	case BACnetEngineeringUnits_BTUS_PER_POUND_DRY_AIR:
		return "BTUS_PER_POUND_DRY_AIR"
	case BACnetEngineeringUnits_KILOVOLT_AMPERE_HOURS:
		return "KILOVOLT_AMPERE_HOURS"
	case BACnetEngineeringUnits_MEGAVOLT_AMPERE_HOURS:
		return "MEGAVOLT_AMPERE_HOURS"
	case BACnetEngineeringUnits_VOLT_AMPERE_HOURS_REACTIVE:
		return "VOLT_AMPERE_HOURS_REACTIVE"
	case BACnetEngineeringUnits_KILOVOLT_AMPERE_HOURS_REACTIVE:
		return "KILOVOLT_AMPERE_HOURS_REACTIVE"
	case BACnetEngineeringUnits_MEGAVOLT_AMPERE_HOURS_REACTIVE:
		return "MEGAVOLT_AMPERE_HOURS_REACTIVE"
	case BACnetEngineeringUnits_VOLT_SQUARE_HOURS:
		return "VOLT_SQUARE_HOURS"
	case BACnetEngineeringUnits_AMPERE_SQUARE_HOURS:
		return "AMPERE_SQUARE_HOURS"
	case BACnetEngineeringUnits_JOULE_PER_HOURS:
		return "JOULE_PER_HOURS"
	case BACnetEngineeringUnits_CUBIC_FEET_PER_DAY:
		return "CUBIC_FEET_PER_DAY"
	case BACnetEngineeringUnits_CUBIC_METERS_PER_DAY:
		return "CUBIC_METERS_PER_DAY"
	case BACnetEngineeringUnits_WATT_HOURS_PER_CUBIC_METER:
		return "WATT_HOURS_PER_CUBIC_METER"
	case BACnetEngineeringUnits_JOULES_PER_CUBIC_METER:
		return "JOULES_PER_CUBIC_METER"
	case BACnetEngineeringUnits_MOLE_PERCENT:
		return "MOLE_PERCENT"
	case BACnetEngineeringUnits_PASCAL_SECONDS:
		return "PASCAL_SECONDS"
	case BACnetEngineeringUnits_MILLION_STANDARD_CUBIC_FEET_PER_MINUTE:
		return "MILLION_STANDARD_CUBIC_FEET_PER_MINUTE"
	case BACnetEngineeringUnits_GRAMS_OF_WATER_PER_KILOGRAM_DRY_AIR:
		return "GRAMS_OF_WATER_PER_KILOGRAM_DRY_AIR"
	case BACnetEngineeringUnits_PERCENT_RELATIVE_HUMIDITY:
		return "PERCENT_RELATIVE_HUMIDITY"
	case BACnetEngineeringUnits_AMPERES:
		return "AMPERES"
	case BACnetEngineeringUnits_MILLIMETERS:
		return "MILLIMETERS"
	case BACnetEngineeringUnits_METERS:
		return "METERS"
	case BACnetEngineeringUnits_INCHES:
		return "INCHES"
	case BACnetEngineeringUnits_FEET:
		return "FEET"
	case BACnetEngineeringUnits_WATTS_PER_SQUARE_FOOT:
		return "WATTS_PER_SQUARE_FOOT"
	case BACnetEngineeringUnits_WATTS_PER_SQUARE_METER:
		return "WATTS_PER_SQUARE_METER"
	case BACnetEngineeringUnits_LUMENS:
		return "LUMENS"
	case BACnetEngineeringUnits_LUXES:
		return "LUXES"
	case BACnetEngineeringUnits_FOOT_CANDLES:
		return "FOOT_CANDLES"
	case BACnetEngineeringUnits_KILOGRAMS:
		return "KILOGRAMS"
	case BACnetEngineeringUnits_OHMS:
		return "OHMS"
	case BACnetEngineeringUnits_POUNDS_MASS:
		return "POUNDS_MASS"
	case BACnetEngineeringUnits_TONS:
		return "TONS"
	case BACnetEngineeringUnits_KILOGRAMS_PER_SECOND:
		return "KILOGRAMS_PER_SECOND"
	case BACnetEngineeringUnits_KILOGRAMS_PER_MINUTE:
		return "KILOGRAMS_PER_MINUTE"
	case BACnetEngineeringUnits_KILOGRAMS_PER_HOUR:
		return "KILOGRAMS_PER_HOUR"
	case BACnetEngineeringUnits_POUNDS_MASS_PER_MINUTE:
		return "POUNDS_MASS_PER_MINUTE"
	case BACnetEngineeringUnits_POUNDS_MASS_PER_HOUR:
		return "POUNDS_MASS_PER_HOUR"
	case BACnetEngineeringUnits_WATTS:
		return "WATTS"
	case BACnetEngineeringUnits_STANDARD_CUBIC_FEET_PER_DAY:
		return "STANDARD_CUBIC_FEET_PER_DAY"
	case BACnetEngineeringUnits_MILLION_STANDARD_CUBIC_FEET_PER_DAY:
		return "MILLION_STANDARD_CUBIC_FEET_PER_DAY"
	case BACnetEngineeringUnits_THOUSAND_CUBIC_FEET_PER_DAY:
		return "THOUSAND_CUBIC_FEET_PER_DAY"
	case BACnetEngineeringUnits_THOUSAND_STANDARD_CUBIC_FEET_PER_DAY:
		return "THOUSAND_STANDARD_CUBIC_FEET_PER_DAY"
	case BACnetEngineeringUnits_POUNDS_MASS_PER_DAY:
		return "POUNDS_MASS_PER_DAY"
	case BACnetEngineeringUnits_MILLIREMS:
		return "MILLIREMS"
	case BACnetEngineeringUnits_MILLIREMS_PER_HOUR:
		return "MILLIREMS_PER_HOUR"
	case BACnetEngineeringUnits_KILOWATTS:
		return "KILOWATTS"
	case BACnetEngineeringUnits_MEGAWATTS:
		return "MEGAWATTS"
	case BACnetEngineeringUnits_VOLTS:
		return "VOLTS"
	case BACnetEngineeringUnits_BTUS_PER_HOUR:
		return "BTUS_PER_HOUR"
	case BACnetEngineeringUnits_HORSEPOWER:
		return "HORSEPOWER"
	case BACnetEngineeringUnits_TONS_REFRIGERATION:
		return "TONS_REFRIGERATION"
	case BACnetEngineeringUnits_PASCALS:
		return "PASCALS"
	case BACnetEngineeringUnits_KILOPASCALS:
		return "KILOPASCALS"
	case BACnetEngineeringUnits_BARS:
		return "BARS"
	case BACnetEngineeringUnits_POUNDS_FORCE_PER_SQUARE_INCH:
		return "POUNDS_FORCE_PER_SQUARE_INCH"
	case BACnetEngineeringUnits_CENTIMETERS_OF_WATER:
		return "CENTIMETERS_OF_WATER"
	case BACnetEngineeringUnits_INCHES_OF_WATER:
		return "INCHES_OF_WATER"
	case BACnetEngineeringUnits_MILLIMETERS_OF_MERCURY:
		return "MILLIMETERS_OF_MERCURY"
	case BACnetEngineeringUnits_KILOVOLTS:
		return "KILOVOLTS"
	case BACnetEngineeringUnits_CENTIMETERS_OF_MERCURY:
		return "CENTIMETERS_OF_MERCURY"
	case BACnetEngineeringUnits_INCHES_OF_MERCURY:
		return "INCHES_OF_MERCURY"
	case BACnetEngineeringUnits_DEGREES_CELSIUS:
		return "DEGREES_CELSIUS"
	case BACnetEngineeringUnits_DEGREES_KELVIN:
		return "DEGREES_KELVIN"
	case BACnetEngineeringUnits_DEGREES_FAHRENHEIT:
		return "DEGREES_FAHRENHEIT"
	case BACnetEngineeringUnits_DEGREE_DAYS_CELSIUS:
		return "DEGREE_DAYS_CELSIUS"
	case BACnetEngineeringUnits_DEGREE_DAYS_FAHRENHEIT:
		return "DEGREE_DAYS_FAHRENHEIT"
	case BACnetEngineeringUnits_YEARS:
		return "YEARS"
	case BACnetEngineeringUnits_MONTHS:
		return "MONTHS"
	case BACnetEngineeringUnits_WEEKS:
		return "WEEKS"
	case BACnetEngineeringUnits_MEGAVOLTS:
		return "MEGAVOLTS"
	case BACnetEngineeringUnits_DAYS:
		return "DAYS"
	case BACnetEngineeringUnits_HOURS:
		return "HOURS"
	case BACnetEngineeringUnits_MINUTES:
		return "MINUTES"
	case BACnetEngineeringUnits_SECONDS:
		return "SECONDS"
	case BACnetEngineeringUnits_METERS_PER_SECOND:
		return "METERS_PER_SECOND"
	case BACnetEngineeringUnits_KILOMETERS_PER_HOUR:
		return "KILOMETERS_PER_HOUR"
	case BACnetEngineeringUnits_FEET_PER_SECOND:
		return "FEET_PER_SECOND"
	case BACnetEngineeringUnits_FEET_PER_MINUTE:
		return "FEET_PER_MINUTE"
	case BACnetEngineeringUnits_MILES_PER_HOUR:
		return "MILES_PER_HOUR"
	case BACnetEngineeringUnits_CUBIC_FEET:
		return "CUBIC_FEET"
	case BACnetEngineeringUnits_VOLT_AMPERES:
		return "VOLT_AMPERES"
	case BACnetEngineeringUnits_CUBIC_METERS:
		return "CUBIC_METERS"
	case BACnetEngineeringUnits_IMPERIAL_GALLONS:
		return "IMPERIAL_GALLONS"
	case BACnetEngineeringUnits_LITERS:
		return "LITERS"
	case BACnetEngineeringUnits_US_GALLONS:
		return "US_GALLONS"
	case BACnetEngineeringUnits_CUBIC_FEET_PER_MINUTE:
		return "CUBIC_FEET_PER_MINUTE"
	case BACnetEngineeringUnits_CUBIC_METERS_PER_SECOND:
		return "CUBIC_METERS_PER_SECOND"
	case BACnetEngineeringUnits_IMPERIAL_GALLONS_PER_MINUTE:
		return "IMPERIAL_GALLONS_PER_MINUTE"
	case BACnetEngineeringUnits_LITERS_PER_SECOND:
		return "LITERS_PER_SECOND"
	case BACnetEngineeringUnits_LITERS_PER_MINUTE:
		return "LITERS_PER_MINUTE"
	case BACnetEngineeringUnits_US_GALLONS_PER_MINUTE:
		return "US_GALLONS_PER_MINUTE"
	case BACnetEngineeringUnits_KILOVOLT_AMPERES:
		return "KILOVOLT_AMPERES"
	case BACnetEngineeringUnits_DEGREES_ANGULAR:
		return "DEGREES_ANGULAR"
	case BACnetEngineeringUnits_DEGREES_CELSIUS_PER_HOUR:
		return "DEGREES_CELSIUS_PER_HOUR"
	case BACnetEngineeringUnits_DEGREES_CELSIUS_PER_MINUTE:
		return "DEGREES_CELSIUS_PER_MINUTE"
	case BACnetEngineeringUnits_DEGREES_FAHRENHEIT_PER_HOUR:
		return "DEGREES_FAHRENHEIT_PER_HOUR"
	case BACnetEngineeringUnits_DEGREES_FAHRENHEIT_PER_MINUTE:
		return "DEGREES_FAHRENHEIT_PER_MINUTE"
	case BACnetEngineeringUnits_NO_UNITS:
		return "NO_UNITS"
	case BACnetEngineeringUnits_PARTS_PER_MILLION:
		return "PARTS_PER_MILLION"
	case BACnetEngineeringUnits_PARTS_PER_BILLION:
		return "PARTS_PER_BILLION"
	case BACnetEngineeringUnits_PERCENT:
		return "PERCENT"
	case BACnetEngineeringUnits_PERCENT_PER_SECOND:
		return "PERCENT_PER_SECOND"
	}
	return ""
}

func (e BACnetEngineeringUnits) String() string {
	return e.PLC4XEnumName()
}
