/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataValueSet is the corresponding interface of BACnetConstructedDataValueSet
type BACnetConstructedDataValueSet interface {
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetValueSet returns ValueSet (property field)
	GetValueSet() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
}

// BACnetConstructedDataValueSetExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataValueSet.
// This is useful for switch cases.
type BACnetConstructedDataValueSetExactly interface {
	BACnetConstructedDataValueSet
	isBACnetConstructedDataValueSet() bool
}

// _BACnetConstructedDataValueSet is the data-structure of this message
type _BACnetConstructedDataValueSet struct {
	*_BACnetConstructedData
	ValueSet BACnetApplicationTagUnsignedInteger
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataValueSet) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataValueSet) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_VALUE_SET
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataValueSet) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataValueSet) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataValueSet) GetValueSet() BACnetApplicationTagUnsignedInteger {
	return m.ValueSet
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataValueSet) GetActualValue() BACnetApplicationTagUnsignedInteger {
	return CastBACnetApplicationTagUnsignedInteger(m.GetValueSet())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataValueSet factory function for _BACnetConstructedDataValueSet
func NewBACnetConstructedDataValueSet(valueSet BACnetApplicationTagUnsignedInteger, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataValueSet {
	_result := &_BACnetConstructedDataValueSet{
		ValueSet:               valueSet,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataValueSet(structType interface{}) BACnetConstructedDataValueSet {
	if casted, ok := structType.(BACnetConstructedDataValueSet); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataValueSet); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataValueSet) GetTypeName() string {
	return "BACnetConstructedDataValueSet"
}

func (m *_BACnetConstructedDataValueSet) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BACnetConstructedDataValueSet) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (valueSet)
	lengthInBits += m.ValueSet.GetLengthInBits()

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataValueSet) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetConstructedDataValueSetParse(readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataValueSet, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataValueSet"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataValueSet")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (valueSet)
	if pullErr := readBuffer.PullContext("valueSet"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for valueSet")
	}
	_valueSet, _valueSetErr := BACnetApplicationTagParse(readBuffer)
	if _valueSetErr != nil {
		return nil, errors.Wrap(_valueSetErr, "Error parsing 'valueSet' field of BACnetConstructedDataValueSet")
	}
	valueSet := _valueSet.(BACnetApplicationTagUnsignedInteger)
	if closeErr := readBuffer.CloseContext("valueSet"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for valueSet")
	}

	// Virtual field
	_actualValue := valueSet
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataValueSet"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataValueSet")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataValueSet{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		ValueSet: valueSet,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataValueSet) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataValueSet"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataValueSet")
		}

		// Simple Field (valueSet)
		if pushErr := writeBuffer.PushContext("valueSet"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for valueSet")
		}
		_valueSetErr := writeBuffer.WriteSerializable(m.GetValueSet())
		if popErr := writeBuffer.PopContext("valueSet"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for valueSet")
		}
		if _valueSetErr != nil {
			return errors.Wrap(_valueSetErr, "Error serializing 'valueSet' field")
		}
		// Virtual field
		if _actualValueErr := writeBuffer.WriteVirtual("actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataValueSet"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataValueSet")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataValueSet) isBACnetConstructedDataValueSet() bool {
	return true
}

func (m *_BACnetConstructedDataValueSet) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
