/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataProfileName is the corresponding interface of BACnetConstructedDataProfileName
type BACnetConstructedDataProfileName interface {
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetProfileName returns ProfileName (property field)
	GetProfileName() BACnetApplicationTagCharacterString
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagCharacterString
}

// BACnetConstructedDataProfileNameExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataProfileName.
// This is useful for switch cases.
type BACnetConstructedDataProfileNameExactly interface {
	BACnetConstructedDataProfileName
	isBACnetConstructedDataProfileName() bool
}

// _BACnetConstructedDataProfileName is the data-structure of this message
type _BACnetConstructedDataProfileName struct {
	*_BACnetConstructedData
	ProfileName BACnetApplicationTagCharacterString
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataProfileName) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataProfileName) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_PROFILE_NAME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataProfileName) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataProfileName) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataProfileName) GetProfileName() BACnetApplicationTagCharacterString {
	return m.ProfileName
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataProfileName) GetActualValue() BACnetApplicationTagCharacterString {
	return CastBACnetApplicationTagCharacterString(m.GetProfileName())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataProfileName factory function for _BACnetConstructedDataProfileName
func NewBACnetConstructedDataProfileName(profileName BACnetApplicationTagCharacterString, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataProfileName {
	_result := &_BACnetConstructedDataProfileName{
		ProfileName:            profileName,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataProfileName(structType interface{}) BACnetConstructedDataProfileName {
	if casted, ok := structType.(BACnetConstructedDataProfileName); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataProfileName); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataProfileName) GetTypeName() string {
	return "BACnetConstructedDataProfileName"
}

func (m *_BACnetConstructedDataProfileName) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BACnetConstructedDataProfileName) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (profileName)
	lengthInBits += m.ProfileName.GetLengthInBits()

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataProfileName) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetConstructedDataProfileNameParse(readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataProfileName, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataProfileName"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataProfileName")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (profileName)
	if pullErr := readBuffer.PullContext("profileName"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for profileName")
	}
	_profileName, _profileNameErr := BACnetApplicationTagParse(readBuffer)
	if _profileNameErr != nil {
		return nil, errors.Wrap(_profileNameErr, "Error parsing 'profileName' field of BACnetConstructedDataProfileName")
	}
	profileName := _profileName.(BACnetApplicationTagCharacterString)
	if closeErr := readBuffer.CloseContext("profileName"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for profileName")
	}

	// Virtual field
	_actualValue := profileName
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataProfileName"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataProfileName")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataProfileName{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		ProfileName: profileName,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataProfileName) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataProfileName"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataProfileName")
		}

		// Simple Field (profileName)
		if pushErr := writeBuffer.PushContext("profileName"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for profileName")
		}
		_profileNameErr := writeBuffer.WriteSerializable(m.GetProfileName())
		if popErr := writeBuffer.PopContext("profileName"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for profileName")
		}
		if _profileNameErr != nil {
			return errors.Wrap(_profileNameErr, "Error serializing 'profileName' field")
		}
		// Virtual field
		if _actualValueErr := writeBuffer.WriteVirtual("actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataProfileName"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataProfileName")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataProfileName) isBACnetConstructedDataProfileName() bool {
	return true
}

func (m *_BACnetConstructedDataProfileName) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
