/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataPower is the corresponding interface of BACnetConstructedDataPower
type BACnetConstructedDataPower interface {
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetPower returns Power (property field)
	GetPower() BACnetApplicationTagReal
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagReal
}

// BACnetConstructedDataPowerExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataPower.
// This is useful for switch cases.
type BACnetConstructedDataPowerExactly interface {
	BACnetConstructedDataPower
	isBACnetConstructedDataPower() bool
}

// _BACnetConstructedDataPower is the data-structure of this message
type _BACnetConstructedDataPower struct {
	*_BACnetConstructedData
	Power BACnetApplicationTagReal
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataPower) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataPower) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_POWER
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataPower) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataPower) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataPower) GetPower() BACnetApplicationTagReal {
	return m.Power
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataPower) GetActualValue() BACnetApplicationTagReal {
	return CastBACnetApplicationTagReal(m.GetPower())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataPower factory function for _BACnetConstructedDataPower
func NewBACnetConstructedDataPower(power BACnetApplicationTagReal, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataPower {
	_result := &_BACnetConstructedDataPower{
		Power:                  power,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataPower(structType interface{}) BACnetConstructedDataPower {
	if casted, ok := structType.(BACnetConstructedDataPower); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataPower); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataPower) GetTypeName() string {
	return "BACnetConstructedDataPower"
}

func (m *_BACnetConstructedDataPower) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BACnetConstructedDataPower) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (power)
	lengthInBits += m.Power.GetLengthInBits()

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataPower) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetConstructedDataPowerParse(readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataPower, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataPower"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataPower")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (power)
	if pullErr := readBuffer.PullContext("power"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for power")
	}
	_power, _powerErr := BACnetApplicationTagParse(readBuffer)
	if _powerErr != nil {
		return nil, errors.Wrap(_powerErr, "Error parsing 'power' field of BACnetConstructedDataPower")
	}
	power := _power.(BACnetApplicationTagReal)
	if closeErr := readBuffer.CloseContext("power"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for power")
	}

	// Virtual field
	_actualValue := power
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataPower"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataPower")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataPower{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		Power: power,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataPower) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataPower"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataPower")
		}

		// Simple Field (power)
		if pushErr := writeBuffer.PushContext("power"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for power")
		}
		_powerErr := writeBuffer.WriteSerializable(m.GetPower())
		if popErr := writeBuffer.PopContext("power"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for power")
		}
		if _powerErr != nil {
			return errors.Wrap(_powerErr, "Error serializing 'power' field")
		}
		// Virtual field
		if _actualValueErr := writeBuffer.WriteVirtual("actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataPower"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataPower")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataPower) isBACnetConstructedDataPower() bool {
	return true
}

func (m *_BACnetConstructedDataPower) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
