/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataNotificationThreshold is the corresponding interface of BACnetConstructedDataNotificationThreshold
type BACnetConstructedDataNotificationThreshold interface {
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetNotificationThreshold returns NotificationThreshold (property field)
	GetNotificationThreshold() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
}

// BACnetConstructedDataNotificationThresholdExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataNotificationThreshold.
// This is useful for switch cases.
type BACnetConstructedDataNotificationThresholdExactly interface {
	BACnetConstructedDataNotificationThreshold
	isBACnetConstructedDataNotificationThreshold() bool
}

// _BACnetConstructedDataNotificationThreshold is the data-structure of this message
type _BACnetConstructedDataNotificationThreshold struct {
	*_BACnetConstructedData
	NotificationThreshold BACnetApplicationTagUnsignedInteger
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataNotificationThreshold) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataNotificationThreshold) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_NOTIFICATION_THRESHOLD
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataNotificationThreshold) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataNotificationThreshold) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataNotificationThreshold) GetNotificationThreshold() BACnetApplicationTagUnsignedInteger {
	return m.NotificationThreshold
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataNotificationThreshold) GetActualValue() BACnetApplicationTagUnsignedInteger {
	return CastBACnetApplicationTagUnsignedInteger(m.GetNotificationThreshold())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataNotificationThreshold factory function for _BACnetConstructedDataNotificationThreshold
func NewBACnetConstructedDataNotificationThreshold(notificationThreshold BACnetApplicationTagUnsignedInteger, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataNotificationThreshold {
	_result := &_BACnetConstructedDataNotificationThreshold{
		NotificationThreshold:  notificationThreshold,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataNotificationThreshold(structType interface{}) BACnetConstructedDataNotificationThreshold {
	if casted, ok := structType.(BACnetConstructedDataNotificationThreshold); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataNotificationThreshold); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataNotificationThreshold) GetTypeName() string {
	return "BACnetConstructedDataNotificationThreshold"
}

func (m *_BACnetConstructedDataNotificationThreshold) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BACnetConstructedDataNotificationThreshold) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (notificationThreshold)
	lengthInBits += m.NotificationThreshold.GetLengthInBits()

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataNotificationThreshold) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetConstructedDataNotificationThresholdParse(readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataNotificationThreshold, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataNotificationThreshold"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataNotificationThreshold")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (notificationThreshold)
	if pullErr := readBuffer.PullContext("notificationThreshold"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for notificationThreshold")
	}
	_notificationThreshold, _notificationThresholdErr := BACnetApplicationTagParse(readBuffer)
	if _notificationThresholdErr != nil {
		return nil, errors.Wrap(_notificationThresholdErr, "Error parsing 'notificationThreshold' field of BACnetConstructedDataNotificationThreshold")
	}
	notificationThreshold := _notificationThreshold.(BACnetApplicationTagUnsignedInteger)
	if closeErr := readBuffer.CloseContext("notificationThreshold"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for notificationThreshold")
	}

	// Virtual field
	_actualValue := notificationThreshold
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataNotificationThreshold"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataNotificationThreshold")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataNotificationThreshold{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		NotificationThreshold: notificationThreshold,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataNotificationThreshold) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataNotificationThreshold"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataNotificationThreshold")
		}

		// Simple Field (notificationThreshold)
		if pushErr := writeBuffer.PushContext("notificationThreshold"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for notificationThreshold")
		}
		_notificationThresholdErr := writeBuffer.WriteSerializable(m.GetNotificationThreshold())
		if popErr := writeBuffer.PopContext("notificationThreshold"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for notificationThreshold")
		}
		if _notificationThresholdErr != nil {
			return errors.Wrap(_notificationThresholdErr, "Error serializing 'notificationThreshold' field")
		}
		// Virtual field
		if _actualValueErr := writeBuffer.WriteVirtual("actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataNotificationThreshold"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataNotificationThreshold")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataNotificationThreshold) isBACnetConstructedDataNotificationThreshold() bool {
	return true
}

func (m *_BACnetConstructedDataNotificationThreshold) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
