/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataMaxFailedAttempts is the corresponding interface of BACnetConstructedDataMaxFailedAttempts
type BACnetConstructedDataMaxFailedAttempts interface {
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetMaxFailedAttempts returns MaxFailedAttempts (property field)
	GetMaxFailedAttempts() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
}

// BACnetConstructedDataMaxFailedAttemptsExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataMaxFailedAttempts.
// This is useful for switch cases.
type BACnetConstructedDataMaxFailedAttemptsExactly interface {
	BACnetConstructedDataMaxFailedAttempts
	isBACnetConstructedDataMaxFailedAttempts() bool
}

// _BACnetConstructedDataMaxFailedAttempts is the data-structure of this message
type _BACnetConstructedDataMaxFailedAttempts struct {
	*_BACnetConstructedData
	MaxFailedAttempts BACnetApplicationTagUnsignedInteger
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataMaxFailedAttempts) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataMaxFailedAttempts) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_MAX_FAILED_ATTEMPTS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataMaxFailedAttempts) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataMaxFailedAttempts) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataMaxFailedAttempts) GetMaxFailedAttempts() BACnetApplicationTagUnsignedInteger {
	return m.MaxFailedAttempts
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataMaxFailedAttempts) GetActualValue() BACnetApplicationTagUnsignedInteger {
	return CastBACnetApplicationTagUnsignedInteger(m.GetMaxFailedAttempts())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataMaxFailedAttempts factory function for _BACnetConstructedDataMaxFailedAttempts
func NewBACnetConstructedDataMaxFailedAttempts(maxFailedAttempts BACnetApplicationTagUnsignedInteger, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataMaxFailedAttempts {
	_result := &_BACnetConstructedDataMaxFailedAttempts{
		MaxFailedAttempts:      maxFailedAttempts,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataMaxFailedAttempts(structType interface{}) BACnetConstructedDataMaxFailedAttempts {
	if casted, ok := structType.(BACnetConstructedDataMaxFailedAttempts); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataMaxFailedAttempts); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataMaxFailedAttempts) GetTypeName() string {
	return "BACnetConstructedDataMaxFailedAttempts"
}

func (m *_BACnetConstructedDataMaxFailedAttempts) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BACnetConstructedDataMaxFailedAttempts) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (maxFailedAttempts)
	lengthInBits += m.MaxFailedAttempts.GetLengthInBits()

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataMaxFailedAttempts) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetConstructedDataMaxFailedAttemptsParse(readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataMaxFailedAttempts, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataMaxFailedAttempts"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataMaxFailedAttempts")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (maxFailedAttempts)
	if pullErr := readBuffer.PullContext("maxFailedAttempts"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for maxFailedAttempts")
	}
	_maxFailedAttempts, _maxFailedAttemptsErr := BACnetApplicationTagParse(readBuffer)
	if _maxFailedAttemptsErr != nil {
		return nil, errors.Wrap(_maxFailedAttemptsErr, "Error parsing 'maxFailedAttempts' field of BACnetConstructedDataMaxFailedAttempts")
	}
	maxFailedAttempts := _maxFailedAttempts.(BACnetApplicationTagUnsignedInteger)
	if closeErr := readBuffer.CloseContext("maxFailedAttempts"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for maxFailedAttempts")
	}

	// Virtual field
	_actualValue := maxFailedAttempts
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataMaxFailedAttempts"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataMaxFailedAttempts")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataMaxFailedAttempts{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		MaxFailedAttempts: maxFailedAttempts,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataMaxFailedAttempts) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataMaxFailedAttempts"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataMaxFailedAttempts")
		}

		// Simple Field (maxFailedAttempts)
		if pushErr := writeBuffer.PushContext("maxFailedAttempts"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for maxFailedAttempts")
		}
		_maxFailedAttemptsErr := writeBuffer.WriteSerializable(m.GetMaxFailedAttempts())
		if popErr := writeBuffer.PopContext("maxFailedAttempts"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for maxFailedAttempts")
		}
		if _maxFailedAttemptsErr != nil {
			return errors.Wrap(_maxFailedAttemptsErr, "Error serializing 'maxFailedAttempts' field")
		}
		// Virtual field
		if _actualValueErr := writeBuffer.WriteVirtual("actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataMaxFailedAttempts"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataMaxFailedAttempts")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataMaxFailedAttempts) isBACnetConstructedDataMaxFailedAttempts() bool {
	return true
}

func (m *_BACnetConstructedDataMaxFailedAttempts) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
