/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLocalForwardingOnly is the corresponding interface of BACnetConstructedDataLocalForwardingOnly
type BACnetConstructedDataLocalForwardingOnly interface {
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetLocalForwardingOnly returns LocalForwardingOnly (property field)
	GetLocalForwardingOnly() BACnetApplicationTagBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBoolean
}

// BACnetConstructedDataLocalForwardingOnlyExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataLocalForwardingOnly.
// This is useful for switch cases.
type BACnetConstructedDataLocalForwardingOnlyExactly interface {
	BACnetConstructedDataLocalForwardingOnly
	isBACnetConstructedDataLocalForwardingOnly() bool
}

// _BACnetConstructedDataLocalForwardingOnly is the data-structure of this message
type _BACnetConstructedDataLocalForwardingOnly struct {
	*_BACnetConstructedData
	LocalForwardingOnly BACnetApplicationTagBoolean
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLocalForwardingOnly) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLocalForwardingOnly) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LOCAL_FORWARDING_ONLY
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLocalForwardingOnly) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataLocalForwardingOnly) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLocalForwardingOnly) GetLocalForwardingOnly() BACnetApplicationTagBoolean {
	return m.LocalForwardingOnly
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLocalForwardingOnly) GetActualValue() BACnetApplicationTagBoolean {
	return CastBACnetApplicationTagBoolean(m.GetLocalForwardingOnly())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataLocalForwardingOnly factory function for _BACnetConstructedDataLocalForwardingOnly
func NewBACnetConstructedDataLocalForwardingOnly(localForwardingOnly BACnetApplicationTagBoolean, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLocalForwardingOnly {
	_result := &_BACnetConstructedDataLocalForwardingOnly{
		LocalForwardingOnly:    localForwardingOnly,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLocalForwardingOnly(structType interface{}) BACnetConstructedDataLocalForwardingOnly {
	if casted, ok := structType.(BACnetConstructedDataLocalForwardingOnly); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLocalForwardingOnly); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLocalForwardingOnly) GetTypeName() string {
	return "BACnetConstructedDataLocalForwardingOnly"
}

func (m *_BACnetConstructedDataLocalForwardingOnly) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BACnetConstructedDataLocalForwardingOnly) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (localForwardingOnly)
	lengthInBits += m.LocalForwardingOnly.GetLengthInBits()

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLocalForwardingOnly) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetConstructedDataLocalForwardingOnlyParse(readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataLocalForwardingOnly, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLocalForwardingOnly"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLocalForwardingOnly")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (localForwardingOnly)
	if pullErr := readBuffer.PullContext("localForwardingOnly"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for localForwardingOnly")
	}
	_localForwardingOnly, _localForwardingOnlyErr := BACnetApplicationTagParse(readBuffer)
	if _localForwardingOnlyErr != nil {
		return nil, errors.Wrap(_localForwardingOnlyErr, "Error parsing 'localForwardingOnly' field of BACnetConstructedDataLocalForwardingOnly")
	}
	localForwardingOnly := _localForwardingOnly.(BACnetApplicationTagBoolean)
	if closeErr := readBuffer.CloseContext("localForwardingOnly"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for localForwardingOnly")
	}

	// Virtual field
	_actualValue := localForwardingOnly
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLocalForwardingOnly"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLocalForwardingOnly")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataLocalForwardingOnly{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		LocalForwardingOnly: localForwardingOnly,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataLocalForwardingOnly) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLocalForwardingOnly"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLocalForwardingOnly")
		}

		// Simple Field (localForwardingOnly)
		if pushErr := writeBuffer.PushContext("localForwardingOnly"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for localForwardingOnly")
		}
		_localForwardingOnlyErr := writeBuffer.WriteSerializable(m.GetLocalForwardingOnly())
		if popErr := writeBuffer.PopContext("localForwardingOnly"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for localForwardingOnly")
		}
		if _localForwardingOnlyErr != nil {
			return errors.Wrap(_localForwardingOnlyErr, "Error serializing 'localForwardingOnly' field")
		}
		// Virtual field
		if _actualValueErr := writeBuffer.WriteVirtual("actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLocalForwardingOnly"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLocalForwardingOnly")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLocalForwardingOnly) isBACnetConstructedDataLocalForwardingOnly() bool {
	return true
}

func (m *_BACnetConstructedDataLocalForwardingOnly) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
