/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLinkSpeedAutonegotiate is the corresponding interface of BACnetConstructedDataLinkSpeedAutonegotiate
type BACnetConstructedDataLinkSpeedAutonegotiate interface {
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetLinkSpeedAutonegotiate returns LinkSpeedAutonegotiate (property field)
	GetLinkSpeedAutonegotiate() BACnetApplicationTagBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBoolean
}

// BACnetConstructedDataLinkSpeedAutonegotiateExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataLinkSpeedAutonegotiate.
// This is useful for switch cases.
type BACnetConstructedDataLinkSpeedAutonegotiateExactly interface {
	BACnetConstructedDataLinkSpeedAutonegotiate
	isBACnetConstructedDataLinkSpeedAutonegotiate() bool
}

// _BACnetConstructedDataLinkSpeedAutonegotiate is the data-structure of this message
type _BACnetConstructedDataLinkSpeedAutonegotiate struct {
	*_BACnetConstructedData
	LinkSpeedAutonegotiate BACnetApplicationTagBoolean
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLinkSpeedAutonegotiate) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLinkSpeedAutonegotiate) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LINK_SPEED_AUTONEGOTIATE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLinkSpeedAutonegotiate) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataLinkSpeedAutonegotiate) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLinkSpeedAutonegotiate) GetLinkSpeedAutonegotiate() BACnetApplicationTagBoolean {
	return m.LinkSpeedAutonegotiate
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLinkSpeedAutonegotiate) GetActualValue() BACnetApplicationTagBoolean {
	return CastBACnetApplicationTagBoolean(m.GetLinkSpeedAutonegotiate())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataLinkSpeedAutonegotiate factory function for _BACnetConstructedDataLinkSpeedAutonegotiate
func NewBACnetConstructedDataLinkSpeedAutonegotiate(linkSpeedAutonegotiate BACnetApplicationTagBoolean, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLinkSpeedAutonegotiate {
	_result := &_BACnetConstructedDataLinkSpeedAutonegotiate{
		LinkSpeedAutonegotiate: linkSpeedAutonegotiate,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLinkSpeedAutonegotiate(structType interface{}) BACnetConstructedDataLinkSpeedAutonegotiate {
	if casted, ok := structType.(BACnetConstructedDataLinkSpeedAutonegotiate); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLinkSpeedAutonegotiate); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLinkSpeedAutonegotiate) GetTypeName() string {
	return "BACnetConstructedDataLinkSpeedAutonegotiate"
}

func (m *_BACnetConstructedDataLinkSpeedAutonegotiate) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BACnetConstructedDataLinkSpeedAutonegotiate) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (linkSpeedAutonegotiate)
	lengthInBits += m.LinkSpeedAutonegotiate.GetLengthInBits()

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLinkSpeedAutonegotiate) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetConstructedDataLinkSpeedAutonegotiateParse(readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataLinkSpeedAutonegotiate, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLinkSpeedAutonegotiate"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLinkSpeedAutonegotiate")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (linkSpeedAutonegotiate)
	if pullErr := readBuffer.PullContext("linkSpeedAutonegotiate"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for linkSpeedAutonegotiate")
	}
	_linkSpeedAutonegotiate, _linkSpeedAutonegotiateErr := BACnetApplicationTagParse(readBuffer)
	if _linkSpeedAutonegotiateErr != nil {
		return nil, errors.Wrap(_linkSpeedAutonegotiateErr, "Error parsing 'linkSpeedAutonegotiate' field of BACnetConstructedDataLinkSpeedAutonegotiate")
	}
	linkSpeedAutonegotiate := _linkSpeedAutonegotiate.(BACnetApplicationTagBoolean)
	if closeErr := readBuffer.CloseContext("linkSpeedAutonegotiate"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for linkSpeedAutonegotiate")
	}

	// Virtual field
	_actualValue := linkSpeedAutonegotiate
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLinkSpeedAutonegotiate"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLinkSpeedAutonegotiate")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataLinkSpeedAutonegotiate{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		LinkSpeedAutonegotiate: linkSpeedAutonegotiate,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataLinkSpeedAutonegotiate) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLinkSpeedAutonegotiate"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLinkSpeedAutonegotiate")
		}

		// Simple Field (linkSpeedAutonegotiate)
		if pushErr := writeBuffer.PushContext("linkSpeedAutonegotiate"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for linkSpeedAutonegotiate")
		}
		_linkSpeedAutonegotiateErr := writeBuffer.WriteSerializable(m.GetLinkSpeedAutonegotiate())
		if popErr := writeBuffer.PopContext("linkSpeedAutonegotiate"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for linkSpeedAutonegotiate")
		}
		if _linkSpeedAutonegotiateErr != nil {
			return errors.Wrap(_linkSpeedAutonegotiateErr, "Error serializing 'linkSpeedAutonegotiate' field")
		}
		// Virtual field
		if _actualValueErr := writeBuffer.WriteVirtual("actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLinkSpeedAutonegotiate"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLinkSpeedAutonegotiate")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLinkSpeedAutonegotiate) isBACnetConstructedDataLinkSpeedAutonegotiate() bool {
	return true
}

func (m *_BACnetConstructedDataLinkSpeedAutonegotiate) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
