/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataActivationTime is the corresponding interface of BACnetConstructedDataActivationTime
type BACnetConstructedDataActivationTime interface {
	utils.LengthAware
	utils.Serializable
	BACnetConstructedData
	// GetActivationTime returns ActivationTime (property field)
	GetActivationTime() BACnetDateTime
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDateTime
}

// BACnetConstructedDataActivationTimeExactly can be used when we want exactly this type and not a type which fulfills BACnetConstructedDataActivationTime.
// This is useful for switch cases.
type BACnetConstructedDataActivationTimeExactly interface {
	BACnetConstructedDataActivationTime
	isBACnetConstructedDataActivationTime() bool
}

// _BACnetConstructedDataActivationTime is the data-structure of this message
type _BACnetConstructedDataActivationTime struct {
	*_BACnetConstructedData
	ActivationTime BACnetDateTime
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataActivationTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataActivationTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ACTIVATION_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataActivationTime) InitializeParent(parent BACnetConstructedData, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag) {
	m.OpeningTag = openingTag
	m.PeekedTagHeader = peekedTagHeader
	m.ClosingTag = closingTag
}

func (m *_BACnetConstructedDataActivationTime) GetParent() BACnetConstructedData {
	return m._BACnetConstructedData
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataActivationTime) GetActivationTime() BACnetDateTime {
	return m.ActivationTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataActivationTime) GetActualValue() BACnetDateTime {
	return CastBACnetDateTime(m.GetActivationTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// NewBACnetConstructedDataActivationTime factory function for _BACnetConstructedDataActivationTime
func NewBACnetConstructedDataActivationTime(activationTime BACnetDateTime, openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataActivationTime {
	_result := &_BACnetConstructedDataActivationTime{
		ActivationTime:         activationTime,
		_BACnetConstructedData: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result._BACnetConstructedData._BACnetConstructedDataChildRequirements = _result
	return _result
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataActivationTime(structType interface{}) BACnetConstructedDataActivationTime {
	if casted, ok := structType.(BACnetConstructedDataActivationTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataActivationTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataActivationTime) GetTypeName() string {
	return "BACnetConstructedDataActivationTime"
}

func (m *_BACnetConstructedDataActivationTime) GetLengthInBits() uint16 {
	return m.GetLengthInBitsConditional(false)
}

func (m *_BACnetConstructedDataActivationTime) GetLengthInBitsConditional(lastItem bool) uint16 {
	lengthInBits := uint16(m.GetParentLengthInBits())

	// Simple field (activationTime)
	lengthInBits += m.ActivationTime.GetLengthInBits()

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataActivationTime) GetLengthInBytes() uint16 {
	return m.GetLengthInBits() / 8
}

func BACnetConstructedDataActivationTimeParse(readBuffer utils.ReadBuffer, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (BACnetConstructedDataActivationTime, error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataActivationTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataActivationTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Simple Field (activationTime)
	if pullErr := readBuffer.PullContext("activationTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for activationTime")
	}
	_activationTime, _activationTimeErr := BACnetDateTimeParse(readBuffer)
	if _activationTimeErr != nil {
		return nil, errors.Wrap(_activationTimeErr, "Error parsing 'activationTime' field of BACnetConstructedDataActivationTime")
	}
	activationTime := _activationTime.(BACnetDateTime)
	if closeErr := readBuffer.CloseContext("activationTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for activationTime")
	}

	// Virtual field
	_actualValue := activationTime
	actualValue := _actualValue
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataActivationTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataActivationTime")
	}

	// Create a partially initialized instance
	_child := &_BACnetConstructedDataActivationTime{
		_BACnetConstructedData: &_BACnetConstructedData{
			TagNumber:          tagNumber,
			ArrayIndexArgument: arrayIndexArgument,
		},
		ActivationTime: activationTime,
	}
	_child._BACnetConstructedData._BACnetConstructedDataChildRequirements = _child
	return _child, nil
}

func (m *_BACnetConstructedDataActivationTime) Serialize(writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataActivationTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataActivationTime")
		}

		// Simple Field (activationTime)
		if pushErr := writeBuffer.PushContext("activationTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for activationTime")
		}
		_activationTimeErr := writeBuffer.WriteSerializable(m.GetActivationTime())
		if popErr := writeBuffer.PopContext("activationTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for activationTime")
		}
		if _activationTimeErr != nil {
			return errors.Wrap(_activationTimeErr, "Error serializing 'activationTime' field")
		}
		// Virtual field
		if _actualValueErr := writeBuffer.WriteVirtual("actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataActivationTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataActivationTime")
		}
		return nil
	}
	return m.SerializeParent(writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataActivationTime) isBACnetConstructedDataActivationTime() bool {
	return true
}

func (m *_BACnetConstructedDataActivationTime) String() string {
	if m == nil {
		return "<nil>"
	}
	writeBuffer := utils.NewWriteBufferBoxBasedWithOptions(true, true)
	if err := writeBuffer.WriteSerializable(m); err != nil {
		return err.Error()
	}
	return writeBuffer.GetBox().String()
}
