/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package readwrite

import (
	"github.com/apache/plc4x/plc4go/protocols/bacnetip/readwrite/model"
	"github.com/apache/plc4x/plc4go/spi/utils"
	"github.com/pkg/errors"
)

// Code generated by code-generation. DO NOT EDIT.

type BacnetipParserHelper struct {
}

func (m BacnetipParserHelper) Parse(typeName string, arguments []string, io utils.ReadBuffer) (interface{}, error) {
	switch typeName {
	case "BACnetAuthenticationStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAuthenticationStatusTaggedParse(io, tagNumber, tagClass)
	case "BACnetLiftGroupModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLiftGroupModeTaggedParse(io, tagNumber, tagClass)
	case "BACnetValueSource":
		return model.BACnetValueSourceParse(io)
	case "BACnetOpeningTag":
		tagNumberArgument, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetOpeningTagParse(io, tagNumberArgument)
	case "BACnetPriorityArray":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		tagNumber, err := utils.StrToUint8(arguments[1])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		var arrayIndexArgument model.BACnetTagPayloadUnsignedInteger
		return model.BACnetPriorityArrayParse(io, objectTypeArgument, tagNumber, arrayIndexArgument)
	case "BACnetNameValue":
		return model.BACnetNameValueParse(io)
	case "BACnetPropertyReferenceEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetPropertyReferenceEnclosedParse(io, tagNumber)
	case "BACnetSpecialEvent":
		return model.BACnetSpecialEventParse(io)
	case "BACnetRouterEntry":
		return model.BACnetRouterEntryParse(io)
	case "BACnetTagPayloadReal":
		return model.BACnetTagPayloadRealParse(io)
	case "BACnetFaultParameterFaultExtendedParameters":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetFaultParameterFaultExtendedParametersParse(io, tagNumber)
	case "BACnetNotificationParametersExtendedParameters":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetNotificationParametersExtendedParametersParse(io, tagNumber)
	case "BACnetLoggingTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLoggingTypeTaggedParse(io, tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilterParse(io, tagNumber)
	case "BACnetTimeValue":
		return model.BACnetTimeValueParse(io)
	case "BACnetTagPayloadOctetString":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTagPayloadOctetStringParse(io, actualLength)
	case "BACnetEscalatorOperationDirectionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetEscalatorOperationDirectionTaggedParse(io, tagNumber, tagClass)
	case "NPDUControl":
		return model.NPDUControlParse(io)
	case "BACnetFaultParameterFaultStateListOfFaultValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetFaultParameterFaultStateListOfFaultValuesParse(io, tagNumber)
	case "BACnetTimeStampEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTimeStampEnclosedParse(io, tagNumber)
	case "BACnetTimerStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetTimerStateTaggedParse(io, tagNumber, tagClass)
	case "BACnetDateRangeEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetDateRangeEnclosedParse(io, tagNumber)
	case "BACnetEventParameterChangeOfTimerAlarmValue":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterChangeOfTimerAlarmValueParse(io, tagNumber)
	case "BACnetUnconfirmedServiceRequest":
		serviceRequestLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetUnconfirmedServiceRequestParse(io, serviceRequestLength)
	case "BACnetAddressEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetAddressEnclosedParse(io, tagNumber)
	case "BACnetObjectTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetObjectTypeTaggedParse(io, tagNumber, tagClass)
	case "BACnetDaysOfWeekTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetDaysOfWeekTaggedParse(io, tagNumber, tagClass)
	case "BACnetReadAccessResultListOfResults":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[1])
		return model.BACnetReadAccessResultListOfResultsParse(io, tagNumber, objectTypeArgument)
	case "BACnetRouterEntryStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetRouterEntryStatusTaggedParse(io, tagNumber, tagClass)
	case "BACnetAccessRuleTimeRangeSpecifierTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessRuleTimeRangeSpecifierTaggedParse(io, tagNumber, tagClass)
	case "BACnetObjectTypesSupportedTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetObjectTypesSupportedTaggedParse(io, tagNumber, tagClass)
	case "BVLCBroadcastDistributionTableEntry":
		return model.BVLCBroadcastDistributionTableEntryParse(io)
	case "BACnetBackupStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetBackupStateTaggedParse(io, tagNumber, tagClass)
	case "BACnetEventParameterChangeOfLifeSavetyListOfLifeSavetyAlarmValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterChangeOfLifeSavetyListOfLifeSavetyAlarmValuesParse(io, tagNumber)
	case "BACnetDestination":
		return model.BACnetDestinationParse(io)
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecification":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationParse(io, tagNumber)
	case "BACnetDeviceStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetDeviceStatusTaggedParse(io, tagNumber, tagClass)
	case "BACnetPrescale":
		return model.BACnetPrescaleParse(io)
	case "ErrorEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.ErrorEnclosedParse(io, tagNumber)
	case "BACnetAuthenticationPolicyListEntry":
		return model.BACnetAuthenticationPolicyListEntryParse(io)
	case "APDU":
		apduLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.APDUParse(io, apduLength)
	case "BACnetEventNotificationSubscription":
		return model.BACnetEventNotificationSubscriptionParse(io)
	case "BACnetSegmentationTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetSegmentationTaggedParse(io, tagNumber, tagClass)
	case "BACnetSecurityKeySet":
		return model.BACnetSecurityKeySetParse(io)
	case "BACnetNetworkSecurityPolicy":
		return model.BACnetNetworkSecurityPolicyParse(io)
	case "BACnetHostNPortEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetHostNPortEnclosedParse(io, tagNumber)
	case "BACnetPropertyIdentifierTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetPropertyIdentifierTaggedParse(io, tagNumber, tagClass)
	case "BACnetRecipientEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetRecipientEnclosedParse(io, tagNumber)
	case "BACnetConfirmedServiceRequest":
		serviceRequestLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetConfirmedServiceRequestParse(io, serviceRequestLength)
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferences":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferencesParse(io, tagNumber)
	case "BACnetTagPayloadUnsignedInteger":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTagPayloadUnsignedIntegerParse(io, actualLength)
	case "BACnetAccessUserTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessUserTypeTaggedParse(io, tagNumber, tagClass)
	case "BACnetRestartReasonTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetRestartReasonTaggedParse(io, tagNumber, tagClass)
	case "BACnetTagPayloadBitString":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTagPayloadBitStringParse(io, actualLength)
	case "BACnetClientCOV":
		return model.BACnetClientCOVParse(io)
	case "BACnetSetpointReference":
		return model.BACnetSetpointReferenceParse(io)
	case "BACnetObjectPropertyReferenceEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetObjectPropertyReferenceEnclosedParse(io, tagNumber)
	case "BACnetEscalatorFaultTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetEscalatorFaultTaggedParse(io, tagNumber, tagClass)
	case "BACnetEventStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetEventStateTaggedParse(io, tagNumber, tagClass)
	case "BACnetTagHeader":
		return model.BACnetTagHeaderParse(io)
	case "BACnetTagPayloadBoolean":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTagPayloadBooleanParse(io, actualLength)
	case "BACnetFaultTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetFaultTypeTaggedParse(io, tagNumber, tagClass)
	case "VTCloseErrorListOfVTSessionIdentifiers":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.VTCloseErrorListOfVTSessionIdentifiersParse(io, tagNumber)
	case "BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecifications":
		return model.BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsParse(io)
	case "BACnetIPModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetIPModeTaggedParse(io, tagNumber, tagClass)
	case "BACnetAccumulatorRecord":
		return model.BACnetAccumulatorRecordParse(io)
	case "BACnetDailySchedule":
		return model.BACnetDailyScheduleParse(io)
	case "BACnetLogDataLogDataEntry":
		return model.BACnetLogDataLogDataEntryParse(io)
	case "BACnetOptionalBinaryPV":
		return model.BACnetOptionalBinaryPVParse(io)
	case "BACnetBDTEntry":
		return model.BACnetBDTEntryParse(io)
	case "BACnetEngineeringUnitsTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetEngineeringUnitsTaggedParse(io, tagNumber, tagClass)
	case "ListOfCovNotifications":
		return model.ListOfCovNotificationsParse(io)
	case "BACnetAssignedAccessRights":
		return model.BACnetAssignedAccessRightsParse(io)
	case "BACnetConfirmedServiceRequestCreateObjectObjectSpecifier":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetConfirmedServiceRequestCreateObjectObjectSpecifierParse(io, tagNumber)
	case "BACnetAuthenticationPolicy":
		return model.BACnetAuthenticationPolicyParse(io)
	case "BACnetPropertyAccessResult":
		return model.BACnetPropertyAccessResultParse(io)
	case "BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsListParse(io, tagNumber)
	case "NPDU":
		npduLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.NPDUParse(io, npduLength)
	case "BACnetProgramStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetProgramStateTaggedParse(io, tagNumber, tagClass)
	case "BACnetDoorSecuredStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetDoorSecuredStatusTaggedParse(io, tagNumber, tagClass)
	case "ErrorClassTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.ErrorClassTaggedParse(io, tagNumber, tagClass)
	case "BACnetSpecialEventListOfTimeValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetSpecialEventListOfTimeValuesParse(io, tagNumber)
	case "BACnetFaultParameterFaultOutOfRangeMaxNormalValue":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetFaultParameterFaultOutOfRangeMaxNormalValueParse(io, tagNumber)
	case "BACnetAccessRuleLocationSpecifierTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessRuleLocationSpecifierTaggedParse(io, tagNumber, tagClass)
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferencesEntry":
		return model.BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryListOfCovReferencesEntryParse(io)
	case "BACnetAuthenticationFactorFormat":
		return model.BACnetAuthenticationFactorFormatParse(io)
	case "BACnetMaintenanceTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetMaintenanceTaggedParse(io, tagNumber, tagClass)
	case "BACnetNotificationParametersChangeOfDiscreteValueNewValue":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetNotificationParametersChangeOfDiscreteValueNewValueParse(io, tagNumber)
	case "BACnetReadAccessPropertyReadResult":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		propertyIdentifierArgument, _ := model.BACnetPropertyIdentifierByName(arguments[1])
		var arrayIndexArgument model.BACnetTagPayloadUnsignedInteger
		return model.BACnetReadAccessPropertyReadResultParse(io, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case "BACnetActionCommand":
		return model.BACnetActionCommandParse(io)
	case "BACnetFaultParameterFaultExtendedParametersEntry":
		return model.BACnetFaultParameterFaultExtendedParametersEntryParse(io)
	case "BACnetTagPayloadDate":
		return model.BACnetTagPayloadDateParse(io)
	case "BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTaggedParse(io, tagNumber, tagClass)
	case "BACnetEventParameterExtendedParameters":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterExtendedParametersParse(io, tagNumber)
	case "BACnetEventParameterAccessEventListOfAccessEvents":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterAccessEventListOfAccessEventsParse(io, tagNumber)
	case "BACnetReadAccessProperty":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		return model.BACnetReadAccessPropertyParse(io, objectTypeArgument)
	case "BACnetLifeSafetyOperationTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLifeSafetyOperationTaggedParse(io, tagNumber, tagClass)
	case "BACnetWeekNDayTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetWeekNDayTaggedParse(io, tagNumber, tagClass)
	case "BACnetEventTransitionBitsTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetEventTransitionBitsTaggedParse(io, tagNumber, tagClass)
	case "BACnetLogData":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetLogDataParse(io, tagNumber)
	case "BACnetFaultParameterFaultCharacterStringListOfFaultValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetFaultParameterFaultCharacterStringListOfFaultValuesParse(io, tagNumber)
	case "BACnetLockStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLockStatusTaggedParse(io, tagNumber, tagClass)
	case "BACnetDeviceObjectPropertyReferenceEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetDeviceObjectPropertyReferenceEnclosedParse(io, tagNumber)
	case "BACnetPropertyStates":
		return model.BACnetPropertyStatesParse(io)
	case "BACnetReadAccessResult":
		return model.BACnetReadAccessResultParse(io)
	case "BACnetResultFlagsTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetResultFlagsTaggedParse(io, tagNumber, tagClass)
	case "BACnetAccessCredentialDisableReasonTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessCredentialDisableReasonTaggedParse(io, tagNumber, tagClass)
	case "BACnetLightingInProgressTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLightingInProgressTaggedParse(io, tagNumber, tagClass)
	case "BACnetLifeSafetyStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLifeSafetyStateTaggedParse(io, tagNumber, tagClass)
	case "BACnetVTSession":
		return model.BACnetVTSessionParse(io)
	case "BACnetEventTimestampsEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventTimestampsEnclosedParse(io, tagNumber)
	case "BACnetSecurityLevelTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetSecurityLevelTaggedParse(io, tagNumber, tagClass)
	case "BACnetLogRecordLogDatum":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetLogRecordLogDatumParse(io, tagNumber)
	case "BACnetDateTimeEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetDateTimeEnclosedParse(io, tagNumber)
	case "BACnetTimerTransitionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetTimerTransitionTaggedParse(io, tagNumber, tagClass)
	case "BACnetLogMultipleRecord":
		return model.BACnetLogMultipleRecordParse(io)
	case "BACnetProgramRequestTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetProgramRequestTaggedParse(io, tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedParse(io, tagNumber, tagClass)
	case "BACnetDateRange":
		return model.BACnetDateRangeParse(io)
	case "BACnetEventParameter":
		return model.BACnetEventParameterParse(io)
	case "BACnetLiftFaultTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLiftFaultTaggedParse(io, tagNumber, tagClass)
	case "MaxApduLengthAcceptedTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.MaxApduLengthAcceptedTaggedParse(io, tagNumber, tagClass)
	case "BACnetPropertyStatesEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetPropertyStatesEnclosedParse(io, tagNumber)
	case "BACnetGroupChannelValueList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetGroupChannelValueListParse(io, tagNumber)
	case "BACnetFileAccessMethodTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetFileAccessMethodTaggedParse(io, tagNumber, tagClass)
	case "BACnetTagPayloadCharacterString":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTagPayloadCharacterStringParse(io, actualLength)
	case "BACnetEventLogRecordLogDatum":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventLogRecordLogDatumParse(io, tagNumber)
	case "BACnetStatusFlagsTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetStatusFlagsTaggedParse(io, tagNumber, tagClass)
	case "BACnetNodeTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetNodeTypeTaggedParse(io, tagNumber, tagClass)
	case "BACnetOptionalCharacterString":
		return model.BACnetOptionalCharacterStringParse(io)
	case "BACnetAddress":
		return model.BACnetAddressParse(io)
	case "BACnetEventParameterChangeOfLifeSavetyListOfAlarmValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterChangeOfLifeSavetyListOfAlarmValuesParse(io, tagNumber)
	case "BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsReference":
		return model.BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsReferenceParse(io)
	case "BACnetApplicationTag":
		return model.BACnetApplicationTagParse(io)
	case "BACnetEventParameterChangeOfBitstringListOfBitstringValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterChangeOfBitstringListOfBitstringValuesParse(io, tagNumber)
	case "BACnetShedLevel":
		return model.BACnetShedLevelParse(io)
	case "BACnetActionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetActionTaggedParse(io, tagNumber, tagClass)
	case "BACnetCredentialAuthenticationFactor":
		return model.BACnetCredentialAuthenticationFactorParse(io)
	case "BACnetAssignedLandingCallsLandingCallsListEntry":
		return model.BACnetAssignedLandingCallsLandingCallsListEntryParse(io)
	case "BACnetPropertyValue":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		return model.BACnetPropertyValueParse(io, objectTypeArgument)
	case "BACnetCOVSubscription":
		return model.BACnetCOVSubscriptionParse(io)
	case "BACnetFaultParameterFaultLifeSafetyListOfFaultValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetFaultParameterFaultLifeSafetyListOfFaultValuesParse(io, tagNumber)
	case "BACnetRelationshipTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetRelationshipTaggedParse(io, tagNumber, tagClass)
	case "NLMInitalizeRoutingTablePortMapping":
		return model.NLMInitalizeRoutingTablePortMappingParse(io)
	case "BACnetRecipientProcessEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetRecipientProcessEnclosedParse(io, tagNumber)
	case "BACnetAccessRule":
		return model.BACnetAccessRuleParse(io)
	case "BACnetHostNPort":
		return model.BACnetHostNPortParse(io)
	case "BACnetShedStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetShedStateTaggedParse(io, tagNumber, tagClass)
	case "BACnetAccessEventTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessEventTaggedParse(io, tagNumber, tagClass)
	case "BACnetServiceAck":
		serviceAckLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetServiceAckParse(io, serviceAckLength)
	case "BACnetAccessCredentialDisableTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessCredentialDisableTaggedParse(io, tagNumber, tagClass)
	case "BACnetLiftCarCallList":
		return model.BACnetLiftCarCallListParse(io)
	case "BACnetLightingTransitionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLightingTransitionTaggedParse(io, tagNumber, tagClass)
	case "BACnetAssignedLandingCalls":
		return model.BACnetAssignedLandingCallsParse(io)
	case "BACnetNotifyTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetNotifyTypeTaggedParse(io, tagNumber, tagClass)
	case "BACnetAuthorizationExemptionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAuthorizationExemptionTaggedParse(io, tagNumber, tagClass)
	case "BACnetLandingDoorStatusLandingDoorsList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetLandingDoorStatusLandingDoorsListParse(io, tagNumber)
	case "BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDeviceTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetConfirmedServiceRequestReinitializeDeviceReinitializedStateOfDeviceTaggedParse(io, tagNumber, tagClass)
	case "BACnetAuthenticationFactorTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAuthenticationFactorTypeTaggedParse(io, tagNumber, tagClass)
	case "BACnetAccessAuthenticationFactorDisableTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessAuthenticationFactorDisableTaggedParse(io, tagNumber, tagClass)
	case "BACnetAuthorizationModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAuthorizationModeTaggedParse(io, tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestConfirmedTextMessageMessagePriorityTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetConfirmedServiceRequestConfirmedTextMessageMessagePriorityTaggedParse(io, tagNumber, tagClass)
	case "BACnetDoorStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetDoorStatusTaggedParse(io, tagNumber, tagClass)
	case "BACnetVendorIdTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetVendorIdTaggedParse(io, tagNumber, tagClass)
	case "BACnetEventTimestamps":
		return model.BACnetEventTimestampsParse(io)
	case "BACnetNameValueCollection":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetNameValueCollectionParse(io, tagNumber)
	case "BACnetTagPayloadEnumerated":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTagPayloadEnumeratedParse(io, actualLength)
	case "BACnetLimitEnableTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLimitEnableTaggedParse(io, tagNumber, tagClass)
	case "BACnetDoorAlarmStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetDoorAlarmStateTaggedParse(io, tagNumber, tagClass)
	case "BACnetServicesSupportedTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetServicesSupportedTaggedParse(io, tagNumber, tagClass)
	case "BACnetWriteStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetWriteStatusTaggedParse(io, tagNumber, tagClass)
	case "BACnetRecipientProcess":
		return model.BACnetRecipientProcessParse(io)
	case "BACnetReadAccessSpecification":
		return model.BACnetReadAccessSpecificationParse(io)
	case "BACnetAuthenticationPolicyList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetAuthenticationPolicyListParse(io, tagNumber)
	case "BACnetLandingDoorStatus":
		return model.BACnetLandingDoorStatusParse(io)
	case "BACnetLiftCarCallListFloorList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetLiftCarCallListFloorListParse(io, tagNumber)
	case "BACnetAccessThreatLevel":
		return model.BACnetAccessThreatLevelParse(io)
	case "BACnetCalendarEntryEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetCalendarEntryEnclosedParse(io, tagNumber)
	case "BACnetRecipient":
		return model.BACnetRecipientParse(io)
	case "BACnetLiftCarDriveStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLiftCarDriveStatusTaggedParse(io, tagNumber, tagClass)
	case "BACnetUnconfirmedServiceRequestWhoHasObject":
		return model.BACnetUnconfirmedServiceRequestWhoHasObjectParse(io)
	case "BACnetTagPayloadSignedInteger":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTagPayloadSignedIntegerParse(io, actualLength)
	case "BACnetSecurityPolicyTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetSecurityPolicyTaggedParse(io, tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecord":
		return model.BACnetConfirmedServiceRequestAtomicReadFileStreamOrRecordParse(io)
	case "BVLC":
		return model.BVLCParse(io)
	case "ConfirmedEventNotificationRequest":
		return model.ConfirmedEventNotificationRequestParse(io)
	case "BACnetLandingDoorStatusLandingDoorsListEntry":
		return model.BACnetLandingDoorStatusLandingDoorsListEntryParse(io)
	case "BACnetLiftCarDirectionTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLiftCarDirectionTaggedParse(io, tagNumber, tagClass)
	case "BACnetConfirmedServiceRequestConfirmedTextMessageMessageClass":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetConfirmedServiceRequestConfirmedTextMessageMessageClassParse(io, tagNumber)
	case "BACnetAddressBinding":
		return model.BACnetAddressBindingParse(io)
	case "BACnetLandingCallStatusCommand":
		return model.BACnetLandingCallStatusCommandParse(io)
	case "ListOfCovNotificationsValue":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		return model.ListOfCovNotificationsValueParse(io, objectTypeArgument)
	case "BACnetLandingCallStatus":
		return model.BACnetLandingCallStatusParse(io)
	case "BACnetEventParameterChangeOfStateListOfValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterChangeOfStateListOfValuesParse(io, tagNumber)
	case "BACnetPortPermission":
		return model.BACnetPortPermissionParse(io)
	case "BACnetConfirmedServiceRequestReadRangeRange":
		return model.BACnetConfirmedServiceRequestReadRangeRangeParse(io)
	case "BACnetError":
		errorChoice, _ := model.BACnetConfirmedServiceChoiceByName(arguments[0])
		return model.BACnetErrorParse(io, errorChoice)
	case "BACnetDeviceObjectReferenceEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetDeviceObjectReferenceEnclosedParse(io, tagNumber)
	case "BACnetOptionalUnsigned":
		return model.BACnetOptionalUnsignedParse(io)
	case "BACnetHostAddress":
		return model.BACnetHostAddressParse(io)
	case "ListOfCovNotificationsList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.ListOfCovNotificationsListParse(io, tagNumber)
	case "BACnetEventSummariesList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventSummariesListParse(io, tagNumber)
	case "BACnetVTClassTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetVTClassTaggedParse(io, tagNumber, tagClass)
	case "BACnetDeviceObjectPropertyReference":
		return model.BACnetDeviceObjectPropertyReferenceParse(io)
	case "BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisableTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetConfirmedServiceRequestDeviceCommunicationControlEnableDisableTaggedParse(io, tagNumber, tagClass)
	case "BACnetProcessIdSelection":
		return model.BACnetProcessIdSelectionParse(io)
	case "BACnetAssignedLandingCallsLandingCallsList":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetAssignedLandingCallsLandingCallsListParse(io, tagNumber)
	case "BACnetTagPayloadDouble":
		return model.BACnetTagPayloadDoubleParse(io)
	case "BACnetAccumulatorRecordAccumulatorStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccumulatorRecordAccumulatorStatusTaggedParse(io, tagNumber, tagClass)
	case "BACnetTimerStateChangeValue":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		return model.BACnetTimerStateChangeValueParse(io, objectTypeArgument)
	case "BACnetSpecialEventPeriod":
		return model.BACnetSpecialEventPeriodParse(io)
	case "BACnetKeyIdentifier":
		return model.BACnetKeyIdentifierParse(io)
	case "BACnetNetworkNumberQualityTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetNetworkNumberQualityTaggedParse(io, tagNumber, tagClass)
	case "BACnetLogStatusTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLogStatusTaggedParse(io, tagNumber, tagClass)
	case "BACnetAbortReasonTagged":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetAbortReasonTaggedParse(io, actualLength)
	case "BACnetProgramErrorTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetProgramErrorTaggedParse(io, tagNumber, tagClass)
	case "Error":
		return model.ErrorParse(io)
	case "BACnetPropertyReference":
		return model.BACnetPropertyReferenceParse(io)
	case "BACnetContextTag":
		tagNumberArgument, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		dataType, _ := model.BACnetDataTypeByName(arguments[1])
		return model.BACnetContextTagParse(io, tagNumberArgument, dataType)
	case "BACnetUnconfirmedServiceChoiceTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetUnconfirmedServiceChoiceTaggedParse(io, tagNumber, tagClass)
	case "BVLCResultCodeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BVLCResultCodeTaggedParse(io, tagNumber, tagClass)
	case "BACnetFaultParameter":
		return model.BACnetFaultParameterParse(io)
	case "BACnetEventParameterChangeOfValueCivCriteria":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterChangeOfValueCivCriteriaParse(io, tagNumber)
	case "BACnetPriorityValue":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		return model.BACnetPriorityValueParse(io, objectTypeArgument)
	case "BACnetLogRecord":
		return model.BACnetLogRecordParse(io)
	case "BACnetCalendarEntry":
		return model.BACnetCalendarEntryParse(io)
	case "BACnetAccessPassbackModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessPassbackModeTaggedParse(io, tagNumber, tagClass)
	case "BACnetDeviceObjectReference":
		return model.BACnetDeviceObjectReferenceParse(io)
	case "BVLCForeignDeviceTableEntry":
		return model.BVLCForeignDeviceTableEntryParse(io)
	case "NLM":
		apduLength, err := utils.StrToUint16(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.NLMParse(io, apduLength)
	case "BACnetWeekNDay":
		return model.BACnetWeekNDayParse(io)
	case "NPDUNetworkPriorityTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.NPDUNetworkPriorityTaggedParse(io, tagNumber, tagClass)
	case "BACnetReliabilityTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetReliabilityTaggedParse(io, tagNumber, tagClass)
	case "BACnetDoorValueTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetDoorValueTaggedParse(io, tagNumber, tagClass)
	case "BACnetScale":
		return model.BACnetScaleParse(io)
	case "BACnetNotificationParametersChangeOfValueNewValue":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetNotificationParametersChangeOfValueNewValueParse(io, tagNumber)
	case "ErrorCodeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.ErrorCodeTaggedParse(io, tagNumber, tagClass)
	case "BACnetPolarityTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetPolarityTaggedParse(io, tagNumber, tagClass)
	case "BACnetServiceAckAtomicReadFileStreamOrRecord":
		return model.BACnetServiceAckAtomicReadFileStreamOrRecordParse(io)
	case "BACnetChannelValue":
		return model.BACnetChannelValueParse(io)
	case "BACnetConstructedData":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[1])
		propertyIdentifierArgument, _ := model.BACnetPropertyIdentifierByName(arguments[2])
		var arrayIndexArgument model.BACnetTagPayloadUnsignedInteger
		return model.BACnetConstructedDataParse(io, tagNumber, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case "BACnetEventTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetEventTypeTaggedParse(io, tagNumber, tagClass)
	case "BACnetObjectPropertyReference":
		return model.BACnetObjectPropertyReferenceParse(io)
	case "BACnetBinaryLightingPVTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetBinaryLightingPVTaggedParse(io, tagNumber, tagClass)
	case "BACnetOptionalREAL":
		return model.BACnetOptionalREALParse(io)
	case "BACnetTagPayloadTime":
		return model.BACnetTagPayloadTimeParse(io)
	case "BACnetAuthenticationFactorEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetAuthenticationFactorEnclosedParse(io, tagNumber)
	case "BACnetEventSummary":
		return model.BACnetEventSummaryParse(io)
	case "BACnetAccessZoneOccupancyStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetAccessZoneOccupancyStateTaggedParse(io, tagNumber, tagClass)
	case "BACnetPropertyAccessResultAccessResult":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		propertyIdentifierArgument, _ := model.BACnetPropertyIdentifierByName(arguments[1])
		var propertyArrayIndexArgument model.BACnetTagPayloadUnsignedInteger
		return model.BACnetPropertyAccessResultAccessResultParse(io, objectTypeArgument, propertyIdentifierArgument, propertyArrayIndexArgument)
	case "BACnetNetworkPortCommandTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetNetworkPortCommandTaggedParse(io, tagNumber, tagClass)
	case "BACnetGroupChannelValue":
		return model.BACnetGroupChannelValueParse(io)
	case "BACnetRejectReasonTagged":
		actualLength, err := utils.StrToUint32(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetRejectReasonTaggedParse(io, actualLength)
	case "BACnetEscalatorModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetEscalatorModeTaggedParse(io, tagNumber, tagClass)
	case "BACnetTagPayloadObjectIdentifier":
		return model.BACnetTagPayloadObjectIdentifierParse(io)
	case "BACnetPropertyWriteDefinition":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		return model.BACnetPropertyWriteDefinitionParse(io, objectTypeArgument)
	case "BACnetEventLogRecord":
		return model.BACnetEventLogRecordParse(io)
	case "BACnetBinaryPVTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetBinaryPVTaggedParse(io, tagNumber, tagClass)
	case "BACnetEventPriorities":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventPrioritiesParse(io, tagNumber)
	case "BACnetDateTime":
		return model.BACnetDateTimeParse(io)
	case "BACnetLightingOperationTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLightingOperationTaggedParse(io, tagNumber, tagClass)
	case "BACnetFaultParameterFaultOutOfRangeMinNormalValue":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetFaultParameterFaultOutOfRangeMinNormalValueParse(io, tagNumber)
	case "BACnetEventParameterChangeOfCharacterStringListOfAlarmValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetEventParameterChangeOfCharacterStringListOfAlarmValuesParse(io, tagNumber)
	case "BACnetSecurityKeySetKeyIds":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetSecurityKeySetKeyIdsParse(io, tagNumber)
	case "BACnetVMACEntry":
		return model.BACnetVMACEntryParse(io)
	case "BACnetTimeStamp":
		return model.BACnetTimeStampParse(io)
	case "BACnetNotificationParameters":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[1])
		return model.BACnetNotificationParametersParse(io, tagNumber, objectTypeArgument)
	case "BACnetClosingTag":
		tagNumberArgument, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetClosingTagParse(io, tagNumberArgument)
	case "BACnetTimeStampsEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetTimeStampsEnclosedParse(io, tagNumber)
	case "BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntry":
		return model.BACnetCOVMultipleSubscriptionListOfCovSubscriptionSpecificationEntryParse(io)
	case "BACnetHostAddressEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetHostAddressEnclosedParse(io, tagNumber)
	case "BACnetNetworkTypeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetNetworkTypeTaggedParse(io, tagNumber, tagClass)
	case "BACnetConstructedDataElement":
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[0])
		propertyIdentifierArgument, _ := model.BACnetPropertyIdentifierByName(arguments[1])
		var arrayIndexArgument model.BACnetTagPayloadUnsignedInteger
		return model.BACnetConstructedDataElementParse(io, objectTypeArgument, propertyIdentifierArgument, arrayIndexArgument)
	case "BACnetPropertyValues":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		objectTypeArgument, _ := model.BACnetObjectTypeByName(arguments[1])
		return model.BACnetPropertyValuesParse(io, tagNumber, objectTypeArgument)
	case "BACnetProtocolLevelTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetProtocolLevelTaggedParse(io, tagNumber, tagClass)
	case "BACnetCOVMultipleSubscription":
		return model.BACnetCOVMultipleSubscriptionParse(io)
	case "BACnetActionList":
		return model.BACnetActionListParse(io)
	case "BACnetLightingCommand":
		return model.BACnetLightingCommandParse(io)
	case "SubscribeCOVPropertyMultipleErrorFirstFailedSubscription":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.SubscribeCOVPropertyMultipleErrorFirstFailedSubscriptionParse(io, tagNumber)
	case "BACnetAuthenticationFactor":
		return model.BACnetAuthenticationFactorParse(io)
	case "MaxSegmentsAcceptedTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.MaxSegmentsAcceptedTaggedParse(io, tagNumber, tagClass)
	case "BACnetWriteAccessSpecification":
		return model.BACnetWriteAccessSpecificationParse(io)
	case "BACnetLightingCommandEnclosed":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		return model.BACnetLightingCommandEnclosedParse(io, tagNumber)
	case "BACnetLiftCarDoorCommandTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLiftCarDoorCommandTaggedParse(io, tagNumber, tagClass)
	case "BACnetLiftCarModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLiftCarModeTaggedParse(io, tagNumber, tagClass)
	case "BACnetSilencedStateTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetSilencedStateTaggedParse(io, tagNumber, tagClass)
	case "BACnetLifeSafetyModeTagged":
		tagNumber, err := utils.StrToUint8(arguments[0])
		if err != nil {
			return nil, errors.Wrap(err, "Error parsing")
		}
		tagClass, _ := model.TagClassByName(arguments[1])
		return model.BACnetLifeSafetyModeTaggedParse(io, tagNumber, tagClass)
	}
	return nil, errors.Errorf("Unsupported type %s", typeName)
}
