/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#ifndef PLC4C_PLC4X_READ_WRITE_PLC4X_VALUE_TYPE_H_
#define PLC4C_PLC4X_READ_WRITE_PLC4X_VALUE_TYPE_H_

#include <stdbool.h>
#include <stdint.h>
#include <plc4c/spi/read_buffer.h>
#include <plc4c/spi/write_buffer.h>

// Code generated by code-generation. DO NOT EDIT.


enum plc4c_plc4x_read_write_plc4x_value_type {
  plc4c_plc4x_read_write_plc4x_value_type_NULL = 0x00,
  plc4c_plc4x_read_write_plc4x_value_type_BOOL = 0x01,
  plc4c_plc4x_read_write_plc4x_value_type_BYTE = 0x02,
  plc4c_plc4x_read_write_plc4x_value_type_WORD = 0x03,
  plc4c_plc4x_read_write_plc4x_value_type_DWORD = 0x04,
  plc4c_plc4x_read_write_plc4x_value_type_LWORD = 0x05,
  plc4c_plc4x_read_write_plc4x_value_type_USINT = 0x11,
  plc4c_plc4x_read_write_plc4x_value_type_UINT = 0x12,
  plc4c_plc4x_read_write_plc4x_value_type_UDINT = 0x13,
  plc4c_plc4x_read_write_plc4x_value_type_ULINT = 0x14,
  plc4c_plc4x_read_write_plc4x_value_type_SINT = 0x21,
  plc4c_plc4x_read_write_plc4x_value_type_INT = 0x22,
  plc4c_plc4x_read_write_plc4x_value_type_DINT = 0x23,
  plc4c_plc4x_read_write_plc4x_value_type_LINT = 0x24,
  plc4c_plc4x_read_write_plc4x_value_type_REAL = 0x31,
  plc4c_plc4x_read_write_plc4x_value_type_LREAL = 0x32,
  plc4c_plc4x_read_write_plc4x_value_type_CHAR = 0x41,
  plc4c_plc4x_read_write_plc4x_value_type_WCHAR = 0x42,
  plc4c_plc4x_read_write_plc4x_value_type_STRING = 0x43,
  plc4c_plc4x_read_write_plc4x_value_type_WSTRING = 0x44,
  plc4c_plc4x_read_write_plc4x_value_type_TIME = 0x51,
  plc4c_plc4x_read_write_plc4x_value_type_LTIME = 0x52,
  plc4c_plc4x_read_write_plc4x_value_type_DATE = 0x53,
  plc4c_plc4x_read_write_plc4x_value_type_LDATE = 0x54,
  plc4c_plc4x_read_write_plc4x_value_type_TIME_OF_DAY = 0x55,
  plc4c_plc4x_read_write_plc4x_value_type_LTIME_OF_DAY = 0x56,
  plc4c_plc4x_read_write_plc4x_value_type_DATE_AND_TIME = 0x57,
  plc4c_plc4x_read_write_plc4x_value_type_LDATE_AND_TIME = 0x58,
  plc4c_plc4x_read_write_plc4x_value_type_Struct = 0x61,
  plc4c_plc4x_read_write_plc4x_value_type_List = 0x62,
  plc4c_plc4x_read_write_plc4x_value_type_RAW_BYTE_ARRAY = 0x71
};
typedef enum plc4c_plc4x_read_write_plc4x_value_type plc4c_plc4x_read_write_plc4x_value_type;

// Get an empty NULL-struct
plc4c_plc4x_read_write_plc4x_value_type plc4c_plc4x_read_write_plc4x_value_type_null();

plc4c_return_code plc4c_plc4x_read_write_plc4x_value_type_parse(plc4c_spi_read_buffer* readBuffer, plc4c_plc4x_read_write_plc4x_value_type* message);

plc4c_return_code plc4c_plc4x_read_write_plc4x_value_type_serialize(plc4c_spi_write_buffer* writeBuffer, plc4c_plc4x_read_write_plc4x_value_type* message);

plc4c_plc4x_read_write_plc4x_value_type plc4c_plc4x_read_write_plc4x_value_type_for_value(uint8_t value);

plc4c_plc4x_read_write_plc4x_value_type plc4c_plc4x_read_write_plc4x_value_type_value_of(char* value_string);

int plc4c_plc4x_read_write_plc4x_value_type_num_values();

plc4c_plc4x_read_write_plc4x_value_type plc4c_plc4x_read_write_plc4x_value_type_value_for_index(int index);

uint16_t plc4c_plc4x_read_write_plc4x_value_type_length_in_bytes(plc4c_plc4x_read_write_plc4x_value_type* message);

uint16_t plc4c_plc4x_read_write_plc4x_value_type_length_in_bits(plc4c_plc4x_read_write_plc4x_value_type* message);


#endif  // PLC4C_PLC4X_READ_WRITE_PLC4X_VALUE_TYPE_H_
