/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#include <string.h>
#include <plc4c/driver_modbus_static.h>

#include "modbus_device_information_level.h"

// Code generated by code-generation. DO NOT EDIT.


// Create an empty NULL-struct
static const plc4c_modbus_read_write_modbus_device_information_level plc4c_modbus_read_write_modbus_device_information_level_null_const;

plc4c_modbus_read_write_modbus_device_information_level plc4c_modbus_read_write_modbus_device_information_level_null() {
  return plc4c_modbus_read_write_modbus_device_information_level_null_const;
}

// Parse function.
plc4c_return_code plc4c_modbus_read_write_modbus_device_information_level_parse(plc4c_spi_read_buffer* readBuffer, plc4c_modbus_read_write_modbus_device_information_level* _message) {
    plc4c_return_code _res = OK;

    uint8_t value;
    _res = plc4c_spi_read_unsigned_byte(readBuffer, 8, (uint8_t*) &value);
    *_message = plc4c_modbus_read_write_modbus_device_information_level_for_value(value);

    return _res;
}

plc4c_return_code plc4c_modbus_read_write_modbus_device_information_level_serialize(plc4c_spi_write_buffer* writeBuffer, plc4c_modbus_read_write_modbus_device_information_level* _message) {
    plc4c_return_code _res = OK;

    _res = plc4c_spi_write_unsigned_byte(writeBuffer, 8, *_message);

    return _res;
}

plc4c_modbus_read_write_modbus_device_information_level plc4c_modbus_read_write_modbus_device_information_level_for_value(uint8_t value) {
    for(int i = 0; i < plc4c_modbus_read_write_modbus_device_information_level_num_values(); i++) {
        if(plc4c_modbus_read_write_modbus_device_information_level_value_for_index(i) == value) {
            return plc4c_modbus_read_write_modbus_device_information_level_value_for_index(i);
        }
    }
    return -1;
}

plc4c_modbus_read_write_modbus_device_information_level plc4c_modbus_read_write_modbus_device_information_level_value_of(char* value_string) {
    if(strcmp(value_string, "BASIC") == 0) {
        return plc4c_modbus_read_write_modbus_device_information_level_BASIC;
    }
    if(strcmp(value_string, "REGULAR") == 0) {
        return plc4c_modbus_read_write_modbus_device_information_level_REGULAR;
    }
    if(strcmp(value_string, "EXTENDED") == 0) {
        return plc4c_modbus_read_write_modbus_device_information_level_EXTENDED;
    }
    if(strcmp(value_string, "INDIVIDUAL") == 0) {
        return plc4c_modbus_read_write_modbus_device_information_level_INDIVIDUAL;
    }
    return -1;
}

int plc4c_modbus_read_write_modbus_device_information_level_num_values() {
  return 4;
}

plc4c_modbus_read_write_modbus_device_information_level plc4c_modbus_read_write_modbus_device_information_level_value_for_index(int index) {
    switch(index) {
      case 0: {
        return plc4c_modbus_read_write_modbus_device_information_level_BASIC;
      }
      case 1: {
        return plc4c_modbus_read_write_modbus_device_information_level_REGULAR;
      }
      case 2: {
        return plc4c_modbus_read_write_modbus_device_information_level_EXTENDED;
      }
      case 3: {
        return plc4c_modbus_read_write_modbus_device_information_level_INDIVIDUAL;
      }
      default: {
        return -1;
      }
    }
}

uint16_t plc4c_modbus_read_write_modbus_device_information_level_length_in_bytes(plc4c_modbus_read_write_modbus_device_information_level* _message) {
    return plc4c_modbus_read_write_modbus_device_information_level_length_in_bits(_message) / 8;
}

uint16_t plc4c_modbus_read_write_modbus_device_information_level_length_in_bits(plc4c_modbus_read_write_modbus_device_information_level* _message) {
    return 8;
}
