/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

#ifndef PLC4C_MODBUS_READ_WRITE_MODBUS_ADU_H_
#define PLC4C_MODBUS_READ_WRITE_MODBUS_ADU_H_

#include <stdbool.h>
#include <stdint.h>
#include <plc4c/spi/read_buffer.h>
#include <plc4c/spi/write_buffer.h>
#include <plc4c/utils/list.h>
#include "modbus_pdu.h"
#include "driver_type.h"
#include "driver_type.h"

// Code generated by code-generation. DO NOT EDIT.


// Structure used to contain the discriminator values for discriminated types using this as a parent
struct plc4c_modbus_read_write_modbus_adu_discriminator {
  enum plc4c_modbus_read_write_driver_type driverType;
};
typedef struct plc4c_modbus_read_write_modbus_adu_discriminator plc4c_modbus_read_write_modbus_adu_discriminator;

// Enum assigning each subtype an individual id.
enum plc4c_modbus_read_write_modbus_adu_type {
  plc4c_modbus_read_write_modbus_adu_type_plc4c_modbus_read_write_modbus_tcp_adu = 0,
  plc4c_modbus_read_write_modbus_adu_type_plc4c_modbus_read_write_modbus_rtu_adu = 1,
  plc4c_modbus_read_write_modbus_adu_type_plc4c_modbus_read_write_modbus_ascii_adu = 2};
typedef enum plc4c_modbus_read_write_modbus_adu_type plc4c_modbus_read_write_modbus_adu_type;

// Function to get the discriminator values for a given type.
plc4c_modbus_read_write_modbus_adu_discriminator plc4c_modbus_read_write_modbus_adu_get_discriminator(plc4c_modbus_read_write_modbus_adu_type type);

// Constant values.
uint16_t PLC4C_MODBUS_READ_WRITE_MODBUS_TCP_ADU_PROTOCOL_IDENTIFIER();

struct plc4c_modbus_read_write_modbus_adu {
  /* This is an abstract type so this property saves the type of this typed union */
  plc4c_modbus_read_write_modbus_adu_type _type;
  /* Properties */
  union {
    struct { /* ModbusTcpADU */
      uint16_t modbus_tcp_adu_transaction_identifier;
      uint8_t modbus_tcp_adu_unit_identifier;
      plc4c_modbus_read_write_modbus_pdu* modbus_tcp_adu_pdu;
    };
    struct { /* ModbusRtuADU */
      uint8_t modbus_rtu_adu_address;
      plc4c_modbus_read_write_modbus_pdu* modbus_rtu_adu_pdu;
    };
    struct { /* ModbusAsciiADU */
      uint8_t modbus_ascii_adu_address;
      plc4c_modbus_read_write_modbus_pdu* modbus_ascii_adu_pdu;
    };
  };
};
typedef struct plc4c_modbus_read_write_modbus_adu plc4c_modbus_read_write_modbus_adu;

// Create an empty NULL-struct
plc4c_modbus_read_write_modbus_adu plc4c_modbus_read_write_modbus_adu_null();

plc4c_return_code plc4c_modbus_read_write_modbus_adu_parse(plc4c_spi_read_buffer* readBuffer, plc4c_modbus_read_write_driver_type driverType, bool response, plc4c_modbus_read_write_modbus_adu** message);

plc4c_return_code plc4c_modbus_read_write_modbus_adu_serialize(plc4c_spi_write_buffer* writeBuffer, plc4c_modbus_read_write_modbus_adu* message);

uint16_t plc4c_modbus_read_write_modbus_adu_length_in_bytes(plc4c_modbus_read_write_modbus_adu* message);

uint16_t plc4c_modbus_read_write_modbus_adu_length_in_bits(plc4c_modbus_read_write_modbus_adu* message);

#endif  // PLC4C_MODBUS_READ_WRITE_MODBUS_ADU_H_
