/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraScrollPaneCornerSkin
extends ComponentSkin {
    private Color backgroundColor;

    public TerraScrollPaneCornerSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.backgroundColor = theme.getColor(11);
    }

    public boolean isFocusable() {
        return false;
    }

    public int getPreferredWidth(int height) {
        return 0;
    }

    public int getPreferredHeight(int width) {
        return 0;
    }

    public Dimensions getPreferredSize() {
        return new Dimensions(0, 0);
    }

    public void layout() {
    }

    public void paint(Graphics2D graphics) {
        int width = this.getWidth();
        int height = this.getHeight();
        graphics.setPaint(this.backgroundColor);
        graphics.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.repaintComponent();
    }

    public final void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)backgroundColor));
    }

    public final void setBackgroundColor(int backgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(backgroundColor));
    }
}

