/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.PushButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraPushButtonSkin
extends PushButtonSkin {
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color backgroundColor;
    private Color disabledBackgroundColor;
    private Color borderColor;
    private Color disabledBorderColor;
    private Insets padding;
    private float minimumAspectRatio;
    private float maximumAspectRatio;
    private boolean toolbar;
    private Color bevelColor;
    private Color pressedBevelColor;
    private Color disabledBevelColor;
    private static final int CORNER_RADIUS = 4;

    public TerraPushButtonSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.font = theme.getFont();
        this.color = theme.getColor(1);
        this.disabledColor = theme.getColor(7);
        this.backgroundColor = theme.getColor(10);
        this.disabledBackgroundColor = theme.getColor(10);
        this.borderColor = theme.getColor(7);
        this.disabledBorderColor = theme.getColor(7);
        this.padding = new Insets(2, 3, 2, 3);
        this.minimumAspectRatio = Float.NaN;
        this.maximumAspectRatio = Float.NaN;
        this.toolbar = false;
        this.bevelColor = TerraTheme.brighten(this.backgroundColor);
        this.pressedBevelColor = TerraTheme.darken(this.backgroundColor);
        this.disabledBevelColor = this.disabledBackgroundColor;
    }

    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        if (height == -1) {
            preferredWidth = this.getPreferredSize().width;
        } else {
            PushButton pushButton = (PushButton)this.getComponent();
            Button.DataRenderer dataRenderer = pushButton.getDataRenderer();
            dataRenderer.render(pushButton.getButtonData(), (Button)pushButton, false);
            int contentHeight = height;
            if (contentHeight != -1) {
                contentHeight = Math.max(contentHeight - this.paddingHeight(), 0);
            }
            preferredWidth = dataRenderer.getPreferredWidth(contentHeight) + this.paddingWidth();
            if (!Float.isNaN(this.minimumAspectRatio) && (float)preferredWidth / (float)height < this.minimumAspectRatio) {
                preferredWidth = (int)((float)height * this.minimumAspectRatio);
            }
        }
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        if (width == -1) {
            preferredHeight = this.getPreferredSize().height;
        } else {
            PushButton pushButton = (PushButton)this.getComponent();
            Button.DataRenderer dataRenderer = pushButton.getDataRenderer();
            dataRenderer.render(pushButton.getButtonData(), (Button)pushButton, false);
            int contentWidth = width;
            if (contentWidth != -1) {
                contentWidth = Math.max(contentWidth - this.paddingWidth(), 0);
            }
            preferredHeight = dataRenderer.getPreferredHeight(contentWidth) + this.paddingHeight();
            if (!Float.isNaN(this.maximumAspectRatio) && (float)width / (float)preferredHeight > this.maximumAspectRatio) {
                preferredHeight = (int)((float)width / this.maximumAspectRatio);
            }
        }
        return preferredHeight;
    }

    public Dimensions getPreferredSize() {
        PushButton pushButton = (PushButton)this.getComponent();
        Button.DataRenderer dataRenderer = pushButton.getDataRenderer();
        dataRenderer.render(pushButton.getButtonData(), (Button)pushButton, false);
        Dimensions preferredContentSize = dataRenderer.getPreferredSize();
        int preferredWidth = preferredContentSize.width + this.paddingWidth();
        int preferredHeight = preferredContentSize.height + this.paddingHeight();
        float aspectRatio = (float)preferredWidth / (float)preferredHeight;
        if (!Float.isNaN(this.minimumAspectRatio) && aspectRatio < this.minimumAspectRatio) {
            preferredWidth = (int)((float)preferredHeight * this.minimumAspectRatio);
        }
        if (!Float.isNaN(this.maximumAspectRatio) && aspectRatio > this.maximumAspectRatio) {
            preferredHeight = (int)((float)preferredWidth / this.maximumAspectRatio);
        }
        return new Dimensions(preferredWidth, preferredHeight);
    }

    public int getBaseline(int width, int height) {
        PushButton pushButton = (PushButton)this.getComponent();
        Button.DataRenderer dataRenderer = pushButton.getDataRenderer();
        dataRenderer.render(pushButton.getButtonData(), (Button)pushButton, false);
        int clientWidth = Math.max(width - this.paddingWidth(), 0);
        int clientHeight = Math.max(height - this.paddingHeight(), 0);
        int baseline = dataRenderer.getBaseline(clientWidth, clientHeight);
        if (baseline != -1) {
            baseline += this.padding.top + 1;
        }
        return baseline;
    }

    public void paint(Graphics2D graphics) {
        PushButton pushButton = (PushButton)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        Color backgroundColorLocal = null;
        Color bevelColorLocal = null;
        Color borderColorLocal = null;
        if (!this.toolbar || this.highlighted || pushButton.isFocused()) {
            if (pushButton.isEnabled()) {
                backgroundColorLocal = this.backgroundColor;
                bevelColorLocal = this.pressed || pushButton.isSelected() ? this.pressedBevelColor : this.bevelColor;
                borderColorLocal = this.borderColor;
            } else {
                backgroundColorLocal = this.disabledBackgroundColor;
                bevelColorLocal = this.disabledBevelColor;
                borderColorLocal = this.disabledBorderColor;
            }
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (backgroundColorLocal != null && bevelColorLocal != null) {
            graphics.setPaint(new GradientPaint((float)width / 2.0f, 0.0f, bevelColorLocal, (float)width / 2.0f, (float)height / 2.0f, backgroundColorLocal));
            graphics.fill(new RoundRectangle2D.Double(0.5, 0.5, width - 1, height - 1, 4.0, 4.0));
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Button.DataRenderer dataRenderer = pushButton.getDataRenderer();
        dataRenderer.render(pushButton.getButtonData(), (Button)pushButton, this.highlighted);
        dataRenderer.setSize(Math.max(width - this.paddingWidth(), 0), Math.max(this.getHeight() - this.paddingHeight(), 0));
        Graphics2D contentGraphics = (Graphics2D)graphics.create();
        contentGraphics.translate(this.padding.left + 1, this.padding.top + 1);
        contentGraphics.clipRect(0, 0, dataRenderer.getWidth(), dataRenderer.getHeight());
        dataRenderer.paint(contentGraphics);
        contentGraphics.dispose();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (borderColorLocal != null) {
            graphics.setPaint(borderColorLocal);
            graphics.setStroke(new BasicStroke(1.0f));
            graphics.draw(new RoundRectangle2D.Double(0.5, 0.5, width - 1, height - 1, 4.0, 4.0));
        }
        if (pushButton.isFocused() && !this.toolbar) {
            BasicStroke dashStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);
            graphics.setStroke(dashStroke);
            graphics.setColor(this.borderColor);
            graphics.draw(new RoundRectangle2D.Double(2.5, 2.5, Math.max(width - 5, 0), Math.max(height - 5, 0), 2.0, 2.0));
        }
    }

    public boolean isFocusable() {
        return true;
    }

    public boolean isOpaque() {
        PushButton pushButton = (PushButton)this.getComponent();
        return !this.toolbar || this.highlighted || pushButton.isFocused();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraPushButtonSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public final void setColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setColor(theme.getColor(color));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public final void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public final void setDisabledColor(int disabledColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(theme.getColor(disabledColor));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.backgroundColor = backgroundColor;
        this.bevelColor = TerraTheme.brighten(backgroundColor);
        this.pressedBevelColor = TerraTheme.darken(backgroundColor);
        this.repaintComponent();
    }

    public final void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)backgroundColor));
    }

    public final void setBackgroundColor(int backgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(backgroundColor));
    }

    public Color getDisabledBackgroundColor() {
        return this.disabledBackgroundColor;
    }

    public void setDisabledBackgroundColor(Color disabledBackgroundColor) {
        if (disabledBackgroundColor == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.disabledBackgroundColor = disabledBackgroundColor;
        this.disabledBevelColor = disabledBackgroundColor;
        this.repaintComponent();
    }

    public final void setDisabledBackgroundColor(String disabledBackgroundColor) {
        if (disabledBackgroundColor == null) {
            throw new IllegalArgumentException("disabledBackgroundColor is null.");
        }
        this.setDisabledBackgroundColor(GraphicsUtilities.decodeColor((String)disabledBackgroundColor));
    }

    public final void setDisabledBackgroundColor(int disabledBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledBackgroundColor(theme.getColor(disabledBackgroundColor));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = borderColor;
        this.repaintComponent();
    }

    public final void setBorderColor(String borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)borderColor));
    }

    public final void setBorderColor(int borderColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBorderColor(theme.getColor(borderColor));
    }

    public Color getDisabledBorderColor() {
        return this.disabledBorderColor;
    }

    public void setDisabledBorderColor(Color disabledBorderColor) {
        if (disabledBorderColor == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.disabledBorderColor = disabledBorderColor;
        this.repaintComponent();
    }

    public final void setDisabledBorderColor(String disabledBorderColor) {
        if (disabledBorderColor == null) {
            throw new IllegalArgumentException("disabledBorderColor is null.");
        }
        this.setDisabledBorderColor(GraphicsUtilities.decodeColor((String)disabledBorderColor));
    }

    public final void setDisabledBorderColor(int disabledBorderColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledBorderColor(theme.getColor(disabledBorderColor));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)padding));
    }

    private int paddingWidth() {
        return this.padding.left + this.padding.right + 2;
    }

    private int paddingHeight() {
        return this.padding.top + this.padding.bottom + 2;
    }

    public float getMinimumAspectRatio() {
        return this.minimumAspectRatio;
    }

    public void setMinimumAspectRatio(float minimumAspectRatio) {
        if (!Float.isNaN(this.maximumAspectRatio) && minimumAspectRatio > this.maximumAspectRatio) {
            throw new IllegalArgumentException("minimumAspectRatio is greater than maximumAspectRatio.");
        }
        this.minimumAspectRatio = minimumAspectRatio;
        this.invalidateComponent();
    }

    public final void setMinimumAspectRatio(Number minimumAspectRatio) {
        if (minimumAspectRatio == null) {
            throw new IllegalArgumentException("minimumAspectRatio is null.");
        }
        this.setMinimumAspectRatio(minimumAspectRatio.floatValue());
    }

    public float getMaximumAspectRatio() {
        return this.maximumAspectRatio;
    }

    public void setMaximumAspectRatio(float maximumAspectRatio) {
        if (!Float.isNaN(this.minimumAspectRatio) && maximumAspectRatio < this.minimumAspectRatio) {
            throw new IllegalArgumentException("maximumAspectRatio is less than minimumAspectRatio.");
        }
        this.maximumAspectRatio = maximumAspectRatio;
        this.invalidateComponent();
    }

    public final void setMaximumAspectRatio(Number maximumAspectRatio) {
        if (maximumAspectRatio == null) {
            throw new IllegalArgumentException("maximumAspectRatio is null.");
        }
        this.setMaximumAspectRatio(maximumAspectRatio.floatValue());
    }

    public boolean isToolbar() {
        return this.toolbar;
    }

    public void setToolbar(boolean toolbar) {
        this.toolbar = toolbar;
        if (toolbar && this.getComponent().isFocused()) {
            Component.clearFocus();
        }
        this.repaintComponent();
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        if (this.toolbar && component.isFocused()) {
            Component.clearFocus();
        }
    }

    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        if (!this.toolbar) {
            component.requestFocus();
        }
        return super.mouseClick(component, button, x, y, count);
    }
}

