/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Border;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.ContainerMouseListener;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuItemSelectionListener;
import org.apache.pivot.wtk.MenuPopup;
import org.apache.pivot.wtk.MenuPopupListener;
import org.apache.pivot.wtk.MenuPopupStateListener;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Panorama;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.DropShadowDecorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.skin.WindowSkin;
import org.apache.pivot.wtk.skin.terra.FadeWindowTransition;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraMenuPopupSkin
extends WindowSkin
implements MenuPopupListener,
MenuPopupStateListener {
    private Panorama panorama;
    private Border border;
    private DropShadowDecorator dropShadowDecorator = null;
    private Transition closeTransition = null;
    private int closeTransitionDuration = 250;
    private int closeTransitionRate = 30;
    private ContainerMouseListener displayMouseListener = new ContainerMouseListener.Adapter(){

        public boolean mouseDown(Container container, Mouse.Button button, int x, int y) {
            Display display;
            Component descendant;
            MenuPopup menuPopup = (MenuPopup)TerraMenuPopupSkin.this.getComponent();
            if (menuPopup.isContextMenu() && (descendant = (display = (Display)container).getDescendantAt(x, y)) != display) {
                Window window = descendant.getWindow();
                if (!(menuPopup.isAncestor(descendant) || window != null && menuPopup.isOwner(window))) {
                    menuPopup.close();
                }
            }
            return false;
        }

        public boolean mouseWheel(Container container, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
            MenuPopup menuPopup;
            boolean consumed = false;
            Display display = (Display)container;
            Window window = (Window)display.getComponentAt(x, y);
            if (!(window == (menuPopup = (MenuPopup)TerraMenuPopupSkin.this.getComponent()) || window != null && menuPopup.isOwner(window))) {
                consumed = true;
            }
            return consumed;
        }
    };
    private MenuItemSelectionListener menuItemSelectionListener = new MenuItemSelectionListener(){

        public void itemSelected(Menu.Item item) {
            MenuPopup menuPopup = (MenuPopup)TerraMenuPopupSkin.this.getComponent();
            menuPopup.close();
        }
    };
    private static final int DEFAULT_CLOSE_TRANSITION_DURATION = 250;
    private static final int DEFAULT_CLOSE_TRANSITION_RATE = 30;

    public TerraMenuPopupSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(null);
        this.panorama = new Panorama();
        this.panorama.getStyles().put("buttonBackgroundColor", (Object)Color.WHITE);
        this.border = new Border((Component)this.panorama);
        this.border.getStyles().put("color", (Object)theme.getColor(7));
        this.border.getStyles().put("backgroundColor", null);
        this.border.getStyles().put("padding", (Object)0);
    }

    public void install(Component component) {
        super.install(component);
        MenuPopup menuPopup = (MenuPopup)component;
        menuPopup.getMenuPopupListeners().add((Object)this);
        menuPopup.getMenuPopupStateListeners().add((Object)this);
        Menu menu = menuPopup.getMenu();
        if (menu != null) {
            menu.getMenuItemSelectionListeners().add((Object)this.menuItemSelectionListener);
        }
        this.panorama.setView((Component)menu);
        menuPopup.setContent((Component)this.border);
        this.dropShadowDecorator = new DropShadowDecorator(3, 3, 3);
        menuPopup.getDecorators().add((Decorator)this.dropShadowDecorator);
    }

    public Color getBorderColor() {
        return (Color)this.border.getStyles().get("color");
    }

    public void setBorderColor(Color borderColor) {
        this.border.getStyles().put("color", (Object)borderColor);
    }

    public void setBorderColor(String borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.border.getStyles().put("color", (Object)borderColor);
    }

    public int getCloseTransitionDuration() {
        return this.closeTransitionDuration;
    }

    public void setCloseTransitionDuration(int closeTransitionDuration) {
        this.closeTransitionDuration = closeTransitionDuration;
    }

    public int getCloseTransitionRate() {
        return this.closeTransitionRate;
    }

    public void setCloseTransitionRate(int closeTransitionRate) {
        this.closeTransitionRate = closeTransitionRate;
    }

    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = super.keyPressed(component, keyCode, keyLocation);
        if (keyCode == 27) {
            MenuPopup menuPopup = (MenuPopup)this.getComponent();
            menuPopup.close();
        }
        return consumed;
    }

    public void windowOpened(Window window) {
        super.windowOpened(window);
        Display display = window.getDisplay();
        display.getContainerMouseListeners().add((Object)this.displayMouseListener);
        MenuPopup menuPopup = (MenuPopup)window;
        Menu menu = menuPopup.getMenu();
        if (menu != null) {
            Menu.Item activeItem = menu.getActiveItem();
            if (activeItem != null) {
                activeItem.setActive(false);
            }
            menu.requestFocus();
        }
        this.panorama.setScrollTop(0);
        ApplicationContext.queueCallback((Runnable)new RepositionCallback());
    }

    public void windowClosed(Window window, Display display, Window owner) {
        super.windowClosed(window, display, owner);
        display.getContainerMouseListeners().remove((Object)this.displayMouseListener);
        if (owner != null && owner.isOpen()) {
            owner.moveToFront();
        }
    }

    public void menuChanged(MenuPopup menuPopup, Menu previousMenu) {
        Menu menu;
        if (previousMenu != null) {
            previousMenu.getMenuItemSelectionListeners().remove((Object)this.menuItemSelectionListener);
        }
        if ((menu = menuPopup.getMenu()) != null) {
            menu.getMenuItemSelectionListeners().add((Object)this.menuItemSelectionListener);
        }
        this.panorama.setView((Component)menu);
    }

    public Vote previewMenuPopupClose(final MenuPopup menuPopup, boolean immediate) {
        if (!immediate && this.closeTransition == null) {
            this.border.setEnabled(false);
            this.closeTransition = new FadeWindowTransition((Component)menuPopup, this.closeTransitionDuration, this.closeTransitionRate, this.dropShadowDecorator);
            this.closeTransition.start(new TransitionListener(){

                public void transitionCompleted(Transition transition) {
                    menuPopup.close();
                }
            });
        }
        return this.closeTransition != null && this.closeTransition.isRunning() ? Vote.DEFER : Vote.APPROVE;
    }

    public void menuPopupCloseVetoed(MenuPopup menuPopup, Vote reason) {
        if (reason == Vote.DENY && this.closeTransition != null) {
            this.closeTransition.stop();
            this.border.setEnabled(true);
            this.closeTransition = null;
        }
    }

    public void menuPopupClosed(MenuPopup menuPopup) {
        this.border.setEnabled(true);
        this.closeTransition = null;
    }

    private class RepositionCallback
    implements Runnable {
        private RepositionCallback() {
        }

        @Override
        public void run() {
            MenuPopup menuPopup = (MenuPopup)TerraMenuPopupSkin.this.getComponent();
            Display display = menuPopup.getDisplay();
            Point location = menuPopup.getLocation();
            Dimensions size = menuPopup.getSize();
            int x = location.x;
            int displayWidth = display.getWidth();
            if (size.width > displayWidth) {
                TerraMenuPopupSkin.this.border.setPreferredWidth(displayWidth);
                x = 0;
            } else if (x + size.width > displayWidth) {
                x -= size.width;
            }
            int y = location.y;
            int displayHeight = display.getHeight();
            if (size.height > displayHeight) {
                TerraMenuPopupSkin.this.border.setPreferredHeight(displayHeight);
                y = 0;
            } else if (y + size.height > displayHeight) {
                y -= size.height;
            }
            menuPopup.setLocation(x, y);
        }
    }
}

